# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessApprovalSettingsEnrolledService',
    'IAMBindingCondition',
    'IAMMemberCondition',
    'IamAuditConfigAuditLogConfig',
    'PolicyBooleanPolicy',
    'PolicyListPolicy',
    'PolicyListPolicyAllow',
    'PolicyListPolicyDeny',
    'PolicyRestorePolicy',
    'GetFoldersFolderResult',
    'GetIAMPolicyAuditConfigResult',
    'GetIAMPolicyAuditConfigAuditLogConfigResult',
    'GetIAMPolicyBindingResult',
    'GetIAMPolicyBindingConditionResult',
    'GetIamCustomRolesRoleResult',
    'GetSOrganizationResult',
]

@pulumi.output_type
class AccessApprovalSettingsEnrolledService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProduct":
            suggest = "cloud_product"
        elif key == "enrollmentLevel":
            suggest = "enrollment_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessApprovalSettingsEnrolledService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessApprovalSettingsEnrolledService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessApprovalSettingsEnrolledService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_product: builtins.str,
                 enrollment_level: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_product: The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive):
               all
               appengine.googleapis.com
               bigquery.googleapis.com
               bigtable.googleapis.com
               cloudkms.googleapis.com
               compute.googleapis.com
               dataflow.googleapis.com
               iam.googleapis.com
               pubsub.googleapis.com
               storage.googleapis.com
        :param builtins.str enrollment_level: The enrollment level of the service.
               Default value is `BLOCK_ALL`.
               Possible values are: `BLOCK_ALL`.
               
               - - -
        """
        pulumi.set(__self__, "cloud_product", cloud_product)
        if enrollment_level is not None:
            pulumi.set(__self__, "enrollment_level", enrollment_level)

    @property
    @pulumi.getter(name="cloudProduct")
    def cloud_product(self) -> builtins.str:
        """
        The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive):
        all
        appengine.googleapis.com
        bigquery.googleapis.com
        bigtable.googleapis.com
        cloudkms.googleapis.com
        compute.googleapis.com
        dataflow.googleapis.com
        iam.googleapis.com
        pubsub.googleapis.com
        storage.googleapis.com
        """
        return pulumi.get(self, "cloud_product")

    @property
    @pulumi.getter(name="enrollmentLevel")
    def enrollment_level(self) -> Optional[builtins.str]:
        """
        The enrollment level of the service.
        Default value is `BLOCK_ALL`.
        Possible values are: `BLOCK_ALL`.

        - - -
        """
        return pulumi.get(self, "enrollment_level")


@pulumi.output_type
class IAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class IAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class IamAuditConfigAuditLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logType":
            suggest = "log_type"
        elif key == "exemptedMembers":
            suggest = "exempted_members"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IamAuditConfigAuditLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IamAuditConfigAuditLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IamAuditConfigAuditLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_type: builtins.str,
                 exempted_members: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str log_type: Permission type for which logging is to be configured.  Must be one of `DATA_READ`, `DATA_WRITE`, or `ADMIN_READ`.
        :param Sequence[builtins.str] exempted_members: Identities that do not cause logging for this type of permission.
               Each entry can have one of the following values:
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        """
        pulumi.set(__self__, "log_type", log_type)
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        """
        Permission type for which logging is to be configured.  Must be one of `DATA_READ`, `DATA_WRITE`, or `ADMIN_READ`.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[Sequence[builtins.str]]:
        """
        Identities that do not cause logging for this type of permission.
        Each entry can have one of the following values:
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "exempted_members")


@pulumi.output_type
class PolicyBooleanPolicy(dict):
    def __init__(__self__, *,
                 enforced: builtins.bool):
        """
        :param builtins.bool enforced: If true, then the Policy is enforced. If false, then any configuration is acceptable.
        """
        pulumi.set(__self__, "enforced", enforced)

    @property
    @pulumi.getter
    def enforced(self) -> builtins.bool:
        """
        If true, then the Policy is enforced. If false, then any configuration is acceptable.
        """
        return pulumi.get(self, "enforced")


@pulumi.output_type
class PolicyListPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inheritFromParent":
            suggest = "inherit_from_parent"
        elif key == "suggestedValue":
            suggest = "suggested_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyListPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyListPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyListPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow: Optional['outputs.PolicyListPolicyAllow'] = None,
                 deny: Optional['outputs.PolicyListPolicyDeny'] = None,
                 inherit_from_parent: Optional[builtins.bool] = None,
                 suggested_value: Optional[builtins.str] = None):
        """
        :param 'PolicyListPolicyAllowArgs' allow: or `deny` - (Optional) One or the other must be set.
        :param 'PolicyListPolicyDenyArgs' deny: One or the other must be set.
        :param builtins.bool inherit_from_parent: If set to true, the values from the effective Policy of the parent resource
               are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
               
               The `allow` or `deny` blocks support:
        :param builtins.str suggested_value: The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if deny is not None:
            pulumi.set(__self__, "deny", deny)
        if inherit_from_parent is not None:
            pulumi.set(__self__, "inherit_from_parent", inherit_from_parent)
        if suggested_value is not None:
            pulumi.set(__self__, "suggested_value", suggested_value)

    @property
    @pulumi.getter
    def allow(self) -> Optional['outputs.PolicyListPolicyAllow']:
        """
        or `deny` - (Optional) One or the other must be set.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def deny(self) -> Optional['outputs.PolicyListPolicyDeny']:
        """
        One or the other must be set.
        """
        return pulumi.get(self, "deny")

    @property
    @pulumi.getter(name="inheritFromParent")
    def inherit_from_parent(self) -> Optional[builtins.bool]:
        """
        If set to true, the values from the effective Policy of the parent resource
        are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.

        The `allow` or `deny` blocks support:
        """
        return pulumi.get(self, "inherit_from_parent")

    @property
    @pulumi.getter(name="suggestedValue")
    def suggested_value(self) -> Optional[builtins.str]:
        """
        The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
        """
        return pulumi.get(self, "suggested_value")


@pulumi.output_type
class PolicyListPolicyAllow(dict):
    def __init__(__self__, *,
                 all: Optional[builtins.bool] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool all: The policy allows or denies all values.
        :param Sequence[builtins.str] values: The policy can define specific values that are allowed or denied.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def all(self) -> Optional[builtins.bool]:
        """
        The policy allows or denies all values.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        The policy can define specific values that are allowed or denied.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PolicyListPolicyDeny(dict):
    def __init__(__self__, *,
                 all: Optional[builtins.bool] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool all: The policy allows or denies all values.
        :param Sequence[builtins.str] values: The policy can define specific values that are allowed or denied.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def all(self) -> Optional[builtins.bool]:
        """
        The policy allows or denies all values.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        The policy can define specific values that are allowed or denied.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PolicyRestorePolicy(dict):
    def __init__(__self__, *,
                 default: builtins.bool):
        """
        :param builtins.bool default: May only be set to true. If set, then the default Policy is restored.
        """
        pulumi.set(__self__, "default", default)

    @property
    @pulumi.getter
    def default(self) -> builtins.bool:
        """
        May only be set to true. If set, then the default Policy is restored.
        """
        return pulumi.get(self, "default")


@pulumi.output_type
class GetFoldersFolderResult(dict):
    def __init__(__self__, *,
                 create_time: builtins.str,
                 delete_time: builtins.str,
                 display_name: builtins.str,
                 etag: builtins.str,
                 name: builtins.str,
                 parent: builtins.str,
                 state: builtins.str,
                 update_time: builtins.str):
        """
        :param builtins.str create_time: The timestamp of when the folder was created
        :param builtins.str delete_time: The timestamp of when the folder was requested to be deleted (if applicable)
        :param builtins.str display_name: The display name of the folder
        :param builtins.str etag: Entity tag identifier of the folder
        :param builtins.str name: The id of the folder
        :param builtins.str parent: The parent id of the folder
        :param builtins.str state: The lifecycle state of the folder
        :param builtins.str update_time: The timestamp of when the folder was last modified
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "delete_time", delete_time)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        The timestamp of when the folder was created
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> builtins.str:
        """
        The timestamp of when the folder was requested to be deleted (if applicable)
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the folder
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        Entity tag identifier of the folder
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The id of the folder
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> builtins.str:
        """
        The parent id of the folder
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state of the folder
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> builtins.str:
        """
        The timestamp of when the folder was last modified
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetIAMPolicyAuditConfigResult(dict):
    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GetIAMPolicyAuditConfigAuditLogConfigResult'],
                 service: builtins.str):
        """
        :param Sequence['GetIAMPolicyAuditConfigAuditLogConfigArgs'] audit_log_configs: A nested block that defines the operations you'd like to log.
        :param builtins.str service: Defines a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GetIAMPolicyAuditConfigAuditLogConfigResult']:
        """
        A nested block that defines the operations you'd like to log.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        Defines a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetIAMPolicyAuditConfigAuditLogConfigResult(dict):
    def __init__(__self__, *,
                 log_type: builtins.str,
                 exempted_members: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str log_type: Defines the logging level. `DATA_READ`, `DATA_WRITE` and `ADMIN_READ` capture different types of events. See [the audit configuration documentation](https://cloud.google.com/resource-manager/reference/rest/Shared.Types/AuditConfig) for more details.
        :param Sequence[builtins.str] exempted_members: Specifies the identities that are exempt from these types of logging operations. Follows the same format of the `members` array for `binding`.
        """
        pulumi.set(__self__, "log_type", log_type)
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        """
        Defines the logging level. `DATA_READ`, `DATA_WRITE` and `ADMIN_READ` capture different types of events. See [the audit configuration documentation](https://cloud.google.com/resource-manager/reference/rest/Shared.Types/AuditConfig) for more details.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the identities that are exempt from these types of logging operations. Follows the same format of the `members` array for `binding`.
        """
        return pulumi.get(self, "exempted_members")


@pulumi.output_type
class GetIAMPolicyBindingResult(dict):
    def __init__(__self__, *,
                 members: Sequence[builtins.str],
                 role: builtins.str,
                 condition: Optional['outputs.GetIAMPolicyBindingConditionResult'] = None):
        """
        :param Sequence[builtins.str] members: An array of identities that will be granted the privilege in the `role`. For more details on format and restrictions see https://cloud.google.com/billing/reference/rest/v1/Policy#Binding
               Each entry can have one of the following values:
               * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account. Some resources **don't** support this identity.
               * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account. Some resources **don't** support this identity.
               * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com.
               * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
               * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
               * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        :param builtins.str role: The role/permission that will be granted to the members.
               See the [IAM Roles](https://cloud.google.com/compute/docs/access/iam) documentation for a complete list of roles.
               Note that custom roles must be of the format `[projects|organizations]/{parent-name}/roles/{role-name}`.
        :param 'GetIAMPolicyBindingConditionArgs' condition: An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding. Structure is documented below.
        """
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def members(self) -> Sequence[builtins.str]:
        """
        An array of identities that will be granted the privilege in the `role`. For more details on format and restrictions see https://cloud.google.com/billing/reference/rest/v1/Policy#Binding
        Each entry can have one of the following values:
        * **allUsers**: A special identifier that represents anyone who is on the internet; with or without a Google account. Some resources **don't** support this identity.
        * **allAuthenticatedUsers**: A special identifier that represents anyone who is authenticated with a Google account or a service account. Some resources **don't** support this identity.
        * **user:{emailid}**: An email address that represents a specific Google account. For example, alice@gmail.com.
        * **serviceAccount:{emailid}**: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
        * **group:{emailid}**: An email address that represents a Google group. For example, admins@example.com.
        * **domain:{domain}**: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        The role/permission that will be granted to the members.
        See the [IAM Roles](https://cloud.google.com/compute/docs/access/iam) documentation for a complete list of roles.
        Note that custom roles must be of the format `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def condition(self) -> Optional['outputs.GetIAMPolicyBindingConditionResult']:
        """
        An [IAM Condition](https://cloud.google.com/iam/docs/conditions-overview) for a given binding. Structure is documented below.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class GetIAMPolicyBindingConditionResult(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetIamCustomRolesRoleResult(dict):
    def __init__(__self__, *,
                 deleted: builtins.bool,
                 description: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 permissions: Sequence[builtins.str],
                 role_id: builtins.str,
                 stage: builtins.str,
                 title: builtins.str):
        """
        :param builtins.bool deleted: The current deleted state of the role.
        :param builtins.str description: A human-readable description for the role.
        :param builtins.str id: an identifier for the resource with the format `organizations/{{org_id}}/roles/{{role_id}}`.
        :param builtins.str name: The name of the role in the format `organizations/{{org_id}}/roles/{{role_id}}`. Like `id`, this field can be used as a reference in other resources such as IAM role bindings.
        :param Sequence[builtins.str] permissions: The names of the permissions this role grants when bound in an IAM policy.
        :param builtins.str role_id: The camel case role id used for this role.
        :param builtins.str stage: The current launch stage of the role. List of possible stages is [here](https://cloud.google.com/iam/reference/rest/v1/organizations.roles#Role.RoleLaunchStage).
        :param builtins.str title: A human-readable title for the role.
        """
        pulumi.set(__self__, "deleted", deleted)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def deleted(self) -> builtins.bool:
        """
        The current deleted state of the role.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A human-readable description for the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        an identifier for the resource with the format `organizations/{{org_id}}/roles/{{role_id}}`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the role in the format `organizations/{{org_id}}/roles/{{role_id}}`. Like `id`, this field can be used as a reference in other resources such as IAM role bindings.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[builtins.str]:
        """
        The names of the permissions this role grants when bound in an IAM policy.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> builtins.str:
        """
        The camel case role id used for this role.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter
    def stage(self) -> builtins.str:
        """
        The current launch stage of the role. List of possible stages is [here](https://cloud.google.com/iam/reference/rest/v1/organizations.roles#Role.RoleLaunchStage).
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A human-readable title for the role.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GetSOrganizationResult(dict):
    def __init__(__self__, *,
                 directory_customer_id: builtins.str,
                 display_name: builtins.str,
                 lifecycle_state: builtins.str,
                 name: builtins.str,
                 org_id: builtins.str):
        """
        :param builtins.str directory_customer_id: The Google for Work customer ID of the Organization.
        :param builtins.str display_name: A human-readable string that refers to the Organization in the Google Cloud console. The string will be set to the primary domain (for example, `"google.com"`) of the G Suite customer that owns the organization.
        :param builtins.str lifecycle_state: The Organization's current lifecycle state.
        :param builtins.str name: The resource name of the Organization in the form `organizations/{organization_id}`.
        :param builtins.str org_id: The Organization ID.
        """
        pulumi.set(__self__, "directory_customer_id", directory_customer_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "org_id", org_id)

    @property
    @pulumi.getter(name="directoryCustomerId")
    def directory_customer_id(self) -> builtins.str:
        """
        The Google for Work customer ID of the Organization.
        """
        return pulumi.get(self, "directory_customer_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A human-readable string that refers to the Organization in the Google Cloud console. The string will be set to the primary domain (for example, `"google.com"`) of the G Suite customer that owns the organization.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> builtins.str:
        """
        The Organization's current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The resource name of the Organization in the form `organizations/{organization_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> builtins.str:
        """
        The Organization ID.
        """
        return pulumi.get(self, "org_id")


