# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomConstraintArgs', 'CustomConstraint']

@pulumi.input_type
class CustomConstraintArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[builtins.str],
                 condition: pulumi.Input[builtins.str],
                 method_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 parent: pulumi.Input[builtins.str],
                 resource_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CustomConstraint resource.
        :param pulumi.Input[builtins.str] action_type: The action to take if the condition is met.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[builtins.str] condition: A CEL condition that refers to a supported service resource, for example `resource.management.autoUpgrade == false`. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] method_types: A list of RESTful methods for which to enforce the constraint. Can be `CREATE`, `UPDATE`, or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
        :param pulumi.Input[builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_types: Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, `container.googleapis.com/NodePool`.
        :param pulumi.Input[builtins.str] description: A human-friendly description of the constraint to display as an error message when the policy is violated.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the constraint.
        :param pulumi.Input[builtins.str] name: Immutable. The name of the custom constraint. This is unique within the organization.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "method_types", method_types)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "resource_types", resource_types)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[builtins.str]:
        """
        The action to take if the condition is met.
        Possible values are: `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[builtins.str]:
        """
        A CEL condition that refers to a supported service resource, for example `resource.management.autoUpgrade == false`. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="methodTypes")
    def method_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of RESTful methods for which to enforce the constraint. Can be `CREATE`, `UPDATE`, or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
        """
        return pulumi.get(self, "method_types")

    @method_types.setter
    def method_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "method_types", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The parent of the resource, an organization. Format should be `organizations/{organization_id}`.


        - - -
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, `container.googleapis.com/NodePool`.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "resource_types", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-friendly description of the constraint to display as an error message when the policy is violated.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-friendly name for the constraint.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The name of the custom constraint. This is unique within the organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CustomConstraintState:
    def __init__(__self__, *,
                 action_type: Optional[pulumi.Input[builtins.str]] = None,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 method_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomConstraint resources.
        :param pulumi.Input[builtins.str] action_type: The action to take if the condition is met.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[builtins.str] condition: A CEL condition that refers to a supported service resource, for example `resource.management.autoUpgrade == false`. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
        :param pulumi.Input[builtins.str] description: A human-friendly description of the constraint to display as an error message when the policy is violated.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the constraint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] method_types: A list of RESTful methods for which to enforce the constraint. Can be `CREATE`, `UPDATE`, or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
        :param pulumi.Input[builtins.str] name: Immutable. The name of the custom constraint. This is unique within the organization.
        :param pulumi.Input[builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_types: Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, `container.googleapis.com/NodePool`.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp representing when the constraint was last updated.
        """
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if method_types is not None:
            pulumi.set(__self__, "method_types", method_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take if the condition is met.
        Possible values are: `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A CEL condition that refers to a supported service resource, for example `resource.management.autoUpgrade == false`. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-friendly description of the constraint to display as an error message when the policy is violated.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-friendly name for the constraint.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="methodTypes")
    def method_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of RESTful methods for which to enforce the constraint. Can be `CREATE`, `UPDATE`, or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
        """
        return pulumi.get(self, "method_types")

    @method_types.setter
    def method_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "method_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The name of the custom constraint. This is unique within the organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent of the resource, an organization. Format should be `organizations/{organization_id}`.


        - - -
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, `container.googleapis.com/NodePool`.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "resource_types", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp representing when the constraint was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:orgpolicy/customConstraint:CustomConstraint")
class CustomConstraint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input[builtins.str]] = None,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 method_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Custom constraints are created by administrators to provide more granular and customizable control over the specific fields that are restricted by your organization policies.

        To get more information about CustomConstraint, see:

        * [API documentation](https://cloud.google.com/resource-manager/docs/reference/orgpolicy/rest/v2/organizations.constraints)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints)
            * [Supported Services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services)

        ## Example Usage

        ### Org Policy Custom Constraint Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        constraint = gcp.orgpolicy.CustomConstraint("constraint",
            name="custom.disableGkeAutoUpgrade",
            parent="organizations/123456789",
            action_type="ALLOW",
            condition="resource.management.autoUpgrade == false",
            method_types=[
                "CREATE",
                "UPDATE",
            ],
            resource_types=["container.googleapis.com/NodePool"])
        ```
        ### Org Policy Custom Constraint Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        constraint = gcp.orgpolicy.CustomConstraint("constraint",
            name="custom.disableGkeAutoUpgrade",
            parent="organizations/123456789",
            display_name="Disable GKE auto upgrade",
            description="Only allow GKE NodePool resource to be created or updated if AutoUpgrade is not enabled where this custom constraint is enforced.",
            action_type="ALLOW",
            condition="resource.management.autoUpgrade == false",
            method_types=[
                "CREATE",
                "UPDATE",
            ],
            resource_types=["container.googleapis.com/NodePool"])
        bool = gcp.orgpolicy.Policy("bool",
            name=constraint.name.apply(lambda name: f"organizations/123456789/policies/{name}"),
            parent="organizations/123456789",
            spec={
                "rules": [{
                    "enforce": "TRUE",
                }],
            })
        ```

        ## Import

        CustomConstraint can be imported using any of these accepted formats:

        * `{{parent}}/customConstraints/{{name}}`

        When using the `pulumi import` command, CustomConstraint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:orgpolicy/customConstraint:CustomConstraint default {{parent}}/customConstraints/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action_type: The action to take if the condition is met.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[builtins.str] condition: A CEL condition that refers to a supported service resource, for example `resource.management.autoUpgrade == false`. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
        :param pulumi.Input[builtins.str] description: A human-friendly description of the constraint to display as an error message when the policy is violated.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the constraint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] method_types: A list of RESTful methods for which to enforce the constraint. Can be `CREATE`, `UPDATE`, or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
        :param pulumi.Input[builtins.str] name: Immutable. The name of the custom constraint. This is unique within the organization.
        :param pulumi.Input[builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_types: Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, `container.googleapis.com/NodePool`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomConstraintArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom constraints are created by administrators to provide more granular and customizable control over the specific fields that are restricted by your organization policies.

        To get more information about CustomConstraint, see:

        * [API documentation](https://cloud.google.com/resource-manager/docs/reference/orgpolicy/rest/v2/organizations.constraints)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints)
            * [Supported Services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services)

        ## Example Usage

        ### Org Policy Custom Constraint Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        constraint = gcp.orgpolicy.CustomConstraint("constraint",
            name="custom.disableGkeAutoUpgrade",
            parent="organizations/123456789",
            action_type="ALLOW",
            condition="resource.management.autoUpgrade == false",
            method_types=[
                "CREATE",
                "UPDATE",
            ],
            resource_types=["container.googleapis.com/NodePool"])
        ```
        ### Org Policy Custom Constraint Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        constraint = gcp.orgpolicy.CustomConstraint("constraint",
            name="custom.disableGkeAutoUpgrade",
            parent="organizations/123456789",
            display_name="Disable GKE auto upgrade",
            description="Only allow GKE NodePool resource to be created or updated if AutoUpgrade is not enabled where this custom constraint is enforced.",
            action_type="ALLOW",
            condition="resource.management.autoUpgrade == false",
            method_types=[
                "CREATE",
                "UPDATE",
            ],
            resource_types=["container.googleapis.com/NodePool"])
        bool = gcp.orgpolicy.Policy("bool",
            name=constraint.name.apply(lambda name: f"organizations/123456789/policies/{name}"),
            parent="organizations/123456789",
            spec={
                "rules": [{
                    "enforce": "TRUE",
                }],
            })
        ```

        ## Import

        CustomConstraint can be imported using any of these accepted formats:

        * `{{parent}}/customConstraints/{{name}}`

        When using the `pulumi import` command, CustomConstraint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:orgpolicy/customConstraint:CustomConstraint default {{parent}}/customConstraints/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CustomConstraintArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomConstraintArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input[builtins.str]] = None,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 method_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomConstraintArgs.__new__(CustomConstraintArgs)

            if action_type is None and not opts.urn:
                raise TypeError("Missing required property 'action_type'")
            __props__.__dict__["action_type"] = action_type
            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if method_types is None and not opts.urn:
                raise TypeError("Missing required property 'method_types'")
            __props__.__dict__["method_types"] = method_types
            __props__.__dict__["name"] = name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if resource_types is None and not opts.urn:
                raise TypeError("Missing required property 'resource_types'")
            __props__.__dict__["resource_types"] = resource_types
            __props__.__dict__["update_time"] = None
        super(CustomConstraint, __self__).__init__(
            'gcp:orgpolicy/customConstraint:CustomConstraint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_type: Optional[pulumi.Input[builtins.str]] = None,
            condition: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            method_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'CustomConstraint':
        """
        Get an existing CustomConstraint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action_type: The action to take if the condition is met.
               Possible values are: `ALLOW`, `DENY`.
        :param pulumi.Input[builtins.str] condition: A CEL condition that refers to a supported service resource, for example `resource.management.autoUpgrade == false`. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
        :param pulumi.Input[builtins.str] description: A human-friendly description of the constraint to display as an error message when the policy is violated.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the constraint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] method_types: A list of RESTful methods for which to enforce the constraint. Can be `CREATE`, `UPDATE`, or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
        :param pulumi.Input[builtins.str] name: Immutable. The name of the custom constraint. This is unique within the organization.
        :param pulumi.Input[builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_types: Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, `container.googleapis.com/NodePool`.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp representing when the constraint was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomConstraintState.__new__(_CustomConstraintState)

        __props__.__dict__["action_type"] = action_type
        __props__.__dict__["condition"] = condition
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["method_types"] = method_types
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["resource_types"] = resource_types
        __props__.__dict__["update_time"] = update_time
        return CustomConstraint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Output[builtins.str]:
        """
        The action to take if the condition is met.
        Possible values are: `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[builtins.str]:
        """
        A CEL condition that refers to a supported service resource, for example `resource.management.autoUpgrade == false`. For details about CEL usage, see [Common Expression Language](https://cloud.google.com/resource-manager/docs/organization-policy/creating-managing-custom-constraints#common_expression_language).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-friendly description of the constraint to display as an error message when the policy is violated.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-friendly name for the constraint.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="methodTypes")
    def method_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of RESTful methods for which to enforce the constraint. Can be `CREATE`, `UPDATE`, or both. Not all Google Cloud services support both methods. To see supported methods for each service, find the service in [Supported services](https://cloud.google.com/resource-manager/docs/organization-policy/custom-constraint-supported-services).
        """
        return pulumi.get(self, "method_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Immutable. The name of the custom constraint. This is unique within the organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The parent of the resource, an organization. Format should be `organizations/{organization_id}`.


        - - -
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Immutable. The fully qualified name of the Google Cloud REST resource containing the object and field you want to restrict. For example, `container.googleapis.com/NodePool`.
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp representing when the constraint was last updated.
        """
        return pulumi.get(self, "update_time")

