# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegionalParameterVersionRenderResult',
    'AwaitableGetRegionalParameterVersionRenderResult',
    'get_regional_parameter_version_render',
    'get_regional_parameter_version_render_output',
]

@pulumi.output_type
class GetRegionalParameterVersionRenderResult:
    """
    A collection of values returned by getRegionalParameterVersionRender.
    """
    def __init__(__self__, disabled=None, id=None, location=None, name=None, parameter=None, parameter_data=None, parameter_version_id=None, project=None, rendered_parameter_data=None):
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameter and not isinstance(parameter, str):
            raise TypeError("Expected argument 'parameter' to be a str")
        pulumi.set(__self__, "parameter", parameter)
        if parameter_data and not isinstance(parameter_data, str):
            raise TypeError("Expected argument 'parameter_data' to be a str")
        pulumi.set(__self__, "parameter_data", parameter_data)
        if parameter_version_id and not isinstance(parameter_version_id, str):
            raise TypeError("Expected argument 'parameter_version_id' to be a str")
        pulumi.set(__self__, "parameter_version_id", parameter_version_id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if rendered_parameter_data and not isinstance(rendered_parameter_data, str):
            raise TypeError("Expected argument 'rendered_parameter_data' to be a str")
        pulumi.set(__self__, "rendered_parameter_data", rendered_parameter_data)

    @property
    @pulumi.getter
    def disabled(self) -> builtins.bool:
        """
        The current state of the Regional Parameter Version.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The resource name of the RegionalParameterVersion. Format:
        `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameter(self) -> builtins.str:
        return pulumi.get(self, "parameter")

    @property
    @pulumi.getter(name="parameterData")
    def parameter_data(self) -> builtins.str:
        """
        The Parameter data.
        """
        return pulumi.get(self, "parameter_data")

    @property
    @pulumi.getter(name="parameterVersionId")
    def parameter_version_id(self) -> builtins.str:
        return pulumi.get(self, "parameter_version_id")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="renderedParameterData")
    def rendered_parameter_data(self) -> builtins.str:
        """
        The Rendered Parameter Data specifies that if you use `__REF__()` to reference a secret and the format is JSON or YAML, the placeholder `__REF__()` will be replaced with the actual secret value. However, if the format is UNFORMATTED, it will stay the same as the original `parameter_data`.
        """
        return pulumi.get(self, "rendered_parameter_data")


class AwaitableGetRegionalParameterVersionRenderResult(GetRegionalParameterVersionRenderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalParameterVersionRenderResult(
            disabled=self.disabled,
            id=self.id,
            location=self.location,
            name=self.name,
            parameter=self.parameter,
            parameter_data=self.parameter_data,
            parameter_version_id=self.parameter_version_id,
            project=self.project,
            rendered_parameter_data=self.rendered_parameter_data)


def get_regional_parameter_version_render(location: Optional[builtins.str] = None,
                                          parameter: Optional[builtins.str] = None,
                                          parameter_version_id: Optional[builtins.str] = None,
                                          project: Optional[builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalParameterVersionRenderResult:
    """
    Get the value and metadata from a Parameter Manager Regional Parameter version with rendered payload data. For this datasource to work as expected, the principal of the parameter must be provided with the [Secret Manager Secret Accessor](https://cloud.google.com/secret-manager/docs/access-control#secretmanager.secretAccessor) role. For more information see the [official documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/overview)  and [API](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters.versions/render).

    > **Warning:** To use this data source, we must grant the `Secret Manager Secret Accessor` role to the principal of the parameter. Please note that it can take up to 7 minutes for the role to take effect. Hence, we might need to wait approximately 7 minutes after granting  `Secret Manager Secret Accessor` role to the principal of the parameter. For more information see the [access change propagation documentation](https://cloud.google.com/iam/docs/access-change-propagation).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.parametermanager.get_regional_parameter_version_render(parameter="test-regional-parameter",
        parameter_version_id="test-regional-parameter-version",
        location="us-central1")
    ```


    :param builtins.str location: Location of Parameter Manager regional Parameter resource.
           It must be provided when the `parameter` field provided consists of only the name of the regional parameter.
    :param builtins.str parameter: The Parameter for obtaining the Regional Parameter Version.
           This can be either the reference of the parameter as in `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}` or only the name of the parameter as in `{{parameter_id}}`.
    :param builtins.str parameter_version_id: The version of the regional parameter to get.
    :param builtins.str project: The project for retrieving the Regional Parameter Version. If it's not
           specified, the provider project will be used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['parameter'] = parameter
    __args__['parameterVersionId'] = parameter_version_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:parametermanager/getRegionalParameterVersionRender:getRegionalParameterVersionRender', __args__, opts=opts, typ=GetRegionalParameterVersionRenderResult).value

    return AwaitableGetRegionalParameterVersionRenderResult(
        disabled=pulumi.get(__ret__, 'disabled'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        parameter=pulumi.get(__ret__, 'parameter'),
        parameter_data=pulumi.get(__ret__, 'parameter_data'),
        parameter_version_id=pulumi.get(__ret__, 'parameter_version_id'),
        project=pulumi.get(__ret__, 'project'),
        rendered_parameter_data=pulumi.get(__ret__, 'rendered_parameter_data'))
def get_regional_parameter_version_render_output(location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                 parameter: Optional[pulumi.Input[builtins.str]] = None,
                                                 parameter_version_id: Optional[pulumi.Input[builtins.str]] = None,
                                                 project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionalParameterVersionRenderResult]:
    """
    Get the value and metadata from a Parameter Manager Regional Parameter version with rendered payload data. For this datasource to work as expected, the principal of the parameter must be provided with the [Secret Manager Secret Accessor](https://cloud.google.com/secret-manager/docs/access-control#secretmanager.secretAccessor) role. For more information see the [official documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/overview)  and [API](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters.versions/render).

    > **Warning:** To use this data source, we must grant the `Secret Manager Secret Accessor` role to the principal of the parameter. Please note that it can take up to 7 minutes for the role to take effect. Hence, we might need to wait approximately 7 minutes after granting  `Secret Manager Secret Accessor` role to the principal of the parameter. For more information see the [access change propagation documentation](https://cloud.google.com/iam/docs/access-change-propagation).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.parametermanager.get_regional_parameter_version_render(parameter="test-regional-parameter",
        parameter_version_id="test-regional-parameter-version",
        location="us-central1")
    ```


    :param builtins.str location: Location of Parameter Manager regional Parameter resource.
           It must be provided when the `parameter` field provided consists of only the name of the regional parameter.
    :param builtins.str parameter: The Parameter for obtaining the Regional Parameter Version.
           This can be either the reference of the parameter as in `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}` or only the name of the parameter as in `{{parameter_id}}`.
    :param builtins.str parameter_version_id: The version of the regional parameter to get.
    :param builtins.str project: The project for retrieving the Regional Parameter Version. If it's not
           specified, the provider project will be used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['parameter'] = parameter
    __args__['parameterVersionId'] = parameter_version_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:parametermanager/getRegionalParameterVersionRender:getRegionalParameterVersionRender', __args__, opts=opts, typ=GetRegionalParameterVersionRenderResult)
    return __ret__.apply(lambda __response__: GetRegionalParameterVersionRenderResult(
        disabled=pulumi.get(__response__, 'disabled'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        parameter=pulumi.get(__response__, 'parameter'),
        parameter_data=pulumi.get(__response__, 'parameter_data'),
        parameter_version_id=pulumi.get(__response__, 'parameter_version_id'),
        project=pulumi.get(__response__, 'project'),
        rendered_parameter_data=pulumi.get(__response__, 'rendered_parameter_data')))
