# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EntitlementArgs', 'Entitlement']

@pulumi.input_type
class EntitlementArgs:
    def __init__(__self__, *,
                 eligible_users: pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]],
                 entitlement_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 max_request_duration: pulumi.Input[builtins.str],
                 parent: pulumi.Input[builtins.str],
                 privileged_access: pulumi.Input['EntitlementPrivilegedAccessArgs'],
                 requester_justification_config: pulumi.Input['EntitlementRequesterJustificationConfigArgs'],
                 additional_notification_targets: Optional[pulumi.Input['EntitlementAdditionalNotificationTargetsArgs']] = None,
                 approval_workflow: Optional[pulumi.Input['EntitlementApprovalWorkflowArgs']] = None):
        """
        The set of arguments for constructing a Entitlement resource.
        :param pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]] eligible_users: Who can create Grants using Entitlement. This list should contain at most one entry
               Structure is documented below.
        :param pulumi.Input[builtins.str] entitlement_id: The ID to use for this Entitlement. This will become the last part of the resource name.
               This value should be 4-63 characters, and valid characters are "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
               This value should be unique among all other Entitlements under the specified `parent`.
        :param pulumi.Input[builtins.str] location: The region of the Entitlement resource.
        :param pulumi.Input[builtins.str] max_request_duration: The maximum amount of time for which access would be granted for a request.
               A requester can choose to ask for access for less than this duration but never more.
               Format: calculate the time in seconds and concatenate it with 's' i.e. 2 hours = "7200s", 45 minutes = "2700s"
        :param pulumi.Input[builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input['EntitlementPrivilegedAccessArgs'] privileged_access: Privileged access that this service can be used to gate.
               Structure is documented below.
        :param pulumi.Input['EntitlementRequesterJustificationConfigArgs'] requester_justification_config: Defines the ways in which a requester should provide the justification while requesting for access.
               Structure is documented below.
        :param pulumi.Input['EntitlementAdditionalNotificationTargetsArgs'] additional_notification_targets: AdditionalNotificationTargets includes email addresses to be notified.
        :param pulumi.Input['EntitlementApprovalWorkflowArgs'] approval_workflow: The approvals needed before access will be granted to a requester. No approvals will be needed if this field is null.
               Different types of approval workflows that can be used to gate privileged access granting.
        """
        pulumi.set(__self__, "eligible_users", eligible_users)
        pulumi.set(__self__, "entitlement_id", entitlement_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "max_request_duration", max_request_duration)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "privileged_access", privileged_access)
        pulumi.set(__self__, "requester_justification_config", requester_justification_config)
        if additional_notification_targets is not None:
            pulumi.set(__self__, "additional_notification_targets", additional_notification_targets)
        if approval_workflow is not None:
            pulumi.set(__self__, "approval_workflow", approval_workflow)

    @property
    @pulumi.getter(name="eligibleUsers")
    def eligible_users(self) -> pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]]:
        """
        Who can create Grants using Entitlement. This list should contain at most one entry
        Structure is documented below.
        """
        return pulumi.get(self, "eligible_users")

    @eligible_users.setter
    def eligible_users(self, value: pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]]):
        pulumi.set(self, "eligible_users", value)

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for this Entitlement. This will become the last part of the resource name.
        This value should be 4-63 characters, and valid characters are "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
        This value should be unique among all other Entitlements under the specified `parent`.
        """
        return pulumi.get(self, "entitlement_id")

    @entitlement_id.setter
    def entitlement_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entitlement_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The region of the Entitlement resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxRequestDuration")
    def max_request_duration(self) -> pulumi.Input[builtins.str]:
        """
        The maximum amount of time for which access would be granted for a request.
        A requester can choose to ask for access for less than this duration but never more.
        Format: calculate the time in seconds and concatenate it with 's' i.e. 2 hours = "7200s", 45 minutes = "2700s"
        """
        return pulumi.get(self, "max_request_duration")

    @max_request_duration.setter
    def max_request_duration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "max_request_duration", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="privilegedAccess")
    def privileged_access(self) -> pulumi.Input['EntitlementPrivilegedAccessArgs']:
        """
        Privileged access that this service can be used to gate.
        Structure is documented below.
        """
        return pulumi.get(self, "privileged_access")

    @privileged_access.setter
    def privileged_access(self, value: pulumi.Input['EntitlementPrivilegedAccessArgs']):
        pulumi.set(self, "privileged_access", value)

    @property
    @pulumi.getter(name="requesterJustificationConfig")
    def requester_justification_config(self) -> pulumi.Input['EntitlementRequesterJustificationConfigArgs']:
        """
        Defines the ways in which a requester should provide the justification while requesting for access.
        Structure is documented below.
        """
        return pulumi.get(self, "requester_justification_config")

    @requester_justification_config.setter
    def requester_justification_config(self, value: pulumi.Input['EntitlementRequesterJustificationConfigArgs']):
        pulumi.set(self, "requester_justification_config", value)

    @property
    @pulumi.getter(name="additionalNotificationTargets")
    def additional_notification_targets(self) -> Optional[pulumi.Input['EntitlementAdditionalNotificationTargetsArgs']]:
        """
        AdditionalNotificationTargets includes email addresses to be notified.
        """
        return pulumi.get(self, "additional_notification_targets")

    @additional_notification_targets.setter
    def additional_notification_targets(self, value: Optional[pulumi.Input['EntitlementAdditionalNotificationTargetsArgs']]):
        pulumi.set(self, "additional_notification_targets", value)

    @property
    @pulumi.getter(name="approvalWorkflow")
    def approval_workflow(self) -> Optional[pulumi.Input['EntitlementApprovalWorkflowArgs']]:
        """
        The approvals needed before access will be granted to a requester. No approvals will be needed if this field is null.
        Different types of approval workflows that can be used to gate privileged access granting.
        """
        return pulumi.get(self, "approval_workflow")

    @approval_workflow.setter
    def approval_workflow(self, value: Optional[pulumi.Input['EntitlementApprovalWorkflowArgs']]):
        pulumi.set(self, "approval_workflow", value)


@pulumi.input_type
class _EntitlementState:
    def __init__(__self__, *,
                 additional_notification_targets: Optional[pulumi.Input['EntitlementAdditionalNotificationTargetsArgs']] = None,
                 approval_workflow: Optional[pulumi.Input['EntitlementApprovalWorkflowArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 eligible_users: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]]] = None,
                 entitlement_id: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_request_duration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 privileged_access: Optional[pulumi.Input['EntitlementPrivilegedAccessArgs']] = None,
                 requester_justification_config: Optional[pulumi.Input['EntitlementRequesterJustificationConfigArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Entitlement resources.
        :param pulumi.Input['EntitlementAdditionalNotificationTargetsArgs'] additional_notification_targets: AdditionalNotificationTargets includes email addresses to be notified.
        :param pulumi.Input['EntitlementApprovalWorkflowArgs'] approval_workflow: The approvals needed before access will be granted to a requester. No approvals will be needed if this field is null.
               Different types of approval workflows that can be used to gate privileged access granting.
        :param pulumi.Input[builtins.str] create_time: Output only. Create time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]] eligible_users: Who can create Grants using Entitlement. This list should contain at most one entry
               Structure is documented below.
        :param pulumi.Input[builtins.str] entitlement_id: The ID to use for this Entitlement. This will become the last part of the resource name.
               This value should be 4-63 characters, and valid characters are "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
               This value should be unique among all other Entitlements under the specified `parent`.
        :param pulumi.Input[builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input[builtins.str] location: The region of the Entitlement resource.
        :param pulumi.Input[builtins.str] max_request_duration: The maximum amount of time for which access would be granted for a request.
               A requester can choose to ask for access for less than this duration but never more.
               Format: calculate the time in seconds and concatenate it with 's' i.e. 2 hours = "7200s", 45 minutes = "2700s"
        :param pulumi.Input[builtins.str] name: Output Only. The entitlement's name follows a hierarchical structure, comprising the organization, folder, or project, alongside the region and a unique entitlement ID.
               Formats: organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}, folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}, and projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}.
        :param pulumi.Input[builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input['EntitlementPrivilegedAccessArgs'] privileged_access: Privileged access that this service can be used to gate.
               Structure is documented below.
        :param pulumi.Input['EntitlementRequesterJustificationConfigArgs'] requester_justification_config: Defines the ways in which a requester should provide the justification while requesting for access.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: Output only. The current state of the Entitlement.
        :param pulumi.Input[builtins.str] update_time: Output only. Update time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if additional_notification_targets is not None:
            pulumi.set(__self__, "additional_notification_targets", additional_notification_targets)
        if approval_workflow is not None:
            pulumi.set(__self__, "approval_workflow", approval_workflow)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if eligible_users is not None:
            pulumi.set(__self__, "eligible_users", eligible_users)
        if entitlement_id is not None:
            pulumi.set(__self__, "entitlement_id", entitlement_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_request_duration is not None:
            pulumi.set(__self__, "max_request_duration", max_request_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if privileged_access is not None:
            pulumi.set(__self__, "privileged_access", privileged_access)
        if requester_justification_config is not None:
            pulumi.set(__self__, "requester_justification_config", requester_justification_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="additionalNotificationTargets")
    def additional_notification_targets(self) -> Optional[pulumi.Input['EntitlementAdditionalNotificationTargetsArgs']]:
        """
        AdditionalNotificationTargets includes email addresses to be notified.
        """
        return pulumi.get(self, "additional_notification_targets")

    @additional_notification_targets.setter
    def additional_notification_targets(self, value: Optional[pulumi.Input['EntitlementAdditionalNotificationTargetsArgs']]):
        pulumi.set(self, "additional_notification_targets", value)

    @property
    @pulumi.getter(name="approvalWorkflow")
    def approval_workflow(self) -> Optional[pulumi.Input['EntitlementApprovalWorkflowArgs']]:
        """
        The approvals needed before access will be granted to a requester. No approvals will be needed if this field is null.
        Different types of approval workflows that can be used to gate privileged access granting.
        """
        return pulumi.get(self, "approval_workflow")

    @approval_workflow.setter
    def approval_workflow(self, value: Optional[pulumi.Input['EntitlementApprovalWorkflowArgs']]):
        pulumi.set(self, "approval_workflow", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Create time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="eligibleUsers")
    def eligible_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]]]:
        """
        Who can create Grants using Entitlement. This list should contain at most one entry
        Structure is documented below.
        """
        return pulumi.get(self, "eligible_users")

    @eligible_users.setter
    def eligible_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntitlementEligibleUserArgs']]]]):
        pulumi.set(self, "eligible_users", value)

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for this Entitlement. This will become the last part of the resource name.
        This value should be 4-63 characters, and valid characters are "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
        This value should be unique among all other Entitlements under the specified `parent`.
        """
        return pulumi.get(self, "entitlement_id")

    @entitlement_id.setter
    def entitlement_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entitlement_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For Resource freshness validation (https://google.aip.dev/154)
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the Entitlement resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxRequestDuration")
    def max_request_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum amount of time for which access would be granted for a request.
        A requester can choose to ask for access for less than this duration but never more.
        Format: calculate the time in seconds and concatenate it with 's' i.e. 2 hours = "7200s", 45 minutes = "2700s"
        """
        return pulumi.get(self, "max_request_duration")

    @max_request_duration.setter
    def max_request_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_request_duration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output Only. The entitlement's name follows a hierarchical structure, comprising the organization, folder, or project, alongside the region and a unique entitlement ID.
        Formats: organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}, folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}, and projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="privilegedAccess")
    def privileged_access(self) -> Optional[pulumi.Input['EntitlementPrivilegedAccessArgs']]:
        """
        Privileged access that this service can be used to gate.
        Structure is documented below.
        """
        return pulumi.get(self, "privileged_access")

    @privileged_access.setter
    def privileged_access(self, value: Optional[pulumi.Input['EntitlementPrivilegedAccessArgs']]):
        pulumi.set(self, "privileged_access", value)

    @property
    @pulumi.getter(name="requesterJustificationConfig")
    def requester_justification_config(self) -> Optional[pulumi.Input['EntitlementRequesterJustificationConfigArgs']]:
        """
        Defines the ways in which a requester should provide the justification while requesting for access.
        Structure is documented below.
        """
        return pulumi.get(self, "requester_justification_config")

    @requester_justification_config.setter
    def requester_justification_config(self, value: Optional[pulumi.Input['EntitlementRequesterJustificationConfigArgs']]):
        pulumi.set(self, "requester_justification_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The current state of the Entitlement.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Update time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:privilegedaccessmanager/entitlement:entitlement")
class Entitlement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_notification_targets: Optional[pulumi.Input[Union['EntitlementAdditionalNotificationTargetsArgs', 'EntitlementAdditionalNotificationTargetsArgsDict']]] = None,
                 approval_workflow: Optional[pulumi.Input[Union['EntitlementApprovalWorkflowArgs', 'EntitlementApprovalWorkflowArgsDict']]] = None,
                 eligible_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementEligibleUserArgs', 'EntitlementEligibleUserArgsDict']]]]] = None,
                 entitlement_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_request_duration: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 privileged_access: Optional[pulumi.Input[Union['EntitlementPrivilegedAccessArgs', 'EntitlementPrivilegedAccessArgsDict']]] = None,
                 requester_justification_config: Optional[pulumi.Input[Union['EntitlementRequesterJustificationConfigArgs', 'EntitlementRequesterJustificationConfigArgsDict']]] = None,
                 __props__=None):
        """
        An Entitlement defines the eligibility of a set of users to obtain a predefined access for some time possibly after going through an approval workflow.

        To get more information about Entitlement, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/pam/rest)
        * How-to Guides
            * [How to create an Entitlement](https://cloud.google.com/iam/docs/pam-create-entitlements)
            * [Official Documentation](https://cloud.google.com/iam/docs/pam-overview)

        ## Example Usage

        ### Privileged Access Manager Entitlement Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tfentitlement = gcp.privilegedaccessmanager.Entitlement("tfentitlement",
            entitlement_id="example-entitlement",
            location="global",
            max_request_duration="43200s",
            parent="projects/my-project-name",
            requester_justification_config={
                "unstructured": {},
            },
            eligible_users=[{
                "principals": ["group:test@google.com"],
            }],
            privileged_access={
                "gcp_iam_access": {
                    "role_bindings": [{
                        "role": "roles/storage.admin",
                        "condition_expression": "request.time < timestamp(\\"2024-04-23T18:30:00.000Z\\")",
                    }],
                    "resource": "//cloudresourcemanager.googleapis.com/projects/my-project-name",
                    "resource_type": "cloudresourcemanager.googleapis.com/Project",
                },
            },
            additional_notification_targets={
                "admin_email_recipients": ["user@example.com"],
                "requester_email_recipients": ["user@example.com"],
            },
            approval_workflow={
                "manual_approvals": {
                    "require_approver_justification": True,
                    "steps": [{
                        "approvals_needed": 1,
                        "approver_email_recipients": ["user@example.com"],
                        "approvers": {
                            "principals": ["group:test@google.com"],
                        },
                    }],
                },
            })
        ```

        ## Import

        Entitlement can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/entitlements/{{entitlement_id}}`

        When using the `pulumi import` command, Entitlement can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:privilegedaccessmanager/entitlement:entitlement default {{parent}}/locations/{{location}}/entitlements/{{entitlement_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EntitlementAdditionalNotificationTargetsArgs', 'EntitlementAdditionalNotificationTargetsArgsDict']] additional_notification_targets: AdditionalNotificationTargets includes email addresses to be notified.
        :param pulumi.Input[Union['EntitlementApprovalWorkflowArgs', 'EntitlementApprovalWorkflowArgsDict']] approval_workflow: The approvals needed before access will be granted to a requester. No approvals will be needed if this field is null.
               Different types of approval workflows that can be used to gate privileged access granting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntitlementEligibleUserArgs', 'EntitlementEligibleUserArgsDict']]]] eligible_users: Who can create Grants using Entitlement. This list should contain at most one entry
               Structure is documented below.
        :param pulumi.Input[builtins.str] entitlement_id: The ID to use for this Entitlement. This will become the last part of the resource name.
               This value should be 4-63 characters, and valid characters are "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
               This value should be unique among all other Entitlements under the specified `parent`.
        :param pulumi.Input[builtins.str] location: The region of the Entitlement resource.
        :param pulumi.Input[builtins.str] max_request_duration: The maximum amount of time for which access would be granted for a request.
               A requester can choose to ask for access for less than this duration but never more.
               Format: calculate the time in seconds and concatenate it with 's' i.e. 2 hours = "7200s", 45 minutes = "2700s"
        :param pulumi.Input[builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input[Union['EntitlementPrivilegedAccessArgs', 'EntitlementPrivilegedAccessArgsDict']] privileged_access: Privileged access that this service can be used to gate.
               Structure is documented below.
        :param pulumi.Input[Union['EntitlementRequesterJustificationConfigArgs', 'EntitlementRequesterJustificationConfigArgsDict']] requester_justification_config: Defines the ways in which a requester should provide the justification while requesting for access.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntitlementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Entitlement defines the eligibility of a set of users to obtain a predefined access for some time possibly after going through an approval workflow.

        To get more information about Entitlement, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/pam/rest)
        * How-to Guides
            * [How to create an Entitlement](https://cloud.google.com/iam/docs/pam-create-entitlements)
            * [Official Documentation](https://cloud.google.com/iam/docs/pam-overview)

        ## Example Usage

        ### Privileged Access Manager Entitlement Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tfentitlement = gcp.privilegedaccessmanager.Entitlement("tfentitlement",
            entitlement_id="example-entitlement",
            location="global",
            max_request_duration="43200s",
            parent="projects/my-project-name",
            requester_justification_config={
                "unstructured": {},
            },
            eligible_users=[{
                "principals": ["group:test@google.com"],
            }],
            privileged_access={
                "gcp_iam_access": {
                    "role_bindings": [{
                        "role": "roles/storage.admin",
                        "condition_expression": "request.time < timestamp(\\"2024-04-23T18:30:00.000Z\\")",
                    }],
                    "resource": "//cloudresourcemanager.googleapis.com/projects/my-project-name",
                    "resource_type": "cloudresourcemanager.googleapis.com/Project",
                },
            },
            additional_notification_targets={
                "admin_email_recipients": ["user@example.com"],
                "requester_email_recipients": ["user@example.com"],
            },
            approval_workflow={
                "manual_approvals": {
                    "require_approver_justification": True,
                    "steps": [{
                        "approvals_needed": 1,
                        "approver_email_recipients": ["user@example.com"],
                        "approvers": {
                            "principals": ["group:test@google.com"],
                        },
                    }],
                },
            })
        ```

        ## Import

        Entitlement can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/entitlements/{{entitlement_id}}`

        When using the `pulumi import` command, Entitlement can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:privilegedaccessmanager/entitlement:entitlement default {{parent}}/locations/{{location}}/entitlements/{{entitlement_id}}
        ```

        :param str resource_name: The name of the resource.
        :param EntitlementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntitlementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_notification_targets: Optional[pulumi.Input[Union['EntitlementAdditionalNotificationTargetsArgs', 'EntitlementAdditionalNotificationTargetsArgsDict']]] = None,
                 approval_workflow: Optional[pulumi.Input[Union['EntitlementApprovalWorkflowArgs', 'EntitlementApprovalWorkflowArgsDict']]] = None,
                 eligible_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementEligibleUserArgs', 'EntitlementEligibleUserArgsDict']]]]] = None,
                 entitlement_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_request_duration: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 privileged_access: Optional[pulumi.Input[Union['EntitlementPrivilegedAccessArgs', 'EntitlementPrivilegedAccessArgsDict']]] = None,
                 requester_justification_config: Optional[pulumi.Input[Union['EntitlementRequesterJustificationConfigArgs', 'EntitlementRequesterJustificationConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntitlementArgs.__new__(EntitlementArgs)

            __props__.__dict__["additional_notification_targets"] = additional_notification_targets
            __props__.__dict__["approval_workflow"] = approval_workflow
            if eligible_users is None and not opts.urn:
                raise TypeError("Missing required property 'eligible_users'")
            __props__.__dict__["eligible_users"] = eligible_users
            if entitlement_id is None and not opts.urn:
                raise TypeError("Missing required property 'entitlement_id'")
            __props__.__dict__["entitlement_id"] = entitlement_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if max_request_duration is None and not opts.urn:
                raise TypeError("Missing required property 'max_request_duration'")
            __props__.__dict__["max_request_duration"] = max_request_duration
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if privileged_access is None and not opts.urn:
                raise TypeError("Missing required property 'privileged_access'")
            __props__.__dict__["privileged_access"] = privileged_access
            if requester_justification_config is None and not opts.urn:
                raise TypeError("Missing required property 'requester_justification_config'")
            __props__.__dict__["requester_justification_config"] = requester_justification_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(Entitlement, __self__).__init__(
            'gcp:privilegedaccessmanager/entitlement:entitlement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_notification_targets: Optional[pulumi.Input[Union['EntitlementAdditionalNotificationTargetsArgs', 'EntitlementAdditionalNotificationTargetsArgsDict']]] = None,
            approval_workflow: Optional[pulumi.Input[Union['EntitlementApprovalWorkflowArgs', 'EntitlementApprovalWorkflowArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            eligible_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntitlementEligibleUserArgs', 'EntitlementEligibleUserArgsDict']]]]] = None,
            entitlement_id: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            max_request_duration: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            privileged_access: Optional[pulumi.Input[Union['EntitlementPrivilegedAccessArgs', 'EntitlementPrivilegedAccessArgsDict']]] = None,
            requester_justification_config: Optional[pulumi.Input[Union['EntitlementRequesterJustificationConfigArgs', 'EntitlementRequesterJustificationConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Entitlement':
        """
        Get an existing Entitlement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EntitlementAdditionalNotificationTargetsArgs', 'EntitlementAdditionalNotificationTargetsArgsDict']] additional_notification_targets: AdditionalNotificationTargets includes email addresses to be notified.
        :param pulumi.Input[Union['EntitlementApprovalWorkflowArgs', 'EntitlementApprovalWorkflowArgsDict']] approval_workflow: The approvals needed before access will be granted to a requester. No approvals will be needed if this field is null.
               Different types of approval workflows that can be used to gate privileged access granting.
        :param pulumi.Input[builtins.str] create_time: Output only. Create time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntitlementEligibleUserArgs', 'EntitlementEligibleUserArgsDict']]]] eligible_users: Who can create Grants using Entitlement. This list should contain at most one entry
               Structure is documented below.
        :param pulumi.Input[builtins.str] entitlement_id: The ID to use for this Entitlement. This will become the last part of the resource name.
               This value should be 4-63 characters, and valid characters are "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
               This value should be unique among all other Entitlements under the specified `parent`.
        :param pulumi.Input[builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input[builtins.str] location: The region of the Entitlement resource.
        :param pulumi.Input[builtins.str] max_request_duration: The maximum amount of time for which access would be granted for a request.
               A requester can choose to ask for access for less than this duration but never more.
               Format: calculate the time in seconds and concatenate it with 's' i.e. 2 hours = "7200s", 45 minutes = "2700s"
        :param pulumi.Input[builtins.str] name: Output Only. The entitlement's name follows a hierarchical structure, comprising the organization, folder, or project, alongside the region and a unique entitlement ID.
               Formats: organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}, folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}, and projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}.
        :param pulumi.Input[builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input[Union['EntitlementPrivilegedAccessArgs', 'EntitlementPrivilegedAccessArgsDict']] privileged_access: Privileged access that this service can be used to gate.
               Structure is documented below.
        :param pulumi.Input[Union['EntitlementRequesterJustificationConfigArgs', 'EntitlementRequesterJustificationConfigArgsDict']] requester_justification_config: Defines the ways in which a requester should provide the justification while requesting for access.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: Output only. The current state of the Entitlement.
        :param pulumi.Input[builtins.str] update_time: Output only. Update time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntitlementState.__new__(_EntitlementState)

        __props__.__dict__["additional_notification_targets"] = additional_notification_targets
        __props__.__dict__["approval_workflow"] = approval_workflow
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["eligible_users"] = eligible_users
        __props__.__dict__["entitlement_id"] = entitlement_id
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["max_request_duration"] = max_request_duration
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["privileged_access"] = privileged_access
        __props__.__dict__["requester_justification_config"] = requester_justification_config
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return Entitlement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalNotificationTargets")
    def additional_notification_targets(self) -> pulumi.Output[Optional['outputs.EntitlementAdditionalNotificationTargets']]:
        """
        AdditionalNotificationTargets includes email addresses to be notified.
        """
        return pulumi.get(self, "additional_notification_targets")

    @property
    @pulumi.getter(name="approvalWorkflow")
    def approval_workflow(self) -> pulumi.Output[Optional['outputs.EntitlementApprovalWorkflow']]:
        """
        The approvals needed before access will be granted to a requester. No approvals will be needed if this field is null.
        Different types of approval workflows that can be used to gate privileged access granting.
        """
        return pulumi.get(self, "approval_workflow")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Create time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="eligibleUsers")
    def eligible_users(self) -> pulumi.Output[Sequence['outputs.EntitlementEligibleUser']]:
        """
        Who can create Grants using Entitlement. This list should contain at most one entry
        Structure is documented below.
        """
        return pulumi.get(self, "eligible_users")

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for this Entitlement. This will become the last part of the resource name.
        This value should be 4-63 characters, and valid characters are "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
        This value should be unique among all other Entitlements under the specified `parent`.
        """
        return pulumi.get(self, "entitlement_id")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        For Resource freshness validation (https://google.aip.dev/154)
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The region of the Entitlement resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxRequestDuration")
    def max_request_duration(self) -> pulumi.Output[builtins.str]:
        """
        The maximum amount of time for which access would be granted for a request.
        A requester can choose to ask for access for less than this duration but never more.
        Format: calculate the time in seconds and concatenate it with 's' i.e. 2 hours = "7200s", 45 minutes = "2700s"
        """
        return pulumi.get(self, "max_request_duration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Output Only. The entitlement's name follows a hierarchical structure, comprising the organization, folder, or project, alongside the region and a unique entitlement ID.
        Formats: organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}, folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}, and projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="privilegedAccess")
    def privileged_access(self) -> pulumi.Output['outputs.EntitlementPrivilegedAccess']:
        """
        Privileged access that this service can be used to gate.
        Structure is documented below.
        """
        return pulumi.get(self, "privileged_access")

    @property
    @pulumi.getter(name="requesterJustificationConfig")
    def requester_justification_config(self) -> pulumi.Output['outputs.EntitlementRequesterJustificationConfig']:
        """
        Defines the ways in which a requester should provide the justification while requesting for access.
        Structure is documented below.
        """
        return pulumi.get(self, "requester_justification_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The current state of the Entitlement.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Update time stamp. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

