# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAncestryResult',
    'AwaitableGetAncestryResult',
    'get_ancestry',
    'get_ancestry_output',
]

@pulumi.output_type
class GetAncestryResult:
    """
    A collection of values returned by getAncestry.
    """
    def __init__(__self__, ancestors=None, id=None, org_id=None, parent_id=None, parent_type=None, project=None):
        if ancestors and not isinstance(ancestors, list):
            raise TypeError("Expected argument 'ancestors' to be a list")
        pulumi.set(__self__, "ancestors", ancestors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if parent_type and not isinstance(parent_type, str):
            raise TypeError("Expected argument 'parent_type' to be a str")
        pulumi.set(__self__, "parent_type", parent_type)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def ancestors(self) -> Sequence['outputs.GetAncestryAncestorResult']:
        """
        A list of the project's ancestors. Structure is defined below.
        """
        return pulumi.get(self, "ancestors")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> builtins.str:
        """
        The optional user-assigned display name of the project.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> builtins.str:
        """
        The parent's id.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> builtins.str:
        """
        One of `"folder"` or `"organization"`.
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")


class AwaitableGetAncestryResult(GetAncestryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAncestryResult(
            ancestors=self.ancestors,
            id=self.id,
            org_id=self.org_id,
            parent_id=self.parent_id,
            parent_type=self.parent_type,
            project=self.project)


def get_ancestry(project: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAncestryResult:
    """
    Retrieve the ancestors for a project.
    See the [REST API](https://cloud.google.com/resource-manager/reference/rest/v1/projects/getAncestry) for more details.


    :param builtins.str project: The ID of the project. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:projects/getAncestry:getAncestry', __args__, opts=opts, typ=GetAncestryResult).value

    return AwaitableGetAncestryResult(
        ancestors=pulumi.get(__ret__, 'ancestors'),
        id=pulumi.get(__ret__, 'id'),
        org_id=pulumi.get(__ret__, 'org_id'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        parent_type=pulumi.get(__ret__, 'parent_type'),
        project=pulumi.get(__ret__, 'project'))
def get_ancestry_output(project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAncestryResult]:
    """
    Retrieve the ancestors for a project.
    See the [REST API](https://cloud.google.com/resource-manager/reference/rest/v1/projects/getAncestry) for more details.


    :param builtins.str project: The ID of the project. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:projects/getAncestry:getAncestry', __args__, opts=opts, typ=GetAncestryResult)
    return __ret__.apply(lambda __response__: GetAncestryResult(
        ancestors=pulumi.get(__response__, 'ancestors'),
        id=pulumi.get(__response__, 'id'),
        org_id=pulumi.get(__response__, 'org_id'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        parent_type=pulumi.get(__response__, 'parent_type'),
        project=pulumi.get(__response__, 'project')))
