# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIamCustomRolesResult',
    'AwaitableGetIamCustomRolesResult',
    'get_iam_custom_roles',
    'get_iam_custom_roles_output',
]

@pulumi.output_type
class GetIamCustomRolesResult:
    """
    A collection of values returned by getIamCustomRoles.
    """
    def __init__(__self__, id=None, project=None, roles=None, show_deleted=None, view=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if show_deleted and not isinstance(show_deleted, bool):
            raise TypeError("Expected argument 'show_deleted' to be a bool")
        pulumi.set(__self__, "show_deleted", show_deleted)
        if view and not isinstance(view, str):
            raise TypeError("Expected argument 'view' to be a str")
        pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetIamCustomRolesRoleResult']:
        """
        A list of all retrieved custom roles roles. Structure is defined below.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="showDeleted")
    def show_deleted(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "show_deleted")

    @property
    @pulumi.getter
    def view(self) -> Optional[builtins.str]:
        return pulumi.get(self, "view")


class AwaitableGetIamCustomRolesResult(GetIamCustomRolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamCustomRolesResult(
            id=self.id,
            project=self.project,
            roles=self.roles,
            show_deleted=self.show_deleted,
            view=self.view)


def get_iam_custom_roles(project: Optional[builtins.str] = None,
                         show_deleted: Optional[builtins.bool] = None,
                         view: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamCustomRolesResult:
    """
    Get information about Google Cloud IAM Custom Roles from a project.
    Note that you must have the `roles/iam.roleViewer`.
    See [the official documentation](https://cloud.google.com/iam/docs/creating-custom-roles)
    and [API](https://cloud.google.com/iam/docs/reference/rest/v1/projects.roles/list).

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.projects.get_iam_custom_roles(project="your-project-id",
        show_deleted=True,
        view="FULL")
    ```


    :param builtins.str project: The project were the custom role has been created in. Defaults to the provider project configuration.
    :param builtins.bool show_deleted: Include Roles that have been deleted. Defaults to `false`.
    :param builtins.str view: When `"FULL"` is specified, the `permissions` field is returned, which includes a list of all permissions in the role. The default value is `"BASIC"`, which does not return the `permissions`.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['showDeleted'] = show_deleted
    __args__['view'] = view
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:projects/getIamCustomRoles:getIamCustomRoles', __args__, opts=opts, typ=GetIamCustomRolesResult).value

    return AwaitableGetIamCustomRolesResult(
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        roles=pulumi.get(__ret__, 'roles'),
        show_deleted=pulumi.get(__ret__, 'show_deleted'),
        view=pulumi.get(__ret__, 'view'))
def get_iam_custom_roles_output(project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                show_deleted: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                view: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIamCustomRolesResult]:
    """
    Get information about Google Cloud IAM Custom Roles from a project.
    Note that you must have the `roles/iam.roleViewer`.
    See [the official documentation](https://cloud.google.com/iam/docs/creating-custom-roles)
    and [API](https://cloud.google.com/iam/docs/reference/rest/v1/projects.roles/list).

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.projects.get_iam_custom_roles(project="your-project-id",
        show_deleted=True,
        view="FULL")
    ```


    :param builtins.str project: The project were the custom role has been created in. Defaults to the provider project configuration.
    :param builtins.bool show_deleted: Include Roles that have been deleted. Defaults to `false`.
    :param builtins.str view: When `"FULL"` is specified, the `permissions` field is returned, which includes a list of all permissions in the role. The default value is `"BASIC"`, which does not return the `permissions`.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['showDeleted'] = show_deleted
    __args__['view'] = view
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:projects/getIamCustomRoles:getIamCustomRoles', __args__, opts=opts, typ=GetIamCustomRolesResult)
    return __ret__.apply(lambda __response__: GetIamCustomRolesResult(
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        roles=pulumi.get(__response__, 'roles'),
        show_deleted=pulumi.get(__response__, 'show_deleted'),
        view=pulumi.get(__response__, 'view')))
