# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    """
    A collection of values returned by getSubscription.
    """
    def __init__(__self__, ack_deadline_seconds=None, bigquery_configs=None, cloud_storage_configs=None, dead_letter_policies=None, effective_labels=None, enable_exactly_once_delivery=None, enable_message_ordering=None, expiration_policies=None, filter=None, id=None, labels=None, message_retention_duration=None, message_transforms=None, name=None, project=None, pulumi_labels=None, push_configs=None, retain_acked_messages=None, retry_policies=None, topic=None):
        if ack_deadline_seconds and not isinstance(ack_deadline_seconds, int):
            raise TypeError("Expected argument 'ack_deadline_seconds' to be a int")
        pulumi.set(__self__, "ack_deadline_seconds", ack_deadline_seconds)
        if bigquery_configs and not isinstance(bigquery_configs, list):
            raise TypeError("Expected argument 'bigquery_configs' to be a list")
        pulumi.set(__self__, "bigquery_configs", bigquery_configs)
        if cloud_storage_configs and not isinstance(cloud_storage_configs, list):
            raise TypeError("Expected argument 'cloud_storage_configs' to be a list")
        pulumi.set(__self__, "cloud_storage_configs", cloud_storage_configs)
        if dead_letter_policies and not isinstance(dead_letter_policies, list):
            raise TypeError("Expected argument 'dead_letter_policies' to be a list")
        pulumi.set(__self__, "dead_letter_policies", dead_letter_policies)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_exactly_once_delivery and not isinstance(enable_exactly_once_delivery, bool):
            raise TypeError("Expected argument 'enable_exactly_once_delivery' to be a bool")
        pulumi.set(__self__, "enable_exactly_once_delivery", enable_exactly_once_delivery)
        if enable_message_ordering and not isinstance(enable_message_ordering, bool):
            raise TypeError("Expected argument 'enable_message_ordering' to be a bool")
        pulumi.set(__self__, "enable_message_ordering", enable_message_ordering)
        if expiration_policies and not isinstance(expiration_policies, list):
            raise TypeError("Expected argument 'expiration_policies' to be a list")
        pulumi.set(__self__, "expiration_policies", expiration_policies)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if message_retention_duration and not isinstance(message_retention_duration, str):
            raise TypeError("Expected argument 'message_retention_duration' to be a str")
        pulumi.set(__self__, "message_retention_duration", message_retention_duration)
        if message_transforms and not isinstance(message_transforms, list):
            raise TypeError("Expected argument 'message_transforms' to be a list")
        pulumi.set(__self__, "message_transforms", message_transforms)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if push_configs and not isinstance(push_configs, list):
            raise TypeError("Expected argument 'push_configs' to be a list")
        pulumi.set(__self__, "push_configs", push_configs)
        if retain_acked_messages and not isinstance(retain_acked_messages, bool):
            raise TypeError("Expected argument 'retain_acked_messages' to be a bool")
        pulumi.set(__self__, "retain_acked_messages", retain_acked_messages)
        if retry_policies and not isinstance(retry_policies, list):
            raise TypeError("Expected argument 'retry_policies' to be a list")
        pulumi.set(__self__, "retry_policies", retry_policies)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="ackDeadlineSeconds")
    def ack_deadline_seconds(self) -> builtins.int:
        return pulumi.get(self, "ack_deadline_seconds")

    @property
    @pulumi.getter(name="bigqueryConfigs")
    def bigquery_configs(self) -> Sequence['outputs.GetSubscriptionBigqueryConfigResult']:
        return pulumi.get(self, "bigquery_configs")

    @property
    @pulumi.getter(name="cloudStorageConfigs")
    def cloud_storage_configs(self) -> Sequence['outputs.GetSubscriptionCloudStorageConfigResult']:
        return pulumi.get(self, "cloud_storage_configs")

    @property
    @pulumi.getter(name="deadLetterPolicies")
    def dead_letter_policies(self) -> Sequence['outputs.GetSubscriptionDeadLetterPolicyResult']:
        return pulumi.get(self, "dead_letter_policies")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableExactlyOnceDelivery")
    def enable_exactly_once_delivery(self) -> builtins.bool:
        return pulumi.get(self, "enable_exactly_once_delivery")

    @property
    @pulumi.getter(name="enableMessageOrdering")
    def enable_message_ordering(self) -> builtins.bool:
        return pulumi.get(self, "enable_message_ordering")

    @property
    @pulumi.getter(name="expirationPolicies")
    def expiration_policies(self) -> Sequence['outputs.GetSubscriptionExpirationPolicyResult']:
        return pulumi.get(self, "expiration_policies")

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="messageRetentionDuration")
    def message_retention_duration(self) -> builtins.str:
        return pulumi.get(self, "message_retention_duration")

    @property
    @pulumi.getter(name="messageTransforms")
    def message_transforms(self) -> Sequence['outputs.GetSubscriptionMessageTransformResult']:
        return pulumi.get(self, "message_transforms")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="pushConfigs")
    def push_configs(self) -> Sequence['outputs.GetSubscriptionPushConfigResult']:
        return pulumi.get(self, "push_configs")

    @property
    @pulumi.getter(name="retainAckedMessages")
    def retain_acked_messages(self) -> builtins.bool:
        return pulumi.get(self, "retain_acked_messages")

    @property
    @pulumi.getter(name="retryPolicies")
    def retry_policies(self) -> Sequence['outputs.GetSubscriptionRetryPolicyResult']:
        return pulumi.get(self, "retry_policies")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        return pulumi.get(self, "topic")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            ack_deadline_seconds=self.ack_deadline_seconds,
            bigquery_configs=self.bigquery_configs,
            cloud_storage_configs=self.cloud_storage_configs,
            dead_letter_policies=self.dead_letter_policies,
            effective_labels=self.effective_labels,
            enable_exactly_once_delivery=self.enable_exactly_once_delivery,
            enable_message_ordering=self.enable_message_ordering,
            expiration_policies=self.expiration_policies,
            filter=self.filter,
            id=self.id,
            labels=self.labels,
            message_retention_duration=self.message_retention_duration,
            message_transforms=self.message_transforms,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            push_configs=self.push_configs,
            retain_acked_messages=self.retain_acked_messages,
            retry_policies=self.retry_policies,
            topic=self.topic)


def get_subscription(name: Optional[builtins.str] = None,
                     project: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Get information about a Google Cloud Pub/Sub Subscription. For more information see
    the [official documentation](https://cloud.google.com/pubsub/docs/)
    and [API](https://cloud.google.com/pubsub/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_pubsub_subscription = gcp.pubsub.get_subscription(name="my-pubsub-subscription")
    ```


    :param builtins.str name: The name of the Cloud Pub/Sub Subscription.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:pubsub/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        ack_deadline_seconds=pulumi.get(__ret__, 'ack_deadline_seconds'),
        bigquery_configs=pulumi.get(__ret__, 'bigquery_configs'),
        cloud_storage_configs=pulumi.get(__ret__, 'cloud_storage_configs'),
        dead_letter_policies=pulumi.get(__ret__, 'dead_letter_policies'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        enable_exactly_once_delivery=pulumi.get(__ret__, 'enable_exactly_once_delivery'),
        enable_message_ordering=pulumi.get(__ret__, 'enable_message_ordering'),
        expiration_policies=pulumi.get(__ret__, 'expiration_policies'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        message_retention_duration=pulumi.get(__ret__, 'message_retention_duration'),
        message_transforms=pulumi.get(__ret__, 'message_transforms'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        push_configs=pulumi.get(__ret__, 'push_configs'),
        retain_acked_messages=pulumi.get(__ret__, 'retain_acked_messages'),
        retry_policies=pulumi.get(__ret__, 'retry_policies'),
        topic=pulumi.get(__ret__, 'topic'))
def get_subscription_output(name: Optional[pulumi.Input[builtins.str]] = None,
                            project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Get information about a Google Cloud Pub/Sub Subscription. For more information see
    the [official documentation](https://cloud.google.com/pubsub/docs/)
    and [API](https://cloud.google.com/pubsub/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_pubsub_subscription = gcp.pubsub.get_subscription(name="my-pubsub-subscription")
    ```


    :param builtins.str name: The name of the Cloud Pub/Sub Subscription.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:pubsub/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSubscriptionResult(
        ack_deadline_seconds=pulumi.get(__response__, 'ack_deadline_seconds'),
        bigquery_configs=pulumi.get(__response__, 'bigquery_configs'),
        cloud_storage_configs=pulumi.get(__response__, 'cloud_storage_configs'),
        dead_letter_policies=pulumi.get(__response__, 'dead_letter_policies'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        enable_exactly_once_delivery=pulumi.get(__response__, 'enable_exactly_once_delivery'),
        enable_message_ordering=pulumi.get(__response__, 'enable_message_ordering'),
        expiration_policies=pulumi.get(__response__, 'expiration_policies'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        message_retention_duration=pulumi.get(__response__, 'message_retention_duration'),
        message_transforms=pulumi.get(__response__, 'message_transforms'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        push_configs=pulumi.get(__response__, 'push_configs'),
        retain_acked_messages=pulumi.get(__response__, 'retain_acked_messages'),
        retry_policies=pulumi.get(__response__, 'retry_policies'),
        topic=pulumi.get(__response__, 'topic')))
