# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LiteSubscriptionDeliveryConfig',
    'LiteTopicPartitionConfig',
    'LiteTopicPartitionConfigCapacity',
    'LiteTopicReservationConfig',
    'LiteTopicRetentionConfig',
    'SchemaIamBindingCondition',
    'SchemaIamMemberCondition',
    'SubscriptionBigqueryConfig',
    'SubscriptionCloudStorageConfig',
    'SubscriptionCloudStorageConfigAvroConfig',
    'SubscriptionDeadLetterPolicy',
    'SubscriptionExpirationPolicy',
    'SubscriptionIAMBindingCondition',
    'SubscriptionIAMMemberCondition',
    'SubscriptionMessageTransform',
    'SubscriptionMessageTransformJavascriptUdf',
    'SubscriptionPushConfig',
    'SubscriptionPushConfigNoWrapper',
    'SubscriptionPushConfigOidcToken',
    'SubscriptionRetryPolicy',
    'TopicIAMBindingCondition',
    'TopicIAMMemberCondition',
    'TopicIngestionDataSourceSettings',
    'TopicIngestionDataSourceSettingsAwsKinesis',
    'TopicIngestionDataSourceSettingsAwsMsk',
    'TopicIngestionDataSourceSettingsAzureEventHubs',
    'TopicIngestionDataSourceSettingsCloudStorage',
    'TopicIngestionDataSourceSettingsCloudStorageAvroFormat',
    'TopicIngestionDataSourceSettingsCloudStoragePubsubAvroFormat',
    'TopicIngestionDataSourceSettingsCloudStorageTextFormat',
    'TopicIngestionDataSourceSettingsConfluentCloud',
    'TopicIngestionDataSourceSettingsPlatformLogsSettings',
    'TopicMessageStoragePolicy',
    'TopicMessageTransform',
    'TopicMessageTransformJavascriptUdf',
    'TopicSchemaSettings',
    'GetSubscriptionBigqueryConfigResult',
    'GetSubscriptionCloudStorageConfigResult',
    'GetSubscriptionCloudStorageConfigAvroConfigResult',
    'GetSubscriptionDeadLetterPolicyResult',
    'GetSubscriptionExpirationPolicyResult',
    'GetSubscriptionMessageTransformResult',
    'GetSubscriptionMessageTransformJavascriptUdfResult',
    'GetSubscriptionPushConfigResult',
    'GetSubscriptionPushConfigNoWrapperResult',
    'GetSubscriptionPushConfigOidcTokenResult',
    'GetSubscriptionRetryPolicyResult',
    'GetTopicIngestionDataSourceSettingResult',
    'GetTopicIngestionDataSourceSettingAwsKineseResult',
    'GetTopicIngestionDataSourceSettingAwsMskResult',
    'GetTopicIngestionDataSourceSettingAzureEventHubResult',
    'GetTopicIngestionDataSourceSettingCloudStorageResult',
    'GetTopicIngestionDataSourceSettingCloudStorageAvroFormatResult',
    'GetTopicIngestionDataSourceSettingCloudStoragePubsubAvroFormatResult',
    'GetTopicIngestionDataSourceSettingCloudStorageTextFormatResult',
    'GetTopicIngestionDataSourceSettingConfluentCloudResult',
    'GetTopicIngestionDataSourceSettingPlatformLogsSettingResult',
    'GetTopicMessageStoragePolicyResult',
    'GetTopicMessageTransformResult',
    'GetTopicMessageTransformJavascriptUdfResult',
    'GetTopicSchemaSettingResult',
]

@pulumi.output_type
class LiteSubscriptionDeliveryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryRequirement":
            suggest = "delivery_requirement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteSubscriptionDeliveryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteSubscriptionDeliveryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteSubscriptionDeliveryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_requirement: builtins.str):
        """
        :param builtins.str delivery_requirement: When this subscription should send messages to subscribers relative to messages persistence in storage.
               Possible values are: `DELIVER_IMMEDIATELY`, `DELIVER_AFTER_STORED`, `DELIVERY_REQUIREMENT_UNSPECIFIED`.
        """
        pulumi.set(__self__, "delivery_requirement", delivery_requirement)

    @property
    @pulumi.getter(name="deliveryRequirement")
    def delivery_requirement(self) -> builtins.str:
        """
        When this subscription should send messages to subscribers relative to messages persistence in storage.
        Possible values are: `DELIVER_IMMEDIATELY`, `DELIVER_AFTER_STORED`, `DELIVERY_REQUIREMENT_UNSPECIFIED`.
        """
        return pulumi.get(self, "delivery_requirement")


@pulumi.output_type
class LiteTopicPartitionConfig(dict):
    def __init__(__self__, *,
                 count: builtins.int,
                 capacity: Optional['outputs.LiteTopicPartitionConfigCapacity'] = None):
        """
        :param builtins.int count: The number of partitions in the topic. Must be at least 1.
        :param 'LiteTopicPartitionConfigCapacityArgs' capacity: The capacity configuration.
               Structure is documented below.
        """
        pulumi.set(__self__, "count", count)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of partitions in the topic. Must be at least 1.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def capacity(self) -> Optional['outputs.LiteTopicPartitionConfigCapacity']:
        """
        The capacity configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class LiteTopicPartitionConfigCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishMibPerSec":
            suggest = "publish_mib_per_sec"
        elif key == "subscribeMibPerSec":
            suggest = "subscribe_mib_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteTopicPartitionConfigCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteTopicPartitionConfigCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteTopicPartitionConfigCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_mib_per_sec: builtins.int,
                 subscribe_mib_per_sec: builtins.int):
        """
        :param builtins.int publish_mib_per_sec: Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        :param builtins.int subscribe_mib_per_sec: Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        """
        pulumi.set(__self__, "publish_mib_per_sec", publish_mib_per_sec)
        pulumi.set(__self__, "subscribe_mib_per_sec", subscribe_mib_per_sec)

    @property
    @pulumi.getter(name="publishMibPerSec")
    def publish_mib_per_sec(self) -> builtins.int:
        """
        Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        """
        return pulumi.get(self, "publish_mib_per_sec")

    @property
    @pulumi.getter(name="subscribeMibPerSec")
    def subscribe_mib_per_sec(self) -> builtins.int:
        """
        Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        """
        return pulumi.get(self, "subscribe_mib_per_sec")


@pulumi.output_type
class LiteTopicReservationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "throughputReservation":
            suggest = "throughput_reservation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteTopicReservationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteTopicReservationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteTopicReservationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 throughput_reservation: Optional[builtins.str] = None):
        """
        :param builtins.str throughput_reservation: The Reservation to use for this topic's throughput capacity.
        """
        if throughput_reservation is not None:
            pulumi.set(__self__, "throughput_reservation", throughput_reservation)

    @property
    @pulumi.getter(name="throughputReservation")
    def throughput_reservation(self) -> Optional[builtins.str]:
        """
        The Reservation to use for this topic's throughput capacity.
        """
        return pulumi.get(self, "throughput_reservation")


@pulumi.output_type
class LiteTopicRetentionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "perPartitionBytes":
            suggest = "per_partition_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiteTopicRetentionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiteTopicRetentionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiteTopicRetentionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 per_partition_bytes: builtins.str,
                 period: Optional[builtins.str] = None):
        """
        :param builtins.str per_partition_bytes: The provisioned storage, in bytes, per partition. If the number of bytes stored
               in any of the topic's partitions grows beyond this value, older messages will be
               dropped to make room for newer ones, regardless of the value of period.
        :param builtins.str period: How long a published message is retained. If unset, messages will be retained as
               long as the bytes retained for each partition is below perPartitionBytes. A
               duration in seconds with up to nine fractional digits, terminated by 's'.
               Example: "3.5s".
        """
        pulumi.set(__self__, "per_partition_bytes", per_partition_bytes)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter(name="perPartitionBytes")
    def per_partition_bytes(self) -> builtins.str:
        """
        The provisioned storage, in bytes, per partition. If the number of bytes stored
        in any of the topic's partitions grows beyond this value, older messages will be
        dropped to make room for newer ones, regardless of the value of period.
        """
        return pulumi.get(self, "per_partition_bytes")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.str]:
        """
        How long a published message is retained. If unset, messages will be retained as
        long as the bytes retained for each partition is below perPartitionBytes. A
        duration in seconds with up to nine fractional digits, terminated by 's'.
        Example: "3.5s".
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class SchemaIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SchemaIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SubscriptionBigqueryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropUnknownFields":
            suggest = "drop_unknown_fields"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "useTableSchema":
            suggest = "use_table_schema"
        elif key == "useTopicSchema":
            suggest = "use_topic_schema"
        elif key == "writeMetadata":
            suggest = "write_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionBigqueryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionBigqueryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionBigqueryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: builtins.str,
                 drop_unknown_fields: Optional[builtins.bool] = None,
                 service_account_email: Optional[builtins.str] = None,
                 use_table_schema: Optional[builtins.bool] = None,
                 use_topic_schema: Optional[builtins.bool] = None,
                 write_metadata: Optional[builtins.bool] = None):
        """
        :param builtins.str table: The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        :param builtins.bool drop_unknown_fields: When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
               are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
               and any messages with extra fields are not written and remain in the subscription's backlog.
        :param builtins.str service_account_email: The service account to use to write to BigQuery. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param builtins.bool use_table_schema: When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
               must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        :param builtins.bool use_topic_schema: When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
               Only one of use_topic_schema and use_table_schema can be set.
        :param builtins.bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
               The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        pulumi.set(__self__, "table", table)
        if drop_unknown_fields is not None:
            pulumi.set(__self__, "drop_unknown_fields", drop_unknown_fields)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if use_table_schema is not None:
            pulumi.set(__self__, "use_table_schema", use_table_schema)
        if use_topic_schema is not None:
            pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        if write_metadata is not None:
            pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter
    def table(self) -> builtins.str:
        """
        The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="dropUnknownFields")
    def drop_unknown_fields(self) -> Optional[builtins.bool]:
        """
        When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
        are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
        and any messages with extra fields are not written and remain in the subscription's backlog.
        """
        return pulumi.get(self, "drop_unknown_fields")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[builtins.str]:
        """
        The service account to use to write to BigQuery. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="useTableSchema")
    def use_table_schema(self) -> Optional[builtins.bool]:
        """
        When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
        must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_table_schema")

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> Optional[builtins.bool]:
        """
        When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
        Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> Optional[builtins.bool]:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
        The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class SubscriptionCloudStorageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "avroConfig":
            suggest = "avro_config"
        elif key == "filenameDatetimeFormat":
            suggest = "filename_datetime_format"
        elif key == "filenamePrefix":
            suggest = "filename_prefix"
        elif key == "filenameSuffix":
            suggest = "filename_suffix"
        elif key == "maxBytes":
            suggest = "max_bytes"
        elif key == "maxDuration":
            suggest = "max_duration"
        elif key == "maxMessages":
            suggest = "max_messages"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionCloudStorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionCloudStorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionCloudStorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 avro_config: Optional['outputs.SubscriptionCloudStorageConfigAvroConfig'] = None,
                 filename_datetime_format: Optional[builtins.str] = None,
                 filename_prefix: Optional[builtins.str] = None,
                 filename_suffix: Optional[builtins.str] = None,
                 max_bytes: Optional[builtins.int] = None,
                 max_duration: Optional[builtins.str] = None,
                 max_messages: Optional[builtins.int] = None,
                 service_account_email: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        :param 'SubscriptionCloudStorageConfigAvroConfigArgs' avro_config: If set, message data will be written to Cloud Storage in Avro format.
               Structure is documented below.
        :param builtins.str filename_datetime_format: User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        :param builtins.str filename_prefix: User-provided prefix for Cloud Storage filename.
        :param builtins.str filename_suffix: User-provided suffix for Cloud Storage filename. Must not end in "/".
        :param builtins.int max_bytes: The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
               The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        :param builtins.str max_duration: The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
               May not exceed the subscription's acknowledgement deadline.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param builtins.int max_messages: The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        :param builtins.str service_account_email: The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param builtins.str state: (Output)
               An output-only field that indicates whether or not the subscription can receive messages.
        """
        pulumi.set(__self__, "bucket", bucket)
        if avro_config is not None:
            pulumi.set(__self__, "avro_config", avro_config)
        if filename_datetime_format is not None:
            pulumi.set(__self__, "filename_datetime_format", filename_datetime_format)
        if filename_prefix is not None:
            pulumi.set(__self__, "filename_prefix", filename_prefix)
        if filename_suffix is not None:
            pulumi.set(__self__, "filename_suffix", filename_suffix)
        if max_bytes is not None:
            pulumi.set(__self__, "max_bytes", max_bytes)
        if max_duration is not None:
            pulumi.set(__self__, "max_duration", max_duration)
        if max_messages is not None:
            pulumi.set(__self__, "max_messages", max_messages)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="avroConfig")
    def avro_config(self) -> Optional['outputs.SubscriptionCloudStorageConfigAvroConfig']:
        """
        If set, message data will be written to Cloud Storage in Avro format.
        Structure is documented below.
        """
        return pulumi.get(self, "avro_config")

    @property
    @pulumi.getter(name="filenameDatetimeFormat")
    def filename_datetime_format(self) -> Optional[builtins.str]:
        """
        User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        """
        return pulumi.get(self, "filename_datetime_format")

    @property
    @pulumi.getter(name="filenamePrefix")
    def filename_prefix(self) -> Optional[builtins.str]:
        """
        User-provided prefix for Cloud Storage filename.
        """
        return pulumi.get(self, "filename_prefix")

    @property
    @pulumi.getter(name="filenameSuffix")
    def filename_suffix(self) -> Optional[builtins.str]:
        """
        User-provided suffix for Cloud Storage filename. Must not end in "/".
        """
        return pulumi.get(self, "filename_suffix")

    @property
    @pulumi.getter(name="maxBytes")
    def max_bytes(self) -> Optional[builtins.int]:
        """
        The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
        The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        """
        return pulumi.get(self, "max_bytes")

    @property
    @pulumi.getter(name="maxDuration")
    def max_duration(self) -> Optional[builtins.str]:
        """
        The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
        May not exceed the subscription's acknowledgement deadline.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_duration")

    @property
    @pulumi.getter(name="maxMessages")
    def max_messages(self) -> Optional[builtins.int]:
        """
        The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        """
        return pulumi.get(self, "max_messages")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[builtins.str]:
        """
        The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        An output-only field that indicates whether or not the subscription can receive messages.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SubscriptionCloudStorageConfigAvroConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useTopicSchema":
            suggest = "use_topic_schema"
        elif key == "writeMetadata":
            suggest = "write_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionCloudStorageConfigAvroConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionCloudStorageConfigAvroConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionCloudStorageConfigAvroConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_topic_schema: Optional[builtins.bool] = None,
                 write_metadata: Optional[builtins.bool] = None):
        """
        :param builtins.bool use_topic_schema: When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        :param builtins.bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        if use_topic_schema is not None:
            pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        if write_metadata is not None:
            pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> Optional[builtins.bool]:
        """
        When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> Optional[builtins.bool]:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class SubscriptionDeadLetterPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deadLetterTopic":
            suggest = "dead_letter_topic"
        elif key == "maxDeliveryAttempts":
            suggest = "max_delivery_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionDeadLetterPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionDeadLetterPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionDeadLetterPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dead_letter_topic: Optional[builtins.str] = None,
                 max_delivery_attempts: Optional[builtins.int] = None):
        """
        :param builtins.str dead_letter_topic: The name of the topic to which dead letter messages should be published.
               Format is `projects/{project}/topics/{topic}`.
               The Cloud Pub/Sub service account associated with the enclosing subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Publish() to this topic.
               The operation will fail if the topic does not exist.
               Users should ensure that there is a subscription attached to this topic
               since messages published to a topic with no subscriptions are lost.
        :param builtins.int max_delivery_attempts: The maximum number of delivery attempts for any message. The value must be
               between 5 and 100.
               The number of delivery attempts is defined as 1 + (the sum of number of
               NACKs and number of times the acknowledgement deadline has been exceeded for the message).
               A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
               client libraries may automatically extend ack_deadlines.
               This field will be honored on a best effort basis.
               If this parameter is 0, a default value of 5 is used.
        """
        if dead_letter_topic is not None:
            pulumi.set(__self__, "dead_letter_topic", dead_letter_topic)
        if max_delivery_attempts is not None:
            pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="deadLetterTopic")
    def dead_letter_topic(self) -> Optional[builtins.str]:
        """
        The name of the topic to which dead letter messages should be published.
        Format is `projects/{project}/topics/{topic}`.
        The Cloud Pub/Sub service account associated with the enclosing subscription's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Publish() to this topic.
        The operation will fail if the topic does not exist.
        Users should ensure that there is a subscription attached to this topic
        since messages published to a topic with no subscriptions are lost.
        """
        return pulumi.get(self, "dead_letter_topic")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> Optional[builtins.int]:
        """
        The maximum number of delivery attempts for any message. The value must be
        between 5 and 100.
        The number of delivery attempts is defined as 1 + (the sum of number of
        NACKs and number of times the acknowledgement deadline has been exceeded for the message).
        A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
        client libraries may automatically extend ack_deadlines.
        This field will be honored on a best effort basis.
        If this parameter is 0, a default value of 5 is used.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class SubscriptionExpirationPolicy(dict):
    def __init__(__self__, *,
                 ttl: builtins.str):
        """
        :param builtins.str ttl: Specifies the "time-to-live" duration for an associated resource. The
               resource expires if it is not active for a period of ttl.
               If ttl is set to "", the associated resource never expires.
               A duration in seconds with up to nine fractional digits, terminated by 's'.
               Example - "3.5s".
        """
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def ttl(self) -> builtins.str:
        """
        Specifies the "time-to-live" duration for an associated resource. The
        resource expires if it is not active for a period of ttl.
        If ttl is set to "", the associated resource never expires.
        A duration in seconds with up to nine fractional digits, terminated by 's'.
        Example - "3.5s".
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class SubscriptionIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SubscriptionIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SubscriptionMessageTransform(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "javascriptUdf":
            suggest = "javascript_udf"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionMessageTransform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionMessageTransform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionMessageTransform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[builtins.bool] = None,
                 javascript_udf: Optional['outputs.SubscriptionMessageTransformJavascriptUdf'] = None):
        """
        :param builtins.bool disabled: Controls whether or not to use this transform. If not set or `false`,
               the transform will be applied to messages. Default: `true`.
        :param 'SubscriptionMessageTransformJavascriptUdfArgs' javascript_udf: Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
               each one must have a unique `function_name`.
               Structure is documented below.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if javascript_udf is not None:
            pulumi.set(__self__, "javascript_udf", javascript_udf)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[builtins.bool]:
        """
        Controls whether or not to use this transform. If not set or `false`,
        the transform will be applied to messages. Default: `true`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="javascriptUdf")
    def javascript_udf(self) -> Optional['outputs.SubscriptionMessageTransformJavascriptUdf']:
        """
        Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
        each one must have a unique `function_name`.
        Structure is documented below.
        """
        return pulumi.get(self, "javascript_udf")


@pulumi.output_type
class SubscriptionMessageTransformJavascriptUdf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionName":
            suggest = "function_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionMessageTransformJavascriptUdf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionMessageTransformJavascriptUdf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionMessageTransformJavascriptUdf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: builtins.str,
                 function_name: builtins.str):
        """
        :param builtins.str code: JavaScript code that contains a function `function_name` with the
               following signature:
               ```
               /**
               * Transforms a Pub/Sub message.
               *
               * @return {(Object<string, (string | Object<string, string>)>|null)} - To
               * filter a message, return `null`. To transform a message return a map
               * with the following keys:
               *   - (required) 'data' : {string}
               *   - (optional) 'attributes' : {Object<string, string>}
               * Returning empty `attributes` will remove all attributes from the
               * message.
               *
               * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
               * message. Keys:
               *   - (required) 'data' : {string}
               *   - (required) 'attributes' : {Object<string, string>}
               *
               * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
               * Keys:
               *   - (required) 'message_id'  : {string}
               *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
               *   - (optional) 'ordering_key': {string}
               */
               function <function_name>(message, metadata) {
               }
               ```
        :param builtins.str function_name: Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "function_name", function_name)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        JavaScript code that contains a function `function_name` with the
        following signature:
        ```
        /**
        * Transforms a Pub/Sub message.
        *
        * @return {(Object<string, (string | Object<string, string>)>|null)} - To
        * filter a message, return `null`. To transform a message return a map
        * with the following keys:
        *   - (required) 'data' : {string}
        *   - (optional) 'attributes' : {Object<string, string>}
        * Returning empty `attributes` will remove all attributes from the
        * message.
        *
        * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
        * message. Keys:
        *   - (required) 'data' : {string}
        *   - (required) 'attributes' : {Object<string, string>}
        *
        * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
        * Keys:
        *   - (required) 'message_id'  : {string}
        *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
        *   - (optional) 'ordering_key': {string}
        */
        function <function_name>(message, metadata) {
        }
        ```
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> builtins.str:
        """
        Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        return pulumi.get(self, "function_name")


@pulumi.output_type
class SubscriptionPushConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pushEndpoint":
            suggest = "push_endpoint"
        elif key == "noWrapper":
            suggest = "no_wrapper"
        elif key == "oidcToken":
            suggest = "oidc_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPushConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPushConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPushConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 push_endpoint: builtins.str,
                 attributes: Optional[Mapping[str, builtins.str]] = None,
                 no_wrapper: Optional['outputs.SubscriptionPushConfigNoWrapper'] = None,
                 oidc_token: Optional['outputs.SubscriptionPushConfigOidcToken'] = None):
        """
        :param builtins.str push_endpoint: A URL locating the endpoint to which messages should be pushed.
               For example, a Webhook endpoint might use
               "https://example.com/push".
        :param Mapping[str, builtins.str] attributes: Endpoint configuration attributes.
               Every endpoint has a set of API supported attributes that can
               be used to control different aspects of the message delivery.
               The currently supported attribute is x-goog-version, which you
               can use to change the format of the pushed message. This
               attribute indicates the version of the data expected by
               the endpoint. This controls the shape of the pushed message
               (i.e., its fields and metadata). The endpoint version is
               based on the version of the Pub/Sub API.
               If not present during the subscriptions.create call,
               it will default to the version of the API used to make
               such call. If not present during a subscriptions.modifyPushConfig
               call, its value will not be changed. subscriptions.get
               calls will always return a valid version, even if the
               subscription was created without this attribute.
               The possible values for this attribute are:
               - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
               - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        :param 'SubscriptionPushConfigNoWrapperArgs' no_wrapper: When set, the payload to the push endpoint is not wrapped.Sets the
               `data` field as the HTTP body for delivery.
               Structure is documented below.
        :param 'SubscriptionPushConfigOidcTokenArgs' oidc_token: If specified, Pub/Sub will generate and attach an OIDC JWT token as
               an Authorization header in the HTTP request for every pushed message.
               Structure is documented below.
        """
        pulumi.set(__self__, "push_endpoint", push_endpoint)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if no_wrapper is not None:
            pulumi.set(__self__, "no_wrapper", no_wrapper)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)

    @property
    @pulumi.getter(name="pushEndpoint")
    def push_endpoint(self) -> builtins.str:
        """
        A URL locating the endpoint to which messages should be pushed.
        For example, a Webhook endpoint might use
        "https://example.com/push".
        """
        return pulumi.get(self, "push_endpoint")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Endpoint configuration attributes.
        Every endpoint has a set of API supported attributes that can
        be used to control different aspects of the message delivery.
        The currently supported attribute is x-goog-version, which you
        can use to change the format of the pushed message. This
        attribute indicates the version of the data expected by
        the endpoint. This controls the shape of the pushed message
        (i.e., its fields and metadata). The endpoint version is
        based on the version of the Pub/Sub API.
        If not present during the subscriptions.create call,
        it will default to the version of the API used to make
        such call. If not present during a subscriptions.modifyPushConfig
        call, its value will not be changed. subscriptions.get
        calls will always return a valid version, even if the
        subscription was created without this attribute.
        The possible values for this attribute are:
        - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
        - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="noWrapper")
    def no_wrapper(self) -> Optional['outputs.SubscriptionPushConfigNoWrapper']:
        """
        When set, the payload to the push endpoint is not wrapped.Sets the
        `data` field as the HTTP body for delivery.
        Structure is documented below.
        """
        return pulumi.get(self, "no_wrapper")

    @property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional['outputs.SubscriptionPushConfigOidcToken']:
        """
        If specified, Pub/Sub will generate and attach an OIDC JWT token as
        an Authorization header in the HTTP request for every pushed message.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_token")


@pulumi.output_type
class SubscriptionPushConfigNoWrapper(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "writeMetadata":
            suggest = "write_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPushConfigNoWrapper. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPushConfigNoWrapper.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPushConfigNoWrapper.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 write_metadata: builtins.bool):
        """
        :param builtins.bool write_metadata: When true, writes the Pub/Sub message metadata to
               `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
               Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
        """
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> builtins.bool:
        """
        When true, writes the Pub/Sub message metadata to
        `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
        Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class SubscriptionPushConfigOidcToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPushConfigOidcToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPushConfigOidcToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPushConfigOidcToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_email: builtins.str,
                 audience: Optional[builtins.str] = None):
        """
        :param builtins.str service_account_email: Service account email to be used for generating the OIDC token.
               The caller (for subscriptions.create, subscriptions.patch, and
               subscriptions.modifyPushConfig RPCs) must have the
               iam.serviceAccounts.actAs permission for the service account.
        :param builtins.str audience: Audience to be used when generating OIDC token. The audience claim
               identifies the recipients that the JWT is intended for. The audience
               value is a single case-sensitive string. Having multiple values (array)
               for the audience field is not supported. More info about the OIDC JWT
               token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
               Note: if not specified, the Push endpoint URL will be used.
        """
        pulumi.set(__self__, "service_account_email", service_account_email)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> builtins.str:
        """
        Service account email to be used for generating the OIDC token.
        The caller (for subscriptions.create, subscriptions.patch, and
        subscriptions.modifyPushConfig RPCs) must have the
        iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def audience(self) -> Optional[builtins.str]:
        """
        Audience to be used when generating OIDC token. The audience claim
        identifies the recipients that the JWT is intended for. The audience
        value is a single case-sensitive string. Having multiple values (array)
        for the audience field is not supported. More info about the OIDC JWT
        token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
        Note: if not specified, the Push endpoint URL will be used.
        """
        return pulumi.get(self, "audience")


@pulumi.output_type
class SubscriptionRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBackoff":
            suggest = "maximum_backoff"
        elif key == "minimumBackoff":
            suggest = "minimum_backoff"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_backoff: Optional[builtins.str] = None,
                 minimum_backoff: Optional[builtins.str] = None):
        """
        :param builtins.str maximum_backoff: The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param builtins.str minimum_backoff: The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if maximum_backoff is not None:
            pulumi.set(__self__, "maximum_backoff", maximum_backoff)
        if minimum_backoff is not None:
            pulumi.set(__self__, "minimum_backoff", minimum_backoff)

    @property
    @pulumi.getter(name="maximumBackoff")
    def maximum_backoff(self) -> Optional[builtins.str]:
        """
        The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "maximum_backoff")

    @property
    @pulumi.getter(name="minimumBackoff")
    def minimum_backoff(self) -> Optional[builtins.str]:
        """
        The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "minimum_backoff")


@pulumi.output_type
class TopicIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TopicIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TopicIngestionDataSourceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsKinesis":
            suggest = "aws_kinesis"
        elif key == "awsMsk":
            suggest = "aws_msk"
        elif key == "azureEventHubs":
            suggest = "azure_event_hubs"
        elif key == "cloudStorage":
            suggest = "cloud_storage"
        elif key == "confluentCloud":
            suggest = "confluent_cloud"
        elif key == "platformLogsSettings":
            suggest = "platform_logs_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_kinesis: Optional['outputs.TopicIngestionDataSourceSettingsAwsKinesis'] = None,
                 aws_msk: Optional['outputs.TopicIngestionDataSourceSettingsAwsMsk'] = None,
                 azure_event_hubs: Optional['outputs.TopicIngestionDataSourceSettingsAzureEventHubs'] = None,
                 cloud_storage: Optional['outputs.TopicIngestionDataSourceSettingsCloudStorage'] = None,
                 confluent_cloud: Optional['outputs.TopicIngestionDataSourceSettingsConfluentCloud'] = None,
                 platform_logs_settings: Optional['outputs.TopicIngestionDataSourceSettingsPlatformLogsSettings'] = None):
        """
        :param 'TopicIngestionDataSourceSettingsAwsKinesisArgs' aws_kinesis: Settings for ingestion from Amazon Kinesis Data Streams.
               Structure is documented below.
        :param 'TopicIngestionDataSourceSettingsAwsMskArgs' aws_msk: Settings for ingestion from Amazon Managed Streaming for Apache Kafka.
               Structure is documented below.
        :param 'TopicIngestionDataSourceSettingsAzureEventHubsArgs' azure_event_hubs: Settings for ingestion from Azure Event Hubs.
               Structure is documented below.
        :param 'TopicIngestionDataSourceSettingsCloudStorageArgs' cloud_storage: Settings for ingestion from Cloud Storage.
               Structure is documented below.
        :param 'TopicIngestionDataSourceSettingsConfluentCloudArgs' confluent_cloud: Settings for ingestion from Confluent Cloud.
               Structure is documented below.
        :param 'TopicIngestionDataSourceSettingsPlatformLogsSettingsArgs' platform_logs_settings: Settings for Platform Logs regarding ingestion to Pub/Sub. If unset,
               no Platform Logs will be generated.'
               Structure is documented below.
        """
        if aws_kinesis is not None:
            pulumi.set(__self__, "aws_kinesis", aws_kinesis)
        if aws_msk is not None:
            pulumi.set(__self__, "aws_msk", aws_msk)
        if azure_event_hubs is not None:
            pulumi.set(__self__, "azure_event_hubs", azure_event_hubs)
        if cloud_storage is not None:
            pulumi.set(__self__, "cloud_storage", cloud_storage)
        if confluent_cloud is not None:
            pulumi.set(__self__, "confluent_cloud", confluent_cloud)
        if platform_logs_settings is not None:
            pulumi.set(__self__, "platform_logs_settings", platform_logs_settings)

    @property
    @pulumi.getter(name="awsKinesis")
    def aws_kinesis(self) -> Optional['outputs.TopicIngestionDataSourceSettingsAwsKinesis']:
        """
        Settings for ingestion from Amazon Kinesis Data Streams.
        Structure is documented below.
        """
        return pulumi.get(self, "aws_kinesis")

    @property
    @pulumi.getter(name="awsMsk")
    def aws_msk(self) -> Optional['outputs.TopicIngestionDataSourceSettingsAwsMsk']:
        """
        Settings for ingestion from Amazon Managed Streaming for Apache Kafka.
        Structure is documented below.
        """
        return pulumi.get(self, "aws_msk")

    @property
    @pulumi.getter(name="azureEventHubs")
    def azure_event_hubs(self) -> Optional['outputs.TopicIngestionDataSourceSettingsAzureEventHubs']:
        """
        Settings for ingestion from Azure Event Hubs.
        Structure is documented below.
        """
        return pulumi.get(self, "azure_event_hubs")

    @property
    @pulumi.getter(name="cloudStorage")
    def cloud_storage(self) -> Optional['outputs.TopicIngestionDataSourceSettingsCloudStorage']:
        """
        Settings for ingestion from Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_storage")

    @property
    @pulumi.getter(name="confluentCloud")
    def confluent_cloud(self) -> Optional['outputs.TopicIngestionDataSourceSettingsConfluentCloud']:
        """
        Settings for ingestion from Confluent Cloud.
        Structure is documented below.
        """
        return pulumi.get(self, "confluent_cloud")

    @property
    @pulumi.getter(name="platformLogsSettings")
    def platform_logs_settings(self) -> Optional['outputs.TopicIngestionDataSourceSettingsPlatformLogsSettings']:
        """
        Settings for Platform Logs regarding ingestion to Pub/Sub. If unset,
        no Platform Logs will be generated.'
        Structure is documented below.
        """
        return pulumi.get(self, "platform_logs_settings")


@pulumi.output_type
class TopicIngestionDataSourceSettingsAwsKinesis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRoleArn":
            suggest = "aws_role_arn"
        elif key == "consumerArn":
            suggest = "consumer_arn"
        elif key == "gcpServiceAccount":
            suggest = "gcp_service_account"
        elif key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettingsAwsKinesis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettingsAwsKinesis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettingsAwsKinesis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_role_arn: builtins.str,
                 consumer_arn: builtins.str,
                 gcp_service_account: builtins.str,
                 stream_arn: builtins.str):
        """
        :param builtins.str aws_role_arn: AWS role ARN to be used for Federated Identity authentication with
               Kinesis. Check the Pub/Sub docs for how to set up this role and the
               required permissions that need to be attached to it.
        :param builtins.str consumer_arn: The Kinesis consumer ARN to used for ingestion in
               Enhanced Fan-Out mode. The consumer must be already
               created and ready to be used.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Kinesis (via a `AssumeRoleWithWebIdentity` call for the provided
               role). The `awsRoleArn` must be set up with `accounts.google.com:sub`
               equals to this service account number.
        :param builtins.str stream_arn: The Kinesis stream ARN to ingest data from.
        """
        pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        pulumi.set(__self__, "consumer_arn", consumer_arn)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> builtins.str:
        """
        AWS role ARN to be used for Federated Identity authentication with
        Kinesis. Check the Pub/Sub docs for how to set up this role and the
        required permissions that need to be attached to it.
        """
        return pulumi.get(self, "aws_role_arn")

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> builtins.str:
        """
        The Kinesis consumer ARN to used for ingestion in
        Enhanced Fan-Out mode. The consumer must be already
        created and ready to be used.
        """
        return pulumi.get(self, "consumer_arn")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> builtins.str:
        """
        The GCP service account to be used for Federated Identity authentication
        with Kinesis (via a `AssumeRoleWithWebIdentity` call for the provided
        role). The `awsRoleArn` must be set up with `accounts.google.com:sub`
        equals to this service account number.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> builtins.str:
        """
        The Kinesis stream ARN to ingest data from.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class TopicIngestionDataSourceSettingsAwsMsk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRoleArn":
            suggest = "aws_role_arn"
        elif key == "clusterArn":
            suggest = "cluster_arn"
        elif key == "gcpServiceAccount":
            suggest = "gcp_service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettingsAwsMsk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettingsAwsMsk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettingsAwsMsk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_role_arn: builtins.str,
                 cluster_arn: builtins.str,
                 gcp_service_account: builtins.str,
                 topic: builtins.str):
        """
        :param builtins.str aws_role_arn: AWS role ARN to be used for Federated Identity authentication with
               MSK. Check the Pub/Sub docs for how to set up this role and the
               required permissions that need to be attached to it.
        :param builtins.str cluster_arn: ARN that uniquely identifies the MSK cluster.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with MSK (via a `AssumeRoleWithWebIdentity` call for the provided
               role). The `awsRoleArn` must be set up with `accounts.google.com:sub`
               equals to this service account number.
        :param builtins.str topic: The name of the MSK topic that Pub/Sub will import from.
        """
        pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> builtins.str:
        """
        AWS role ARN to be used for Federated Identity authentication with
        MSK. Check the Pub/Sub docs for how to set up this role and the
        required permissions that need to be attached to it.
        """
        return pulumi.get(self, "aws_role_arn")

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> builtins.str:
        """
        ARN that uniquely identifies the MSK cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> builtins.str:
        """
        The GCP service account to be used for Federated Identity authentication
        with MSK (via a `AssumeRoleWithWebIdentity` call for the provided
        role). The `awsRoleArn` must be set up with `accounts.google.com:sub`
        equals to this service account number.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The name of the MSK topic that Pub/Sub will import from.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class TopicIngestionDataSourceSettingsAzureEventHubs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "eventHub":
            suggest = "event_hub"
        elif key == "gcpServiceAccount":
            suggest = "gcp_service_account"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettingsAzureEventHubs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettingsAzureEventHubs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettingsAzureEventHubs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[builtins.str] = None,
                 event_hub: Optional[builtins.str] = None,
                 gcp_service_account: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 resource_group: Optional[builtins.str] = None,
                 subscription_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str client_id: The Azure event hub client ID to use for ingestion.
        :param builtins.str event_hub: The Azure event hub to ingest data from.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Azure (via a `AssumeRoleWithWebIdentity` call for the provided
               role).
        :param builtins.str namespace: The Azure event hub namespace to ingest data from.
        :param builtins.str resource_group: The name of the resource group within an Azure subscription.
        :param builtins.str subscription_id: The Azure event hub subscription ID to use for ingestion.
        :param builtins.str tenant_id: The Azure event hub tenant ID to use for ingestion.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if event_hub is not None:
            pulumi.set(__self__, "event_hub", event_hub)
        if gcp_service_account is not None:
            pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        The Azure event hub client ID to use for ingestion.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="eventHub")
    def event_hub(self) -> Optional[builtins.str]:
        """
        The Azure event hub to ingest data from.
        """
        return pulumi.get(self, "event_hub")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> Optional[builtins.str]:
        """
        The GCP service account to be used for Federated Identity authentication
        with Azure (via a `AssumeRoleWithWebIdentity` call for the provided
        role).
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The Azure event hub namespace to ingest data from.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[builtins.str]:
        """
        The name of the resource group within an Azure subscription.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[builtins.str]:
        """
        The Azure event hub subscription ID to use for ingestion.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Azure event hub tenant ID to use for ingestion.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class TopicIngestionDataSourceSettingsCloudStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "avroFormat":
            suggest = "avro_format"
        elif key == "matchGlob":
            suggest = "match_glob"
        elif key == "minimumObjectCreateTime":
            suggest = "minimum_object_create_time"
        elif key == "pubsubAvroFormat":
            suggest = "pubsub_avro_format"
        elif key == "textFormat":
            suggest = "text_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettingsCloudStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettingsCloudStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettingsCloudStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 avro_format: Optional['outputs.TopicIngestionDataSourceSettingsCloudStorageAvroFormat'] = None,
                 match_glob: Optional[builtins.str] = None,
                 minimum_object_create_time: Optional[builtins.str] = None,
                 pubsub_avro_format: Optional['outputs.TopicIngestionDataSourceSettingsCloudStoragePubsubAvroFormat'] = None,
                 text_format: Optional['outputs.TopicIngestionDataSourceSettingsCloudStorageTextFormat'] = None):
        """
        :param builtins.str bucket: Cloud Storage bucket. The bucket name must be without any
               prefix like "gs://". See the bucket naming requirements:
               https://cloud.google.com/storage/docs/buckets#naming.
        :param 'TopicIngestionDataSourceSettingsCloudStorageAvroFormatArgs' avro_format: Configuration for reading Cloud Storage data in Avro binary format. The
               bytes of each object will be set to the `data` field of a Pub/Sub message.
        :param builtins.str match_glob: Glob pattern used to match objects that will be ingested. If unset, all
               objects will be ingested. See the supported patterns:
               https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob
        :param builtins.str minimum_object_create_time: The timestamp set in RFC3339 text format. If set, only objects with a
               larger or equal timestamp will be ingested. Unset by default, meaning
               all objects will be ingested.
        :param 'TopicIngestionDataSourceSettingsCloudStoragePubsubAvroFormatArgs' pubsub_avro_format: Configuration for reading Cloud Storage data written via Cloud Storage
               subscriptions(See https://cloud.google.com/pubsub/docs/cloudstorage). The
               data and attributes fields of the originally exported Pub/Sub message
               will be restored when publishing.
        :param 'TopicIngestionDataSourceSettingsCloudStorageTextFormatArgs' text_format: Configuration for reading Cloud Storage data in text format. Each line of
               text as specified by the delimiter will be set to the `data` field of a
               Pub/Sub message.
               Structure is documented below.
        """
        pulumi.set(__self__, "bucket", bucket)
        if avro_format is not None:
            pulumi.set(__self__, "avro_format", avro_format)
        if match_glob is not None:
            pulumi.set(__self__, "match_glob", match_glob)
        if minimum_object_create_time is not None:
            pulumi.set(__self__, "minimum_object_create_time", minimum_object_create_time)
        if pubsub_avro_format is not None:
            pulumi.set(__self__, "pubsub_avro_format", pubsub_avro_format)
        if text_format is not None:
            pulumi.set(__self__, "text_format", text_format)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Cloud Storage bucket. The bucket name must be without any
        prefix like "gs://". See the bucket naming requirements:
        https://cloud.google.com/storage/docs/buckets#naming.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="avroFormat")
    def avro_format(self) -> Optional['outputs.TopicIngestionDataSourceSettingsCloudStorageAvroFormat']:
        """
        Configuration for reading Cloud Storage data in Avro binary format. The
        bytes of each object will be set to the `data` field of a Pub/Sub message.
        """
        return pulumi.get(self, "avro_format")

    @property
    @pulumi.getter(name="matchGlob")
    def match_glob(self) -> Optional[builtins.str]:
        """
        Glob pattern used to match objects that will be ingested. If unset, all
        objects will be ingested. See the supported patterns:
        https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob
        """
        return pulumi.get(self, "match_glob")

    @property
    @pulumi.getter(name="minimumObjectCreateTime")
    def minimum_object_create_time(self) -> Optional[builtins.str]:
        """
        The timestamp set in RFC3339 text format. If set, only objects with a
        larger or equal timestamp will be ingested. Unset by default, meaning
        all objects will be ingested.
        """
        return pulumi.get(self, "minimum_object_create_time")

    @property
    @pulumi.getter(name="pubsubAvroFormat")
    def pubsub_avro_format(self) -> Optional['outputs.TopicIngestionDataSourceSettingsCloudStoragePubsubAvroFormat']:
        """
        Configuration for reading Cloud Storage data written via Cloud Storage
        subscriptions(See https://cloud.google.com/pubsub/docs/cloudstorage). The
        data and attributes fields of the originally exported Pub/Sub message
        will be restored when publishing.
        """
        return pulumi.get(self, "pubsub_avro_format")

    @property
    @pulumi.getter(name="textFormat")
    def text_format(self) -> Optional['outputs.TopicIngestionDataSourceSettingsCloudStorageTextFormat']:
        """
        Configuration for reading Cloud Storage data in text format. Each line of
        text as specified by the delimiter will be set to the `data` field of a
        Pub/Sub message.
        Structure is documented below.
        """
        return pulumi.get(self, "text_format")


@pulumi.output_type
class TopicIngestionDataSourceSettingsCloudStorageAvroFormat(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class TopicIngestionDataSourceSettingsCloudStoragePubsubAvroFormat(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class TopicIngestionDataSourceSettingsCloudStorageTextFormat(dict):
    def __init__(__self__, *,
                 delimiter: Optional[builtins.str] = None):
        """
        :param builtins.str delimiter: The delimiter to use when using the 'text' format. Each line of text as
               specified by the delimiter will be set to the 'data' field of a Pub/Sub
               message. When unset, '\\n' is used.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[builtins.str]:
        """
        The delimiter to use when using the 'text' format. Each line of text as
        specified by the delimiter will be set to the 'data' field of a Pub/Sub
        message. When unset, '\\n' is used.
        """
        return pulumi.get(self, "delimiter")


@pulumi.output_type
class TopicIngestionDataSourceSettingsConfluentCloud(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootstrapServer":
            suggest = "bootstrap_server"
        elif key == "gcpServiceAccount":
            suggest = "gcp_service_account"
        elif key == "identityPoolId":
            suggest = "identity_pool_id"
        elif key == "clusterId":
            suggest = "cluster_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIngestionDataSourceSettingsConfluentCloud. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIngestionDataSourceSettingsConfluentCloud.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIngestionDataSourceSettingsConfluentCloud.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bootstrap_server: builtins.str,
                 gcp_service_account: builtins.str,
                 identity_pool_id: builtins.str,
                 topic: builtins.str,
                 cluster_id: Optional[builtins.str] = None):
        """
        :param builtins.str bootstrap_server: The Confluent Cloud bootstrap server. The format is url:port.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Confluent Cloud.
        :param builtins.str identity_pool_id: Identity pool ID to be used for Federated Identity authentication with Confluent Cloud.
        :param builtins.str topic: Name of the Confluent Cloud topic that Pub/Sub will import from.
        :param builtins.str cluster_id: The Confluent Cloud cluster ID.
        """
        pulumi.set(__self__, "bootstrap_server", bootstrap_server)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "topic", topic)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)

    @property
    @pulumi.getter(name="bootstrapServer")
    def bootstrap_server(self) -> builtins.str:
        """
        The Confluent Cloud bootstrap server. The format is url:port.
        """
        return pulumi.get(self, "bootstrap_server")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> builtins.str:
        """
        The GCP service account to be used for Federated Identity authentication
        with Confluent Cloud.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> builtins.str:
        """
        Identity pool ID to be used for Federated Identity authentication with Confluent Cloud.
        """
        return pulumi.get(self, "identity_pool_id")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        Name of the Confluent Cloud topic that Pub/Sub will import from.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[builtins.str]:
        """
        The Confluent Cloud cluster ID.
        """
        return pulumi.get(self, "cluster_id")


@pulumi.output_type
class TopicIngestionDataSourceSettingsPlatformLogsSettings(dict):
    def __init__(__self__, *,
                 severity: Optional[builtins.str] = None):
        """
        :param builtins.str severity: The minimum severity level of Platform Logs that will be written. If unspecified,
               no Platform Logs will be written.
               Default value is `SEVERITY_UNSPECIFIED`.
               Possible values are: `SEVERITY_UNSPECIFIED`, `DISABLED`, `DEBUG`, `INFO`, `WARNING`, `ERROR`.
        """
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def severity(self) -> Optional[builtins.str]:
        """
        The minimum severity level of Platform Logs that will be written. If unspecified,
        no Platform Logs will be written.
        Default value is `SEVERITY_UNSPECIFIED`.
        Possible values are: `SEVERITY_UNSPECIFIED`, `DISABLED`, `DEBUG`, `INFO`, `WARNING`, `ERROR`.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class TopicMessageStoragePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedPersistenceRegions":
            suggest = "allowed_persistence_regions"
        elif key == "enforceInTransit":
            suggest = "enforce_in_transit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicMessageStoragePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicMessageStoragePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicMessageStoragePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_persistence_regions: Sequence[builtins.str],
                 enforce_in_transit: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] allowed_persistence_regions: A list of IDs of GCP regions where messages that are published to
               the topic may be persisted in storage. Messages published by
               publishers running in non-allowed GCP regions (or running outside
               of GCP altogether) will be routed for storage in one of the
               allowed regions. An empty list means that no regions are allowed,
               and is not a valid configuration.
        :param builtins.bool enforce_in_transit: If true, `allowedPersistenceRegions` is also used to enforce in-transit
               guarantees for messages. That is, Pub/Sub will fail topics.publish
               operations on this topic and subscribe operations on any subscription
               attached to this topic in any region that is not in `allowedPersistenceRegions`.
        """
        pulumi.set(__self__, "allowed_persistence_regions", allowed_persistence_regions)
        if enforce_in_transit is not None:
            pulumi.set(__self__, "enforce_in_transit", enforce_in_transit)

    @property
    @pulumi.getter(name="allowedPersistenceRegions")
    def allowed_persistence_regions(self) -> Sequence[builtins.str]:
        """
        A list of IDs of GCP regions where messages that are published to
        the topic may be persisted in storage. Messages published by
        publishers running in non-allowed GCP regions (or running outside
        of GCP altogether) will be routed for storage in one of the
        allowed regions. An empty list means that no regions are allowed,
        and is not a valid configuration.
        """
        return pulumi.get(self, "allowed_persistence_regions")

    @property
    @pulumi.getter(name="enforceInTransit")
    def enforce_in_transit(self) -> Optional[builtins.bool]:
        """
        If true, `allowedPersistenceRegions` is also used to enforce in-transit
        guarantees for messages. That is, Pub/Sub will fail topics.publish
        operations on this topic and subscribe operations on any subscription
        attached to this topic in any region that is not in `allowedPersistenceRegions`.
        """
        return pulumi.get(self, "enforce_in_transit")


@pulumi.output_type
class TopicMessageTransform(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "javascriptUdf":
            suggest = "javascript_udf"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicMessageTransform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicMessageTransform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicMessageTransform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[builtins.bool] = None,
                 javascript_udf: Optional['outputs.TopicMessageTransformJavascriptUdf'] = None):
        """
        :param builtins.bool disabled: Controls whether or not to use this transform. If not set or `false`,
               the transform will be applied to messages. Default: `true`.
        :param 'TopicMessageTransformJavascriptUdfArgs' javascript_udf: Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
               each one must have a unique `function_name`.
               Structure is documented below.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if javascript_udf is not None:
            pulumi.set(__self__, "javascript_udf", javascript_udf)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[builtins.bool]:
        """
        Controls whether or not to use this transform. If not set or `false`,
        the transform will be applied to messages. Default: `true`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="javascriptUdf")
    def javascript_udf(self) -> Optional['outputs.TopicMessageTransformJavascriptUdf']:
        """
        Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
        each one must have a unique `function_name`.
        Structure is documented below.
        """
        return pulumi.get(self, "javascript_udf")


@pulumi.output_type
class TopicMessageTransformJavascriptUdf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionName":
            suggest = "function_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicMessageTransformJavascriptUdf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicMessageTransformJavascriptUdf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicMessageTransformJavascriptUdf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: builtins.str,
                 function_name: builtins.str):
        """
        :param builtins.str code: JavaScript code that contains a function `function_name` with the
               following signature:
               ```
               /**
               * Transforms a Pub/Sub message.
               *
               * @return {(Object<string, (string | Object<string, string>)>|null)} - To
               * filter a message, return `null`. To transform a message return a map
               * with the following keys:
               *   - (required) 'data' : {string}
               *   - (optional) 'attributes' : {Object<string, string>}
               * Returning empty `attributes` will remove all attributes from the
               * message.
               *
               * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
               * message. Keys:
               *   - (required) 'data' : {string}
               *   - (required) 'attributes' : {Object<string, string>}
               *
               * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
               * Keys:
               *   - (required) 'message_id'  : {string}
               *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
               *   - (optional) 'ordering_key': {string}
               */
               function <function_name>(message, metadata) {
               }
               ```
        :param builtins.str function_name: Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "function_name", function_name)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        JavaScript code that contains a function `function_name` with the
        following signature:
        ```
        /**
        * Transforms a Pub/Sub message.
        *
        * @return {(Object<string, (string | Object<string, string>)>|null)} - To
        * filter a message, return `null`. To transform a message return a map
        * with the following keys:
        *   - (required) 'data' : {string}
        *   - (optional) 'attributes' : {Object<string, string>}
        * Returning empty `attributes` will remove all attributes from the
        * message.
        *
        * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
        * message. Keys:
        *   - (required) 'data' : {string}
        *   - (required) 'attributes' : {Object<string, string>}
        *
        * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
        * Keys:
        *   - (required) 'message_id'  : {string}
        *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
        *   - (optional) 'ordering_key': {string}
        */
        function <function_name>(message, metadata) {
        }
        ```
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> builtins.str:
        """
        Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        return pulumi.get(self, "function_name")


@pulumi.output_type
class TopicSchemaSettings(dict):
    def __init__(__self__, *,
                 schema: builtins.str,
                 encoding: Optional[builtins.str] = None):
        """
        :param builtins.str schema: The name of the schema that messages published should be
               validated against. Format is projects/{project}/schemas/{schema}.
               The value of this field will be _deleted-schema_
               if the schema has been deleted.
        :param builtins.str encoding: The encoding of messages validated against schema.
               Default value is `ENCODING_UNSPECIFIED`.
               Possible values are: `ENCODING_UNSPECIFIED`, `JSON`, `BINARY`.
        """
        pulumi.set(__self__, "schema", schema)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def schema(self) -> builtins.str:
        """
        The name of the schema that messages published should be
        validated against. Format is projects/{project}/schemas/{schema}.
        The value of this field will be _deleted-schema_
        if the schema has been deleted.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[builtins.str]:
        """
        The encoding of messages validated against schema.
        Default value is `ENCODING_UNSPECIFIED`.
        Possible values are: `ENCODING_UNSPECIFIED`, `JSON`, `BINARY`.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class GetSubscriptionBigqueryConfigResult(dict):
    def __init__(__self__, *,
                 drop_unknown_fields: builtins.bool,
                 service_account_email: builtins.str,
                 table: builtins.str,
                 use_table_schema: builtins.bool,
                 use_topic_schema: builtins.bool,
                 write_metadata: builtins.bool):
        """
        :param builtins.bool drop_unknown_fields: When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
               are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
               and any messages with extra fields are not written and remain in the subscription's backlog.
        :param builtins.str service_account_email: The service account to use to write to BigQuery. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param builtins.str table: The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        :param builtins.bool use_table_schema: When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
               must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        :param builtins.bool use_topic_schema: When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
               Only one of use_topic_schema and use_table_schema can be set.
        :param builtins.bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
               The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        pulumi.set(__self__, "drop_unknown_fields", drop_unknown_fields)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "table", table)
        pulumi.set(__self__, "use_table_schema", use_table_schema)
        pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="dropUnknownFields")
    def drop_unknown_fields(self) -> builtins.bool:
        """
        When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
        are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
        and any messages with extra fields are not written and remain in the subscription's backlog.
        """
        return pulumi.get(self, "drop_unknown_fields")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> builtins.str:
        """
        The service account to use to write to BigQuery. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def table(self) -> builtins.str:
        """
        The name of the table to which to write data, of the form {projectId}.{datasetId}.{tableId}
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="useTableSchema")
    def use_table_schema(self) -> builtins.bool:
        """
        When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
        must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_table_schema")

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> builtins.bool:
        """
        When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
        Only one of use_topic_schema and use_table_schema can be set.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> builtins.bool:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
        The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class GetSubscriptionCloudStorageConfigResult(dict):
    def __init__(__self__, *,
                 avro_configs: Sequence['outputs.GetSubscriptionCloudStorageConfigAvroConfigResult'],
                 bucket: builtins.str,
                 filename_datetime_format: builtins.str,
                 filename_prefix: builtins.str,
                 filename_suffix: builtins.str,
                 max_bytes: builtins.int,
                 max_duration: builtins.str,
                 max_messages: builtins.int,
                 service_account_email: builtins.str,
                 state: builtins.str):
        """
        :param Sequence['GetSubscriptionCloudStorageConfigAvroConfigArgs'] avro_configs: If set, message data will be written to Cloud Storage in Avro format.
        :param builtins.str bucket: User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        :param builtins.str filename_datetime_format: User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        :param builtins.str filename_prefix: User-provided prefix for Cloud Storage filename.
        :param builtins.str filename_suffix: User-provided suffix for Cloud Storage filename. Must not end in "/".
        :param builtins.int max_bytes: The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
               The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        :param builtins.str max_duration: The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
               May not exceed the subscription's acknowledgement deadline.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param builtins.int max_messages: The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        :param builtins.str service_account_email: The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
               [service agent](https://cloud.google.com/iam/docs/service-agents),
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        :param builtins.str state: An output-only field that indicates whether or not the subscription can receive messages.
        """
        pulumi.set(__self__, "avro_configs", avro_configs)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "filename_datetime_format", filename_datetime_format)
        pulumi.set(__self__, "filename_prefix", filename_prefix)
        pulumi.set(__self__, "filename_suffix", filename_suffix)
        pulumi.set(__self__, "max_bytes", max_bytes)
        pulumi.set(__self__, "max_duration", max_duration)
        pulumi.set(__self__, "max_messages", max_messages)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="avroConfigs")
    def avro_configs(self) -> Sequence['outputs.GetSubscriptionCloudStorageConfigAvroConfigResult']:
        """
        If set, message data will be written to Cloud Storage in Avro format.
        """
        return pulumi.get(self, "avro_configs")

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="filenameDatetimeFormat")
    def filename_datetime_format(self) -> builtins.str:
        """
        User-provided format string specifying how to represent datetimes in Cloud Storage filenames.
        """
        return pulumi.get(self, "filename_datetime_format")

    @property
    @pulumi.getter(name="filenamePrefix")
    def filename_prefix(self) -> builtins.str:
        """
        User-provided prefix for Cloud Storage filename.
        """
        return pulumi.get(self, "filename_prefix")

    @property
    @pulumi.getter(name="filenameSuffix")
    def filename_suffix(self) -> builtins.str:
        """
        User-provided suffix for Cloud Storage filename. Must not end in "/".
        """
        return pulumi.get(self, "filename_suffix")

    @property
    @pulumi.getter(name="maxBytes")
    def max_bytes(self) -> builtins.int:
        """
        The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
        The maxBytes limit may be exceeded in cases where messages are larger than the limit.
        """
        return pulumi.get(self, "max_bytes")

    @property
    @pulumi.getter(name="maxDuration")
    def max_duration(self) -> builtins.str:
        """
        The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
        May not exceed the subscription's acknowledgement deadline.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_duration")

    @property
    @pulumi.getter(name="maxMessages")
    def max_messages(self) -> builtins.int:
        """
        The maximum messages that can be written to a Cloud Storage file before a new file is created. Min 1000 messages.
        """
        return pulumi.get(self, "max_messages")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> builtins.str:
        """
        The service account to use to write to Cloud Storage. If not specified, the Pub/Sub
        [service agent](https://cloud.google.com/iam/docs/service-agents),
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        An output-only field that indicates whether or not the subscription can receive messages.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetSubscriptionCloudStorageConfigAvroConfigResult(dict):
    def __init__(__self__, *,
                 use_topic_schema: builtins.bool,
                 write_metadata: builtins.bool):
        """
        :param builtins.bool use_topic_schema: When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        :param builtins.bool write_metadata: When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        pulumi.set(__self__, "use_topic_schema", use_topic_schema)
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="useTopicSchema")
    def use_topic_schema(self) -> builtins.bool:
        """
        When true, the output Cloud Storage file will be serialized using the topic schema, if it exists.
        """
        return pulumi.get(self, "use_topic_schema")

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> builtins.bool:
        """
        When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class GetSubscriptionDeadLetterPolicyResult(dict):
    def __init__(__self__, *,
                 dead_letter_topic: builtins.str,
                 max_delivery_attempts: builtins.int):
        """
        :param builtins.str dead_letter_topic: The name of the topic to which dead letter messages should be published.
               Format is 'projects/{project}/topics/{topic}'.
               
               The Cloud Pub/Sub service account associated with the enclosing subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Publish() to this topic.
               
               The operation will fail if the topic does not exist.
               Users should ensure that there is a subscription attached to this topic
               since messages published to a topic with no subscriptions are lost.
        :param builtins.int max_delivery_attempts: The maximum number of delivery attempts for any message. The value must be
               between 5 and 100.
               
               The number of delivery attempts is defined as 1 + (the sum of number of
               NACKs and number of times the acknowledgement deadline has been exceeded for the message).
               
               A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
               client libraries may automatically extend ack_deadlines.
               
               This field will be honored on a best effort basis.
               
               If this parameter is 0, a default value of 5 is used.
        """
        pulumi.set(__self__, "dead_letter_topic", dead_letter_topic)
        pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="deadLetterTopic")
    def dead_letter_topic(self) -> builtins.str:
        """
        The name of the topic to which dead letter messages should be published.
        Format is 'projects/{project}/topics/{topic}'.

        The Cloud Pub/Sub service account associated with the enclosing subscription's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Publish() to this topic.

        The operation will fail if the topic does not exist.
        Users should ensure that there is a subscription attached to this topic
        since messages published to a topic with no subscriptions are lost.
        """
        return pulumi.get(self, "dead_letter_topic")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> builtins.int:
        """
        The maximum number of delivery attempts for any message. The value must be
        between 5 and 100.

        The number of delivery attempts is defined as 1 + (the sum of number of
        NACKs and number of times the acknowledgement deadline has been exceeded for the message).

        A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
        client libraries may automatically extend ack_deadlines.

        This field will be honored on a best effort basis.

        If this parameter is 0, a default value of 5 is used.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class GetSubscriptionExpirationPolicyResult(dict):
    def __init__(__self__, *,
                 ttl: builtins.str):
        """
        :param builtins.str ttl: Specifies the "time-to-live" duration for an associated resource. The
               resource expires if it is not active for a period of ttl.
               If ttl is set to "", the associated resource never expires.
               A duration in seconds with up to nine fractional digits, terminated by 's'.
               Example - "3.5s".
        """
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def ttl(self) -> builtins.str:
        """
        Specifies the "time-to-live" duration for an associated resource. The
        resource expires if it is not active for a period of ttl.
        If ttl is set to "", the associated resource never expires.
        A duration in seconds with up to nine fractional digits, terminated by 's'.
        Example - "3.5s".
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetSubscriptionMessageTransformResult(dict):
    def __init__(__self__, *,
                 disabled: builtins.bool,
                 javascript_udfs: Sequence['outputs.GetSubscriptionMessageTransformJavascriptUdfResult']):
        """
        :param builtins.bool disabled: Controls whether or not to use this transform. If not set or 'false',
               the transform will be applied to messages. Default: 'true'.
        :param Sequence['GetSubscriptionMessageTransformJavascriptUdfArgs'] javascript_udfs: Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
               each one must have a unique 'function_name'.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "javascript_udfs", javascript_udfs)

    @property
    @pulumi.getter
    def disabled(self) -> builtins.bool:
        """
        Controls whether or not to use this transform. If not set or 'false',
        the transform will be applied to messages. Default: 'true'.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="javascriptUdfs")
    def javascript_udfs(self) -> Sequence['outputs.GetSubscriptionMessageTransformJavascriptUdfResult']:
        """
        Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
        each one must have a unique 'function_name'.
        """
        return pulumi.get(self, "javascript_udfs")


@pulumi.output_type
class GetSubscriptionMessageTransformJavascriptUdfResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 function_name: builtins.str):
        """
        :param builtins.str code: JavaScript code that contains a function 'function_name' with the
               following signature:
               '''
                 /**
                 * Transforms a Pub/Sub message.
                 *
                 * @return {(Object<string, (string | Object<string, string>)>|null)} - To
                 * filter a message, return 'null'. To transform a message return a map
                 * with the following keys:
                 *   - (required) 'data' : {string}
                 *   - (optional) 'attributes' : {Object<string, string>}
                 * Returning empty 'attributes' will remove all attributes from the
                 * message.
                 *
                 * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
                 * message. Keys:
                 *   - (required) 'data' : {string}
                 *   - (required) 'attributes' : {Object<string, string>}
                 *
                 * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
                 * Keys:
                 *   - (required) 'message_id'  : {string}
                 *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
                 *   - (optional) 'ordering_key': {string}
                 */
                 function <function_name>(message, metadata) {
                 }
               '''
        :param builtins.str function_name: Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "function_name", function_name)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        JavaScript code that contains a function 'function_name' with the
        following signature:
        '''
          /**
          * Transforms a Pub/Sub message.
          *
          * @return {(Object<string, (string | Object<string, string>)>|null)} - To
          * filter a message, return 'null'. To transform a message return a map
          * with the following keys:
          *   - (required) 'data' : {string}
          *   - (optional) 'attributes' : {Object<string, string>}
          * Returning empty 'attributes' will remove all attributes from the
          * message.
          *
          * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
          * message. Keys:
          *   - (required) 'data' : {string}
          *   - (required) 'attributes' : {Object<string, string>}
          *
          * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
          * Keys:
          *   - (required) 'message_id'  : {string}
          *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
          *   - (optional) 'ordering_key': {string}
          */
          function <function_name>(message, metadata) {
          }
        '''
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> builtins.str:
        """
        Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        return pulumi.get(self, "function_name")


@pulumi.output_type
class GetSubscriptionPushConfigResult(dict):
    def __init__(__self__, *,
                 attributes: Mapping[str, builtins.str],
                 no_wrappers: Sequence['outputs.GetSubscriptionPushConfigNoWrapperResult'],
                 oidc_tokens: Sequence['outputs.GetSubscriptionPushConfigOidcTokenResult'],
                 push_endpoint: builtins.str):
        """
        :param Mapping[str, builtins.str] attributes: Endpoint configuration attributes.
               
               Every endpoint has a set of API supported attributes that can
               be used to control different aspects of the message delivery.
               
               The currently supported attribute is x-goog-version, which you
               can use to change the format of the pushed message. This
               attribute indicates the version of the data expected by
               the endpoint. This controls the shape of the pushed message
               (i.e., its fields and metadata). The endpoint version is
               based on the version of the Pub/Sub API.
               
               If not present during the subscriptions.create call,
               it will default to the version of the API used to make
               such call. If not present during a subscriptions.modifyPushConfig
               call, its value will not be changed. subscriptions.get
               calls will always return a valid version, even if the
               subscription was created without this attribute.
               
               The possible values for this attribute are:
               
               - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
               - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        :param Sequence['GetSubscriptionPushConfigNoWrapperArgs'] no_wrappers: When set, the payload to the push endpoint is not wrapped.Sets the
               'data' field as the HTTP body for delivery.
        :param Sequence['GetSubscriptionPushConfigOidcTokenArgs'] oidc_tokens: If specified, Pub/Sub will generate and attach an OIDC JWT token as
               an Authorization header in the HTTP request for every pushed message.
        :param builtins.str push_endpoint: A URL locating the endpoint to which messages should be pushed.
               For example, a Webhook endpoint might use
               "https://example.com/push".
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "no_wrappers", no_wrappers)
        pulumi.set(__self__, "oidc_tokens", oidc_tokens)
        pulumi.set(__self__, "push_endpoint", push_endpoint)

    @property
    @pulumi.getter
    def attributes(self) -> Mapping[str, builtins.str]:
        """
        Endpoint configuration attributes.

        Every endpoint has a set of API supported attributes that can
        be used to control different aspects of the message delivery.

        The currently supported attribute is x-goog-version, which you
        can use to change the format of the pushed message. This
        attribute indicates the version of the data expected by
        the endpoint. This controls the shape of the pushed message
        (i.e., its fields and metadata). The endpoint version is
        based on the version of the Pub/Sub API.

        If not present during the subscriptions.create call,
        it will default to the version of the API used to make
        such call. If not present during a subscriptions.modifyPushConfig
        call, its value will not be changed. subscriptions.get
        calls will always return a valid version, even if the
        subscription was created without this attribute.

        The possible values for this attribute are:

        - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
        - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="noWrappers")
    def no_wrappers(self) -> Sequence['outputs.GetSubscriptionPushConfigNoWrapperResult']:
        """
        When set, the payload to the push endpoint is not wrapped.Sets the
        'data' field as the HTTP body for delivery.
        """
        return pulumi.get(self, "no_wrappers")

    @property
    @pulumi.getter(name="oidcTokens")
    def oidc_tokens(self) -> Sequence['outputs.GetSubscriptionPushConfigOidcTokenResult']:
        """
        If specified, Pub/Sub will generate and attach an OIDC JWT token as
        an Authorization header in the HTTP request for every pushed message.
        """
        return pulumi.get(self, "oidc_tokens")

    @property
    @pulumi.getter(name="pushEndpoint")
    def push_endpoint(self) -> builtins.str:
        """
        A URL locating the endpoint to which messages should be pushed.
        For example, a Webhook endpoint might use
        "https://example.com/push".
        """
        return pulumi.get(self, "push_endpoint")


@pulumi.output_type
class GetSubscriptionPushConfigNoWrapperResult(dict):
    def __init__(__self__, *,
                 write_metadata: builtins.bool):
        """
        :param builtins.bool write_metadata: When true, writes the Pub/Sub message metadata to
               'x-goog-pubsub-<KEY>:<VAL>' headers of the HTTP request. Writes the
               Pub/Sub message attributes to '<KEY>:<VAL>' headers of the HTTP request.
        """
        pulumi.set(__self__, "write_metadata", write_metadata)

    @property
    @pulumi.getter(name="writeMetadata")
    def write_metadata(self) -> builtins.bool:
        """
        When true, writes the Pub/Sub message metadata to
        'x-goog-pubsub-<KEY>:<VAL>' headers of the HTTP request. Writes the
        Pub/Sub message attributes to '<KEY>:<VAL>' headers of the HTTP request.
        """
        return pulumi.get(self, "write_metadata")


@pulumi.output_type
class GetSubscriptionPushConfigOidcTokenResult(dict):
    def __init__(__self__, *,
                 audience: builtins.str,
                 service_account_email: builtins.str):
        """
        :param builtins.str audience: Audience to be used when generating OIDC token. The audience claim
               identifies the recipients that the JWT is intended for. The audience
               value is a single case-sensitive string. Having multiple values (array)
               for the audience field is not supported. More info about the OIDC JWT
               token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
               Note: if not specified, the Push endpoint URL will be used.
        :param builtins.str service_account_email: Service account email to be used for generating the OIDC token.
               The caller (for subscriptions.create, subscriptions.patch, and
               subscriptions.modifyPushConfig RPCs) must have the
               iam.serviceAccounts.actAs permission for the service account.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "service_account_email", service_account_email)

    @property
    @pulumi.getter
    def audience(self) -> builtins.str:
        """
        Audience to be used when generating OIDC token. The audience claim
        identifies the recipients that the JWT is intended for. The audience
        value is a single case-sensitive string. Having multiple values (array)
        for the audience field is not supported. More info about the OIDC JWT
        token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
        Note: if not specified, the Push endpoint URL will be used.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> builtins.str:
        """
        Service account email to be used for generating the OIDC token.
        The caller (for subscriptions.create, subscriptions.patch, and
        subscriptions.modifyPushConfig RPCs) must have the
        iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")


@pulumi.output_type
class GetSubscriptionRetryPolicyResult(dict):
    def __init__(__self__, *,
                 maximum_backoff: builtins.str,
                 minimum_backoff: builtins.str):
        """
        :param builtins.str maximum_backoff: The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param builtins.str minimum_backoff: The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "maximum_backoff", maximum_backoff)
        pulumi.set(__self__, "minimum_backoff", minimum_backoff)

    @property
    @pulumi.getter(name="maximumBackoff")
    def maximum_backoff(self) -> builtins.str:
        """
        The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "maximum_backoff")

    @property
    @pulumi.getter(name="minimumBackoff")
    def minimum_backoff(self) -> builtins.str:
        """
        The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "minimum_backoff")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingResult(dict):
    def __init__(__self__, *,
                 aws_kineses: Sequence['outputs.GetTopicIngestionDataSourceSettingAwsKineseResult'],
                 aws_msks: Sequence['outputs.GetTopicIngestionDataSourceSettingAwsMskResult'],
                 azure_event_hubs: Sequence['outputs.GetTopicIngestionDataSourceSettingAzureEventHubResult'],
                 cloud_storages: Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStorageResult'],
                 confluent_clouds: Sequence['outputs.GetTopicIngestionDataSourceSettingConfluentCloudResult'],
                 platform_logs_settings: Sequence['outputs.GetTopicIngestionDataSourceSettingPlatformLogsSettingResult']):
        """
        :param Sequence['GetTopicIngestionDataSourceSettingAwsKineseArgs'] aws_kineses: Settings for ingestion from Amazon Kinesis Data Streams.
        :param Sequence['GetTopicIngestionDataSourceSettingAwsMskArgs'] aws_msks: Settings for ingestion from Amazon Managed Streaming for Apache Kafka.
        :param Sequence['GetTopicIngestionDataSourceSettingAzureEventHubArgs'] azure_event_hubs: Settings for ingestion from Azure Event Hubs.
        :param Sequence['GetTopicIngestionDataSourceSettingCloudStorageArgs'] cloud_storages: Settings for ingestion from Cloud Storage.
        :param Sequence['GetTopicIngestionDataSourceSettingConfluentCloudArgs'] confluent_clouds: Settings for ingestion from Confluent Cloud.
        :param Sequence['GetTopicIngestionDataSourceSettingPlatformLogsSettingArgs'] platform_logs_settings: Settings for Platform Logs regarding ingestion to Pub/Sub. If unset,
               no Platform Logs will be generated.'
        """
        pulumi.set(__self__, "aws_kineses", aws_kineses)
        pulumi.set(__self__, "aws_msks", aws_msks)
        pulumi.set(__self__, "azure_event_hubs", azure_event_hubs)
        pulumi.set(__self__, "cloud_storages", cloud_storages)
        pulumi.set(__self__, "confluent_clouds", confluent_clouds)
        pulumi.set(__self__, "platform_logs_settings", platform_logs_settings)

    @property
    @pulumi.getter(name="awsKineses")
    def aws_kineses(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingAwsKineseResult']:
        """
        Settings for ingestion from Amazon Kinesis Data Streams.
        """
        return pulumi.get(self, "aws_kineses")

    @property
    @pulumi.getter(name="awsMsks")
    def aws_msks(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingAwsMskResult']:
        """
        Settings for ingestion from Amazon Managed Streaming for Apache Kafka.
        """
        return pulumi.get(self, "aws_msks")

    @property
    @pulumi.getter(name="azureEventHubs")
    def azure_event_hubs(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingAzureEventHubResult']:
        """
        Settings for ingestion from Azure Event Hubs.
        """
        return pulumi.get(self, "azure_event_hubs")

    @property
    @pulumi.getter(name="cloudStorages")
    def cloud_storages(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStorageResult']:
        """
        Settings for ingestion from Cloud Storage.
        """
        return pulumi.get(self, "cloud_storages")

    @property
    @pulumi.getter(name="confluentClouds")
    def confluent_clouds(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingConfluentCloudResult']:
        """
        Settings for ingestion from Confluent Cloud.
        """
        return pulumi.get(self, "confluent_clouds")

    @property
    @pulumi.getter(name="platformLogsSettings")
    def platform_logs_settings(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingPlatformLogsSettingResult']:
        """
        Settings for Platform Logs regarding ingestion to Pub/Sub. If unset,
        no Platform Logs will be generated.'
        """
        return pulumi.get(self, "platform_logs_settings")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingAwsKineseResult(dict):
    def __init__(__self__, *,
                 aws_role_arn: builtins.str,
                 consumer_arn: builtins.str,
                 gcp_service_account: builtins.str,
                 stream_arn: builtins.str):
        """
        :param builtins.str aws_role_arn: AWS role ARN to be used for Federated Identity authentication with
               Kinesis. Check the Pub/Sub docs for how to set up this role and the
               required permissions that need to be attached to it.
        :param builtins.str consumer_arn: The Kinesis consumer ARN to used for ingestion in
               Enhanced Fan-Out mode. The consumer must be already
               created and ready to be used.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Kinesis (via a 'AssumeRoleWithWebIdentity' call for the provided
               role). The 'awsRoleArn' must be set up with 'accounts.google.com:sub'
               equals to this service account number.
        :param builtins.str stream_arn: The Kinesis stream ARN to ingest data from.
        """
        pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        pulumi.set(__self__, "consumer_arn", consumer_arn)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> builtins.str:
        """
        AWS role ARN to be used for Federated Identity authentication with
        Kinesis. Check the Pub/Sub docs for how to set up this role and the
        required permissions that need to be attached to it.
        """
        return pulumi.get(self, "aws_role_arn")

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> builtins.str:
        """
        The Kinesis consumer ARN to used for ingestion in
        Enhanced Fan-Out mode. The consumer must be already
        created and ready to be used.
        """
        return pulumi.get(self, "consumer_arn")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> builtins.str:
        """
        The GCP service account to be used for Federated Identity authentication
        with Kinesis (via a 'AssumeRoleWithWebIdentity' call for the provided
        role). The 'awsRoleArn' must be set up with 'accounts.google.com:sub'
        equals to this service account number.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> builtins.str:
        """
        The Kinesis stream ARN to ingest data from.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingAwsMskResult(dict):
    def __init__(__self__, *,
                 aws_role_arn: builtins.str,
                 cluster_arn: builtins.str,
                 gcp_service_account: builtins.str,
                 topic: builtins.str):
        """
        :param builtins.str aws_role_arn: AWS role ARN to be used for Federated Identity authentication with
               MSK. Check the Pub/Sub docs for how to set up this role and the
               required permissions that need to be attached to it.
        :param builtins.str cluster_arn: ARN that uniquely identifies the MSK cluster.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with MSK (via a 'AssumeRoleWithWebIdentity' call for the provided
               role). The 'awsRoleArn' must be set up with 'accounts.google.com:sub'
               equals to this service account number.
        :param builtins.str topic: The name of the MSK topic that Pub/Sub will import from.
        """
        pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> builtins.str:
        """
        AWS role ARN to be used for Federated Identity authentication with
        MSK. Check the Pub/Sub docs for how to set up this role and the
        required permissions that need to be attached to it.
        """
        return pulumi.get(self, "aws_role_arn")

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> builtins.str:
        """
        ARN that uniquely identifies the MSK cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> builtins.str:
        """
        The GCP service account to be used for Federated Identity authentication
        with MSK (via a 'AssumeRoleWithWebIdentity' call for the provided
        role). The 'awsRoleArn' must be set up with 'accounts.google.com:sub'
        equals to this service account number.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The name of the MSK topic that Pub/Sub will import from.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingAzureEventHubResult(dict):
    def __init__(__self__, *,
                 client_id: builtins.str,
                 event_hub: builtins.str,
                 gcp_service_account: builtins.str,
                 namespace: builtins.str,
                 resource_group: builtins.str,
                 subscription_id: builtins.str,
                 tenant_id: builtins.str):
        """
        :param builtins.str client_id: The Azure event hub client ID to use for ingestion.
        :param builtins.str event_hub: The Azure event hub to ingest data from.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Azure (via a 'AssumeRoleWithWebIdentity' call for the provided
               role).
        :param builtins.str namespace: The Azure event hub namespace to ingest data from.
        :param builtins.str resource_group: The name of the resource group within an Azure subscription.
        :param builtins.str subscription_id: The Azure event hub subscription ID to use for ingestion.
        :param builtins.str tenant_id: The Azure event hub tenant ID to use for ingestion.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "event_hub", event_hub)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        The Azure event hub client ID to use for ingestion.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="eventHub")
    def event_hub(self) -> builtins.str:
        """
        The Azure event hub to ingest data from.
        """
        return pulumi.get(self, "event_hub")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> builtins.str:
        """
        The GCP service account to be used for Federated Identity authentication
        with Azure (via a 'AssumeRoleWithWebIdentity' call for the provided
        role).
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The Azure event hub namespace to ingest data from.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        """
        The name of the resource group within an Azure subscription.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The Azure event hub subscription ID to use for ingestion.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Azure event hub tenant ID to use for ingestion.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingCloudStorageResult(dict):
    def __init__(__self__, *,
                 avro_formats: Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStorageAvroFormatResult'],
                 bucket: builtins.str,
                 match_glob: builtins.str,
                 minimum_object_create_time: builtins.str,
                 pubsub_avro_formats: Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStoragePubsubAvroFormatResult'],
                 text_formats: Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStorageTextFormatResult']):
        """
        :param Sequence['GetTopicIngestionDataSourceSettingCloudStorageAvroFormatArgs'] avro_formats: Configuration for reading Cloud Storage data in Avro binary format. The
               bytes of each object will be set to the 'data' field of a Pub/Sub message.
        :param builtins.str bucket: Cloud Storage bucket. The bucket name must be without any
               prefix like "gs://". See the bucket naming requirements:
               https://cloud.google.com/storage/docs/buckets#naming.
        :param builtins.str match_glob: Glob pattern used to match objects that will be ingested. If unset, all
               objects will be ingested. See the supported patterns:
               https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob
        :param builtins.str minimum_object_create_time: The timestamp set in RFC3339 text format. If set, only objects with a
               larger or equal timestamp will be ingested. Unset by default, meaning
               all objects will be ingested.
        :param Sequence['GetTopicIngestionDataSourceSettingCloudStoragePubsubAvroFormatArgs'] pubsub_avro_formats: Configuration for reading Cloud Storage data written via Cloud Storage
               subscriptions(See https://cloud.google.com/pubsub/docs/cloudstorage). The
               data and attributes fields of the originally exported Pub/Sub message
               will be restored when publishing.
        :param Sequence['GetTopicIngestionDataSourceSettingCloudStorageTextFormatArgs'] text_formats: Configuration for reading Cloud Storage data in text format. Each line of
               text as specified by the delimiter will be set to the 'data' field of a
               Pub/Sub message.
        """
        pulumi.set(__self__, "avro_formats", avro_formats)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "match_glob", match_glob)
        pulumi.set(__self__, "minimum_object_create_time", minimum_object_create_time)
        pulumi.set(__self__, "pubsub_avro_formats", pubsub_avro_formats)
        pulumi.set(__self__, "text_formats", text_formats)

    @property
    @pulumi.getter(name="avroFormats")
    def avro_formats(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStorageAvroFormatResult']:
        """
        Configuration for reading Cloud Storage data in Avro binary format. The
        bytes of each object will be set to the 'data' field of a Pub/Sub message.
        """
        return pulumi.get(self, "avro_formats")

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Cloud Storage bucket. The bucket name must be without any
        prefix like "gs://". See the bucket naming requirements:
        https://cloud.google.com/storage/docs/buckets#naming.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="matchGlob")
    def match_glob(self) -> builtins.str:
        """
        Glob pattern used to match objects that will be ingested. If unset, all
        objects will be ingested. See the supported patterns:
        https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob
        """
        return pulumi.get(self, "match_glob")

    @property
    @pulumi.getter(name="minimumObjectCreateTime")
    def minimum_object_create_time(self) -> builtins.str:
        """
        The timestamp set in RFC3339 text format. If set, only objects with a
        larger or equal timestamp will be ingested. Unset by default, meaning
        all objects will be ingested.
        """
        return pulumi.get(self, "minimum_object_create_time")

    @property
    @pulumi.getter(name="pubsubAvroFormats")
    def pubsub_avro_formats(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStoragePubsubAvroFormatResult']:
        """
        Configuration for reading Cloud Storage data written via Cloud Storage
        subscriptions(See https://cloud.google.com/pubsub/docs/cloudstorage). The
        data and attributes fields of the originally exported Pub/Sub message
        will be restored when publishing.
        """
        return pulumi.get(self, "pubsub_avro_formats")

    @property
    @pulumi.getter(name="textFormats")
    def text_formats(self) -> Sequence['outputs.GetTopicIngestionDataSourceSettingCloudStorageTextFormatResult']:
        """
        Configuration for reading Cloud Storage data in text format. Each line of
        text as specified by the delimiter will be set to the 'data' field of a
        Pub/Sub message.
        """
        return pulumi.get(self, "text_formats")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingCloudStorageAvroFormatResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetTopicIngestionDataSourceSettingCloudStoragePubsubAvroFormatResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetTopicIngestionDataSourceSettingCloudStorageTextFormatResult(dict):
    def __init__(__self__, *,
                 delimiter: builtins.str):
        """
        :param builtins.str delimiter: The delimiter to use when using the 'text' format. Each line of text as
               specified by the delimiter will be set to the 'data' field of a Pub/Sub
               message. When unset, '\\n' is used.
        """
        pulumi.set(__self__, "delimiter", delimiter)

    @property
    @pulumi.getter
    def delimiter(self) -> builtins.str:
        """
        The delimiter to use when using the 'text' format. Each line of text as
        specified by the delimiter will be set to the 'data' field of a Pub/Sub
        message. When unset, '\\n' is used.
        """
        return pulumi.get(self, "delimiter")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingConfluentCloudResult(dict):
    def __init__(__self__, *,
                 bootstrap_server: builtins.str,
                 cluster_id: builtins.str,
                 gcp_service_account: builtins.str,
                 identity_pool_id: builtins.str,
                 topic: builtins.str):
        """
        :param builtins.str bootstrap_server: The Confluent Cloud bootstrap server. The format is url:port.
        :param builtins.str cluster_id: The Confluent Cloud cluster ID.
        :param builtins.str gcp_service_account: The GCP service account to be used for Federated Identity authentication
               with Confluent Cloud.
        :param builtins.str identity_pool_id: Identity pool ID to be used for Federated Identity authentication with Confluent Cloud.
        :param builtins.str topic: Name of the Confluent Cloud topic that Pub/Sub will import from.
        """
        pulumi.set(__self__, "bootstrap_server", bootstrap_server)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "gcp_service_account", gcp_service_account)
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="bootstrapServer")
    def bootstrap_server(self) -> builtins.str:
        """
        The Confluent Cloud bootstrap server. The format is url:port.
        """
        return pulumi.get(self, "bootstrap_server")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The Confluent Cloud cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="gcpServiceAccount")
    def gcp_service_account(self) -> builtins.str:
        """
        The GCP service account to be used for Federated Identity authentication
        with Confluent Cloud.
        """
        return pulumi.get(self, "gcp_service_account")

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> builtins.str:
        """
        Identity pool ID to be used for Federated Identity authentication with Confluent Cloud.
        """
        return pulumi.get(self, "identity_pool_id")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        Name of the Confluent Cloud topic that Pub/Sub will import from.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetTopicIngestionDataSourceSettingPlatformLogsSettingResult(dict):
    def __init__(__self__, *,
                 severity: builtins.str):
        """
        :param builtins.str severity: The minimum severity level of Platform Logs that will be written. If unspecified,
               no Platform Logs will be written. Default value: "SEVERITY_UNSPECIFIED" Possible values: ["SEVERITY_UNSPECIFIED", "DISABLED", "DEBUG", "INFO", "WARNING", "ERROR"]
        """
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        The minimum severity level of Platform Logs that will be written. If unspecified,
        no Platform Logs will be written. Default value: "SEVERITY_UNSPECIFIED" Possible values: ["SEVERITY_UNSPECIFIED", "DISABLED", "DEBUG", "INFO", "WARNING", "ERROR"]
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class GetTopicMessageStoragePolicyResult(dict):
    def __init__(__self__, *,
                 allowed_persistence_regions: Sequence[builtins.str],
                 enforce_in_transit: builtins.bool):
        """
        :param Sequence[builtins.str] allowed_persistence_regions: A list of IDs of GCP regions where messages that are published to
               the topic may be persisted in storage. Messages published by
               publishers running in non-allowed GCP regions (or running outside
               of GCP altogether) will be routed for storage in one of the
               allowed regions. An empty list means that no regions are allowed,
               and is not a valid configuration.
        :param builtins.bool enforce_in_transit: If true, 'allowedPersistenceRegions' is also used to enforce in-transit
               guarantees for messages. That is, Pub/Sub will fail topics.publish
               operations on this topic and subscribe operations on any subscription
               attached to this topic in any region that is not in 'allowedPersistenceRegions'.
        """
        pulumi.set(__self__, "allowed_persistence_regions", allowed_persistence_regions)
        pulumi.set(__self__, "enforce_in_transit", enforce_in_transit)

    @property
    @pulumi.getter(name="allowedPersistenceRegions")
    def allowed_persistence_regions(self) -> Sequence[builtins.str]:
        """
        A list of IDs of GCP regions where messages that are published to
        the topic may be persisted in storage. Messages published by
        publishers running in non-allowed GCP regions (or running outside
        of GCP altogether) will be routed for storage in one of the
        allowed regions. An empty list means that no regions are allowed,
        and is not a valid configuration.
        """
        return pulumi.get(self, "allowed_persistence_regions")

    @property
    @pulumi.getter(name="enforceInTransit")
    def enforce_in_transit(self) -> builtins.bool:
        """
        If true, 'allowedPersistenceRegions' is also used to enforce in-transit
        guarantees for messages. That is, Pub/Sub will fail topics.publish
        operations on this topic and subscribe operations on any subscription
        attached to this topic in any region that is not in 'allowedPersistenceRegions'.
        """
        return pulumi.get(self, "enforce_in_transit")


@pulumi.output_type
class GetTopicMessageTransformResult(dict):
    def __init__(__self__, *,
                 disabled: builtins.bool,
                 javascript_udfs: Sequence['outputs.GetTopicMessageTransformJavascriptUdfResult']):
        """
        :param builtins.bool disabled: Controls whether or not to use this transform. If not set or 'false',
               the transform will be applied to messages. Default: 'true'.
        :param Sequence['GetTopicMessageTransformJavascriptUdfArgs'] javascript_udfs: Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
               each one must have a unique 'function_name'.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "javascript_udfs", javascript_udfs)

    @property
    @pulumi.getter
    def disabled(self) -> builtins.bool:
        """
        Controls whether or not to use this transform. If not set or 'false',
        the transform will be applied to messages. Default: 'true'.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="javascriptUdfs")
    def javascript_udfs(self) -> Sequence['outputs.GetTopicMessageTransformJavascriptUdfResult']:
        """
        Javascript User Defined Function. If multiple Javascript UDFs are specified on a resource,
        each one must have a unique 'function_name'.
        """
        return pulumi.get(self, "javascript_udfs")


@pulumi.output_type
class GetTopicMessageTransformJavascriptUdfResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 function_name: builtins.str):
        """
        :param builtins.str code: JavaScript code that contains a function 'function_name' with the
               following signature:
               '''
                 /**
                 * Transforms a Pub/Sub message.
                 *
                 * @return {(Object<string, (string | Object<string, string>)>|null)} - To
                 * filter a message, return 'null'. To transform a message return a map
                 * with the following keys:
                 *   - (required) 'data' : {string}
                 *   - (optional) 'attributes' : {Object<string, string>}
                 * Returning empty 'attributes' will remove all attributes from the
                 * message.
                 *
                 * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
                 * message. Keys:
                 *   - (required) 'data' : {string}
                 *   - (required) 'attributes' : {Object<string, string>}
                 *
                 * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
                 * Keys:
                 *   - (required) 'message_id'  : {string}
                 *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
                 *   - (optional) 'ordering_key': {string}
                 */
                 function <function_name>(message, metadata) {
                 }
               '''
        :param builtins.str function_name: Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "function_name", function_name)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        JavaScript code that contains a function 'function_name' with the
        following signature:
        '''
          /**
          * Transforms a Pub/Sub message.
          *
          * @return {(Object<string, (string | Object<string, string>)>|null)} - To
          * filter a message, return 'null'. To transform a message return a map
          * with the following keys:
          *   - (required) 'data' : {string}
          *   - (optional) 'attributes' : {Object<string, string>}
          * Returning empty 'attributes' will remove all attributes from the
          * message.
          *
          * @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
          * message. Keys:
          *   - (required) 'data' : {string}
          *   - (required) 'attributes' : {Object<string, string>}
          *
          * @param  {Object<string, any>} metadata - Pub/Sub message metadata.
          * Keys:
          *   - (required) 'message_id'  : {string}
          *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
          *   - (optional) 'ordering_key': {string}
          */
          function <function_name>(message, metadata) {
          }
        '''
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> builtins.str:
        """
        Name of the JavaScript function that should be applied to Pub/Sub messages.
        """
        return pulumi.get(self, "function_name")


@pulumi.output_type
class GetTopicSchemaSettingResult(dict):
    def __init__(__self__, *,
                 encoding: builtins.str,
                 schema: builtins.str):
        """
        :param builtins.str encoding: The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"]
        :param builtins.str schema: The name of the schema that messages published should be
               validated against. Format is projects/{project}/schemas/{schema}.
               The value of this field will be _deleted-schema_
               if the schema has been deleted.
        """
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def encoding(self) -> builtins.str:
        """
        The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"]
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def schema(self) -> builtins.str:
        """
        The name of the schema that messages published should be
        validated against. Format is projects/{project}/schemas/{schema}.
        The value of this field will be _deleted-schema_
        if the schema has been deleted.
        """
        return pulumi.get(self, "schema")


