# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterAutomatedBackupConfig',
    'ClusterAutomatedBackupConfigFixedFrequencySchedule',
    'ClusterAutomatedBackupConfigFixedFrequencyScheduleStartTime',
    'ClusterCrossClusterReplicationConfig',
    'ClusterCrossClusterReplicationConfigMembership',
    'ClusterCrossClusterReplicationConfigMembershipPrimaryCluster',
    'ClusterCrossClusterReplicationConfigMembershipSecondaryCluster',
    'ClusterCrossClusterReplicationConfigPrimaryCluster',
    'ClusterCrossClusterReplicationConfigSecondaryCluster',
    'ClusterDiscoveryEndpoint',
    'ClusterDiscoveryEndpointPscConfig',
    'ClusterGcsSource',
    'ClusterMaintenancePolicy',
    'ClusterMaintenancePolicyWeeklyMaintenanceWindow',
    'ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTime',
    'ClusterMaintenanceSchedule',
    'ClusterManagedBackupSource',
    'ClusterManagedServerCa',
    'ClusterManagedServerCaCaCert',
    'ClusterPersistenceConfig',
    'ClusterPersistenceConfigAofConfig',
    'ClusterPersistenceConfigRdbConfig',
    'ClusterPscConfig',
    'ClusterPscConnection',
    'ClusterPscServiceAttachment',
    'ClusterStateInfo',
    'ClusterStateInfoUpdateInfo',
    'ClusterUserCreatedConnectionsClusterEndpoint',
    'ClusterUserCreatedConnectionsClusterEndpointConnection',
    'ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnection',
    'ClusterZoneDistributionConfig',
    'InstanceMaintenancePolicy',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindow',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime',
    'InstanceMaintenanceSchedule',
    'InstanceNode',
    'InstancePersistenceConfig',
    'InstanceServerCaCert',
    'GetInstanceMaintenancePolicyResult',
    'GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult',
    'GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult',
    'GetInstanceMaintenanceScheduleResult',
    'GetInstanceNodeResult',
    'GetInstancePersistenceConfigResult',
    'GetInstanceServerCaCertResult',
]

@pulumi.output_type
class ClusterAutomatedBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedFrequencySchedule":
            suggest = "fixed_frequency_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_frequency_schedule: 'outputs.ClusterAutomatedBackupConfigFixedFrequencySchedule',
                 retention: builtins.str):
        """
        :param 'ClusterAutomatedBackupConfigFixedFrequencyScheduleArgs' fixed_frequency_schedule: Trigger automated backups at a fixed frequency.
               Structure is documented below.
        :param builtins.str retention: How long to keep automated backups before the backups are deleted.
               The value should be between 1 day and 365 days. If not specified, the default value is 35 days.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "fixed_frequency_schedule", fixed_frequency_schedule)
        pulumi.set(__self__, "retention", retention)

    @property
    @pulumi.getter(name="fixedFrequencySchedule")
    def fixed_frequency_schedule(self) -> 'outputs.ClusterAutomatedBackupConfigFixedFrequencySchedule':
        """
        Trigger automated backups at a fixed frequency.
        Structure is documented below.
        """
        return pulumi.get(self, "fixed_frequency_schedule")

    @property
    @pulumi.getter
    def retention(self) -> builtins.str:
        """
        How long to keep automated backups before the backups are deleted.
        The value should be between 1 day and 365 days. If not specified, the default value is 35 days.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention")


@pulumi.output_type
class ClusterAutomatedBackupConfigFixedFrequencySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupConfigFixedFrequencySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupConfigFixedFrequencySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupConfigFixedFrequencySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: 'outputs.ClusterAutomatedBackupConfigFixedFrequencyScheduleStartTime'):
        """
        :param 'ClusterAutomatedBackupConfigFixedFrequencyScheduleStartTimeArgs' start_time: The start time of every automated backup in UTC.
               It must be set to the start of an hour. This field is required.
               Structure is documented below.
        """
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.ClusterAutomatedBackupConfigFixedFrequencyScheduleStartTime':
        """
        The start time of every automated backup in UTC.
        It must be set to the start of an hour. This field is required.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterAutomatedBackupConfigFixedFrequencyScheduleStartTime(dict):
    def __init__(__self__, *,
                 hours: builtins.int):
        """
        :param builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        pulumi.set(__self__, "hours", hours)

    @property
    @pulumi.getter
    def hours(self) -> builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")


@pulumi.output_type
class ClusterCrossClusterReplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterRole":
            suggest = "cluster_role"
        elif key == "primaryCluster":
            suggest = "primary_cluster"
        elif key == "secondaryClusters":
            suggest = "secondary_clusters"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCrossClusterReplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCrossClusterReplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCrossClusterReplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_role: Optional[builtins.str] = None,
                 memberships: Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigMembership']] = None,
                 primary_cluster: Optional['outputs.ClusterCrossClusterReplicationConfigPrimaryCluster'] = None,
                 secondary_clusters: Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigSecondaryCluster']] = None,
                 update_time: Optional[builtins.str] = None):
        """
        :param builtins.str cluster_role: The role of the cluster in cross cluster replication. Supported values are:
               1. `CLUSTER_ROLE_UNSPECIFIED`: This is an independent cluster that has never participated in cross cluster replication. It allows both reads and writes.
               1. `NONE`: This is an independent cluster that previously participated in cross cluster replication(either as a `PRIMARY` or `SECONDARY` cluster). It allows both reads and writes.
               1. `PRIMARY`: This cluster serves as the replication source for secondary clusters that are replicating from it. Any data written to it is automatically replicated to its secondary clusters. It allows both reads and writes.
               1. `SECONDARY`: This cluster replicates data from the primary cluster. It allows only reads.
               Possible values are: `CLUSTER_ROLE_UNSPECIFIED`, `NONE`, `PRIMARY`, `SECONDARY`.
        :param Sequence['ClusterCrossClusterReplicationConfigMembershipArgs'] memberships: (Output)
               An output only view of all the member clusters participating in cross cluster replication. This field is populated for all the member clusters irrespective of their cluster role.
               Structure is documented below.
        :param 'ClusterCrossClusterReplicationConfigPrimaryClusterArgs' primary_cluster: Details of the primary cluster that is used as the replication source for this secondary cluster. This is allowed to be set only for clusters whose cluster role is of type `SECONDARY`.
               Structure is documented below.
        :param Sequence['ClusterCrossClusterReplicationConfigSecondaryClusterArgs'] secondary_clusters: List of secondary clusters that are replicating from this primary cluster. This is allowed to be set only for clusters whose cluster role is of type `PRIMARY`.
               Structure is documented below.
        :param builtins.str update_time: (Output)
               The last time cross cluster replication config was updated.
        """
        if cluster_role is not None:
            pulumi.set(__self__, "cluster_role", cluster_role)
        if memberships is not None:
            pulumi.set(__self__, "memberships", memberships)
        if primary_cluster is not None:
            pulumi.set(__self__, "primary_cluster", primary_cluster)
        if secondary_clusters is not None:
            pulumi.set(__self__, "secondary_clusters", secondary_clusters)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="clusterRole")
    def cluster_role(self) -> Optional[builtins.str]:
        """
        The role of the cluster in cross cluster replication. Supported values are:
        1. `CLUSTER_ROLE_UNSPECIFIED`: This is an independent cluster that has never participated in cross cluster replication. It allows both reads and writes.
        1. `NONE`: This is an independent cluster that previously participated in cross cluster replication(either as a `PRIMARY` or `SECONDARY` cluster). It allows both reads and writes.
        1. `PRIMARY`: This cluster serves as the replication source for secondary clusters that are replicating from it. Any data written to it is automatically replicated to its secondary clusters. It allows both reads and writes.
        1. `SECONDARY`: This cluster replicates data from the primary cluster. It allows only reads.
        Possible values are: `CLUSTER_ROLE_UNSPECIFIED`, `NONE`, `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "cluster_role")

    @property
    @pulumi.getter
    def memberships(self) -> Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigMembership']]:
        """
        (Output)
        An output only view of all the member clusters participating in cross cluster replication. This field is populated for all the member clusters irrespective of their cluster role.
        Structure is documented below.
        """
        return pulumi.get(self, "memberships")

    @property
    @pulumi.getter(name="primaryCluster")
    def primary_cluster(self) -> Optional['outputs.ClusterCrossClusterReplicationConfigPrimaryCluster']:
        """
        Details of the primary cluster that is used as the replication source for this secondary cluster. This is allowed to be set only for clusters whose cluster role is of type `SECONDARY`.
        Structure is documented below.
        """
        return pulumi.get(self, "primary_cluster")

    @property
    @pulumi.getter(name="secondaryClusters")
    def secondary_clusters(self) -> Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigSecondaryCluster']]:
        """
        List of secondary clusters that are replicating from this primary cluster. This is allowed to be set only for clusters whose cluster role is of type `PRIMARY`.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_clusters")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The last time cross cluster replication config was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class ClusterCrossClusterReplicationConfigMembership(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryClusters":
            suggest = "primary_clusters"
        elif key == "secondaryClusters":
            suggest = "secondary_clusters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCrossClusterReplicationConfigMembership. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCrossClusterReplicationConfigMembership.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCrossClusterReplicationConfigMembership.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_clusters: Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigMembershipPrimaryCluster']] = None,
                 secondary_clusters: Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigMembershipSecondaryCluster']] = None):
        """
        :param Sequence['ClusterCrossClusterReplicationConfigMembershipPrimaryClusterArgs'] primary_clusters: Details of the primary cluster that is used as the replication source for all the secondary clusters.
        :param Sequence['ClusterCrossClusterReplicationConfigMembershipSecondaryClusterArgs'] secondary_clusters: List of secondary clusters that are replicating from the primary cluster.
        """
        if primary_clusters is not None:
            pulumi.set(__self__, "primary_clusters", primary_clusters)
        if secondary_clusters is not None:
            pulumi.set(__self__, "secondary_clusters", secondary_clusters)

    @property
    @pulumi.getter(name="primaryClusters")
    def primary_clusters(self) -> Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigMembershipPrimaryCluster']]:
        """
        Details of the primary cluster that is used as the replication source for all the secondary clusters.
        """
        return pulumi.get(self, "primary_clusters")

    @property
    @pulumi.getter(name="secondaryClusters")
    def secondary_clusters(self) -> Optional[Sequence['outputs.ClusterCrossClusterReplicationConfigMembershipSecondaryCluster']]:
        """
        List of secondary clusters that are replicating from the primary cluster.
        """
        return pulumi.get(self, "secondary_clusters")


@pulumi.output_type
class ClusterCrossClusterReplicationConfigMembershipPrimaryCluster(dict):
    def __init__(__self__, *,
                 cluster: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str cluster: The full resource path of the primary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        :param builtins.str uid: (Output)
               The unique id of the primary cluster.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[builtins.str]:
        """
        The full resource path of the primary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        (Output)
        The unique id of the primary cluster.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ClusterCrossClusterReplicationConfigMembershipSecondaryCluster(dict):
    def __init__(__self__, *,
                 cluster: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str cluster: (Output)
               The full resource path of the secondary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        :param builtins.str uid: (Output)
               The unique id of the secondary cluster.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[builtins.str]:
        """
        (Output)
        The full resource path of the secondary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        (Output)
        The unique id of the secondary cluster.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ClusterCrossClusterReplicationConfigPrimaryCluster(dict):
    def __init__(__self__, *,
                 cluster: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str cluster: The full resource path of the primary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        :param builtins.str uid: (Output)
               The unique id of the primary cluster.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[builtins.str]:
        """
        The full resource path of the primary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        (Output)
        The unique id of the primary cluster.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ClusterCrossClusterReplicationConfigSecondaryCluster(dict):
    def __init__(__self__, *,
                 cluster: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        :param builtins.str cluster: (Output)
               The full resource path of the secondary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        :param builtins.str uid: (Output)
               The unique id of the secondary cluster.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[builtins.str]:
        """
        (Output)
        The full resource path of the secondary cluster in the format: projects/{project}/locations/{region}/clusters/{cluster-id}
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        (Output)
        The unique id of the secondary cluster.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ClusterDiscoveryEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pscConfig":
            suggest = "psc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDiscoveryEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDiscoveryEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDiscoveryEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 psc_config: Optional['outputs.ClusterDiscoveryEndpointPscConfig'] = None):
        """
        :param builtins.str address: Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param builtins.int port: Output only. The port number of the exposed Redis endpoint.
        :param 'ClusterDiscoveryEndpointPscConfigArgs' psc_config: Output only. Customer configuration for where the endpoint
               is created and accessed from.
               Structure is documented below.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Output only. The port number of the exposed Redis endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional['outputs.ClusterDiscoveryEndpointPscConfig']:
        """
        Output only. Customer configuration for where the endpoint
        is created and accessed from.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")


@pulumi.output_type
class ClusterDiscoveryEndpointPscConfig(dict):
    def __init__(__self__, *,
                 network: Optional[builtins.str] = None):
        """
        :param builtins.str network: The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class ClusterGcsSource(dict):
    def __init__(__self__, *,
                 uris: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] uris: URIs of the GCS objects to import. Example: gs://bucket1/object1, gs://bucket2/folder2/object2
        """
        pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter
    def uris(self) -> Sequence[builtins.str]:
        """
        URIs of the GCS objects to import. Example: gs://bucket1/object1, gs://bucket2/folder2/object2
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class ClusterMaintenancePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "weeklyMaintenanceWindows":
            suggest = "weekly_maintenance_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: Optional[builtins.str] = None,
                 update_time: Optional[builtins.str] = None,
                 weekly_maintenance_windows: Optional[Sequence['outputs.ClusterMaintenancePolicyWeeklyMaintenanceWindow']] = None):
        """
        :param builtins.str create_time: (Output)
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str update_time: (Output)
               Output only. The time when the policy was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param Sequence['ClusterMaintenancePolicyWeeklyMaintenanceWindowArgs'] weekly_maintenance_windows: Optional. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number
               of weekly_window is expected to be one.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if weekly_maintenance_windows is not None:
            pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Optional[Sequence['outputs.ClusterMaintenancePolicyWeeklyMaintenanceWindow']]:
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_maintenance_windows")


@pulumi.output_type
class ClusterMaintenancePolicyWeeklyMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenancePolicyWeeklyMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: builtins.str,
                 start_time: 'outputs.ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTime',
                 duration: Optional[builtins.str] = None):
        """
        :param builtins.str day: Required. The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param 'ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs' start_time: Required. Start time of the window in UTC time.
               Structure is documented below.
        :param builtins.str duration: (Output)
               Output only. Duration of the maintenance window.
               The current window is fixed at 1 hour.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def day(self) -> builtins.str:
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTime':
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class ClusterMaintenancePolicyWeeklyMaintenanceWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[builtins.int] = None,
                 minutes: Optional[builtins.int] = None,
                 nanos: Optional[builtins.int] = None,
                 seconds: Optional[builtins.int] = None):
        """
        :param builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[builtins.int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[builtins.int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[builtins.int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[builtins.int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ClusterMaintenanceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "scheduleDeadlineTime":
            suggest = "schedule_deadline_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenanceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenanceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenanceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[builtins.str] = None,
                 schedule_deadline_time: Optional[builtins.str] = None,
                 start_time: Optional[builtins.str] = None):
        """
        :param builtins.str end_time: (Output)
               Output only. The end time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str schedule_deadline_time: (Output)
               Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str start_time: (Output)
               Output only. The start time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule_deadline_time is not None:
            pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterManagedBackupSource(dict):
    def __init__(__self__, *,
                 backup: builtins.str):
        """
        :param builtins.str backup: Example: `projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup}`.
        """
        pulumi.set(__self__, "backup", backup)

    @property
    @pulumi.getter
    def backup(self) -> builtins.str:
        """
        Example: `projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup}`.
        """
        return pulumi.get(self, "backup")


@pulumi.output_type
class ClusterManagedServerCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCerts":
            suggest = "ca_certs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterManagedServerCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterManagedServerCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterManagedServerCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certs: Optional[Sequence['outputs.ClusterManagedServerCaCaCert']] = None):
        """
        :param Sequence['ClusterManagedServerCaCaCertArgs'] ca_certs: (Output)
               The PEM encoded CA certificate chains for redis managed server authentication
               Structure is documented below.
        """
        if ca_certs is not None:
            pulumi.set(__self__, "ca_certs", ca_certs)

    @property
    @pulumi.getter(name="caCerts")
    def ca_certs(self) -> Optional[Sequence['outputs.ClusterManagedServerCaCaCert']]:
        """
        (Output)
        The PEM encoded CA certificate chains for redis managed server authentication
        Structure is documented below.
        """
        return pulumi.get(self, "ca_certs")


@pulumi.output_type
class ClusterManagedServerCaCaCert(dict):
    def __init__(__self__, *,
                 certificates: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] certificates: (Output)
               The certificates that form the CA chain, from leaf to root order
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence[builtins.str]]:
        """
        (Output)
        The certificates that form the CA chain, from leaf to root order
        """
        return pulumi.get(self, "certificates")


@pulumi.output_type
class ClusterPersistenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aofConfig":
            suggest = "aof_config"
        elif key == "rdbConfig":
            suggest = "rdb_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPersistenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPersistenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPersistenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aof_config: Optional['outputs.ClusterPersistenceConfigAofConfig'] = None,
                 mode: Optional[builtins.str] = None,
                 rdb_config: Optional['outputs.ClusterPersistenceConfigRdbConfig'] = None):
        """
        :param 'ClusterPersistenceConfigAofConfigArgs' aof_config: AOF configuration. This field will be ignored if mode is not AOF.
               Structure is documented below.
        :param builtins.str mode: Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
               - DISABLED: 	Persistence (both backup and restore) is disabled for the cluster.
               - RDB: RDB based Persistence is enabled.
               - AOF: AOF based Persistence is enabled.
               Possible values are: `PERSISTENCE_MODE_UNSPECIFIED`, `DISABLED`, `RDB`, `AOF`.
        :param 'ClusterPersistenceConfigRdbConfigArgs' rdb_config: RDB configuration. This field will be ignored if mode is not RDB.
               Structure is documented below.
        """
        if aof_config is not None:
            pulumi.set(__self__, "aof_config", aof_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if rdb_config is not None:
            pulumi.set(__self__, "rdb_config", rdb_config)

    @property
    @pulumi.getter(name="aofConfig")
    def aof_config(self) -> Optional['outputs.ClusterPersistenceConfigAofConfig']:
        """
        AOF configuration. This field will be ignored if mode is not AOF.
        Structure is documented below.
        """
        return pulumi.get(self, "aof_config")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
        - DISABLED: 	Persistence (both backup and restore) is disabled for the cluster.
        - RDB: RDB based Persistence is enabled.
        - AOF: AOF based Persistence is enabled.
        Possible values are: `PERSISTENCE_MODE_UNSPECIFIED`, `DISABLED`, `RDB`, `AOF`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="rdbConfig")
    def rdb_config(self) -> Optional['outputs.ClusterPersistenceConfigRdbConfig']:
        """
        RDB configuration. This field will be ignored if mode is not RDB.
        Structure is documented below.
        """
        return pulumi.get(self, "rdb_config")


@pulumi.output_type
class ClusterPersistenceConfigAofConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appendFsync":
            suggest = "append_fsync"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPersistenceConfigAofConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPersistenceConfigAofConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPersistenceConfigAofConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 append_fsync: Optional[builtins.str] = None):
        """
        :param builtins.str append_fsync: Optional. Available fsync modes.
               - NO - Do not explicitly call fsync(). Rely on OS defaults.
               - EVERYSEC - Call fsync() once per second in a background thread. A balance between performance and durability.
               - ALWAYS - Call fsync() for earch write command.
               Possible values are: `APPEND_FSYNC_UNSPECIFIED`, `NO`, `EVERYSEC`, `ALWAYS`.
        """
        if append_fsync is not None:
            pulumi.set(__self__, "append_fsync", append_fsync)

    @property
    @pulumi.getter(name="appendFsync")
    def append_fsync(self) -> Optional[builtins.str]:
        """
        Optional. Available fsync modes.
        - NO - Do not explicitly call fsync(). Rely on OS defaults.
        - EVERYSEC - Call fsync() once per second in a background thread. A balance between performance and durability.
        - ALWAYS - Call fsync() for earch write command.
        Possible values are: `APPEND_FSYNC_UNSPECIFIED`, `NO`, `EVERYSEC`, `ALWAYS`.
        """
        return pulumi.get(self, "append_fsync")


@pulumi.output_type
class ClusterPersistenceConfigRdbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rdbSnapshotPeriod":
            suggest = "rdb_snapshot_period"
        elif key == "rdbSnapshotStartTime":
            suggest = "rdb_snapshot_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPersistenceConfigRdbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPersistenceConfigRdbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPersistenceConfigRdbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rdb_snapshot_period: Optional[builtins.str] = None,
                 rdb_snapshot_start_time: Optional[builtins.str] = None):
        """
        :param builtins.str rdb_snapshot_period: Optional. Available snapshot periods for scheduling.
               - ONE_HOUR:	Snapshot every 1 hour.
               - SIX_HOURS:	Snapshot every 6 hours.
               - TWELVE_HOURS:	Snapshot every 12 hours.
               - TWENTY_FOUR_HOURS:	Snapshot every 24 hours.
               Possible values are: `SNAPSHOT_PERIOD_UNSPECIFIED`, `ONE_HOUR`, `SIX_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`.
        :param builtins.str rdb_snapshot_start_time: The time that the first snapshot was/will be attempted, and to which
               future snapshots will be aligned.
               If not provided, the current time will be used.
        """
        if rdb_snapshot_period is not None:
            pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        if rdb_snapshot_start_time is not None:
            pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> Optional[builtins.str]:
        """
        Optional. Available snapshot periods for scheduling.
        - ONE_HOUR:	Snapshot every 1 hour.
        - SIX_HOURS:	Snapshot every 6 hours.
        - TWELVE_HOURS:	Snapshot every 12 hours.
        - TWENTY_FOUR_HOURS:	Snapshot every 24 hours.
        Possible values are: `SNAPSHOT_PERIOD_UNSPECIFIED`, `ONE_HOUR`, `SIX_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`.
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> Optional[builtins.str]:
        """
        The time that the first snapshot was/will be attempted, and to which
        future snapshots will be aligned.
        If not provided, the current time will be used.
        """
        return pulumi.get(self, "rdb_snapshot_start_time")


@pulumi.output_type
class ClusterPscConfig(dict):
    def __init__(__self__, *,
                 network: builtins.str):
        """
        :param builtins.str network: Required. The consumer network where the network address of
               the discovery endpoint will be reserved, in the form of
               projects/{network_project_id_or_number}/global/networks/{network_id}.
        """
        pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        Required. The consumer network where the network address of
        the discovery endpoint will be reserved, in the form of
        projects/{network_project_id_or_number}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class ClusterPscConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "pscConnectionId":
            suggest = "psc_connection_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPscConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPscConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPscConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 forwarding_rule: Optional[builtins.str] = None,
                 network: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 psc_connection_id: Optional[builtins.str] = None):
        """
        :param builtins.str address: Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param builtins.str forwarding_rule: Output only. The URI of the consumer side forwarding rule. Example: projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
        :param builtins.str network: The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        :param builtins.str project_id: Output only. The consumer projectId where the forwarding rule is created from.
        :param builtins.str psc_connection_id: Output only. The PSC connection id of the forwarding rule connected to the service attachment.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[builtins.str]:
        """
        Output only. The URI of the consumer side forwarding rule. Example: projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
        """
        return pulumi.get(self, "forwarding_rule")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        The consumer network where the IP address resides, in the form of projects/{projectId}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        Output only. The consumer projectId where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[builtins.str]:
        """
        Output only. The PSC connection id of the forwarding rule connected to the service attachment.
        """
        return pulumi.get(self, "psc_connection_id")


@pulumi.output_type
class ClusterPscServiceAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPscServiceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPscServiceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPscServiceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: Optional[builtins.str] = None,
                 service_attachment: Optional[builtins.str] = None):
        """
        :param builtins.str connection_type: (Output)
               Type of a PSC connection targeting this service attachment.
        :param builtins.str service_attachment: (Output)
               Service attachment URI which your self-created PscConnection should use as
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[builtins.str]:
        """
        (Output)
        Type of a PSC connection targeting this service attachment.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[builtins.str]:
        """
        (Output)
        Service attachment URI which your self-created PscConnection should use as
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class ClusterStateInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateInfo":
            suggest = "update_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStateInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStateInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStateInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_info: Optional['outputs.ClusterStateInfoUpdateInfo'] = None):
        """
        :param 'ClusterStateInfoUpdateInfoArgs' update_info: A nested object resource.
               Structure is documented below.
        """
        if update_info is not None:
            pulumi.set(__self__, "update_info", update_info)

    @property
    @pulumi.getter(name="updateInfo")
    def update_info(self) -> Optional['outputs.ClusterStateInfoUpdateInfo']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "update_info")


@pulumi.output_type
class ClusterStateInfoUpdateInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetReplicaCount":
            suggest = "target_replica_count"
        elif key == "targetShardCount":
            suggest = "target_shard_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStateInfoUpdateInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStateInfoUpdateInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStateInfoUpdateInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_replica_count: Optional[builtins.int] = None,
                 target_shard_count: Optional[builtins.int] = None):
        """
        :param builtins.int target_replica_count: Target number of replica nodes per shard.
        :param builtins.int target_shard_count: Target number of shards for redis cluster.
        """
        if target_replica_count is not None:
            pulumi.set(__self__, "target_replica_count", target_replica_count)
        if target_shard_count is not None:
            pulumi.set(__self__, "target_shard_count", target_shard_count)

    @property
    @pulumi.getter(name="targetReplicaCount")
    def target_replica_count(self) -> Optional[builtins.int]:
        """
        Target number of replica nodes per shard.
        """
        return pulumi.get(self, "target_replica_count")

    @property
    @pulumi.getter(name="targetShardCount")
    def target_shard_count(self) -> Optional[builtins.int]:
        """
        Target number of shards for redis cluster.
        """
        return pulumi.get(self, "target_shard_count")


@pulumi.output_type
class ClusterUserCreatedConnectionsClusterEndpoint(dict):
    def __init__(__self__, *,
                 connections: Optional[Sequence['outputs.ClusterUserCreatedConnectionsClusterEndpointConnection']] = None):
        """
        :param Sequence['ClusterUserCreatedConnectionsClusterEndpointConnectionArgs'] connections: Structure is documented below.
        """
        if connections is not None:
            pulumi.set(__self__, "connections", connections)

    @property
    @pulumi.getter
    def connections(self) -> Optional[Sequence['outputs.ClusterUserCreatedConnectionsClusterEndpointConnection']]:
        """
        Structure is documented below.
        """
        return pulumi.get(self, "connections")


@pulumi.output_type
class ClusterUserCreatedConnectionsClusterEndpointConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pscConnection":
            suggest = "psc_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUserCreatedConnectionsClusterEndpointConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUserCreatedConnectionsClusterEndpointConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUserCreatedConnectionsClusterEndpointConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 psc_connection: Optional['outputs.ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnection'] = None):
        """
        :param 'ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnectionArgs' psc_connection: Detailed information of a PSC connection that is created by the customer
               who owns the cluster.
               Structure is documented below.
        """
        if psc_connection is not None:
            pulumi.set(__self__, "psc_connection", psc_connection)

    @property
    @pulumi.getter(name="pscConnection")
    def psc_connection(self) -> Optional['outputs.ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnection']:
        """
        Detailed information of a PSC connection that is created by the customer
        who owns the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connection")


@pulumi.output_type
class ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "pscConnectionId":
            suggest = "psc_connection_id"
        elif key == "serviceAttachment":
            suggest = "service_attachment"
        elif key == "connectionType":
            suggest = "connection_type"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "pscConnectionStatus":
            suggest = "psc_connection_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUserCreatedConnectionsClusterEndpointConnectionPscConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 forwarding_rule: builtins.str,
                 network: builtins.str,
                 psc_connection_id: builtins.str,
                 service_attachment: builtins.str,
                 connection_type: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 psc_connection_status: Optional[builtins.str] = None):
        """
        :param builtins.str address: The IP allocated on the consumer network for the PSC forwarding rule.
        :param builtins.str forwarding_rule: The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param builtins.str network: The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param builtins.str psc_connection_id: The PSC connection id of the forwarding rule connected to the
               service attachment.
        :param builtins.str service_attachment: The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        :param builtins.str connection_type: (Output)
               Output Only. Type of a PSC Connection.
               Possible values:
               CONNECTION_TYPE_DISCOVERY
               CONNECTION_TYPE_PRIMARY
               CONNECTION_TYPE_READER
        :param builtins.str project_id: The consumer project_id where the forwarding rule is created from.
        :param builtins.str psc_connection_status: (Output)
               Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists.
               Possible values:
               ACTIVE
               NOT_FOUND
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        pulumi.set(__self__, "service_attachment", service_attachment)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_status is not None:
            pulumi.set(__self__, "psc_connection_status", psc_connection_status)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> builtins.str:
        """
        The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> builtins.str:
        """
        The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> builtins.str:
        """
        The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        return pulumi.get(self, "service_attachment")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[builtins.str]:
        """
        (Output)
        Output Only. Type of a PSC Connection.
        Possible values:
        CONNECTION_TYPE_DISCOVERY
        CONNECTION_TYPE_PRIMARY
        CONNECTION_TYPE_READER
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> Optional[builtins.str]:
        """
        (Output)
        Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists.
        Possible values:
        ACTIVE
        NOT_FOUND
        """
        return pulumi.get(self, "psc_connection_status")


@pulumi.output_type
class ClusterZoneDistributionConfig(dict):
    def __init__(__self__, *,
                 mode: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str mode: Immutable. The mode for zone distribution for Memorystore Redis cluster.
               If not provided, MULTI_ZONE will be used as default
               Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        :param builtins.str zone: Immutable. The zone for single zone Memorystore Redis cluster.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        Immutable. The mode for zone distribution for Memorystore Redis cluster.
        If not provided, MULTI_ZONE will be used as default
        Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        Immutable. The zone for single zone Memorystore Redis cluster.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceMaintenancePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "weeklyMaintenanceWindows":
            suggest = "weekly_maintenance_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 update_time: Optional[builtins.str] = None,
                 weekly_maintenance_windows: Optional[Sequence['outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindow']] = None):
        """
        :param builtins.str create_time: (Output)
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str description: Optional. Description of what this policy is for.
               Create/Update methods return INVALID_ARGUMENT if the
               length is greater than 512.
        :param builtins.str update_time: (Output)
               Output only. The time when the policy was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param Sequence['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs'] weekly_maintenance_windows: Optional. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number
               of weekly_window is expected to be one.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if weekly_maintenance_windows is not None:
            pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Optional[Sequence['outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindow']]:
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_maintenance_windows")


@pulumi.output_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenancePolicyWeeklyMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: builtins.str,
                 start_time: 'outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime',
                 duration: Optional[builtins.str] = None):
        """
        :param builtins.str day: Required. The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param 'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs' start_time: Required. Start time of the window in UTC time.
               Structure is documented below.
        :param builtins.str duration: (Output)
               Output only. Duration of the maintenance window.
               The current window is fixed at 1 hour.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def day(self) -> builtins.str:
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime':
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[builtins.int] = None,
                 minutes: Optional[builtins.int] = None,
                 nanos: Optional[builtins.int] = None,
                 seconds: Optional[builtins.int] = None):
        """
        :param builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[builtins.int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[builtins.int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[builtins.int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[builtins.int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class InstanceMaintenanceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "scheduleDeadlineTime":
            suggest = "schedule_deadline_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenanceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenanceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenanceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[builtins.str] = None,
                 schedule_deadline_time: Optional[builtins.str] = None,
                 start_time: Optional[builtins.str] = None):
        """
        :param builtins.str end_time: (Output)
               Output only. The end time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str schedule_deadline_time: (Output)
               Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str start_time: (Output)
               Output only. The start time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule_deadline_time is not None:
            pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InstanceNode(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str id: (Output)
               Node identifying string. e.g. 'node-0', 'node-1'
        :param builtins.str zone: (Output)
               Location of the node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        (Output)
        Node identifying string. e.g. 'node-0', 'node-1'
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        (Output)
        Location of the node.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstancePersistenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "persistenceMode":
            suggest = "persistence_mode"
        elif key == "rdbNextSnapshotTime":
            suggest = "rdb_next_snapshot_time"
        elif key == "rdbSnapshotPeriod":
            suggest = "rdb_snapshot_period"
        elif key == "rdbSnapshotStartTime":
            suggest = "rdb_snapshot_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePersistenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePersistenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePersistenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 persistence_mode: Optional[builtins.str] = None,
                 rdb_next_snapshot_time: Optional[builtins.str] = None,
                 rdb_snapshot_period: Optional[builtins.str] = None,
                 rdb_snapshot_start_time: Optional[builtins.str] = None):
        """
        :param builtins.str persistence_mode: Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
               - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
               - RDB: RDB based Persistence is enabled.
               Possible values are: `DISABLED`, `RDB`.
        :param builtins.str rdb_next_snapshot_time: (Output)
               Output only. The next time that a snapshot attempt is scheduled to occur.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
               to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param builtins.str rdb_snapshot_period: Optional. Available snapshot periods for scheduling.
               - ONE_HOUR:	Snapshot every 1 hour.
               - SIX_HOURS:	Snapshot every 6 hours.
               - TWELVE_HOURS:	Snapshot every 12 hours.
               - TWENTY_FOUR_HOURS:	Snapshot every 24 hours.
               Possible values are: `ONE_HOUR`, `SIX_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`.
        :param builtins.str rdb_snapshot_start_time: Optional. Date and time that the first snapshot was/will be attempted,
               and to which future snapshots will be aligned. If not provided,
               the current time will be used.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
               and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if persistence_mode is not None:
            pulumi.set(__self__, "persistence_mode", persistence_mode)
        if rdb_next_snapshot_time is not None:
            pulumi.set(__self__, "rdb_next_snapshot_time", rdb_next_snapshot_time)
        if rdb_snapshot_period is not None:
            pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        if rdb_snapshot_start_time is not None:
            pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @property
    @pulumi.getter(name="persistenceMode")
    def persistence_mode(self) -> Optional[builtins.str]:
        """
        Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
        - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
        - RDB: RDB based Persistence is enabled.
        Possible values are: `DISABLED`, `RDB`.
        """
        return pulumi.get(self, "persistence_mode")

    @property
    @pulumi.getter(name="rdbNextSnapshotTime")
    def rdb_next_snapshot_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The next time that a snapshot attempt is scheduled to occur.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "rdb_next_snapshot_time")

    @property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> Optional[builtins.str]:
        """
        Optional. Available snapshot periods for scheduling.
        - ONE_HOUR:	Snapshot every 1 hour.
        - SIX_HOURS:	Snapshot every 6 hours.
        - TWELVE_HOURS:	Snapshot every 12 hours.
        - TWENTY_FOUR_HOURS:	Snapshot every 24 hours.
        Possible values are: `ONE_HOUR`, `SIX_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`.
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> Optional[builtins.str]:
        """
        Optional. Date and time that the first snapshot was/will be attempted,
        and to which future snapshots will be aligned. If not provided,
        the current time will be used.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
        and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "rdb_snapshot_start_time")


@pulumi.output_type
class InstanceServerCaCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "expireTime":
            suggest = "expire_time"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerCaCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerCaCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerCaCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[builtins.str] = None,
                 create_time: Optional[builtins.str] = None,
                 expire_time: Optional[builtins.str] = None,
                 serial_number: Optional[builtins.str] = None,
                 sha1_fingerprint: Optional[builtins.str] = None):
        """
        :param builtins.str cert: (Output)
               The certificate data in PEM format.
        :param builtins.str create_time: (Output)
               The time when the certificate was created.
        :param builtins.str expire_time: (Output)
               The time when the certificate expires.
        :param builtins.str serial_number: (Output)
               Serial number, as extracted from the certificate.
        :param builtins.str sha1_fingerprint: (Output)
               Sha1 Fingerprint of the certificate.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[builtins.str]:
        """
        (Output)
        The certificate data in PEM format.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The time when the certificate expires.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[builtins.str]:
        """
        (Output)
        Serial number, as extracted from the certificate.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[builtins.str]:
        """
        (Output)
        Sha1 Fingerprint of the certificate.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetInstanceMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 create_time: builtins.str,
                 description: builtins.str,
                 update_time: builtins.str,
                 weekly_maintenance_windows: Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult']):
        """
        :param builtins.str create_time: Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str description: Optional. Description of what this policy is for.
               Create/Update methods return INVALID_ARGUMENT if the
               length is greater than 512.
        :param builtins.str update_time: Output only. The time when the policy was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param Sequence['GetInstanceMaintenancePolicyWeeklyMaintenanceWindowArgs'] weekly_maintenance_windows: Optional. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number
               of weekly_window is expected to be one.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> builtins.str:
        """
        Output only. The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult']:
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        """
        return pulumi.get(self, "weekly_maintenance_windows")


@pulumi.output_type
class GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: builtins.str,
                 duration: builtins.str,
                 start_times: Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult']):
        """
        :param builtins.str day: Required. The day of week that maintenance updates occur.
               
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param builtins.str duration: Output only. Duration of the maintenance window.
               The current window is fixed at 1 hour.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        :param Sequence['GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'] start_times: Required. Start time of the window in UTC time.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_times", start_times)

    @property
    @pulumi.getter
    def day(self) -> builtins.str:
        """
        Required. The day of week that maintenance updates occur.

        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Output only. Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult']:
        """
        Required. Start time of the window in UTC time.
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: builtins.int,
                 minutes: builtins.int,
                 nanos: builtins.int,
                 seconds: builtins.int):
        """
        :param builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> builtins.int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> builtins.int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> builtins.int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GetInstanceMaintenanceScheduleResult(dict):
    def __init__(__self__, *,
                 end_time: builtins.str,
                 schedule_deadline_time: builtins.str,
                 start_time: builtins.str):
        """
        :param builtins.str end_time: Output only. The end time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str schedule_deadline_time: Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str start_time: Output only. The start time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> builtins.str:
        """
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> builtins.str:
        """
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetInstanceNodeResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str id: Node identifying string. e.g. 'node-0', 'node-1'
        :param builtins.str zone: Location of the node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Node identifying string. e.g. 'node-0', 'node-1'
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        Location of the node.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstancePersistenceConfigResult(dict):
    def __init__(__self__, *,
                 persistence_mode: builtins.str,
                 rdb_next_snapshot_time: builtins.str,
                 rdb_snapshot_period: builtins.str,
                 rdb_snapshot_start_time: builtins.str):
        """
        :param builtins.str persistence_mode: Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
               
               - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
               - RDB: RDB based Persistence is enabled. Possible values: ["DISABLED", "RDB"]
        :param builtins.str rdb_next_snapshot_time: Output only. The next time that a snapshot attempt is scheduled to occur.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
               to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param builtins.str rdb_snapshot_period: Optional. Available snapshot periods for scheduling.
               
               - ONE_HOUR:	Snapshot every 1 hour.
               - SIX_HOURS:	Snapshot every 6 hours.
               - TWELVE_HOURS:	Snapshot every 12 hours.
               - TWENTY_FOUR_HOURS:	Snapshot every 24 hours. Possible values: ["ONE_HOUR", "SIX_HOURS", "TWELVE_HOURS", "TWENTY_FOUR_HOURS"]
        :param builtins.str rdb_snapshot_start_time: Optional. Date and time that the first snapshot was/will be attempted,
               and to which future snapshots will be aligned. If not provided,
               the current time will be used.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
               and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "persistence_mode", persistence_mode)
        pulumi.set(__self__, "rdb_next_snapshot_time", rdb_next_snapshot_time)
        pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @property
    @pulumi.getter(name="persistenceMode")
    def persistence_mode(self) -> builtins.str:
        """
        Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.

        - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
        - RDB: RDB based Persistence is enabled. Possible values: ["DISABLED", "RDB"]
        """
        return pulumi.get(self, "persistence_mode")

    @property
    @pulumi.getter(name="rdbNextSnapshotTime")
    def rdb_next_snapshot_time(self) -> builtins.str:
        """
        Output only. The next time that a snapshot attempt is scheduled to occur.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "rdb_next_snapshot_time")

    @property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> builtins.str:
        """
        Optional. Available snapshot periods for scheduling.

        - ONE_HOUR:	Snapshot every 1 hour.
        - SIX_HOURS:	Snapshot every 6 hours.
        - TWELVE_HOURS:	Snapshot every 12 hours.
        - TWENTY_FOUR_HOURS:	Snapshot every 24 hours. Possible values: ["ONE_HOUR", "SIX_HOURS", "TWELVE_HOURS", "TWENTY_FOUR_HOURS"]
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> builtins.str:
        """
        Optional. Date and time that the first snapshot was/will be attempted,
        and to which future snapshots will be aligned. If not provided,
        the current time will be used.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
        and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "rdb_snapshot_start_time")


@pulumi.output_type
class GetInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: builtins.str,
                 create_time: builtins.str,
                 expire_time: builtins.str,
                 serial_number: builtins.str,
                 sha1_fingerprint: builtins.str):
        """
        :param builtins.str cert: The certificate data in PEM format.
        :param builtins.str create_time: The time when the certificate was created.
        :param builtins.str expire_time: The time when the certificate expires.
        :param builtins.str serial_number: Serial number, as extracted from the certificate.
        :param builtins.str sha1_fingerprint: Sha1 Fingerprint of the certificate.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> builtins.str:
        """
        The certificate data in PEM format.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> builtins.str:
        """
        The time when the certificate expires.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> builtins.str:
        """
        Serial number, as extracted from the certificate.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> builtins.str:
        """
        Sha1 Fingerprint of the certificate.
        """
        return pulumi.get(self, "sha1_fingerprint")


