# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretVersionArgs', 'SecretVersion']

@pulumi.input_type
class SecretVersionArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[builtins.str],
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[builtins.bool]] = None,
                 secret_data: Optional[pulumi.Input[builtins.str]] = None,
                 secret_data_wo_version: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a SecretVersion resource.
        :param pulumi.Input[builtins.str] secret: Secret Manager secret resource
               
               
               - - -
        :param pulumi.Input[builtins.str] deletion_policy: The deletion policy for the secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[builtins.bool] enabled: The current state of the SecretVersion.
        :param pulumi.Input[builtins.bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        :param pulumi.Input[builtins.str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.int] secret_data_wo_version: Triggers update of secret data write-only. For more info see [updating write-only attributes](https://www.terraform.io/docs/providers/google/guides/using_write_only_attributes.html#updating-write-only-attributes)
        """
        pulumi.set(__self__, "secret", secret)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if is_secret_data_base64 is not None:
            pulumi.set(__self__, "is_secret_data_base64", is_secret_data_base64)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_data_wo_version is not None:
            pulumi.set(__self__, "secret_data_wo_version", secret_data_wo_version)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[builtins.str]:
        """
        Secret Manager secret resource


        - - -
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deletion policy for the secret version. Setting `ABANDON` allows the resource
        to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
        disabled rather than deleted. Default is `DELETE`. Possible values are:
        * DELETE
        * DISABLE
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The current state of the SecretVersion.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        """
        return pulumi.get(self, "is_secret_data_base64")

    @is_secret_data_base64.setter
    def is_secret_data_base64(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_secret_data_base64", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret data. Must be no larger than 64KiB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretDataWoVersion")
    def secret_data_wo_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Triggers update of secret data write-only. For more info see [updating write-only attributes](https://www.terraform.io/docs/providers/google/guides/using_write_only_attributes.html#updating-write-only-attributes)
        """
        return pulumi.get(self, "secret_data_wo_version")

    @secret_data_wo_version.setter
    def secret_data_wo_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "secret_data_wo_version", value)


@pulumi.input_type
class _SecretVersionState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 destroy_time: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 secret_data: Optional[pulumi.Input[builtins.str]] = None,
                 secret_data_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretVersion resources.
        :param pulumi.Input[builtins.str] create_time: The time at which the Secret was created.
        :param pulumi.Input[builtins.str] deletion_policy: The deletion policy for the secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[builtins.str] destroy_time: The time at which the Secret was destroyed. Only present if state is DESTROYED.
        :param pulumi.Input[builtins.bool] enabled: The current state of the SecretVersion.
        :param pulumi.Input[builtins.bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        :param pulumi.Input[builtins.str] name: The resource name of the SecretVersion. Format:
               `projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}`
        :param pulumi.Input[builtins.str] secret: Secret Manager secret resource
               
               
               - - -
        :param pulumi.Input[builtins.str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.int] secret_data_wo_version: Triggers update of secret data write-only. For more info see [updating write-only attributes](https://www.terraform.io/docs/providers/google/guides/using_write_only_attributes.html#updating-write-only-attributes)
        :param pulumi.Input[builtins.str] version: The version of the Secret.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if destroy_time is not None:
            pulumi.set(__self__, "destroy_time", destroy_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if is_secret_data_base64 is not None:
            pulumi.set(__self__, "is_secret_data_base64", is_secret_data_base64)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_data_wo_version is not None:
            pulumi.set(__self__, "secret_data_wo_version", secret_data_wo_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the Secret was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deletion policy for the secret version. Setting `ABANDON` allows the resource
        to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
        disabled rather than deleted. Default is `DELETE`. Possible values are:
        * DELETE
        * DISABLE
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="destroyTime")
    def destroy_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the Secret was destroyed. Only present if state is DESTROYED.
        """
        return pulumi.get(self, "destroy_time")

    @destroy_time.setter
    def destroy_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destroy_time", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The current state of the SecretVersion.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        """
        return pulumi.get(self, "is_secret_data_base64")

    @is_secret_data_base64.setter
    def is_secret_data_base64(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_secret_data_base64", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the SecretVersion. Format:
        `projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secret Manager secret resource


        - - -
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret data. Must be no larger than 64KiB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretDataWoVersion")
    def secret_data_wo_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Triggers update of secret data write-only. For more info see [updating write-only attributes](https://www.terraform.io/docs/providers/google/guides/using_write_only_attributes.html#updating-write-only-attributes)
        """
        return pulumi.get(self, "secret_data_wo_version")

    @secret_data_wo_version.setter
    def secret_data_wo_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "secret_data_wo_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the Secret.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("gcp:secretmanager/secretVersion:SecretVersion")
class SecretVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[builtins.bool]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 secret_data: Optional[pulumi.Input[builtins.str]] = None,
                 secret_data_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        A secret version resource.

        To get more information about SecretVersion, see:

        * [API documentation](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions)
        * How-to Guides
            * [Create and deploy a Secret Version](https://cloud.google.com/secret-manager/docs/add-secret-version)

        > **Note:**  All arguments marked as write-only values will not be stored in the state: `payload.secret_data_wo`.
        Read more about Write-only Attributes.

        ## Example Usage

        ### Secret Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            labels={
                "label": "my-label",
            },
            replication={
                "auto": {},
            })
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        ```
        ### Secret Version Deletion Policy Abandon

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_deletion_policy = gcp.secretmanager.SecretVersion("secret-version-deletion-policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="ABANDON")
        ```
        ### Secret Version Deletion Policy Disable

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_deletion_policy = gcp.secretmanager.SecretVersion("secret-version-deletion-policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="DISABLE")
        ```
        ### Secret Version With Base64 String Secret Data

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_base64 = gcp.secretmanager.SecretVersion("secret-version-base64",
            secret=secret_basic.id,
            is_secret_data_base64=True,
            secret_data=std.filebase64(input="secret-data.pfx").result)
        ```
        ## Import

        SecretVersion can be imported using any of these accepted formats:

        * `projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}`

        When using the `pulumi import` command, SecretVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:secretmanager/secretVersion:SecretVersion default projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] deletion_policy: The deletion policy for the secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[builtins.bool] enabled: The current state of the SecretVersion.
        :param pulumi.Input[builtins.bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        :param pulumi.Input[builtins.str] secret: Secret Manager secret resource
               
               
               - - -
        :param pulumi.Input[builtins.str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.int] secret_data_wo_version: Triggers update of secret data write-only. For more info see [updating write-only attributes](https://www.terraform.io/docs/providers/google/guides/using_write_only_attributes.html#updating-write-only-attributes)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A secret version resource.

        To get more information about SecretVersion, see:

        * [API documentation](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions)
        * How-to Guides
            * [Create and deploy a Secret Version](https://cloud.google.com/secret-manager/docs/add-secret-version)

        > **Note:**  All arguments marked as write-only values will not be stored in the state: `payload.secret_data_wo`.
        Read more about Write-only Attributes.

        ## Example Usage

        ### Secret Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            labels={
                "label": "my-label",
            },
            replication={
                "auto": {},
            })
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        ```
        ### Secret Version Deletion Policy Abandon

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_deletion_policy = gcp.secretmanager.SecretVersion("secret-version-deletion-policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="ABANDON")
        ```
        ### Secret Version Deletion Policy Disable

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_deletion_policy = gcp.secretmanager.SecretVersion("secret-version-deletion-policy",
            secret=secret_basic.id,
            secret_data="secret-data",
            deletion_policy="DISABLE")
        ```
        ### Secret Version With Base64 String Secret Data

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-version",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_version_base64 = gcp.secretmanager.SecretVersion("secret-version-base64",
            secret=secret_basic.id,
            is_secret_data_base64=True,
            secret_data=std.filebase64(input="secret-data.pfx").result)
        ```
        ## Import

        SecretVersion can be imported using any of these accepted formats:

        * `projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}`

        When using the `pulumi import` command, SecretVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:secretmanager/secretVersion:SecretVersion default projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}
        ```

        :param str resource_name: The name of the resource.
        :param SecretVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_secret_data_base64: Optional[pulumi.Input[builtins.bool]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 secret_data: Optional[pulumi.Input[builtins.str]] = None,
                 secret_data_wo_version: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretVersionArgs.__new__(SecretVersionArgs)

            __props__.__dict__["deletion_policy"] = deletion_policy
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["is_secret_data_base64"] = is_secret_data_base64
            if secret is None and not opts.urn:
                raise TypeError("Missing required property 'secret'")
            __props__.__dict__["secret"] = secret
            __props__.__dict__["secret_data"] = None if secret_data is None else pulumi.Output.secret(secret_data)
            __props__.__dict__["secret_data_wo_version"] = secret_data_wo_version
            __props__.__dict__["create_time"] = None
            __props__.__dict__["destroy_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretVersion, __self__).__init__(
            'gcp:secretmanager/secretVersion:SecretVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
            destroy_time: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_secret_data_base64: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            secret: Optional[pulumi.Input[builtins.str]] = None,
            secret_data: Optional[pulumi.Input[builtins.str]] = None,
            secret_data_wo_version: Optional[pulumi.Input[builtins.int]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'SecretVersion':
        """
        Get an existing SecretVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The time at which the Secret was created.
        :param pulumi.Input[builtins.str] deletion_policy: The deletion policy for the secret version. Setting `ABANDON` allows the resource
               to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
               disabled rather than deleted. Default is `DELETE`. Possible values are:
               * DELETE
               * DISABLE
               * ABANDON
        :param pulumi.Input[builtins.str] destroy_time: The time at which the Secret was destroyed. Only present if state is DESTROYED.
        :param pulumi.Input[builtins.bool] enabled: The current state of the SecretVersion.
        :param pulumi.Input[builtins.bool] is_secret_data_base64: If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        :param pulumi.Input[builtins.str] name: The resource name of the SecretVersion. Format:
               `projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}`
        :param pulumi.Input[builtins.str] secret: Secret Manager secret resource
               
               
               - - -
        :param pulumi.Input[builtins.str] secret_data: The secret data. Must be no larger than 64KiB.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.int] secret_data_wo_version: Triggers update of secret data write-only. For more info see [updating write-only attributes](https://www.terraform.io/docs/providers/google/guides/using_write_only_attributes.html#updating-write-only-attributes)
        :param pulumi.Input[builtins.str] version: The version of the Secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretVersionState.__new__(_SecretVersionState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["destroy_time"] = destroy_time
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["is_secret_data_base64"] = is_secret_data_base64
        __props__.__dict__["name"] = name
        __props__.__dict__["secret"] = secret
        __props__.__dict__["secret_data"] = secret_data
        __props__.__dict__["secret_data_wo_version"] = secret_data_wo_version
        __props__.__dict__["version"] = version
        return SecretVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the Secret was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The deletion policy for the secret version. Setting `ABANDON` allows the resource
        to be abandoned rather than deleted. Setting `DISABLE` allows the resource to be
        disabled rather than deleted. Default is `DELETE`. Possible values are:
        * DELETE
        * DISABLE
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="destroyTime")
    def destroy_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the Secret was destroyed. Only present if state is DESTROYED.
        """
        return pulumi.get(self, "destroy_time")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The current state of the SecretVersion.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
        """
        return pulumi.get(self, "is_secret_data_base64")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the SecretVersion. Format:
        `projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[builtins.str]:
        """
        Secret Manager secret resource


        - - -
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The secret data. Must be no larger than 64KiB.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter(name="secretDataWoVersion")
    def secret_data_wo_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Triggers update of secret data write-only. For more info see [updating write-only attributes](https://www.terraform.io/docs/providers/google/guides/using_write_only_attributes.html#updating-write-only-attributes)
        """
        return pulumi.get(self, "secret_data_wo_version")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the Secret.
        """
        return pulumi.get(self, "version")

