# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BranchRuleArgs', 'BranchRule']

@pulumi.input_type
class BranchRuleArgs:
    def __init__(__self__, *,
                 branch_rule_id: pulumi.Input[builtins.str],
                 include_pattern: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 repository_id: pulumi.Input[builtins.str],
                 allow_stale_reviews: Optional[pulumi.Input[builtins.bool]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 minimum_approvals_count: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_reviews_count: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 require_comments_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 require_linear_history: Optional[pulumi.Input[builtins.bool]] = None,
                 require_pull_request: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a BranchRule resource.
        :param pulumi.Input[builtins.str] branch_rule_id: The ID for the BranchRule.
        :param pulumi.Input[builtins.str] include_pattern: The BranchRule matches branches based on the specified regular expression. Use .* to match all branches.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
               
               
               - - -
        :param pulumi.Input[builtins.bool] allow_stale_reviews: Determines if allow stale reviews or approvals before merging to the branch.
        :param pulumi.Input[builtins.bool] disabled: Determines if the branch rule is disabled or not.
        :param pulumi.Input[builtins.int] minimum_approvals_count: The minimum number of approvals required for the branch rule to be matched.
        :param pulumi.Input[builtins.int] minimum_reviews_count: The minimum number of reviews required for the branch rule to be matched.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.bool] require_comments_resolved: Determines if require comments resolved before merging to the branch.
        :param pulumi.Input[builtins.bool] require_linear_history: Determines if require linear history before merging to the branch.
        :param pulumi.Input[builtins.bool] require_pull_request: Determines if the branch rule requires a pull request or not.
        """
        pulumi.set(__self__, "branch_rule_id", branch_rule_id)
        pulumi.set(__self__, "include_pattern", include_pattern)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "repository_id", repository_id)
        if allow_stale_reviews is not None:
            pulumi.set(__self__, "allow_stale_reviews", allow_stale_reviews)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if minimum_approvals_count is not None:
            pulumi.set(__self__, "minimum_approvals_count", minimum_approvals_count)
        if minimum_reviews_count is not None:
            pulumi.set(__self__, "minimum_reviews_count", minimum_reviews_count)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if require_comments_resolved is not None:
            pulumi.set(__self__, "require_comments_resolved", require_comments_resolved)
        if require_linear_history is not None:
            pulumi.set(__self__, "require_linear_history", require_linear_history)
        if require_pull_request is not None:
            pulumi.set(__self__, "require_pull_request", require_pull_request)

    @property
    @pulumi.getter(name="branchRuleId")
    def branch_rule_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID for the BranchRule.
        """
        return pulumi.get(self, "branch_rule_id")

    @branch_rule_id.setter
    def branch_rule_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "branch_rule_id", value)

    @property
    @pulumi.getter(name="includePattern")
    def include_pattern(self) -> pulumi.Input[builtins.str]:
        """
        The BranchRule matches branches based on the specified regular expression. Use .* to match all branches.
        """
        return pulumi.get(self, "include_pattern")

    @include_pattern.setter
    def include_pattern(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "include_pattern", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID for the Repository.


        - - -
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="allowStaleReviews")
    def allow_stale_reviews(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if allow stale reviews or approvals before merging to the branch.
        """
        return pulumi.get(self, "allow_stale_reviews")

    @allow_stale_reviews.setter
    def allow_stale_reviews(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_stale_reviews", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the branch rule is disabled or not.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="minimumApprovalsCount")
    def minimum_approvals_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of approvals required for the branch rule to be matched.
        """
        return pulumi.get(self, "minimum_approvals_count")

    @minimum_approvals_count.setter
    def minimum_approvals_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_approvals_count", value)

    @property
    @pulumi.getter(name="minimumReviewsCount")
    def minimum_reviews_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of reviews required for the branch rule to be matched.
        """
        return pulumi.get(self, "minimum_reviews_count")

    @minimum_reviews_count.setter
    def minimum_reviews_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_reviews_count", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requireCommentsResolved")
    def require_comments_resolved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if require comments resolved before merging to the branch.
        """
        return pulumi.get(self, "require_comments_resolved")

    @require_comments_resolved.setter
    def require_comments_resolved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_comments_resolved", value)

    @property
    @pulumi.getter(name="requireLinearHistory")
    def require_linear_history(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if require linear history before merging to the branch.
        """
        return pulumi.get(self, "require_linear_history")

    @require_linear_history.setter
    def require_linear_history(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_linear_history", value)

    @property
    @pulumi.getter(name="requirePullRequest")
    def require_pull_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the branch rule requires a pull request or not.
        """
        return pulumi.get(self, "require_pull_request")

    @require_pull_request.setter
    def require_pull_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_pull_request", value)


@pulumi.input_type
class _BranchRuleState:
    def __init__(__self__, *,
                 allow_stale_reviews: Optional[pulumi.Input[builtins.bool]] = None,
                 branch_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 include_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_approvals_count: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_reviews_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 require_comments_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 require_linear_history: Optional[pulumi.Input[builtins.bool]] = None,
                 require_pull_request: Optional[pulumi.Input[builtins.bool]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BranchRule resources.
        :param pulumi.Input[builtins.bool] allow_stale_reviews: Determines if allow stale reviews or approvals before merging to the branch.
        :param pulumi.Input[builtins.str] branch_rule_id: The ID for the BranchRule.
        :param pulumi.Input[builtins.str] create_time: Time the BranchRule was created in UTC.
        :param pulumi.Input[builtins.bool] disabled: Determines if the branch rule is disabled or not.
        :param pulumi.Input[builtins.str] include_pattern: The BranchRule matches branches based on the specified regular expression. Use .* to match all branches.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.int] minimum_approvals_count: The minimum number of approvals required for the branch rule to be matched.
        :param pulumi.Input[builtins.int] minimum_reviews_count: The minimum number of reviews required for the branch rule to be matched.
        :param pulumi.Input[builtins.str] name: The resource name for the BranchRule.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
               
               
               - - -
        :param pulumi.Input[builtins.bool] require_comments_resolved: Determines if require comments resolved before merging to the branch.
        :param pulumi.Input[builtins.bool] require_linear_history: Determines if require linear history before merging to the branch.
        :param pulumi.Input[builtins.bool] require_pull_request: Determines if the branch rule requires a pull request or not.
        :param pulumi.Input[builtins.str] uid: Unique identifier of the BranchRule.
        :param pulumi.Input[builtins.str] update_time: Time the BranchRule was updated in UTC.
        """
        if allow_stale_reviews is not None:
            pulumi.set(__self__, "allow_stale_reviews", allow_stale_reviews)
        if branch_rule_id is not None:
            pulumi.set(__self__, "branch_rule_id", branch_rule_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if include_pattern is not None:
            pulumi.set(__self__, "include_pattern", include_pattern)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if minimum_approvals_count is not None:
            pulumi.set(__self__, "minimum_approvals_count", minimum_approvals_count)
        if minimum_reviews_count is not None:
            pulumi.set(__self__, "minimum_reviews_count", minimum_reviews_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if require_comments_resolved is not None:
            pulumi.set(__self__, "require_comments_resolved", require_comments_resolved)
        if require_linear_history is not None:
            pulumi.set(__self__, "require_linear_history", require_linear_history)
        if require_pull_request is not None:
            pulumi.set(__self__, "require_pull_request", require_pull_request)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="allowStaleReviews")
    def allow_stale_reviews(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if allow stale reviews or approvals before merging to the branch.
        """
        return pulumi.get(self, "allow_stale_reviews")

    @allow_stale_reviews.setter
    def allow_stale_reviews(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_stale_reviews", value)

    @property
    @pulumi.getter(name="branchRuleId")
    def branch_rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the BranchRule.
        """
        return pulumi.get(self, "branch_rule_id")

    @branch_rule_id.setter
    def branch_rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch_rule_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the BranchRule was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the branch rule is disabled or not.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="includePattern")
    def include_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The BranchRule matches branches based on the specified regular expression. Use .* to match all branches.
        """
        return pulumi.get(self, "include_pattern")

    @include_pattern.setter
    def include_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "include_pattern", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="minimumApprovalsCount")
    def minimum_approvals_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of approvals required for the branch rule to be matched.
        """
        return pulumi.get(self, "minimum_approvals_count")

    @minimum_approvals_count.setter
    def minimum_approvals_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_approvals_count", value)

    @property
    @pulumi.getter(name="minimumReviewsCount")
    def minimum_reviews_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of reviews required for the branch rule to be matched.
        """
        return pulumi.get(self, "minimum_reviews_count")

    @minimum_reviews_count.setter
    def minimum_reviews_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_reviews_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the BranchRule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the Repository.


        - - -
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="requireCommentsResolved")
    def require_comments_resolved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if require comments resolved before merging to the branch.
        """
        return pulumi.get(self, "require_comments_resolved")

    @require_comments_resolved.setter
    def require_comments_resolved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_comments_resolved", value)

    @property
    @pulumi.getter(name="requireLinearHistory")
    def require_linear_history(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if require linear history before merging to the branch.
        """
        return pulumi.get(self, "require_linear_history")

    @require_linear_history.setter
    def require_linear_history(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_linear_history", value)

    @property
    @pulumi.getter(name="requirePullRequest")
    def require_pull_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the branch rule requires a pull request or not.
        """
        return pulumi.get(self, "require_pull_request")

    @require_pull_request.setter
    def require_pull_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_pull_request", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the BranchRule.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the BranchRule was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:securesourcemanager/branchRule:BranchRule")
class BranchRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_stale_reviews: Optional[pulumi.Input[builtins.bool]] = None,
                 branch_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 include_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_approvals_count: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_reviews_count: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 require_comments_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 require_linear_history: Optional[pulumi.Input[builtins.bool]] = None,
                 require_pull_request: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        BranchRule is the protection rule to enforce pre-defined rules on designated branches within a repository.

        To get more information about BranchRule, see:

        * [API documentation](https://cloud.google.com/secure-source-manager/docs/reference/rest/v1/projects.locations.repositories.branchRules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/overview)

        ## Example Usage

        ### Secure Source Manager Branch Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-basic-instance")
        repository = gcp.securesourcemanager.Repository("repository",
            repository_id="my-basic-repository",
            location=instance.location,
            instance=instance.name)
        basic = gcp.securesourcemanager.BranchRule("basic",
            branch_rule_id="my-basic-branchrule",
            repository_id=repository.repository_id,
            location=repository.location,
            include_pattern="main")
        ```
        ### Secure Source Manager Branch Rule With Fields

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-initial-instance")
        repository = gcp.securesourcemanager.Repository("repository",
            repository_id="my-initial-repository",
            instance=instance.name,
            location=instance.location)
        default = gcp.securesourcemanager.BranchRule("default",
            branch_rule_id="my-initial-branchrule",
            location=repository.location,
            repository_id=repository.repository_id,
            include_pattern="test",
            minimum_approvals_count=2,
            minimum_reviews_count=2,
            require_comments_resolved=True,
            require_linear_history=True,
            require_pull_request=True,
            disabled=False,
            allow_stale_reviews=False)
        ```

        ## Import

        BranchRule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/branchRules/{{branch_rule_id}}`

        * `{{project}}/{{location}}/{{repository_id}}/{{branch_rule_id}}`

        * `{{location}}/{{repository_id}}/{{branch_rule_id}}`

        * `{{branch_rule_id}}`

        When using the `pulumi import` command, BranchRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/branchRules/{{branch_rule_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default {{project}}/{{location}}/{{repository_id}}/{{branch_rule_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default {{location}}/{{repository_id}}/{{branch_rule_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default {{branch_rule_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_stale_reviews: Determines if allow stale reviews or approvals before merging to the branch.
        :param pulumi.Input[builtins.str] branch_rule_id: The ID for the BranchRule.
        :param pulumi.Input[builtins.bool] disabled: Determines if the branch rule is disabled or not.
        :param pulumi.Input[builtins.str] include_pattern: The BranchRule matches branches based on the specified regular expression. Use .* to match all branches.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.int] minimum_approvals_count: The minimum number of approvals required for the branch rule to be matched.
        :param pulumi.Input[builtins.int] minimum_reviews_count: The minimum number of reviews required for the branch rule to be matched.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
               
               
               - - -
        :param pulumi.Input[builtins.bool] require_comments_resolved: Determines if require comments resolved before merging to the branch.
        :param pulumi.Input[builtins.bool] require_linear_history: Determines if require linear history before merging to the branch.
        :param pulumi.Input[builtins.bool] require_pull_request: Determines if the branch rule requires a pull request or not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BranchRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        BranchRule is the protection rule to enforce pre-defined rules on designated branches within a repository.

        To get more information about BranchRule, see:

        * [API documentation](https://cloud.google.com/secure-source-manager/docs/reference/rest/v1/projects.locations.repositories.branchRules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/overview)

        ## Example Usage

        ### Secure Source Manager Branch Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-basic-instance")
        repository = gcp.securesourcemanager.Repository("repository",
            repository_id="my-basic-repository",
            location=instance.location,
            instance=instance.name)
        basic = gcp.securesourcemanager.BranchRule("basic",
            branch_rule_id="my-basic-branchrule",
            repository_id=repository.repository_id,
            location=repository.location,
            include_pattern="main")
        ```
        ### Secure Source Manager Branch Rule With Fields

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.securesourcemanager.Instance("instance",
            location="us-central1",
            instance_id="my-initial-instance")
        repository = gcp.securesourcemanager.Repository("repository",
            repository_id="my-initial-repository",
            instance=instance.name,
            location=instance.location)
        default = gcp.securesourcemanager.BranchRule("default",
            branch_rule_id="my-initial-branchrule",
            location=repository.location,
            repository_id=repository.repository_id,
            include_pattern="test",
            minimum_approvals_count=2,
            minimum_reviews_count=2,
            require_comments_resolved=True,
            require_linear_history=True,
            require_pull_request=True,
            disabled=False,
            allow_stale_reviews=False)
        ```

        ## Import

        BranchRule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/branchRules/{{branch_rule_id}}`

        * `{{project}}/{{location}}/{{repository_id}}/{{branch_rule_id}}`

        * `{{location}}/{{repository_id}}/{{branch_rule_id}}`

        * `{{branch_rule_id}}`

        When using the `pulumi import` command, BranchRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/branchRules/{{branch_rule_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default {{project}}/{{location}}/{{repository_id}}/{{branch_rule_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default {{location}}/{{repository_id}}/{{branch_rule_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/branchRule:BranchRule default {{branch_rule_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BranchRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BranchRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_stale_reviews: Optional[pulumi.Input[builtins.bool]] = None,
                 branch_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 include_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_approvals_count: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_reviews_count: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 require_comments_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 require_linear_history: Optional[pulumi.Input[builtins.bool]] = None,
                 require_pull_request: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BranchRuleArgs.__new__(BranchRuleArgs)

            __props__.__dict__["allow_stale_reviews"] = allow_stale_reviews
            if branch_rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'branch_rule_id'")
            __props__.__dict__["branch_rule_id"] = branch_rule_id
            __props__.__dict__["disabled"] = disabled
            if include_pattern is None and not opts.urn:
                raise TypeError("Missing required property 'include_pattern'")
            __props__.__dict__["include_pattern"] = include_pattern
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["minimum_approvals_count"] = minimum_approvals_count
            __props__.__dict__["minimum_reviews_count"] = minimum_reviews_count
            __props__.__dict__["project"] = project
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["require_comments_resolved"] = require_comments_resolved
            __props__.__dict__["require_linear_history"] = require_linear_history
            __props__.__dict__["require_pull_request"] = require_pull_request
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(BranchRule, __self__).__init__(
            'gcp:securesourcemanager/branchRule:BranchRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_stale_reviews: Optional[pulumi.Input[builtins.bool]] = None,
            branch_rule_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            include_pattern: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            minimum_approvals_count: Optional[pulumi.Input[builtins.int]] = None,
            minimum_reviews_count: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            repository_id: Optional[pulumi.Input[builtins.str]] = None,
            require_comments_resolved: Optional[pulumi.Input[builtins.bool]] = None,
            require_linear_history: Optional[pulumi.Input[builtins.bool]] = None,
            require_pull_request: Optional[pulumi.Input[builtins.bool]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'BranchRule':
        """
        Get an existing BranchRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_stale_reviews: Determines if allow stale reviews or approvals before merging to the branch.
        :param pulumi.Input[builtins.str] branch_rule_id: The ID for the BranchRule.
        :param pulumi.Input[builtins.str] create_time: Time the BranchRule was created in UTC.
        :param pulumi.Input[builtins.bool] disabled: Determines if the branch rule is disabled or not.
        :param pulumi.Input[builtins.str] include_pattern: The BranchRule matches branches based on the specified regular expression. Use .* to match all branches.
        :param pulumi.Input[builtins.str] location: The location for the Repository.
        :param pulumi.Input[builtins.int] minimum_approvals_count: The minimum number of approvals required for the branch rule to be matched.
        :param pulumi.Input[builtins.int] minimum_reviews_count: The minimum number of reviews required for the branch rule to be matched.
        :param pulumi.Input[builtins.str] name: The resource name for the BranchRule.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] repository_id: The ID for the Repository.
               
               
               - - -
        :param pulumi.Input[builtins.bool] require_comments_resolved: Determines if require comments resolved before merging to the branch.
        :param pulumi.Input[builtins.bool] require_linear_history: Determines if require linear history before merging to the branch.
        :param pulumi.Input[builtins.bool] require_pull_request: Determines if the branch rule requires a pull request or not.
        :param pulumi.Input[builtins.str] uid: Unique identifier of the BranchRule.
        :param pulumi.Input[builtins.str] update_time: Time the BranchRule was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BranchRuleState.__new__(_BranchRuleState)

        __props__.__dict__["allow_stale_reviews"] = allow_stale_reviews
        __props__.__dict__["branch_rule_id"] = branch_rule_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["include_pattern"] = include_pattern
        __props__.__dict__["location"] = location
        __props__.__dict__["minimum_approvals_count"] = minimum_approvals_count
        __props__.__dict__["minimum_reviews_count"] = minimum_reviews_count
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["require_comments_resolved"] = require_comments_resolved
        __props__.__dict__["require_linear_history"] = require_linear_history
        __props__.__dict__["require_pull_request"] = require_pull_request
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return BranchRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowStaleReviews")
    def allow_stale_reviews(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if allow stale reviews or approvals before merging to the branch.
        """
        return pulumi.get(self, "allow_stale_reviews")

    @property
    @pulumi.getter(name="branchRuleId")
    def branch_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID for the BranchRule.
        """
        return pulumi.get(self, "branch_rule_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the BranchRule was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if the branch rule is disabled or not.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="includePattern")
    def include_pattern(self) -> pulumi.Output[builtins.str]:
        """
        The BranchRule matches branches based on the specified regular expression. Use .* to match all branches.
        """
        return pulumi.get(self, "include_pattern")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="minimumApprovalsCount")
    def minimum_approvals_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of approvals required for the branch rule to be matched.
        """
        return pulumi.get(self, "minimum_approvals_count")

    @property
    @pulumi.getter(name="minimumReviewsCount")
    def minimum_reviews_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of reviews required for the branch rule to be matched.
        """
        return pulumi.get(self, "minimum_reviews_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name for the BranchRule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID for the Repository.


        - - -
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="requireCommentsResolved")
    def require_comments_resolved(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if require comments resolved before merging to the branch.
        """
        return pulumi.get(self, "require_comments_resolved")

    @property
    @pulumi.getter(name="requireLinearHistory")
    def require_linear_history(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if require linear history before merging to the branch.
        """
        return pulumi.get(self, "require_linear_history")

    @property
    @pulumi.getter(name="requirePullRequest")
    def require_pull_request(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if the branch rule requires a pull request or not.
        """
        return pulumi.get(self, "require_pull_request")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the BranchRule.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the BranchRule was updated in UTC.
        """
        return pulumi.get(self, "update_time")

