# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SourceIamPolicyArgs', 'SourceIamPolicy']

@pulumi.input_type
class SourceIamPolicyArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[builtins.str],
                 policy_data: pulumi.Input[builtins.str],
                 source: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a SourceIamPolicy resource.
        :param pulumi.Input[builtins.str] organization: The organization whose Cloud Security Command Center the Source
               lives in.
               
               
               - - -
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "policy_data", policy_data)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[builtins.str]:
        """
        The organization whose Cloud Security Command Center the Source
        lives in.


        - - -
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_data", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _SourceIamPolicyState:
    def __init__(__self__, *,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SourceIamPolicy resources.
        :param pulumi.Input[builtins.str] organization: The organization whose Cloud Security Command Center the Source
               lives in.
               
               
               - - -
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if policy_data is not None:
            pulumi.set(__self__, "policy_data", policy_data)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization whose Cloud Security Command Center the Source
        lives in.


        - - -
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_data", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.type_token("gcp:securitycenter/sourceIamPolicy:SourceIamPolicy")
class SourceIamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Cloud Security Command Center's (Cloud SCC) finding source. A finding
        source is an entity or a mechanism that can produce a finding. A source is
        like a container of findings that come from the same scanner, logger,
        monitor, etc.

        To get more information about Source, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/organizations.sources)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs)

        ## Example Usage

        ### Scc Source Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_source = gcp.securitycenter.Source("custom_source",
            display_name="My Source",
            organization="123456789",
            description="My custom Cloud Security Command Center Finding Source")
        ```

        ## Import

        Source can be imported using any of these accepted formats:

        * `organizations/{{organization}}/sources/{{name}}`

        * `{{organization}}/{{name}}`

        When using the `pulumi import` command, Source can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/sourceIamPolicy:SourceIamPolicy default organizations/{{organization}}/sources/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/sourceIamPolicy:SourceIamPolicy default {{organization}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] organization: The organization whose Cloud Security Command Center the Source
               lives in.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceIamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Security Command Center's (Cloud SCC) finding source. A finding
        source is an entity or a mechanism that can produce a finding. A source is
        like a container of findings that come from the same scanner, logger,
        monitor, etc.

        To get more information about Source, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/organizations.sources)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs)

        ## Example Usage

        ### Scc Source Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_source = gcp.securitycenter.Source("custom_source",
            display_name="My Source",
            organization="123456789",
            description="My custom Cloud Security Command Center Finding Source")
        ```

        ## Import

        Source can be imported using any of these accepted formats:

        * `organizations/{{organization}}/sources/{{name}}`

        * `{{organization}}/{{name}}`

        When using the `pulumi import` command, Source can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/sourceIamPolicy:SourceIamPolicy default organizations/{{organization}}/sources/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/sourceIamPolicy:SourceIamPolicy default {{organization}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SourceIamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceIamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceIamPolicyArgs.__new__(SourceIamPolicyArgs)

            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'policy_data'")
            __props__.__dict__["policy_data"] = policy_data
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["etag"] = None
        super(SourceIamPolicy, __self__).__init__(
            'gcp:securitycenter/sourceIamPolicy:SourceIamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            organization: Optional[pulumi.Input[builtins.str]] = None,
            policy_data: Optional[pulumi.Input[builtins.str]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None) -> 'SourceIamPolicy':
        """
        Get an existing SourceIamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] organization: The organization whose Cloud Security Command Center the Source
               lives in.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceIamPolicyState.__new__(_SourceIamPolicyState)

        __props__.__dict__["etag"] = etag
        __props__.__dict__["organization"] = organization
        __props__.__dict__["policy_data"] = policy_data
        __props__.__dict__["source"] = source
        return SourceIamPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[builtins.str]:
        """
        The organization whose Cloud Security Command Center the Source
        lives in.


        - - -
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "source")

