# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSResult',
    'AwaitableGetSResult',
    'get_s',
    'get_s_output',
]

@pulumi.output_type
class GetSResult:
    """
    A collection of values returned by getS.
    """
    def __init__(__self__, accounts=None, id=None, prefix=None, project=None, regex=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if regex and not isinstance(regex, str):
            raise TypeError("Expected argument 'regex' to be a str")
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def accounts(self) -> Sequence['outputs.GetSAccountResult']:
        """
        A list of all retrieved service accounts. Structure is defined below.
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.str]:
        return pulumi.get(self, "regex")


class AwaitableGetSResult(GetSResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSResult(
            accounts=self.accounts,
            id=self.id,
            prefix=self.prefix,
            project=self.project,
            regex=self.regex)


def get_s(prefix: Optional[builtins.str] = None,
          project: Optional[builtins.str] = None,
          regex: Optional[builtins.str] = None,
          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSResult:
    """
    Gets a list of all service accounts from a project.
    See [the official documentation](https://cloud.google.com/iam/docs/service-account-overview)
    and [API](https://cloud.google.com/iam/docs/reference/rest/v1/projects.serviceAccounts).

    ## Example Usage

    Get all service accounts from a project

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.serviceaccount.get_s(project="example-project")
    ```

    Get all service accounts that are prefixed with `"foo"`

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.serviceaccount.get_s(prefix="foo")
    ```

    Get all service accounts that contain `"bar"`

    ```python
    import pulumi
    import pulumi_gcp as gcp

    bar = gcp.serviceaccount.get_s(regex=".*bar.*")
    ```

    Get all service accounts that are prefixed with `"foo"` and contain `"bar"`

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo_bar = gcp.serviceaccount.get_s(prefix="foo",
        regex=".*bar.*")
    ```


    :param builtins.str prefix: A prefix for filtering. It's applied with the `account_id`.
    :param builtins.str project: The ID of the project. If it is not provided, the provider project is used.
    :param builtins.str regex: A regular expression for filtering. It's applied with the `email`. Further information about the syntax can be found [here](https://github.com/google/re2/wiki/Syntax).
    """
    __args__ = dict()
    __args__['prefix'] = prefix
    __args__['project'] = project
    __args__['regex'] = regex
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:serviceaccount/getS:getS', __args__, opts=opts, typ=GetSResult).value

    return AwaitableGetSResult(
        accounts=pulumi.get(__ret__, 'accounts'),
        id=pulumi.get(__ret__, 'id'),
        prefix=pulumi.get(__ret__, 'prefix'),
        project=pulumi.get(__ret__, 'project'),
        regex=pulumi.get(__ret__, 'regex'))
def get_s_output(prefix: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                 project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                 regex: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSResult]:
    """
    Gets a list of all service accounts from a project.
    See [the official documentation](https://cloud.google.com/iam/docs/service-account-overview)
    and [API](https://cloud.google.com/iam/docs/reference/rest/v1/projects.serviceAccounts).

    ## Example Usage

    Get all service accounts from a project

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.serviceaccount.get_s(project="example-project")
    ```

    Get all service accounts that are prefixed with `"foo"`

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.serviceaccount.get_s(prefix="foo")
    ```

    Get all service accounts that contain `"bar"`

    ```python
    import pulumi
    import pulumi_gcp as gcp

    bar = gcp.serviceaccount.get_s(regex=".*bar.*")
    ```

    Get all service accounts that are prefixed with `"foo"` and contain `"bar"`

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo_bar = gcp.serviceaccount.get_s(prefix="foo",
        regex=".*bar.*")
    ```


    :param builtins.str prefix: A prefix for filtering. It's applied with the `account_id`.
    :param builtins.str project: The ID of the project. If it is not provided, the provider project is used.
    :param builtins.str regex: A regular expression for filtering. It's applied with the `email`. Further information about the syntax can be found [here](https://github.com/google/re2/wiki/Syntax).
    """
    __args__ = dict()
    __args__['prefix'] = prefix
    __args__['project'] = project
    __args__['regex'] = regex
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:serviceaccount/getS:getS', __args__, opts=opts, typ=GetSResult)
    return __ret__.apply(lambda __response__: GetSResult(
        accounts=pulumi.get(__response__, 'accounts'),
        id=pulumi.get(__response__, 'id'),
        prefix=pulumi.get(__response__, 'prefix'),
        project=pulumi.get(__response__, 'project'),
        regex=pulumi.get(__response__, 'regex')))
