# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WebResourceArgs', 'WebResource']

@pulumi.input_type
class WebResourceArgs:
    def __init__(__self__, *,
                 site: pulumi.Input['WebResourceSiteArgs'],
                 verification_method: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a WebResource resource.
        :param pulumi.Input['WebResourceSiteArgs'] site: Container for the address and type of a site for which a verification token will be verified.
               Structure is documented below.
        :param pulumi.Input[builtins.str] verification_method: The verification method for the Site Verification system to use to verify
               this site or domain.
               Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
        """
        pulumi.set(__self__, "site", site)
        pulumi.set(__self__, "verification_method", verification_method)

    @property
    @pulumi.getter
    def site(self) -> pulumi.Input['WebResourceSiteArgs']:
        """
        Container for the address and type of a site for which a verification token will be verified.
        Structure is documented below.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: pulumi.Input['WebResourceSiteArgs']):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="verificationMethod")
    def verification_method(self) -> pulumi.Input[builtins.str]:
        """
        The verification method for the Site Verification system to use to verify
        this site or domain.
        Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
        """
        return pulumi.get(self, "verification_method")

    @verification_method.setter
    def verification_method(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "verification_method", value)


@pulumi.input_type
class _WebResourceState:
    def __init__(__self__, *,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 site: Optional[pulumi.Input['WebResourceSiteArgs']] = None,
                 verification_method: Optional[pulumi.Input[builtins.str]] = None,
                 web_resource_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WebResource resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: The email addresses of all direct, verified owners of this exact property. Indirect owners —
               for example verified owners of the containing domain—are not included in this list.
        :param pulumi.Input['WebResourceSiteArgs'] site: Container for the address and type of a site for which a verification token will be verified.
               Structure is documented below.
        :param pulumi.Input[builtins.str] verification_method: The verification method for the Site Verification system to use to verify
               this site or domain.
               Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
        :param pulumi.Input[builtins.str] web_resource_id: The string used to identify this web resource.
        """
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if verification_method is not None:
            pulumi.set(__self__, "verification_method", verification_method)
        if web_resource_id is not None:
            pulumi.set(__self__, "web_resource_id", web_resource_id)

    @property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The email addresses of all direct, verified owners of this exact property. Indirect owners —
        for example verified owners of the containing domain—are not included in this list.
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "owners", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input['WebResourceSiteArgs']]:
        """
        Container for the address and type of a site for which a verification token will be verified.
        Structure is documented below.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input['WebResourceSiteArgs']]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="verificationMethod")
    def verification_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The verification method for the Site Verification system to use to verify
        this site or domain.
        Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
        """
        return pulumi.get(self, "verification_method")

    @verification_method.setter
    def verification_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verification_method", value)

    @property
    @pulumi.getter(name="webResourceId")
    def web_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The string used to identify this web resource.
        """
        return pulumi.get(self, "web_resource_id")

    @web_resource_id.setter
    def web_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_resource_id", value)


@pulumi.type_token("gcp:siteverification/webResource:WebResource")
class WebResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 site: Optional[pulumi.Input[Union['WebResourceSiteArgs', 'WebResourceSiteArgsDict']]] = None,
                 verification_method: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A web resource is a website or domain with verified ownership. Once your
        ownership is verified you will be able to manage your website in the
        [Google Search Console](https://www.google.com/webmasters/tools/).

        > **Note:** The verification data (DNS `TXT` record, HTML file, `meta` tag, etc.)
        must already exist before the web resource is created, and must be deleted before
        the web resource is destroyed. The Google Site Verification API checks that the
        verification data exists at creation time and does not exist at destruction time
        and will fail if the required condition is not met.

        To get more information about WebResource, see:

        * [API documentation](https://developers.google.com/site-verification/v1)
        * How-to Guides
            * [Getting Started](https://developers.google.com/site-verification/v1/getting_started)

        ## Example Usage

        ### Site Verification Domain Record

        ```python
        import pulumi
        import pulumi_gcp as gcp

        token = gcp.siteverification.get_token(type="INET_DOMAIN",
            identifier="www.example.com",
            verification_method="DNS_TXT")
        example = gcp.dns.RecordSet("example",
            managed_zone="example.com",
            name="www.example.com.",
            type="TXT",
            rrdatas=[token.token],
            ttl=86400)
        example_web_resource = gcp.siteverification.WebResource("example",
            site={
                "type": token.type,
                "identifier": token.identifier,
            },
            verification_method=token.verification_method,
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        WebResource can be imported using any of these accepted formats:

        * `webResource/{{web_resource_id}}`

        * `{{web_resource_id}}`

        When using the `pulumi import` command, WebResource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:siteverification/webResource:WebResource default webResource/{{web_resource_id}}
        ```

        ```sh
        $ pulumi import gcp:siteverification/webResource:WebResource default {{web_resource_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WebResourceSiteArgs', 'WebResourceSiteArgsDict']] site: Container for the address and type of a site for which a verification token will be verified.
               Structure is documented below.
        :param pulumi.Input[builtins.str] verification_method: The verification method for the Site Verification system to use to verify
               this site or domain.
               Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A web resource is a website or domain with verified ownership. Once your
        ownership is verified you will be able to manage your website in the
        [Google Search Console](https://www.google.com/webmasters/tools/).

        > **Note:** The verification data (DNS `TXT` record, HTML file, `meta` tag, etc.)
        must already exist before the web resource is created, and must be deleted before
        the web resource is destroyed. The Google Site Verification API checks that the
        verification data exists at creation time and does not exist at destruction time
        and will fail if the required condition is not met.

        To get more information about WebResource, see:

        * [API documentation](https://developers.google.com/site-verification/v1)
        * How-to Guides
            * [Getting Started](https://developers.google.com/site-verification/v1/getting_started)

        ## Example Usage

        ### Site Verification Domain Record

        ```python
        import pulumi
        import pulumi_gcp as gcp

        token = gcp.siteverification.get_token(type="INET_DOMAIN",
            identifier="www.example.com",
            verification_method="DNS_TXT")
        example = gcp.dns.RecordSet("example",
            managed_zone="example.com",
            name="www.example.com.",
            type="TXT",
            rrdatas=[token.token],
            ttl=86400)
        example_web_resource = gcp.siteverification.WebResource("example",
            site={
                "type": token.type,
                "identifier": token.identifier,
            },
            verification_method=token.verification_method,
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        WebResource can be imported using any of these accepted formats:

        * `webResource/{{web_resource_id}}`

        * `{{web_resource_id}}`

        When using the `pulumi import` command, WebResource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:siteverification/webResource:WebResource default webResource/{{web_resource_id}}
        ```

        ```sh
        $ pulumi import gcp:siteverification/webResource:WebResource default {{web_resource_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WebResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 site: Optional[pulumi.Input[Union['WebResourceSiteArgs', 'WebResourceSiteArgsDict']]] = None,
                 verification_method: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebResourceArgs.__new__(WebResourceArgs)

            if site is None and not opts.urn:
                raise TypeError("Missing required property 'site'")
            __props__.__dict__["site"] = site
            if verification_method is None and not opts.urn:
                raise TypeError("Missing required property 'verification_method'")
            __props__.__dict__["verification_method"] = verification_method
            __props__.__dict__["owners"] = None
            __props__.__dict__["web_resource_id"] = None
        super(WebResource, __self__).__init__(
            'gcp:siteverification/webResource:WebResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            site: Optional[pulumi.Input[Union['WebResourceSiteArgs', 'WebResourceSiteArgsDict']]] = None,
            verification_method: Optional[pulumi.Input[builtins.str]] = None,
            web_resource_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WebResource':
        """
        Get an existing WebResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] owners: The email addresses of all direct, verified owners of this exact property. Indirect owners —
               for example verified owners of the containing domain—are not included in this list.
        :param pulumi.Input[Union['WebResourceSiteArgs', 'WebResourceSiteArgsDict']] site: Container for the address and type of a site for which a verification token will be verified.
               Structure is documented below.
        :param pulumi.Input[builtins.str] verification_method: The verification method for the Site Verification system to use to verify
               this site or domain.
               Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
        :param pulumi.Input[builtins.str] web_resource_id: The string used to identify this web resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebResourceState.__new__(_WebResourceState)

        __props__.__dict__["owners"] = owners
        __props__.__dict__["site"] = site
        __props__.__dict__["verification_method"] = verification_method
        __props__.__dict__["web_resource_id"] = web_resource_id
        return WebResource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def owners(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The email addresses of all direct, verified owners of this exact property. Indirect owners —
        for example verified owners of the containing domain—are not included in this list.
        """
        return pulumi.get(self, "owners")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output['outputs.WebResourceSite']:
        """
        Container for the address and type of a site for which a verification token will be verified.
        Structure is documented below.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter(name="verificationMethod")
    def verification_method(self) -> pulumi.Output[builtins.str]:
        """
        The verification method for the Site Verification system to use to verify
        this site or domain.
        Possible values are: `ANALYTICS`, `DNS_CNAME`, `DNS_TXT`, `FILE`, `META`, `TAG_MANAGER`.
        """
        return pulumi.get(self, "verification_method")

    @property
    @pulumi.getter(name="webResourceId")
    def web_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The string used to identify this web resource.
        """
        return pulumi.get(self, "web_resource_id")

