# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 config: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 autoscaling_config: Optional[pulumi.Input['InstanceAutoscalingConfigArgs']] = None,
                 default_backup_schedule_type: Optional[pulumi.Input[builtins.str]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] config: The name of the instance's configuration (similar but not
               quite the same as a region) which defines the geographic placement and
               replication of your databases in this instance. It determines where your data
               is stored. Values are typically of the form `regional-europe-west1` , `us-central` etc.
               In order to obtain a valid list please consult the
               [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance as it appears in UIs. Must be
               unique per project and between 4 and 30 characters in length.
               
               
               - - -
        :param pulumi.Input[builtins.str] default_backup_schedule_type: Controls the default backup behavior for new databases within the instance.
               Note that `AUTOMATIC` is not permitted for free instances, as backups and backup schedules are not allowed for free instances.
               if unset or NONE, no default backup schedule will be created for new databases within the instance.
               Possible values are: `NONE`, `AUTOMATIC`.
        :param pulumi.Input[builtins.str] edition: The edition selected for this instance. Different editions provide different capabilities at different price points.
               Possible values are: `EDITION_UNSPECIFIED`, `STANDARD`, `ENTERPRISE`, `ENTERPRISE_PLUS`.
        :param pulumi.Input[builtins.bool] force_destroy: When deleting a spanner instance, this boolean option will delete all backups of this instance.
               This must be set to true if you created a backup manually in the console.
        :param pulumi.Input[builtins.str] instance_type: The type of this instance. The type can be used to distinguish product variants, that can affect aspects like:
               usage restrictions, quotas and billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED instances.
               When configured as FREE_INSTANCE, the field `edition` should not be configured.
               Possible values are: `PROVISIONED`, `FREE_INSTANCE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance, which cannot be changed after
               the instance is created. The name must be between 6 and 30 characters
               in length.
               If not provided, a random string starting with `tf-` will be selected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "display_name", display_name)
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if default_backup_schedule_type is not None:
            pulumi.set(__self__, "default_backup_schedule_type", default_backup_schedule_type)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if processing_units is not None:
            pulumi.set(__self__, "processing_units", processing_units)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input[builtins.str]:
        """
        The name of the instance's configuration (similar but not
        quite the same as a region) which defines the geographic placement and
        replication of your databases in this instance. It determines where your data
        is stored. Values are typically of the form `regional-europe-west1` , `us-central` etc.
        In order to obtain a valid list please consult the
        [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The descriptive name for this instance as it appears in UIs. Must be
        unique per project and between 4 and 30 characters in length.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional[pulumi.Input['InstanceAutoscalingConfigArgs']]:
        return pulumi.get(self, "autoscaling_config")

    @autoscaling_config.setter
    def autoscaling_config(self, value: Optional[pulumi.Input['InstanceAutoscalingConfigArgs']]):
        pulumi.set(self, "autoscaling_config", value)

    @property
    @pulumi.getter(name="defaultBackupScheduleType")
    def default_backup_schedule_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the default backup behavior for new databases within the instance.
        Note that `AUTOMATIC` is not permitted for free instances, as backups and backup schedules are not allowed for free instances.
        if unset or NONE, no default backup schedule will be created for new databases within the instance.
        Possible values are: `NONE`, `AUTOMATIC`.
        """
        return pulumi.get(self, "default_backup_schedule_type")

    @default_backup_schedule_type.setter
    def default_backup_schedule_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_backup_schedule_type", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edition selected for this instance. Different editions provide different capabilities at different price points.
        Possible values are: `EDITION_UNSPECIFIED`, `STANDARD`, `ENTERPRISE`, `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When deleting a spanner instance, this boolean option will delete all backups of this instance.
        This must be set to true if you created a backup manually in the console.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of this instance. The type can be used to distinguish product variants, that can affect aspects like:
        usage restrictions, quotas and billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED instances.
        When configured as FREE_INSTANCE, the field `edition` should not be configured.
        Possible values are: `PROVISIONED`, `FREE_INSTANCE`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the instance, which cannot be changed after
        the instance is created. The name must be between 6 and 30 characters
        in length.
        If not provided, a random string starting with `tf-` will be selected.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "num_nodes")

    @num_nodes.setter
    def num_nodes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_nodes", value)

    @property
    @pulumi.getter(name="processingUnits")
    def processing_units(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "processing_units")

    @processing_units.setter
    def processing_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "processing_units", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 autoscaling_config: Optional[pulumi.Input['InstanceAutoscalingConfigArgs']] = None,
                 config: Optional[pulumi.Input[builtins.str]] = None,
                 default_backup_schedule_type: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[builtins.str] config: The name of the instance's configuration (similar but not
               quite the same as a region) which defines the geographic placement and
               replication of your databases in this instance. It determines where your data
               is stored. Values are typically of the form `regional-europe-west1` , `us-central` etc.
               In order to obtain a valid list please consult the
               [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
        :param pulumi.Input[builtins.str] default_backup_schedule_type: Controls the default backup behavior for new databases within the instance.
               Note that `AUTOMATIC` is not permitted for free instances, as backups and backup schedules are not allowed for free instances.
               if unset or NONE, no default backup schedule will be created for new databases within the instance.
               Possible values are: `NONE`, `AUTOMATIC`.
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance as it appears in UIs. Must be
               unique per project and between 4 and 30 characters in length.
               
               
               - - -
        :param pulumi.Input[builtins.str] edition: The edition selected for this instance. Different editions provide different capabilities at different price points.
               Possible values are: `EDITION_UNSPECIFIED`, `STANDARD`, `ENTERPRISE`, `ENTERPRISE_PLUS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] force_destroy: When deleting a spanner instance, this boolean option will delete all backups of this instance.
               This must be set to true if you created a backup manually in the console.
        :param pulumi.Input[builtins.str] instance_type: The type of this instance. The type can be used to distinguish product variants, that can affect aspects like:
               usage restrictions, quotas and billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED instances.
               When configured as FREE_INSTANCE, the field `edition` should not be configured.
               Possible values are: `PROVISIONED`, `FREE_INSTANCE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance, which cannot be changed after
               the instance is created. The name must be between 6 and 30 characters
               in length.
               If not provided, a random string starting with `tf-` will be selected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: Instance status: `CREATING` or `READY`.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if default_backup_schedule_type is not None:
            pulumi.set(__self__, "default_backup_schedule_type", default_backup_schedule_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if processing_units is not None:
            pulumi.set(__self__, "processing_units", processing_units)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional[pulumi.Input['InstanceAutoscalingConfigArgs']]:
        return pulumi.get(self, "autoscaling_config")

    @autoscaling_config.setter
    def autoscaling_config(self, value: Optional[pulumi.Input['InstanceAutoscalingConfigArgs']]):
        pulumi.set(self, "autoscaling_config", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance's configuration (similar but not
        quite the same as a region) which defines the geographic placement and
        replication of your databases in this instance. It determines where your data
        is stored. Values are typically of the form `regional-europe-west1` , `us-central` etc.
        In order to obtain a valid list please consult the
        [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="defaultBackupScheduleType")
    def default_backup_schedule_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the default backup behavior for new databases within the instance.
        Note that `AUTOMATIC` is not permitted for free instances, as backups and backup schedules are not allowed for free instances.
        if unset or NONE, no default backup schedule will be created for new databases within the instance.
        Possible values are: `NONE`, `AUTOMATIC`.
        """
        return pulumi.get(self, "default_backup_schedule_type")

    @default_backup_schedule_type.setter
    def default_backup_schedule_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_backup_schedule_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The descriptive name for this instance as it appears in UIs. Must be
        unique per project and between 4 and 30 characters in length.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edition selected for this instance. Different editions provide different capabilities at different price points.
        Possible values are: `EDITION_UNSPECIFIED`, `STANDARD`, `ENTERPRISE`, `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When deleting a spanner instance, this boolean option will delete all backups of this instance.
        This must be set to true if you created a backup manually in the console.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of this instance. The type can be used to distinguish product variants, that can affect aspects like:
        usage restrictions, quotas and billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED instances.
        When configured as FREE_INSTANCE, the field `edition` should not be configured.
        Possible values are: `PROVISIONED`, `FREE_INSTANCE`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the instance, which cannot be changed after
        the instance is created. The name must be between 6 and 30 characters
        in length.
        If not provided, a random string starting with `tf-` will be selected.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "num_nodes")

    @num_nodes.setter
    def num_nodes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_nodes", value)

    @property
    @pulumi.getter(name="processingUnits")
    def processing_units(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "processing_units")

    @processing_units.setter
    def processing_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "processing_units", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Instance status: `CREATING` or `READY`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:spanner/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_config: Optional[pulumi.Input[Union['InstanceAutoscalingConfigArgs', 'InstanceAutoscalingConfigArgsDict']]] = None,
                 config: Optional[pulumi.Input[builtins.str]] = None,
                 default_backup_schedule_type: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An isolated set of Cloud Spanner resources on which databases can be
        hosted.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/)

        ## Example Usage

        ### Spanner Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.spanner.Instance("example",
            config="regional-us-central1",
            display_name="Test Spanner Instance",
            num_nodes=2,
            edition="STANDARD",
            default_backup_schedule_type="AUTOMATIC",
            labels={
                "foo": "bar",
            })
        ```
        ### Spanner Instance Processing Units

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.spanner.Instance("example",
            config="regional-us-central1",
            display_name="Test Spanner Instance",
            processing_units=200,
            labels={
                "foo": "bar",
            })
        ```
        ### Spanner Instance Multi Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.spanner.Instance("example",
            config="nam-eur-asia1",
            display_name="Multi Regional Instance",
            num_nodes=2,
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/instance:Instance default projects/{{project}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instance:Instance default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] config: The name of the instance's configuration (similar but not
               quite the same as a region) which defines the geographic placement and
               replication of your databases in this instance. It determines where your data
               is stored. Values are typically of the form `regional-europe-west1` , `us-central` etc.
               In order to obtain a valid list please consult the
               [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
        :param pulumi.Input[builtins.str] default_backup_schedule_type: Controls the default backup behavior for new databases within the instance.
               Note that `AUTOMATIC` is not permitted for free instances, as backups and backup schedules are not allowed for free instances.
               if unset or NONE, no default backup schedule will be created for new databases within the instance.
               Possible values are: `NONE`, `AUTOMATIC`.
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance as it appears in UIs. Must be
               unique per project and between 4 and 30 characters in length.
               
               
               - - -
        :param pulumi.Input[builtins.str] edition: The edition selected for this instance. Different editions provide different capabilities at different price points.
               Possible values are: `EDITION_UNSPECIFIED`, `STANDARD`, `ENTERPRISE`, `ENTERPRISE_PLUS`.
        :param pulumi.Input[builtins.bool] force_destroy: When deleting a spanner instance, this boolean option will delete all backups of this instance.
               This must be set to true if you created a backup manually in the console.
        :param pulumi.Input[builtins.str] instance_type: The type of this instance. The type can be used to distinguish product variants, that can affect aspects like:
               usage restrictions, quotas and billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED instances.
               When configured as FREE_INSTANCE, the field `edition` should not be configured.
               Possible values are: `PROVISIONED`, `FREE_INSTANCE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance, which cannot be changed after
               the instance is created. The name must be between 6 and 30 characters
               in length.
               If not provided, a random string starting with `tf-` will be selected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An isolated set of Cloud Spanner resources on which databases can be
        hosted.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/spanner/docs/reference/rest/v1/projects.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/spanner/)

        ## Example Usage

        ### Spanner Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.spanner.Instance("example",
            config="regional-us-central1",
            display_name="Test Spanner Instance",
            num_nodes=2,
            edition="STANDARD",
            default_backup_schedule_type="AUTOMATIC",
            labels={
                "foo": "bar",
            })
        ```
        ### Spanner Instance Processing Units

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.spanner.Instance("example",
            config="regional-us-central1",
            display_name="Test Spanner Instance",
            processing_units=200,
            labels={
                "foo": "bar",
            })
        ```
        ### Spanner Instance Multi Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.spanner.Instance("example",
            config="nam-eur-asia1",
            display_name="Multi Regional Instance",
            num_nodes=2,
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:spanner/instance:Instance default projects/{{project}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instance:Instance default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:spanner/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_config: Optional[pulumi.Input[Union['InstanceAutoscalingConfigArgs', 'InstanceAutoscalingConfigArgsDict']]] = None,
                 config: Optional[pulumi.Input[builtins.str]] = None,
                 default_backup_schedule_type: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 processing_units: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["autoscaling_config"] = autoscaling_config
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["default_backup_schedule_type"] = default_backup_schedule_type
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["edition"] = edition
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["num_nodes"] = num_nodes
            __props__.__dict__["processing_units"] = processing_units
            __props__.__dict__["project"] = project
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:spanner/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaling_config: Optional[pulumi.Input[Union['InstanceAutoscalingConfigArgs', 'InstanceAutoscalingConfigArgsDict']]] = None,
            config: Optional[pulumi.Input[builtins.str]] = None,
            default_backup_schedule_type: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            edition: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            instance_type: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            num_nodes: Optional[pulumi.Input[builtins.int]] = None,
            processing_units: Optional[pulumi.Input[builtins.int]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] config: The name of the instance's configuration (similar but not
               quite the same as a region) which defines the geographic placement and
               replication of your databases in this instance. It determines where your data
               is stored. Values are typically of the form `regional-europe-west1` , `us-central` etc.
               In order to obtain a valid list please consult the
               [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
        :param pulumi.Input[builtins.str] default_backup_schedule_type: Controls the default backup behavior for new databases within the instance.
               Note that `AUTOMATIC` is not permitted for free instances, as backups and backup schedules are not allowed for free instances.
               if unset or NONE, no default backup schedule will be created for new databases within the instance.
               Possible values are: `NONE`, `AUTOMATIC`.
        :param pulumi.Input[builtins.str] display_name: The descriptive name for this instance as it appears in UIs. Must be
               unique per project and between 4 and 30 characters in length.
               
               
               - - -
        :param pulumi.Input[builtins.str] edition: The edition selected for this instance. Different editions provide different capabilities at different price points.
               Possible values are: `EDITION_UNSPECIFIED`, `STANDARD`, `ENTERPRISE`, `ENTERPRISE_PLUS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] force_destroy: When deleting a spanner instance, this boolean option will delete all backups of this instance.
               This must be set to true if you created a backup manually in the console.
        :param pulumi.Input[builtins.str] instance_type: The type of this instance. The type can be used to distinguish product variants, that can affect aspects like:
               usage restrictions, quotas and billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED instances.
               When configured as FREE_INSTANCE, the field `edition` should not be configured.
               Possible values are: `PROVISIONED`, `FREE_INSTANCE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: A unique identifier for the instance, which cannot be changed after
               the instance is created. The name must be between 6 and 30 characters
               in length.
               If not provided, a random string starting with `tf-` will be selected.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: Instance status: `CREATING` or `READY`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["autoscaling_config"] = autoscaling_config
        __props__.__dict__["config"] = config
        __props__.__dict__["default_backup_schedule_type"] = default_backup_schedule_type
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["edition"] = edition
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["num_nodes"] = num_nodes
        __props__.__dict__["processing_units"] = processing_units
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> pulumi.Output[Optional['outputs.InstanceAutoscalingConfig']]:
        return pulumi.get(self, "autoscaling_config")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[builtins.str]:
        """
        The name of the instance's configuration (similar but not
        quite the same as a region) which defines the geographic placement and
        replication of your databases in this instance. It determines where your data
        is stored. Values are typically of the form `regional-europe-west1` , `us-central` etc.
        In order to obtain a valid list please consult the
        [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="defaultBackupScheduleType")
    def default_backup_schedule_type(self) -> pulumi.Output[builtins.str]:
        """
        Controls the default backup behavior for new databases within the instance.
        Note that `AUTOMATIC` is not permitted for free instances, as backups and backup schedules are not allowed for free instances.
        if unset or NONE, no default backup schedule will be created for new databases within the instance.
        Possible values are: `NONE`, `AUTOMATIC`.
        """
        return pulumi.get(self, "default_backup_schedule_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The descriptive name for this instance as it appears in UIs. Must be
        unique per project and between 4 and 30 characters in length.


        - - -
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[builtins.str]:
        """
        The edition selected for this instance. Different editions provide different capabilities at different price points.
        Possible values are: `EDITION_UNSPECIFIED`, `STANDARD`, `ENTERPRISE`, `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When deleting a spanner instance, this boolean option will delete all backups of this instance.
        This must be set to true if you created a backup manually in the console.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of this instance. The type can be used to distinguish product variants, that can affect aspects like:
        usage restrictions, quotas and billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED instances.
        When configured as FREE_INSTANCE, the field `edition` should not be configured.
        Possible values are: `PROVISIONED`, `FREE_INSTANCE`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the instance, which cannot be changed after
        the instance is created. The name must be between 6 and 30 characters
        in length.
        If not provided, a random string starting with `tf-` will be selected.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "num_nodes")

    @property
    @pulumi.getter(name="processingUnits")
    def processing_units(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "processing_units")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Instance status: `CREATING` or `READY`.
        """
        return pulumi.get(self, "state")

