# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseInstanceClone',
    'DatabaseInstanceDnsName',
    'DatabaseInstanceIpAddress',
    'DatabaseInstanceReplicaConfiguration',
    'DatabaseInstanceReplicationCluster',
    'DatabaseInstanceRestoreBackupContext',
    'DatabaseInstanceServerCaCert',
    'DatabaseInstanceSettings',
    'DatabaseInstanceSettingsActiveDirectoryConfig',
    'DatabaseInstanceSettingsAdvancedMachineFeatures',
    'DatabaseInstanceSettingsBackupConfiguration',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings',
    'DatabaseInstanceSettingsConnectionPoolConfig',
    'DatabaseInstanceSettingsConnectionPoolConfigFlag',
    'DatabaseInstanceSettingsDataCacheConfig',
    'DatabaseInstanceSettingsDatabaseFlag',
    'DatabaseInstanceSettingsDenyMaintenancePeriod',
    'DatabaseInstanceSettingsInsightsConfig',
    'DatabaseInstanceSettingsIpConfiguration',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork',
    'DatabaseInstanceSettingsIpConfigurationPscConfig',
    'DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection',
    'DatabaseInstanceSettingsLocationPreference',
    'DatabaseInstanceSettingsMaintenanceWindow',
    'DatabaseInstanceSettingsPasswordValidationPolicy',
    'DatabaseInstanceSettingsSqlServerAuditConfig',
    'UserPasswordPolicy',
    'UserPasswordPolicyStatus',
    'UserSqlServerUserDetail',
    'GetCaCertsCertResult',
    'GetDatabaseInstanceCloneResult',
    'GetDatabaseInstanceDnsNameResult',
    'GetDatabaseInstanceIpAddressResult',
    'GetDatabaseInstanceReplicaConfigurationResult',
    'GetDatabaseInstanceReplicationClusterResult',
    'GetDatabaseInstanceRestoreBackupContextResult',
    'GetDatabaseInstanceServerCaCertResult',
    'GetDatabaseInstanceSettingResult',
    'GetDatabaseInstanceSettingActiveDirectoryConfigResult',
    'GetDatabaseInstanceSettingAdvancedMachineFeatureResult',
    'GetDatabaseInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult',
    'GetDatabaseInstanceSettingConnectionPoolConfigResult',
    'GetDatabaseInstanceSettingConnectionPoolConfigFlagResult',
    'GetDatabaseInstanceSettingDataCacheConfigResult',
    'GetDatabaseInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstanceSettingDenyMaintenancePeriodResult',
    'GetDatabaseInstanceSettingInsightsConfigResult',
    'GetDatabaseInstanceSettingIpConfigurationResult',
    'GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstanceSettingIpConfigurationPscConfigResult',
    'GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult',
    'GetDatabaseInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstanceSettingMaintenanceWindowResult',
    'GetDatabaseInstanceSettingPasswordValidationPolicyResult',
    'GetDatabaseInstanceSettingSqlServerAuditConfigResult',
    'GetDatabaseInstancesInstanceResult',
    'GetDatabaseInstancesInstanceCloneResult',
    'GetDatabaseInstancesInstanceDnsNameResult',
    'GetDatabaseInstancesInstanceIpAddressResult',
    'GetDatabaseInstancesInstanceReplicaConfigurationResult',
    'GetDatabaseInstancesInstanceReplicationClusterResult',
    'GetDatabaseInstancesInstanceRestoreBackupContextResult',
    'GetDatabaseInstancesInstanceServerCaCertResult',
    'GetDatabaseInstancesInstanceSettingResult',
    'GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult',
    'GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult',
    'GetDatabaseInstancesInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult',
    'GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult',
    'GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult',
    'GetDatabaseInstancesInstanceSettingDataCacheConfigResult',
    'GetDatabaseInstancesInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult',
    'GetDatabaseInstancesInstanceSettingInsightsConfigResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult',
    'GetDatabaseInstancesInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstancesInstanceSettingMaintenanceWindowResult',
    'GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult',
    'GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult',
    'GetDatabasesDatabaseResult',
    'GetTiersTierResult',
]

@pulumi.output_type
class DatabaseInstanceClone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceInstanceName":
            suggest = "source_instance_name"
        elif key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "databaseNames":
            suggest = "database_names"
        elif key == "pointInTime":
            suggest = "point_in_time"
        elif key == "preferredZone":
            suggest = "preferred_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceClone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_instance_name: builtins.str,
                 allocated_ip_range: Optional[builtins.str] = None,
                 database_names: Optional[Sequence[builtins.str]] = None,
                 point_in_time: Optional[builtins.str] = None,
                 preferred_zone: Optional[builtins.str] = None):
        """
        :param builtins.str source_instance_name: Name of the source instance which will be cloned.
        :param builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[builtins.str] database_names: (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        :param builtins.str point_in_time: The timestamp of the point in time that should be restored.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param builtins.str preferred_zone: (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance. [clone-unavailable-instance](https://cloud.google.com/sql/docs/postgres/clone-instance#clone-unavailable-instance)
        """
        pulumi.set(__self__, "source_instance_name", source_instance_name)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if database_names is not None:
            pulumi.set(__self__, "database_names", database_names)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)
        if preferred_zone is not None:
            pulumi.set(__self__, "preferred_zone", preferred_zone)

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> builtins.str:
        """
        Name of the source instance which will be cloned.
        """
        return pulumi.get(self, "source_instance_name")

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[builtins.str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Optional[Sequence[builtins.str]]:
        """
        (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[builtins.str]:
        """
        The timestamp of the point in time that should be restored.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "point_in_time")

    @property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> Optional[builtins.str]:
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance. [clone-unavailable-instance](https://cloud.google.com/sql/docs/postgres/clone-instance#clone-unavailable-instance)
        """
        return pulumi.get(self, "preferred_zone")


@pulumi.output_type
class DatabaseInstanceDnsName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "dnsScope":
            suggest = "dns_scope"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceDnsName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceDnsName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceDnsName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: Optional[builtins.str] = None,
                 dns_scope: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str connection_type: The connection type of the DNS name. Can be either `PUBLIC`, `PRIVATE_SERVICES_ACCESS`, or `PRIVATE_SERVICE_CONNECT`.
        :param builtins.str dns_scope: The scope that the DNS name applies to.
        :param builtins.str name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if dns_scope is not None:
            pulumi.set(__self__, "dns_scope", dns_scope)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[builtins.str]:
        """
        The connection type of the DNS name. Can be either `PUBLIC`, `PRIVATE_SERVICES_ACCESS`, or `PRIVATE_SERVICE_CONNECT`.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="dnsScope")
    def dns_scope(self) -> Optional[builtins.str]:
        """
        The scope that the DNS name applies to.
        """
        return pulumi.get(self, "dns_scope")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DatabaseInstanceIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "timeToRetire":
            suggest = "time_to_retire"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[builtins.str] = None,
                 time_to_retire: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str ip_address: The IPv4 address assigned.
        :param builtins.str time_to_retire: The time this IP address will be retired, in RFC
               3339 format.
        :param builtins.str type: The type of this IP address.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        """
        The IPv4 address assigned.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[builtins.str]:
        """
        The time this IP address will be retired, in RFC
        3339 format.
        """
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of this IP address.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DatabaseInstanceReplicaConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "cascadableReplica":
            suggest = "cascadable_replica"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "connectRetryInterval":
            suggest = "connect_retry_interval"
        elif key == "dumpFilePath":
            suggest = "dump_file_path"
        elif key == "failoverTarget":
            suggest = "failover_target"
        elif key == "masterHeartbeatPeriod":
            suggest = "master_heartbeat_period"
        elif key == "sslCipher":
            suggest = "ssl_cipher"
        elif key == "verifyServerCertificate":
            suggest = "verify_server_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceReplicaConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: Optional[builtins.str] = None,
                 cascadable_replica: Optional[builtins.bool] = None,
                 client_certificate: Optional[builtins.str] = None,
                 client_key: Optional[builtins.str] = None,
                 connect_retry_interval: Optional[builtins.int] = None,
                 dump_file_path: Optional[builtins.str] = None,
                 failover_target: Optional[builtins.bool] = None,
                 master_heartbeat_period: Optional[builtins.int] = None,
                 password: Optional[builtins.str] = None,
                 ssl_cipher: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None,
                 verify_server_certificate: Optional[builtins.bool] = None):
        """
        :param builtins.str ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param builtins.bool cascadable_replica: Specifies if the replica is a cascadable replica. If true, instance must be in different region from primary.
               
               > **NOTE:** Only supported for SQL Server database.
        :param builtins.str client_certificate: PEM representation of the replica's x509
               certificate.
        :param builtins.str client_key: PEM representation of the replica's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param builtins.int connect_retry_interval: The number of seconds
               between connect retries. MySQL's default is 60 seconds.
        :param builtins.str dump_file_path: Path to a SQL file in GCS from which replica
               instances are created. Format is `gs://bucket/filename`. Note, if the master
               instance is a source representation instance this field must be present.
        :param builtins.bool failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
               > **NOTE:** Not supported for Postgres database.
        :param builtins.int master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param builtins.str password: Password for the replication connection.
        :param builtins.str ssl_cipher: Permissible ciphers for use in SSL encryption.
        :param builtins.str username: Username for replication connection.
        :param builtins.bool verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if cascadable_replica is not None:
            pulumi.set(__self__, "cascadable_replica", cascadable_replica)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[builtins.str]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="cascadableReplica")
    def cascadable_replica(self) -> Optional[builtins.bool]:
        """
        Specifies if the replica is a cascadable replica. If true, instance must be in different region from primary.

        > **NOTE:** Only supported for SQL Server database.
        """
        return pulumi.get(self, "cascadable_replica")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[builtins.str]:
        """
        PEM representation of the replica's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[builtins.str]:
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[builtins.int]:
        """
        The number of seconds
        between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[builtins.str]:
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`. Note, if the master
        instance is a source representation instance this field must be present.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[builtins.bool]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        > **NOTE:** Not supported for Postgres database.
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[builtins.int]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[builtins.str]:
        """
        Permissible ciphers for use in SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[builtins.bool]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class DatabaseInstanceReplicationCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drReplica":
            suggest = "dr_replica"
        elif key == "failoverDrReplicaName":
            suggest = "failover_dr_replica_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceReplicationCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceReplicationCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceReplicationCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dr_replica: Optional[builtins.bool] = None,
                 failover_dr_replica_name: Optional[builtins.str] = None):
        """
        :param builtins.bool dr_replica: Read-only field that indicates whether the replica is a DR replica.
        :param builtins.str failover_dr_replica_name: If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        if dr_replica is not None:
            pulumi.set(__self__, "dr_replica", dr_replica)
        if failover_dr_replica_name is not None:
            pulumi.set(__self__, "failover_dr_replica_name", failover_dr_replica_name)

    @property
    @pulumi.getter(name="drReplica")
    def dr_replica(self) -> Optional[builtins.bool]:
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        return pulumi.get(self, "dr_replica")

    @property
    @pulumi.getter(name="failoverDrReplicaName")
    def failover_dr_replica_name(self) -> Optional[builtins.str]:
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        return pulumi.get(self, "failover_dr_replica_name")


@pulumi.output_type
class DatabaseInstanceRestoreBackupContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRunId":
            suggest = "backup_run_id"
        elif key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceRestoreBackupContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_run_id: builtins.int,
                 instance_id: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None):
        """
        :param builtins.int backup_run_id: The ID of the backup run to restore from.
        :param builtins.str instance_id: The ID of the instance that the backup was taken from. If left empty,
               this instance's ID will be used.
        :param builtins.str project: The full project ID of the source instance.`
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> builtins.int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        """
        The full project ID of the source instance.`
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class DatabaseInstanceServerCaCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceServerCaCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[builtins.str] = None,
                 common_name: Optional[builtins.str] = None,
                 create_time: Optional[builtins.str] = None,
                 expiration_time: Optional[builtins.str] = None,
                 sha1_fingerprint: Optional[builtins.str] = None):
        """
        :param builtins.str cert: The CA Certificate used to connect to the SQL Instance via SSL.
        :param builtins.str common_name: The CN valid for the CA Cert.
        :param builtins.str create_time: Creation time of the CA Cert.
        :param builtins.str expiration_time: Expiration time of the CA Cert.
        :param builtins.str sha1_fingerprint: SHA Fingerprint of the CA Cert.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[builtins.str]:
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[builtins.str]:
        """
        The CN valid for the CA Cert.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        Creation time of the CA Cert.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[builtins.str]:
        """
        Expiration time of the CA Cert.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[builtins.str]:
        """
        SHA Fingerprint of the CA Cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class DatabaseInstanceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationPolicy":
            suggest = "activation_policy"
        elif key == "activeDirectoryConfig":
            suggest = "active_directory_config"
        elif key == "advancedMachineFeatures":
            suggest = "advanced_machine_features"
        elif key == "availabilityType":
            suggest = "availability_type"
        elif key == "backupConfiguration":
            suggest = "backup_configuration"
        elif key == "connectionPoolConfigs":
            suggest = "connection_pool_configs"
        elif key == "connectorEnforcement":
            suggest = "connector_enforcement"
        elif key == "dataCacheConfig":
            suggest = "data_cache_config"
        elif key == "dataDiskProvisionedIops":
            suggest = "data_disk_provisioned_iops"
        elif key == "dataDiskProvisionedThroughput":
            suggest = "data_disk_provisioned_throughput"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "deletionProtectionEnabled":
            suggest = "deletion_protection_enabled"
        elif key == "denyMaintenancePeriod":
            suggest = "deny_maintenance_period"
        elif key == "diskAutoresize":
            suggest = "disk_autoresize"
        elif key == "diskAutoresizeLimit":
            suggest = "disk_autoresize_limit"
        elif key == "diskSize":
            suggest = "disk_size"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "enableDataplexIntegration":
            suggest = "enable_dataplex_integration"
        elif key == "enableGoogleMlIntegration":
            suggest = "enable_google_ml_integration"
        elif key == "insightsConfig":
            suggest = "insights_config"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "locationPreference":
            suggest = "location_preference"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "passwordValidationPolicy":
            suggest = "password_validation_policy"
        elif key == "pricingPlan":
            suggest = "pricing_plan"
        elif key == "retainBackupsOnDelete":
            suggest = "retain_backups_on_delete"
        elif key == "sqlServerAuditConfig":
            suggest = "sql_server_audit_config"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "userLabels":
            suggest = "user_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tier: builtins.str,
                 activation_policy: Optional[builtins.str] = None,
                 active_directory_config: Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig'] = None,
                 advanced_machine_features: Optional['outputs.DatabaseInstanceSettingsAdvancedMachineFeatures'] = None,
                 availability_type: Optional[builtins.str] = None,
                 backup_configuration: Optional['outputs.DatabaseInstanceSettingsBackupConfiguration'] = None,
                 collation: Optional[builtins.str] = None,
                 connection_pool_configs: Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfig']] = None,
                 connector_enforcement: Optional[builtins.str] = None,
                 data_cache_config: Optional['outputs.DatabaseInstanceSettingsDataCacheConfig'] = None,
                 data_disk_provisioned_iops: Optional[builtins.int] = None,
                 data_disk_provisioned_throughput: Optional[builtins.int] = None,
                 database_flags: Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']] = None,
                 deletion_protection_enabled: Optional[builtins.bool] = None,
                 deny_maintenance_period: Optional['outputs.DatabaseInstanceSettingsDenyMaintenancePeriod'] = None,
                 disk_autoresize: Optional[builtins.bool] = None,
                 disk_autoresize_limit: Optional[builtins.int] = None,
                 disk_size: Optional[builtins.int] = None,
                 disk_type: Optional[builtins.str] = None,
                 edition: Optional[builtins.str] = None,
                 enable_dataplex_integration: Optional[builtins.bool] = None,
                 enable_google_ml_integration: Optional[builtins.bool] = None,
                 insights_config: Optional['outputs.DatabaseInstanceSettingsInsightsConfig'] = None,
                 ip_configuration: Optional['outputs.DatabaseInstanceSettingsIpConfiguration'] = None,
                 location_preference: Optional['outputs.DatabaseInstanceSettingsLocationPreference'] = None,
                 maintenance_window: Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow'] = None,
                 password_validation_policy: Optional['outputs.DatabaseInstanceSettingsPasswordValidationPolicy'] = None,
                 pricing_plan: Optional[builtins.str] = None,
                 retain_backups_on_delete: Optional[builtins.bool] = None,
                 sql_server_audit_config: Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig'] = None,
                 time_zone: Optional[builtins.str] = None,
                 user_labels: Optional[Mapping[str, builtins.str]] = None,
                 version: Optional[builtins.int] = None):
        """
        :param builtins.str tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param builtins.str activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param builtins.str availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
               `settings.backup_configuration.enabled` is set to `true`.
               For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
               For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
               is set to `true`. Defaults to `ZONAL`.
        :param builtins.str collation: The name of server instance collation.
        :param Sequence['DatabaseInstanceSettingsConnectionPoolConfigArgs'] connection_pool_configs: The managed connection pool setting for a Cloud SQL instance.
        :param builtins.str connector_enforcement: Control the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections, can be `REQUIRED` or `NOT_REQUIRED`. If enabled, all the direct connections are rejected.
        :param 'DatabaseInstanceSettingsDataCacheConfigArgs' data_cache_config: Data cache configurations.
        :param builtins.int data_disk_provisioned_iops: Provisioned number of I/O operations per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        :param builtins.int data_disk_provisioned_throughput: Provisioned throughput measured in MiB per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        :param builtins.bool deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param builtins.bool disk_autoresize: Enables auto-resizing of the storage size. Defaults to `true`. Note that if `disk_size` is set, future `pulumi up` calls will attempt to delete the instance in order to resize the disk to the value specified in disk_size if it has been resized. To avoid this, ensure that `lifecycle.ignore_changes` is applied to `disk_size`.
        :param builtins.int disk_autoresize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param builtins.int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED. Note that this value will override the resizing from `disk_autoresize` if that feature is enabled. To avoid this, set `lifecycle.ignore_changes` on this field.
        :param builtins.str disk_type: The type of data disk: PD_SSD, PD_HDD, or HYPERDISK_BALANCED. Defaults to `PD_SSD`. HYPERDISK_BALANCED is preview.
        :param builtins.str edition: The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        :param builtins.bool enable_dataplex_integration: Enables [Cloud SQL instance integration with Dataplex](https://cloud.google.com/sql/docs/mysql/dataplex-catalog-integration). MySQL, Postgres and SQL Server instances are supported for this feature. Defaults to `false`.
        :param builtins.bool enable_google_ml_integration: Enables [Cloud SQL instances to connect to Vertex AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai) and pass requests for real-time predictions and insights. Defaults to `false`.
        :param 'DatabaseInstanceSettingsInsightsConfigArgs' insights_config: Configuration of Query Insights.
        :param 'DatabaseInstanceSettingsMaintenanceWindowArgs' maintenance_window: Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        :param builtins.str pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param builtins.bool retain_backups_on_delete: When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The `ON_DEMAND` backup will be retained until customer deletes the backup or the project. The `AUTOMATED` backup will be retained based on the backups retention setting.
        :param builtins.str time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param Mapping[str, builtins.str] user_labels: A set of key/value user label pairs to assign to the instance.
        :param builtins.int version: Used to make sure changes to the `settings` block are
               atomic.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if connection_pool_configs is not None:
            pulumi.set(__self__, "connection_pool_configs", connection_pool_configs)
        if connector_enforcement is not None:
            pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        if data_cache_config is not None:
            pulumi.set(__self__, "data_cache_config", data_cache_config)
        if data_disk_provisioned_iops is not None:
            pulumi.set(__self__, "data_disk_provisioned_iops", data_disk_provisioned_iops)
        if data_disk_provisioned_throughput is not None:
            pulumi.set(__self__, "data_disk_provisioned_throughput", data_disk_provisioned_throughput)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deny_maintenance_period is not None:
            pulumi.set(__self__, "deny_maintenance_period", deny_maintenance_period)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_autoresize_limit is not None:
            pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if enable_dataplex_integration is not None:
            pulumi.set(__self__, "enable_dataplex_integration", enable_dataplex_integration)
        if enable_google_ml_integration is not None:
            pulumi.set(__self__, "enable_google_ml_integration", enable_google_ml_integration)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if password_validation_policy is not None:
            pulumi.set(__self__, "password_validation_policy", password_validation_policy)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if retain_backups_on_delete is not None:
            pulumi.set(__self__, "retain_backups_on_delete", retain_backups_on_delete)
        if sql_server_audit_config is not None:
            pulumi.set(__self__, "sql_server_audit_config", sql_server_audit_config)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[builtins.str]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig']:
        return pulumi.get(self, "active_directory_config")

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional['outputs.DatabaseInstanceSettingsAdvancedMachineFeatures']:
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[builtins.str]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`. Defaults to `ZONAL`.
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfiguration']:
        return pulumi.get(self, "backup_configuration")

    @property
    @pulumi.getter
    def collation(self) -> Optional[builtins.str]:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="connectionPoolConfigs")
    def connection_pool_configs(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfig']]:
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        return pulumi.get(self, "connection_pool_configs")

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> Optional[builtins.str]:
        """
        Control the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections, can be `REQUIRED` or `NOT_REQUIRED`. If enabled, all the direct connections are rejected.
        """
        return pulumi.get(self, "connector_enforcement")

    @property
    @pulumi.getter(name="dataCacheConfig")
    def data_cache_config(self) -> Optional['outputs.DatabaseInstanceSettingsDataCacheConfig']:
        """
        Data cache configurations.
        """
        return pulumi.get(self, "data_cache_config")

    @property
    @pulumi.getter(name="dataDiskProvisionedIops")
    def data_disk_provisioned_iops(self) -> Optional[builtins.int]:
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_iops")

    @property
    @pulumi.getter(name="dataDiskProvisionedThroughput")
    def data_disk_provisioned_throughput(self) -> Optional[builtins.int]:
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_throughput")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']]:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[builtins.bool]:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> Optional['outputs.DatabaseInstanceSettingsDenyMaintenancePeriod']:
        return pulumi.get(self, "deny_maintenance_period")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[builtins.bool]:
        """
        Enables auto-resizing of the storage size. Defaults to `true`. Note that if `disk_size` is set, future `pulumi up` calls will attempt to delete the instance in order to resize the disk to the value specified in disk_size if it has been resized. To avoid this, ensure that `lifecycle.ignore_changes` is applied to `disk_size`.
        """
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> Optional[builtins.int]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[builtins.int]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED. Note that this value will override the resizing from `disk_autoresize` if that feature is enabled. To avoid this, set `lifecycle.ignore_changes` on this field.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[builtins.str]:
        """
        The type of data disk: PD_SSD, PD_HDD, or HYPERDISK_BALANCED. Defaults to `PD_SSD`. HYPERDISK_BALANCED is preview.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def edition(self) -> Optional[builtins.str]:
        """
        The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="enableDataplexIntegration")
    def enable_dataplex_integration(self) -> Optional[builtins.bool]:
        """
        Enables [Cloud SQL instance integration with Dataplex](https://cloud.google.com/sql/docs/mysql/dataplex-catalog-integration). MySQL, Postgres and SQL Server instances are supported for this feature. Defaults to `false`.
        """
        return pulumi.get(self, "enable_dataplex_integration")

    @property
    @pulumi.getter(name="enableGoogleMlIntegration")
    def enable_google_ml_integration(self) -> Optional[builtins.bool]:
        """
        Enables [Cloud SQL instances to connect to Vertex AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai) and pass requests for real-time predictions and insights. Defaults to `false`.
        """
        return pulumi.get(self, "enable_google_ml_integration")

    @property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional['outputs.DatabaseInstanceSettingsInsightsConfig']:
        """
        Configuration of Query Insights.
        """
        return pulumi.get(self, "insights_config")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsIpConfiguration']:
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional['outputs.DatabaseInstanceSettingsLocationPreference']:
        return pulumi.get(self, "location_preference")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow']:
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="passwordValidationPolicy")
    def password_validation_policy(self) -> Optional['outputs.DatabaseInstanceSettingsPasswordValidationPolicy']:
        return pulumi.get(self, "password_validation_policy")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[builtins.str]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="retainBackupsOnDelete")
    def retain_backups_on_delete(self) -> Optional[builtins.bool]:
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The `ON_DEMAND` backup will be retained until customer deletes the backup or the project. The `AUTOMATED` backup will be retained based on the backups retention setting.
        """
        return pulumi.get(self, "retain_backups_on_delete")

    @property
    @pulumi.getter(name="sqlServerAuditConfig")
    def sql_server_audit_config(self) -> Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig']:
        return pulumi.get(self, "sql_server_audit_config")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[builtins.str]:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.int]:
        """
        Used to make sure changes to the `settings` block are
        atomic.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DatabaseInstanceSettingsActiveDirectoryConfig(dict):
    def __init__(__self__, *,
                 domain: builtins.str):
        """
        :param builtins.str domain: The domain name for the active directory (e.g., mydomain.com).
               Can only be used with SQL Server.
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class DatabaseInstanceSettingsAdvancedMachineFeatures(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "threadsPerCore":
            suggest = "threads_per_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsAdvancedMachineFeatures. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsAdvancedMachineFeatures.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsAdvancedMachineFeatures.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 threads_per_core: Optional[builtins.int] = None):
        """
        :param builtins.int threads_per_core: The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        if threads_per_core is not None:
            pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> Optional[builtins.int]:
        """
        The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRetentionSettings":
            suggest = "backup_retention_settings"
        elif key == "binaryLogEnabled":
            suggest = "binary_log_enabled"
        elif key == "pointInTimeRecoveryEnabled":
            suggest = "point_in_time_recovery_enabled"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "transactionLogRetentionDays":
            suggest = "transaction_log_retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_retention_settings: Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings'] = None,
                 binary_log_enabled: Optional[builtins.bool] = None,
                 enabled: Optional[builtins.bool] = None,
                 location: Optional[builtins.str] = None,
                 point_in_time_recovery_enabled: Optional[builtins.bool] = None,
                 start_time: Optional[builtins.str] = None,
                 transaction_log_retention_days: Optional[builtins.int] = None):
        """
        :param 'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs' backup_retention_settings: Backup retention settings. The configuration is detailed below.
        :param builtins.bool binary_log_enabled: True if binary logging is enabled.
               Can only be used with MySQL.
        :param builtins.bool enabled: True if backup configuration is enabled.
        :param builtins.str location: The region where the backup will be stored
        :param builtins.bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances. Enabled by default for PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances.
        :param builtins.str start_time: `HH:MM` format time indicating when backup
               configuration starts.
        :param builtins.int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7. For PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances, the number of days of retained transaction logs can be set from 1 to 35.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings']:
        """
        Backup retention settings. The configuration is detailed below.
        """
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[builtins.bool]:
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The region where the backup will be stored
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[builtins.bool]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances. Enabled by default for PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[builtins.int]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. For PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances, the number of days of retained transaction logs can be set from 1 to 35.
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainedBackups":
            suggest = "retained_backups"
        elif key == "retentionUnit":
            suggest = "retention_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retained_backups: builtins.int,
                 retention_unit: Optional[builtins.str] = None):
        """
        :param builtins.int retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
               is 'COUNT', we will retain this many backups.
        :param builtins.str retention_unit: The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> builtins.int:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[builtins.str]:
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class DatabaseInstanceSettingsConnectionPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionPoolingEnabled":
            suggest = "connection_pooling_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsConnectionPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsConnectionPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsConnectionPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_pooling_enabled: Optional[builtins.bool] = None,
                 flags: Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfigFlag']] = None):
        """
        :param builtins.bool connection_pooling_enabled: True if the manager connection pooling configuration is enabled.
        :param Sequence['DatabaseInstanceSettingsConnectionPoolConfigFlagArgs'] flags: List of connection pool configuration flags
        """
        if connection_pooling_enabled is not None:
            pulumi.set(__self__, "connection_pooling_enabled", connection_pooling_enabled)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="connectionPoolingEnabled")
    def connection_pooling_enabled(self) -> Optional[builtins.bool]:
        """
        True if the manager connection pooling configuration is enabled.
        """
        return pulumi.get(self, "connection_pooling_enabled")

    @property
    @pulumi.getter
    def flags(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsConnectionPoolConfigFlag']]:
        """
        List of connection pool configuration flags
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class DatabaseInstanceSettingsConnectionPoolConfigFlag(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the flag.
        :param builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatabaseInstanceSettingsDataCacheConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCacheEnabled":
            suggest = "data_cache_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsDataCacheConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsDataCacheConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsDataCacheConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_cache_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool data_cache_enabled: Whether data cache is enabled for the instance. Defaults to `false`. Can be used with MYSQL and PostgreSQL only.
        """
        if data_cache_enabled is not None:
            pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> Optional[builtins.bool]:
        """
        Whether data cache is enabled for the instance. Defaults to `false`. Can be used with MYSQL and PostgreSQL only.
        """
        return pulumi.get(self, "data_cache_enabled")


@pulumi.output_type
class DatabaseInstanceSettingsDatabaseFlag(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the flag.
        :param builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatabaseInstanceSettingsDenyMaintenancePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsDenyMaintenancePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsDenyMaintenancePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsDenyMaintenancePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: builtins.str,
                 start_date: builtins.str,
                 time: builtins.str):
        """
        :param builtins.str end_date: "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        :param builtins.str start_date: "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        :param builtins.str time: Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> builtins.str:
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> builtins.str:
        """
        Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class DatabaseInstanceSettingsInsightsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryInsightsEnabled":
            suggest = "query_insights_enabled"
        elif key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "queryStringLength":
            suggest = "query_string_length"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "recordClientAddress":
            suggest = "record_client_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsInsightsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_insights_enabled: Optional[builtins.bool] = None,
                 query_plans_per_minute: Optional[builtins.int] = None,
                 query_string_length: Optional[builtins.int] = None,
                 record_application_tags: Optional[builtins.bool] = None,
                 record_client_address: Optional[builtins.bool] = None):
        """
        :param builtins.bool query_insights_enabled: True if Query Insights feature is enabled.
        :param builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        :param builtins.int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        :param builtins.bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param builtins.bool record_client_address: True if Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[builtins.bool]:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[builtins.int]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[builtins.int]:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        """
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[builtins.bool]:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[builtins.bool]:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "authorizedNetworks":
            suggest = "authorized_networks"
        elif key == "customSubjectAlternativeNames":
            suggest = "custom_subject_alternative_names"
        elif key == "enablePrivatePathForGoogleCloudServices":
            suggest = "enable_private_path_for_google_cloud_services"
        elif key == "ipv4Enabled":
            suggest = "ipv4_enabled"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "pscConfigs":
            suggest = "psc_configs"
        elif key == "serverCaMode":
            suggest = "server_ca_mode"
        elif key == "serverCaPool":
            suggest = "server_ca_pool"
        elif key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range: Optional[builtins.str] = None,
                 authorized_networks: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']] = None,
                 custom_subject_alternative_names: Optional[Sequence[builtins.str]] = None,
                 enable_private_path_for_google_cloud_services: Optional[builtins.bool] = None,
                 ipv4_enabled: Optional[builtins.bool] = None,
                 private_network: Optional[builtins.str] = None,
                 psc_configs: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfig']] = None,
                 server_ca_mode: Optional[builtins.str] = None,
                 server_ca_pool: Optional[builtins.str] = None,
                 ssl_mode: Optional[builtins.str] = None):
        """
        :param builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[builtins.str] custom_subject_alternative_names: The custom subject alternative names for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        :param builtins.bool enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param builtins.bool ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. At least `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param builtins.str private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param Sequence['DatabaseInstanceSettingsIpConfigurationPscConfigArgs'] psc_configs: PSC settings for a Cloud SQL instance.
        :param builtins.str server_ca_mode: Specify how the server certificate's Certificate Authority is hosted. Supported values are `GOOGLE_MANAGED_INTERNAL_CA` and `GOOGLE_MANAGED_CAS_CA`.
        :param builtins.str server_ca_pool: The resource name of the server CA pool for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        :param builtins.str ssl_mode: Specify how SSL connection should be enforced in DB connections. Supported values are `ALLOW_UNENCRYPTED_AND_ENCRYPTED`, `ENCRYPTED_ONLY`, and `TRUSTED_CLIENT_CERTIFICATE_REQUIRED` (not supported for SQL Server). See [API reference doc](https://cloud.google.com/sql/docs/postgres/admin-api/rest/v1/instances#ipconfiguration) for details.
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if custom_subject_alternative_names is not None:
            pulumi.set(__self__, "custom_subject_alternative_names", custom_subject_alternative_names)
        if enable_private_path_for_google_cloud_services is not None:
            pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if psc_configs is not None:
            pulumi.set(__self__, "psc_configs", psc_configs)
        if server_ca_mode is not None:
            pulumi.set(__self__, "server_ca_mode", server_ca_mode)
        if server_ca_pool is not None:
            pulumi.set(__self__, "server_ca_pool", server_ca_pool)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[builtins.str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']]:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="customSubjectAlternativeNames")
    def custom_subject_alternative_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The custom subject alternative names for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        return pulumi.get(self, "custom_subject_alternative_names")

    @property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> Optional[builtins.bool]:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[builtins.bool]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[builtins.str]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfig']]:
        """
        PSC settings for a Cloud SQL instance.
        """
        return pulumi.get(self, "psc_configs")

    @property
    @pulumi.getter(name="serverCaMode")
    def server_ca_mode(self) -> Optional[builtins.str]:
        """
        Specify how the server certificate's Certificate Authority is hosted. Supported values are `GOOGLE_MANAGED_INTERNAL_CA` and `GOOGLE_MANAGED_CAS_CA`.
        """
        return pulumi.get(self, "server_ca_mode")

    @property
    @pulumi.getter(name="serverCaPool")
    def server_ca_pool(self) -> Optional[builtins.str]:
        """
        The resource name of the server CA pool for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        return pulumi.get(self, "server_ca_pool")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[builtins.str]:
        """
        Specify how SSL connection should be enforced in DB connections. Supported values are `ALLOW_UNENCRYPTED_AND_ENCRYPTED`, `ENCRYPTED_ONLY`, and `TRUSTED_CLIENT_CERTIFICATE_REQUIRED` (not supported for SQL Server). See [API reference doc](https://cloud.google.com/sql/docs/postgres/admin-api/rest/v1/instances#ipconfiguration) for details.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: builtins.str,
                 expiration_time: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param builtins.str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param builtins.str name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[builtins.str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationPscConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedConsumerProjects":
            suggest = "allowed_consumer_projects"
        elif key == "pscAutoConnections":
            suggest = "psc_auto_connections"
        elif key == "pscEnabled":
            suggest = "psc_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationPscConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_consumer_projects: Optional[Sequence[builtins.str]] = None,
                 psc_auto_connections: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection']] = None,
                 psc_enabled: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] allowed_consumer_projects: List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        :param Sequence['DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs'] psc_auto_connections: A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        :param builtins.bool psc_enabled: Whether PSC connectivity is enabled for this instance.
        """
        if allowed_consumer_projects is not None:
            pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        if psc_auto_connections is not None:
            pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        if psc_enabled is not None:
            pulumi.set(__self__, "psc_enabled", psc_enabled)

    @property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Optional[Sequence[builtins.str]]:
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection']]:
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        return pulumi.get(self, "psc_auto_connections")

    @property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> Optional[builtins.bool]:
        """
        Whether PSC connectivity is enabled for this instance.
        """
        return pulumi.get(self, "psc_enabled")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerNetwork":
            suggest = "consumer_network"
        elif key == "consumerServiceProjectId":
            suggest = "consumer_service_project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_network: builtins.str,
                 consumer_service_project_id: Optional[builtins.str] = None):
        """
        :param builtins.str consumer_network: "The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. For example, `projects/project1/global/networks/network1`. The consumer host project of this network might be different from the consumer service project."
        :param builtins.str consumer_service_project_id: The project ID of consumer service project of this consumer endpoint.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        if consumer_service_project_id is not None:
            pulumi.set(__self__, "consumer_service_project_id", consumer_service_project_id)

    @property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> builtins.str:
        """
        "The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. For example, `projects/project1/global/networks/network1`. The consumer host project of this network might be different from the consumer service project."
        """
        return pulumi.get(self, "consumer_network")

    @property
    @pulumi.getter(name="consumerServiceProjectId")
    def consumer_service_project_id(self) -> Optional[builtins.str]:
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        return pulumi.get(self, "consumer_service_project_id")


@pulumi.output_type
class DatabaseInstanceSettingsLocationPreference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followGaeApplication":
            suggest = "follow_gae_application"
        elif key == "secondaryZone":
            suggest = "secondary_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsLocationPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 follow_gae_application: Optional[builtins.str] = None,
                 secondary_zone: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param builtins.str secondary_zone: The preferred Compute Engine zone for the secondary/failover.
        :param builtins.str zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[builtins.str]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[builtins.str]:
        """
        The preferred Compute Engine zone for the secondary/failover.
        """
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DatabaseInstanceSettingsMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTrack":
            suggest = "update_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: Optional[builtins.int] = None,
                 hour: Optional[builtins.int] = None,
                 update_track: Optional[builtins.str] = None):
        """
        :param builtins.int day: Day of week (`1-7`), starting on Monday
        :param builtins.int hour: Hour of day (`0-23`), ignored if `day` not set
        :param builtins.str update_track: Receive updates after one week (`canary`) or after two weeks (`stable`) or after five weeks (`week5`) of notification.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[builtins.int]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> Optional[builtins.int]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[builtins.str]:
        """
        Receive updates after one week (`canary`) or after two weeks (`stable`) or after five weeks (`week5`) of notification.
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class DatabaseInstanceSettingsPasswordValidationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePasswordPolicy":
            suggest = "enable_password_policy"
        elif key == "disallowUsernameSubstring":
            suggest = "disallow_username_substring"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "passwordChangeInterval":
            suggest = "password_change_interval"
        elif key == "reuseInterval":
            suggest = "reuse_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsPasswordValidationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsPasswordValidationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsPasswordValidationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_password_policy: builtins.bool,
                 complexity: Optional[builtins.str] = None,
                 disallow_username_substring: Optional[builtins.bool] = None,
                 min_length: Optional[builtins.int] = None,
                 password_change_interval: Optional[builtins.str] = None,
                 reuse_interval: Optional[builtins.int] = None):
        """
        :param builtins.bool enable_password_policy: Enables or disable the password validation policy.
        :param builtins.str complexity: Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        :param builtins.bool disallow_username_substring: Prevents the use of the username in the password.
        :param builtins.int min_length: Specifies the minimum number of characters that the password must have.
        :param builtins.str password_change_interval: Specifies the minimum duration after which you can change the password.
        :param builtins.int reuse_interval: Specifies the number of previous passwords that you can't reuse.
        """
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if disallow_username_substring is not None:
            pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if password_change_interval is not None:
            pulumi.set(__self__, "password_change_interval", password_change_interval)
        if reuse_interval is not None:
            pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> builtins.bool:
        """
        Enables or disable the password validation policy.
        """
        return pulumi.get(self, "enable_password_policy")

    @property
    @pulumi.getter
    def complexity(self) -> Optional[builtins.str]:
        """
        Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> Optional[builtins.bool]:
        """
        Prevents the use of the username in the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[builtins.int]:
        """
        Specifies the minimum number of characters that the password must have.
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> Optional[builtins.str]:
        """
        Specifies the minimum duration after which you can change the password.
        """
        return pulumi.get(self, "password_change_interval")

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> Optional[builtins.int]:
        """
        Specifies the number of previous passwords that you can't reuse.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class DatabaseInstanceSettingsSqlServerAuditConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInterval":
            suggest = "retention_interval"
        elif key == "uploadInterval":
            suggest = "upload_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsSqlServerAuditConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 retention_interval: Optional[builtins.str] = None,
                 upload_interval: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param builtins.str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param builtins.str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if retention_interval is not None:
            pulumi.set(__self__, "retention_interval", retention_interval)
        if upload_interval is not None:
            pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> Optional[builtins.str]:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> Optional[builtins.str]:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class UserPasswordPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedFailedAttempts":
            suggest = "allowed_failed_attempts"
        elif key == "enableFailedAttemptsCheck":
            suggest = "enable_failed_attempts_check"
        elif key == "enablePasswordVerification":
            suggest = "enable_password_verification"
        elif key == "passwordExpirationDuration":
            suggest = "password_expiration_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_failed_attempts: Optional[builtins.int] = None,
                 enable_failed_attempts_check: Optional[builtins.bool] = None,
                 enable_password_verification: Optional[builtins.bool] = None,
                 password_expiration_duration: Optional[builtins.str] = None,
                 statuses: Optional[Sequence['outputs.UserPasswordPolicyStatus']] = None):
        """
        :param builtins.int allowed_failed_attempts: Number of failed attempts allowed before the user get locked.
        :param builtins.bool enable_failed_attempts_check: If true, the check that will lock user after too many failed login attempts will be enabled.
        :param builtins.bool enable_password_verification: If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        :param builtins.str password_expiration_duration: Password expiration duration with one week grace period.
        """
        if allowed_failed_attempts is not None:
            pulumi.set(__self__, "allowed_failed_attempts", allowed_failed_attempts)
        if enable_failed_attempts_check is not None:
            pulumi.set(__self__, "enable_failed_attempts_check", enable_failed_attempts_check)
        if enable_password_verification is not None:
            pulumi.set(__self__, "enable_password_verification", enable_password_verification)
        if password_expiration_duration is not None:
            pulumi.set(__self__, "password_expiration_duration", password_expiration_duration)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="allowedFailedAttempts")
    def allowed_failed_attempts(self) -> Optional[builtins.int]:
        """
        Number of failed attempts allowed before the user get locked.
        """
        return pulumi.get(self, "allowed_failed_attempts")

    @property
    @pulumi.getter(name="enableFailedAttemptsCheck")
    def enable_failed_attempts_check(self) -> Optional[builtins.bool]:
        """
        If true, the check that will lock user after too many failed login attempts will be enabled.
        """
        return pulumi.get(self, "enable_failed_attempts_check")

    @property
    @pulumi.getter(name="enablePasswordVerification")
    def enable_password_verification(self) -> Optional[builtins.bool]:
        """
        If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        """
        return pulumi.get(self, "enable_password_verification")

    @property
    @pulumi.getter(name="passwordExpirationDuration")
    def password_expiration_duration(self) -> Optional[builtins.str]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_duration")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.UserPasswordPolicyStatus']]:
        return pulumi.get(self, "statuses")


@pulumi.output_type
class UserPasswordPolicyStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordExpirationTime":
            suggest = "password_expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordPolicyStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordPolicyStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordPolicyStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locked: Optional[builtins.bool] = None,
                 password_expiration_time: Optional[builtins.str] = None):
        """
        :param builtins.bool locked: If true, user does not have login privileges.
        :param builtins.str password_expiration_time: Password expiration duration with one week grace period.
        """
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if password_expiration_time is not None:
            pulumi.set(__self__, "password_expiration_time", password_expiration_time)

    @property
    @pulumi.getter
    def locked(self) -> Optional[builtins.bool]:
        """
        If true, user does not have login privileges.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter(name="passwordExpirationTime")
    def password_expiration_time(self) -> Optional[builtins.str]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_time")


@pulumi.output_type
class UserSqlServerUserDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverRoles":
            suggest = "server_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserSqlServerUserDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserSqlServerUserDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserSqlServerUserDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[builtins.bool] = None,
                 server_roles: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool disabled: If the user has been disabled.
        :param Sequence[builtins.str] server_roles: The server roles for this user in the database.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[builtins.bool]:
        """
        If the user has been disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The server roles for this user in the database.
        """
        return pulumi.get(self, "server_roles")


@pulumi.output_type
class GetCaCertsCertResult(dict):
    def __init__(__self__, *,
                 cert: builtins.str,
                 common_name: builtins.str,
                 create_time: builtins.str,
                 expiration_time: builtins.str,
                 sha1_fingerprint: builtins.str):
        """
        :param builtins.str cert: The CA certificate used to connect to the SQL instance via SSL.
        :param builtins.str common_name: The CN valid for the CA cert.
        :param builtins.str create_time: Creation time of the CA cert.
        :param builtins.str expiration_time: Expiration time of the CA cert.
        :param builtins.str sha1_fingerprint: SHA1 fingerprint of the CA cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> builtins.str:
        """
        The CA certificate used to connect to the SQL instance via SSL.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> builtins.str:
        """
        The CN valid for the CA cert.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        Creation time of the CA cert.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        """
        Expiration time of the CA cert.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> builtins.str:
        """
        SHA1 fingerprint of the CA cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceCloneResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: builtins.str,
                 database_names: Sequence[builtins.str],
                 point_in_time: builtins.str,
                 preferred_zone: builtins.str,
                 source_instance_name: builtins.str):
        """
        :param builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[builtins.str] database_names: (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        :param builtins.str point_in_time: The timestamp of the point in time that should be restored.
        :param builtins.str preferred_zone: (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        :param builtins.str source_instance_name: The name of the instance from which the point in time should be restored.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "database_names", database_names)
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "preferred_zone", preferred_zone)
        pulumi.set(__self__, "source_instance_name", source_instance_name)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Sequence[builtins.str]:
        """
        (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> builtins.str:
        """
        The timestamp of the point in time that should be restored.
        """
        return pulumi.get(self, "point_in_time")

    @property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> builtins.str:
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        """
        return pulumi.get(self, "preferred_zone")

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> builtins.str:
        """
        The name of the instance from which the point in time should be restored.
        """
        return pulumi.get(self, "source_instance_name")


@pulumi.output_type
class GetDatabaseInstanceDnsNameResult(dict):
    def __init__(__self__, *,
                 connection_type: builtins.str,
                 dns_scope: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str name: The name of the instance.
        """
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "dns_scope", dns_scope)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> builtins.str:
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="dnsScope")
    def dns_scope(self) -> builtins.str:
        return pulumi.get(self, "dns_scope")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatabaseInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: builtins.str,
                 time_to_retire: builtins.str,
                 type: builtins.str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> builtins.str:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: builtins.str,
                 cascadable_replica: builtins.bool,
                 client_certificate: builtins.str,
                 client_key: builtins.str,
                 connect_retry_interval: builtins.int,
                 dump_file_path: builtins.str,
                 failover_target: builtins.bool,
                 master_heartbeat_period: builtins.int,
                 password: builtins.str,
                 ssl_cipher: builtins.str,
                 username: builtins.str,
                 verify_server_certificate: builtins.bool):
        """
        :param builtins.str ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param builtins.bool cascadable_replica: Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        :param builtins.str client_certificate: PEM representation of the replica's x509 certificate.
        :param builtins.str client_key: PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        :param builtins.int connect_retry_interval: The number of seconds between connect retries. MySQL's default is 60 seconds.
        :param builtins.str dump_file_path: Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        :param builtins.bool failover_target: Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        :param builtins.int master_heartbeat_period: Time in ms between replication heartbeats.
        :param builtins.str password: Password for the replication connection.
        :param builtins.str ssl_cipher: Permissible ciphers for use in SSL encryption.
        :param builtins.str username: Username for replication connection.
        :param builtins.bool verify_server_certificate: True if the master's common name value is checked during the SSL handshake.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "cascadable_replica", cascadable_replica)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> builtins.str:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="cascadableReplica")
    def cascadable_replica(self) -> builtins.bool:
        """
        Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        """
        return pulumi.get(self, "cascadable_replica")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> builtins.str:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> builtins.str:
        """
        PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> builtins.int:
        """
        The number of seconds between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> builtins.str:
        """
        Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> builtins.bool:
        """
        Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> builtins.int:
        """
        Time in ms between replication heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> builtins.str:
        """
        Permissible ciphers for use in SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> builtins.bool:
        """
        True if the master's common name value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstanceReplicationClusterResult(dict):
    def __init__(__self__, *,
                 dr_replica: builtins.bool,
                 failover_dr_replica_name: builtins.str):
        """
        :param builtins.bool dr_replica: Read-only field that indicates whether the replica is a DR replica.
        :param builtins.str failover_dr_replica_name: If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        pulumi.set(__self__, "dr_replica", dr_replica)
        pulumi.set(__self__, "failover_dr_replica_name", failover_dr_replica_name)

    @property
    @pulumi.getter(name="drReplica")
    def dr_replica(self) -> builtins.bool:
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        return pulumi.get(self, "dr_replica")

    @property
    @pulumi.getter(name="failoverDrReplicaName")
    def failover_dr_replica_name(self) -> builtins.str:
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        return pulumi.get(self, "failover_dr_replica_name")


@pulumi.output_type
class GetDatabaseInstanceRestoreBackupContextResult(dict):
    def __init__(__self__, *,
                 backup_run_id: builtins.int,
                 instance_id: builtins.str,
                 project: builtins.str):
        """
        :param builtins.int backup_run_id: The ID of the backup run to restore from.
        :param builtins.str instance_id: The ID of the instance that the backup was taken from.
        :param builtins.str project: The ID of the project in which the resource belongs.
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> builtins.int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        """
        The ID of the instance that the backup was taken from.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the resource belongs.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetDatabaseInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: builtins.str,
                 common_name: builtins.str,
                 create_time: builtins.str,
                 expiration_time: builtins.str,
                 sha1_fingerprint: builtins.str):
        """
        :param builtins.str cert: The CA Certificate used to connect to the SQL Instance via SSL.
        :param builtins.str common_name: The CN valid for the CA Cert.
        :param builtins.str create_time: Creation time of the CA Cert.
        :param builtins.str expiration_time: Expiration time of the CA Cert.
        :param builtins.str sha1_fingerprint: SHA Fingerprint of the CA Cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> builtins.str:
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> builtins.str:
        """
        The CN valid for the CA Cert.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        Creation time of the CA Cert.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        """
        Expiration time of the CA Cert.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> builtins.str:
        """
        SHA Fingerprint of the CA Cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: builtins.str,
                 active_directory_configs: Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult'],
                 advanced_machine_features: Sequence['outputs.GetDatabaseInstanceSettingAdvancedMachineFeatureResult'],
                 availability_type: builtins.str,
                 backup_configurations: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult'],
                 collation: builtins.str,
                 connection_pool_configs: Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigResult'],
                 connector_enforcement: builtins.str,
                 data_cache_configs: Sequence['outputs.GetDatabaseInstanceSettingDataCacheConfigResult'],
                 data_disk_provisioned_iops: builtins.int,
                 data_disk_provisioned_throughput: builtins.int,
                 database_flags: Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult'],
                 deletion_protection_enabled: builtins.bool,
                 deny_maintenance_periods: Sequence['outputs.GetDatabaseInstanceSettingDenyMaintenancePeriodResult'],
                 disk_autoresize: builtins.bool,
                 disk_autoresize_limit: builtins.int,
                 disk_size: builtins.int,
                 disk_type: builtins.str,
                 edition: builtins.str,
                 enable_dataplex_integration: builtins.bool,
                 enable_google_ml_integration: builtins.bool,
                 insights_configs: Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult'],
                 ip_configurations: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult'],
                 location_preferences: Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult'],
                 password_validation_policies: Sequence['outputs.GetDatabaseInstanceSettingPasswordValidationPolicyResult'],
                 pricing_plan: builtins.str,
                 retain_backups_on_delete: builtins.bool,
                 sql_server_audit_configs: Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult'],
                 tier: builtins.str,
                 time_zone: builtins.str,
                 user_labels: Mapping[str, builtins.str],
                 version: builtins.int):
        """
        :param builtins.str activation_policy: This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        :param builtins.str availability_type: The availability type of the Cloud SQL instance, high availability
               (REGIONAL) or single zone (ZONAL). For all instances, ensure that
               settings.backup_configuration.enabled is set to true.
               For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
               For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
               is set to true. Defaults to ZONAL.
        :param builtins.str collation: The name of server instance collation.
        :param Sequence['GetDatabaseInstanceSettingConnectionPoolConfigArgs'] connection_pool_configs: The managed connection pool setting for a Cloud SQL instance.
        :param builtins.str connector_enforcement: Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        :param Sequence['GetDatabaseInstanceSettingDataCacheConfigArgs'] data_cache_configs: Data cache configurations.
        :param builtins.int data_disk_provisioned_iops: Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param builtins.int data_disk_provisioned_throughput: Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param builtins.bool deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param builtins.bool disk_autoresize: Enables auto-resizing of the storage size. Defaults to true.
        :param builtins.int disk_autoresize_limit: The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param builtins.int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        :param builtins.str disk_type: The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        :param builtins.str edition: The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        :param builtins.bool enable_dataplex_integration: Enables Dataplex Integration.
        :param builtins.bool enable_google_ml_integration: Enables Vertex AI Integration.
        :param Sequence['GetDatabaseInstanceSettingInsightsConfigArgs'] insights_configs: Configuration of Query Insights.
        :param Sequence['GetDatabaseInstanceSettingMaintenanceWindowArgs'] maintenance_windows: Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        :param builtins.str pricing_plan: Pricing plan for this instance, can only be PER_USE.
        :param builtins.bool retain_backups_on_delete: When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        :param builtins.str tier: The machine type to use. See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
        :param builtins.str time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param Mapping[str, builtins.str] user_labels: A set of key/value user label pairs to assign to the instance.
        :param builtins.int version: Used to make sure changes to the settings block are atomic.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "connection_pool_configs", connection_pool_configs)
        pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        pulumi.set(__self__, "data_cache_configs", data_cache_configs)
        pulumi.set(__self__, "data_disk_provisioned_iops", data_disk_provisioned_iops)
        pulumi.set(__self__, "data_disk_provisioned_throughput", data_disk_provisioned_throughput)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "enable_dataplex_integration", enable_dataplex_integration)
        pulumi.set(__self__, "enable_google_ml_integration", enable_google_ml_integration)
        pulumi.set(__self__, "insights_configs", insights_configs)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "password_validation_policies", password_validation_policies)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "retain_backups_on_delete", retain_backups_on_delete)
        pulumi.set(__self__, "sql_server_audit_configs", sql_server_audit_configs)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> builtins.str:
        """
        This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult']:
        return pulumi.get(self, "active_directory_configs")

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Sequence['outputs.GetDatabaseInstanceSettingAdvancedMachineFeatureResult']:
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> builtins.str:
        """
        The availability type of the Cloud SQL instance, high availability
        (REGIONAL) or single zone (ZONAL). For all instances, ensure that
        settings.backup_configuration.enabled is set to true.
        For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
        For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
        is set to true. Defaults to ZONAL.
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @property
    @pulumi.getter
    def collation(self) -> builtins.str:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="connectionPoolConfigs")
    def connection_pool_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigResult']:
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        return pulumi.get(self, "connection_pool_configs")

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> builtins.str:
        """
        Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        """
        return pulumi.get(self, "connector_enforcement")

    @property
    @pulumi.getter(name="dataCacheConfigs")
    def data_cache_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingDataCacheConfigResult']:
        """
        Data cache configurations.
        """
        return pulumi.get(self, "data_cache_configs")

    @property
    @pulumi.getter(name="dataDiskProvisionedIops")
    def data_disk_provisioned_iops(self) -> builtins.int:
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_iops")

    @property
    @pulumi.getter(name="dataDiskProvisionedThroughput")
    def data_disk_provisioned_throughput(self) -> builtins.int:
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_throughput")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> builtins.bool:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Sequence['outputs.GetDatabaseInstanceSettingDenyMaintenancePeriodResult']:
        return pulumi.get(self, "deny_maintenance_periods")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> builtins.bool:
        """
        Enables auto-resizing of the storage size. Defaults to true.
        """
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> builtins.int:
        """
        The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> builtins.int:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> builtins.str:
        """
        The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def edition(self) -> builtins.str:
        """
        The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="enableDataplexIntegration")
    def enable_dataplex_integration(self) -> builtins.bool:
        """
        Enables Dataplex Integration.
        """
        return pulumi.get(self, "enable_dataplex_integration")

    @property
    @pulumi.getter(name="enableGoogleMlIntegration")
    def enable_google_ml_integration(self) -> builtins.bool:
        """
        Enables Vertex AI Integration.
        """
        return pulumi.get(self, "enable_google_ml_integration")

    @property
    @pulumi.getter(name="insightsConfigs")
    def insights_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult']:
        """
        Configuration of Query Insights.
        """
        return pulumi.get(self, "insights_configs")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult']:
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="passwordValidationPolicies")
    def password_validation_policies(self) -> Sequence['outputs.GetDatabaseInstanceSettingPasswordValidationPolicyResult']:
        return pulumi.get(self, "password_validation_policies")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> builtins.str:
        """
        Pricing plan for this instance, can only be PER_USE.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="retainBackupsOnDelete")
    def retain_backups_on_delete(self) -> builtins.bool:
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        """
        return pulumi.get(self, "retain_backups_on_delete")

    @property
    @pulumi.getter(name="sqlServerAuditConfigs")
    def sql_server_audit_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult']:
        return pulumi.get(self, "sql_server_audit_configs")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        """
        The machine type to use. See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, builtins.str]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        Used to make sure changes to the settings block are atomic.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstanceSettingActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain: builtins.str):
        """
        :param builtins.str domain: Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetDatabaseInstanceSettingAdvancedMachineFeatureResult(dict):
    def __init__(__self__, *,
                 threads_per_core: builtins.int):
        """
        :param builtins.int threads_per_core: The number of threads per physical core. Can be 1 or 2.
        """
        pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> builtins.int:
        """
        The number of threads per physical core. Can be 1 or 2.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 backup_retention_settings: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult'],
                 binary_log_enabled: builtins.bool,
                 enabled: builtins.bool,
                 location: builtins.str,
                 point_in_time_recovery_enabled: builtins.bool,
                 start_time: builtins.str,
                 transaction_log_retention_days: builtins.int):
        """
        :param builtins.bool binary_log_enabled: True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        :param builtins.bool enabled: True if backup configuration is enabled.
        :param builtins.str location: Location of the backup configuration.
        :param builtins.bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled.
        :param builtins.str start_time: HH:MM format time indicating when backup configuration starts.
        :param builtins.int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult']:
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> builtins.bool:
        """
        True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Location of the backup configuration.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> builtins.bool:
        """
        True if Point-in-time recovery is enabled.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        HH:MM format time indicating when backup configuration starts.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> builtins.int:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult(dict):
    def __init__(__self__, *,
                 retained_backups: builtins.int,
                 retention_unit: builtins.str):
        """
        :param builtins.int retained_backups: Number of backups to retain.
        :param builtins.str retention_unit: The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> builtins.int:
        """
        Number of backups to retain.
        """
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> builtins.str:
        """
        The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class GetDatabaseInstanceSettingConnectionPoolConfigResult(dict):
    def __init__(__self__, *,
                 connection_pooling_enabled: builtins.bool,
                 flags: Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigFlagResult']):
        """
        :param builtins.bool connection_pooling_enabled: Whether Managed Connection Pool is enabled for this instance.
        :param Sequence['GetDatabaseInstanceSettingConnectionPoolConfigFlagArgs'] flags: List of connection pool configuration flags
        """
        pulumi.set(__self__, "connection_pooling_enabled", connection_pooling_enabled)
        pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="connectionPoolingEnabled")
    def connection_pooling_enabled(self) -> builtins.bool:
        """
        Whether Managed Connection Pool is enabled for this instance.
        """
        return pulumi.get(self, "connection_pooling_enabled")

    @property
    @pulumi.getter
    def flags(self) -> Sequence['outputs.GetDatabaseInstanceSettingConnectionPoolConfigFlagResult']:
        """
        List of connection pool configuration flags
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class GetDatabaseInstanceSettingConnectionPoolConfigFlagResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the instance.
        :param builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingDataCacheConfigResult(dict):
    def __init__(__self__, *,
                 data_cache_enabled: builtins.bool):
        """
        :param builtins.bool data_cache_enabled: Whether data cache is enabled for the instance.
        """
        pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> builtins.bool:
        """
        Whether data cache is enabled for the instance.
        """
        return pulumi.get(self, "data_cache_enabled")


@pulumi.output_type
class GetDatabaseInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the instance.
        :param builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingDenyMaintenancePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: builtins.str,
                 start_date: builtins.str,
                 time: builtins.str):
        """
        :param builtins.str end_date: End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param builtins.str start_date: Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param builtins.str time: Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> builtins.str:
        """
        End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        """
        Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> builtins.str:
        """
        Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class GetDatabaseInstanceSettingInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_insights_enabled: builtins.bool,
                 query_plans_per_minute: builtins.int,
                 query_string_length: builtins.int,
                 record_application_tags: builtins.bool,
                 record_client_address: builtins.bool):
        """
        :param builtins.bool query_insights_enabled: True if Query Insights feature is enabled.
        :param builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        :param builtins.int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        :param builtins.bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param builtins.bool record_client_address: True if Query Insights will record client address when enabled.
        """
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> builtins.bool:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> builtins.int:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> builtins.int:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        """
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> builtins.bool:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> builtins.bool:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: builtins.str,
                 authorized_networks: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 custom_subject_alternative_names: Sequence[builtins.str],
                 enable_private_path_for_google_cloud_services: builtins.bool,
                 ipv4_enabled: builtins.bool,
                 private_network: builtins.str,
                 psc_configs: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigResult'],
                 server_ca_mode: builtins.str,
                 server_ca_pool: builtins.str,
                 ssl_mode: builtins.str):
        """
        :param builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[builtins.str] custom_subject_alternative_names: The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param builtins.bool enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param builtins.bool ipv4_enabled: Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        :param builtins.str private_network: The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        :param Sequence['GetDatabaseInstanceSettingIpConfigurationPscConfigArgs'] psc_configs: PSC settings for a Cloud SQL instance.
        :param builtins.str server_ca_mode: Specify how the server certificate's Certificate Authority is hosted.
        :param builtins.str server_ca_pool: The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param builtins.str ssl_mode: Specify how SSL connection should be enforced in DB connections.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "custom_subject_alternative_names", custom_subject_alternative_names)
        pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "psc_configs", psc_configs)
        pulumi.set(__self__, "server_ca_mode", server_ca_mode)
        pulumi.set(__self__, "server_ca_pool", server_ca_pool)
        pulumi.set(__self__, "ssl_mode", ssl_mode)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="customSubjectAlternativeNames")
    def custom_subject_alternative_names(self) -> Sequence[builtins.str]:
        """
        The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "custom_subject_alternative_names")

    @property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> builtins.bool:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> builtins.bool:
        """
        Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> builtins.str:
        """
        The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigResult']:
        """
        PSC settings for a Cloud SQL instance.
        """
        return pulumi.get(self, "psc_configs")

    @property
    @pulumi.getter(name="serverCaMode")
    def server_ca_mode(self) -> builtins.str:
        """
        Specify how the server certificate's Certificate Authority is hosted.
        """
        return pulumi.get(self, "server_ca_mode")

    @property
    @pulumi.getter(name="serverCaPool")
    def server_ca_pool(self) -> builtins.str:
        """
        The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "server_ca_pool")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> builtins.str:
        """
        Specify how SSL connection should be enforced in DB connections.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: builtins.str,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the instance.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationPscConfigResult(dict):
    def __init__(__self__, *,
                 allowed_consumer_projects: Sequence[builtins.str],
                 psc_auto_connections: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult'],
                 psc_enabled: builtins.bool):
        """
        :param Sequence[builtins.str] allowed_consumer_projects: List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        :param Sequence['GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionArgs'] psc_auto_connections: A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        :param builtins.bool psc_enabled: Whether PSC connectivity is enabled for this instance.
        """
        pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        pulumi.set(__self__, "psc_enabled", psc_enabled)

    @property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Sequence[builtins.str]:
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult']:
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        return pulumi.get(self, "psc_auto_connections")

    @property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> builtins.bool:
        """
        Whether PSC connectivity is enabled for this instance.
        """
        return pulumi.get(self, "psc_enabled")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 consumer_network: builtins.str,
                 consumer_service_project_id: builtins.str):
        """
        :param builtins.str consumer_network: The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        :param builtins.str consumer_service_project_id: The project ID of consumer service project of this consumer endpoint.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        pulumi.set(__self__, "consumer_service_project_id", consumer_service_project_id)

    @property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> builtins.str:
        """
        The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        """
        return pulumi.get(self, "consumer_network")

    @property
    @pulumi.getter(name="consumerServiceProjectId")
    def consumer_service_project_id(self) -> builtins.str:
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        return pulumi.get(self, "consumer_service_project_id")


@pulumi.output_type
class GetDatabaseInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: builtins.str,
                 secondary_zone: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str follow_gae_application: A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        :param builtins.str secondary_zone: The preferred Compute Engine zone for the secondary/failover
        :param builtins.str zone: The preferred compute engine zone.
        """
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> builtins.str:
        """
        A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> builtins.str:
        """
        The preferred Compute Engine zone for the secondary/failover
        """
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        The preferred compute engine zone.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: builtins.int,
                 hour: builtins.int,
                 update_track: builtins.str):
        """
        :param builtins.int day: Day of week (1-7), starting on Monday
        :param builtins.int hour: Hour of day (0-23), ignored if day not set
        :param builtins.str update_track: Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> builtins.int:
        """
        Day of week (1-7), starting on Monday
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of day (0-23), ignored if day not set
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> builtins.str:
        """
        Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class GetDatabaseInstanceSettingPasswordValidationPolicyResult(dict):
    def __init__(__self__, *,
                 complexity: builtins.str,
                 disallow_username_substring: builtins.bool,
                 enable_password_policy: builtins.bool,
                 min_length: builtins.int,
                 password_change_interval: builtins.str,
                 reuse_interval: builtins.int):
        """
        :param builtins.str complexity: Password complexity.
        :param builtins.bool disallow_username_substring: Disallow username as a part of the password.
        :param builtins.bool enable_password_policy: Whether the password policy is enabled or not.
        :param builtins.int min_length: Minimum number of characters allowed.
        :param builtins.str password_change_interval: Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        :param builtins.int reuse_interval: Number of previous passwords that cannot be reused.
        """
        pulumi.set(__self__, "complexity", complexity)
        pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        pulumi.set(__self__, "min_length", min_length)
        pulumi.set(__self__, "password_change_interval", password_change_interval)
        pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter
    def complexity(self) -> builtins.str:
        """
        Password complexity.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> builtins.bool:
        """
        Disallow username as a part of the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> builtins.bool:
        """
        Whether the password policy is enabled or not.
        """
        return pulumi.get(self, "enable_password_policy")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> builtins.int:
        """
        Minimum number of characters allowed.
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> builtins.str:
        """
        Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        """
        return pulumi.get(self, "password_change_interval")

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> builtins.int:
        """
        Number of previous passwords that cannot be reused.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class GetDatabaseInstanceSettingSqlServerAuditConfigResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 retention_interval: builtins.str,
                 upload_interval: builtins.str):
        """
        :param builtins.str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param builtins.str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        :param builtins.str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> builtins.str:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        """
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> builtins.str:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class GetDatabaseInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 available_maintenance_versions: Sequence[builtins.str],
                 clones: Sequence['outputs.GetDatabaseInstancesInstanceCloneResult'],
                 connection_name: builtins.str,
                 database_version: builtins.str,
                 deletion_protection: builtins.bool,
                 dns_name: builtins.str,
                 dns_names: Sequence['outputs.GetDatabaseInstancesInstanceDnsNameResult'],
                 encryption_key_name: builtins.str,
                 first_ip_address: builtins.str,
                 instance_type: builtins.str,
                 ip_addresses: Sequence['outputs.GetDatabaseInstancesInstanceIpAddressResult'],
                 maintenance_version: builtins.str,
                 master_instance_name: builtins.str,
                 name: builtins.str,
                 private_ip_address: builtins.str,
                 project: builtins.str,
                 psc_service_attachment_link: builtins.str,
                 public_ip_address: builtins.str,
                 region: builtins.str,
                 replica_configurations: Sequence['outputs.GetDatabaseInstancesInstanceReplicaConfigurationResult'],
                 replica_names: Sequence[builtins.str],
                 replication_clusters: Sequence['outputs.GetDatabaseInstancesInstanceReplicationClusterResult'],
                 restore_backup_contexts: Sequence['outputs.GetDatabaseInstancesInstanceRestoreBackupContextResult'],
                 root_password: builtins.str,
                 self_link: builtins.str,
                 server_ca_certs: Sequence['outputs.GetDatabaseInstancesInstanceServerCaCertResult'],
                 service_account_email_address: builtins.str,
                 settings: Sequence['outputs.GetDatabaseInstancesInstanceSettingResult']):
        """
        :param Sequence[builtins.str] available_maintenance_versions: Available Maintenance versions.
        :param Sequence['GetDatabaseInstancesInstanceCloneArgs'] clones: Configuration for creating a new instance as a clone of another instance.
        :param builtins.str connection_name: The connection name of the instance to be used in connection strings. For example, when connecting with Cloud SQL Proxy.
        :param builtins.str database_version: To filter out the Cloud SQL instances which are of the specified database version.
        :param builtins.str dns_name: The instance-level dns name of the instance for PSC instances or public IP CAS instances.
        :param Sequence['GetDatabaseInstancesInstanceDnsNameArgs'] dns_names: The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        :param builtins.str instance_type: The type of the instance. The valid values are:- 'SQL_INSTANCE_TYPE_UNSPECIFIED', 'CLOUD_SQL_INSTANCE', 'ON_PREMISES_INSTANCE' and 'READ_REPLICA_INSTANCE'.
        :param builtins.str maintenance_version: Maintenance version.
        :param builtins.str master_instance_name: The name of the instance that will act as the master in the replication setup. Note, this requires the master to have binary_log_enabled set, as well as existing backups.
        :param builtins.str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        :param builtins.str psc_service_attachment_link: The link to service attachment of PSC instance.
        :param builtins.str region: To filter out the Cloud SQL instances which are located in the specified region.
        :param Sequence['GetDatabaseInstancesInstanceReplicaConfigurationArgs'] replica_configurations: The configuration for replication.
        :param Sequence[builtins.str] replica_names: The replicas of the instance.
        :param Sequence['GetDatabaseInstancesInstanceReplicationClusterArgs'] replication_clusters: A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        :param builtins.str root_password: Initial root password. Required for MS SQL Server.
        :param builtins.str self_link: The URI of the created resource.
        :param builtins.str service_account_email_address: The service account email address assigned to the instance.
        :param Sequence['GetDatabaseInstancesInstanceSettingArgs'] settings: The settings to use for the database. The configuration is detailed below.
        """
        pulumi.set(__self__, "available_maintenance_versions", available_maintenance_versions)
        pulumi.set(__self__, "clones", clones)
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "database_version", database_version)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "dns_names", dns_names)
        pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        pulumi.set(__self__, "first_ip_address", first_ip_address)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "maintenance_version", maintenance_version)
        pulumi.set(__self__, "master_instance_name", master_instance_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "psc_service_attachment_link", psc_service_attachment_link)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "replica_configurations", replica_configurations)
        pulumi.set(__self__, "replica_names", replica_names)
        pulumi.set(__self__, "replication_clusters", replication_clusters)
        pulumi.set(__self__, "restore_backup_contexts", restore_backup_contexts)
        pulumi.set(__self__, "root_password", root_password)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> Sequence[builtins.str]:
        """
        Available Maintenance versions.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @property
    @pulumi.getter
    def clones(self) -> Sequence['outputs.GetDatabaseInstancesInstanceCloneResult']:
        """
        Configuration for creating a new instance as a clone of another instance.
        """
        return pulumi.get(self, "clones")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> builtins.str:
        """
        The connection name of the instance to be used in connection strings. For example, when connecting with Cloud SQL Proxy.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> builtins.str:
        """
        To filter out the Cloud SQL instances which are of the specified database version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> builtins.bool:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> builtins.str:
        """
        The instance-level dns name of the instance for PSC instances or public IP CAS instances.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Sequence['outputs.GetDatabaseInstancesInstanceDnsNameResult']:
        """
        The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        """
        return pulumi.get(self, "dns_names")

    @property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> builtins.str:
        return pulumi.get(self, "encryption_key_name")

    @property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> builtins.str:
        return pulumi.get(self, "first_ip_address")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        """
        The type of the instance. The valid values are:- 'SQL_INSTANCE_TYPE_UNSPECIFIED', 'CLOUD_SQL_INSTANCE', 'ON_PREMISES_INSTANCE' and 'READ_REPLICA_INSTANCE'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence['outputs.GetDatabaseInstancesInstanceIpAddressResult']:
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> builtins.str:
        """
        Maintenance version.
        """
        return pulumi.get(self, "maintenance_version")

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> builtins.str:
        """
        The name of the instance that will act as the master in the replication setup. Note, this requires the master to have binary_log_enabled set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> builtins.str:
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscServiceAttachmentLink")
    def psc_service_attachment_link(self) -> builtins.str:
        """
        The link to service attachment of PSC instance.
        """
        return pulumi.get(self, "psc_service_attachment_link")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> builtins.str:
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        To filter out the Cloud SQL instances which are located in the specified region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaConfigurations")
    def replica_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceReplicaConfigurationResult']:
        """
        The configuration for replication.
        """
        return pulumi.get(self, "replica_configurations")

    @property
    @pulumi.getter(name="replicaNames")
    def replica_names(self) -> Sequence[builtins.str]:
        """
        The replicas of the instance.
        """
        return pulumi.get(self, "replica_names")

    @property
    @pulumi.getter(name="replicationClusters")
    def replication_clusters(self) -> Sequence['outputs.GetDatabaseInstancesInstanceReplicationClusterResult']:
        """
        A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        """
        return pulumi.get(self, "replication_clusters")

    @property
    @pulumi.getter(name="restoreBackupContexts")
    def restore_backup_contexts(self) -> Sequence['outputs.GetDatabaseInstancesInstanceRestoreBackupContextResult']:
        return pulumi.get(self, "restore_backup_contexts")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> builtins.str:
        """
        Initial root password. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceServerCaCertResult']:
        return pulumi.get(self, "server_ca_certs")

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> builtins.str:
        """
        The service account email address assigned to the instance.
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingResult']:
        """
        The settings to use for the database. The configuration is detailed below.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class GetDatabaseInstancesInstanceCloneResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: builtins.str,
                 database_names: Sequence[builtins.str],
                 point_in_time: builtins.str,
                 preferred_zone: builtins.str,
                 source_instance_name: builtins.str):
        """
        :param builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[builtins.str] database_names: (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        :param builtins.str point_in_time: The timestamp of the point in time that should be restored.
        :param builtins.str preferred_zone: (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        :param builtins.str source_instance_name: The name of the instance from which the point in time should be restored.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "database_names", database_names)
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "preferred_zone", preferred_zone)
        pulumi.set(__self__, "source_instance_name", source_instance_name)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Sequence[builtins.str]:
        """
        (SQL Server only, use with point_in_time) clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> builtins.str:
        """
        The timestamp of the point in time that should be restored.
        """
        return pulumi.get(self, "point_in_time")

    @property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> builtins.str:
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance.
        """
        return pulumi.get(self, "preferred_zone")

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> builtins.str:
        """
        The name of the instance from which the point in time should be restored.
        """
        return pulumi.get(self, "source_instance_name")


@pulumi.output_type
class GetDatabaseInstancesInstanceDnsNameResult(dict):
    def __init__(__self__, *,
                 connection_type: builtins.str,
                 dns_scope: builtins.str,
                 name: builtins.str):
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "dns_scope", dns_scope)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> builtins.str:
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="dnsScope")
    def dns_scope(self) -> builtins.str:
        return pulumi.get(self, "dns_scope")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatabaseInstancesInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: builtins.str,
                 time_to_retire: builtins.str,
                 type: builtins.str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> builtins.str:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstancesInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: builtins.str,
                 cascadable_replica: builtins.bool,
                 client_certificate: builtins.str,
                 client_key: builtins.str,
                 connect_retry_interval: builtins.int,
                 dump_file_path: builtins.str,
                 failover_target: builtins.bool,
                 master_heartbeat_period: builtins.int,
                 password: builtins.str,
                 ssl_cipher: builtins.str,
                 username: builtins.str,
                 verify_server_certificate: builtins.bool):
        """
        :param builtins.str ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param builtins.bool cascadable_replica: Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        :param builtins.str client_certificate: PEM representation of the replica's x509 certificate.
        :param builtins.str client_key: PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        :param builtins.int connect_retry_interval: The number of seconds between connect retries. MySQL's default is 60 seconds.
        :param builtins.str dump_file_path: Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        :param builtins.bool failover_target: Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        :param builtins.int master_heartbeat_period: Time in ms between replication heartbeats.
        :param builtins.str password: Password for the replication connection.
        :param builtins.str ssl_cipher: Permissible ciphers for use in SSL encryption.
        :param builtins.str username: Username for replication connection.
        :param builtins.bool verify_server_certificate: True if the master's common name value is checked during the SSL handshake.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "cascadable_replica", cascadable_replica)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> builtins.str:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="cascadableReplica")
    def cascadable_replica(self) -> builtins.bool:
        """
        Specifies if a SQL Server replica is a cascadable replica. A cascadable replica is a SQL Server cross region replica that supports replica(s) under it.
        """
        return pulumi.get(self, "cascadable_replica")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> builtins.str:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> builtins.str:
        """
        PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> builtins.int:
        """
        The number of seconds between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> builtins.str:
        """
        Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> builtins.bool:
        """
        Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance. Not supported for Postgres
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> builtins.int:
        """
        Time in ms between replication heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> builtins.str:
        """
        Permissible ciphers for use in SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> builtins.bool:
        """
        True if the master's common name value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstancesInstanceReplicationClusterResult(dict):
    def __init__(__self__, *,
                 dr_replica: builtins.bool,
                 failover_dr_replica_name: builtins.str):
        """
        :param builtins.bool dr_replica: Read-only field that indicates whether the replica is a DR replica.
        :param builtins.str failover_dr_replica_name: If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        pulumi.set(__self__, "dr_replica", dr_replica)
        pulumi.set(__self__, "failover_dr_replica_name", failover_dr_replica_name)

    @property
    @pulumi.getter(name="drReplica")
    def dr_replica(self) -> builtins.bool:
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        return pulumi.get(self, "dr_replica")

    @property
    @pulumi.getter(name="failoverDrReplicaName")
    def failover_dr_replica_name(self) -> builtins.str:
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        return pulumi.get(self, "failover_dr_replica_name")


@pulumi.output_type
class GetDatabaseInstancesInstanceRestoreBackupContextResult(dict):
    def __init__(__self__, *,
                 backup_run_id: builtins.int,
                 instance_id: builtins.str,
                 project: builtins.str):
        """
        :param builtins.int backup_run_id: The ID of the backup run to restore from.
        :param builtins.str instance_id: The ID of the instance that the backup was taken from.
        :param builtins.str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> builtins.int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        """
        The ID of the instance that the backup was taken from.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetDatabaseInstancesInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: builtins.str,
                 common_name: builtins.str,
                 create_time: builtins.str,
                 expiration_time: builtins.str,
                 sha1_fingerprint: builtins.str):
        """
        :param builtins.str cert: The CA Certificate used to connect to the SQL Instance via SSL.
        :param builtins.str common_name: The CN valid for the CA Cert.
        :param builtins.str create_time: Creation time of the CA Cert.
        :param builtins.str expiration_time: Expiration time of the CA Cert.
        :param builtins.str sha1_fingerprint: SHA Fingerprint of the CA Cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> builtins.str:
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> builtins.str:
        """
        The CN valid for the CA Cert.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        Creation time of the CA Cert.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        """
        Expiration time of the CA Cert.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> builtins.str:
        """
        SHA Fingerprint of the CA Cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: builtins.str,
                 active_directory_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult'],
                 advanced_machine_features: Sequence['outputs.GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult'],
                 availability_type: builtins.str,
                 backup_configurations: Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationResult'],
                 collation: builtins.str,
                 connection_pool_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult'],
                 connector_enforcement: builtins.str,
                 data_cache_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingDataCacheConfigResult'],
                 data_disk_provisioned_iops: builtins.int,
                 data_disk_provisioned_throughput: builtins.int,
                 database_flags: Sequence['outputs.GetDatabaseInstancesInstanceSettingDatabaseFlagResult'],
                 deletion_protection_enabled: builtins.bool,
                 deny_maintenance_periods: Sequence['outputs.GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult'],
                 disk_autoresize: builtins.bool,
                 disk_autoresize_limit: builtins.int,
                 disk_size: builtins.int,
                 disk_type: builtins.str,
                 edition: builtins.str,
                 enable_dataplex_integration: builtins.bool,
                 enable_google_ml_integration: builtins.bool,
                 insights_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingInsightsConfigResult'],
                 ip_configurations: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationResult'],
                 location_preferences: Sequence['outputs.GetDatabaseInstancesInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: Sequence['outputs.GetDatabaseInstancesInstanceSettingMaintenanceWindowResult'],
                 password_validation_policies: Sequence['outputs.GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult'],
                 pricing_plan: builtins.str,
                 retain_backups_on_delete: builtins.bool,
                 sql_server_audit_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult'],
                 tier: builtins.str,
                 time_zone: builtins.str,
                 user_labels: Mapping[str, builtins.str],
                 version: builtins.int):
        """
        :param builtins.str activation_policy: This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        :param builtins.str availability_type: The availability type of the Cloud SQL instance, high availability
               (REGIONAL) or single zone (ZONAL). For all instances, ensure that
               settings.backup_configuration.enabled is set to true.
               For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
               For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
               is set to true. Defaults to ZONAL.
        :param builtins.str collation: The name of server instance collation.
        :param Sequence['GetDatabaseInstancesInstanceSettingConnectionPoolConfigArgs'] connection_pool_configs: The managed connection pool setting for a Cloud SQL instance.
        :param builtins.str connector_enforcement: Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        :param Sequence['GetDatabaseInstancesInstanceSettingDataCacheConfigArgs'] data_cache_configs: Data cache configurations.
        :param builtins.int data_disk_provisioned_iops: Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param builtins.int data_disk_provisioned_throughput: Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        :param builtins.bool deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param builtins.bool disk_autoresize: Enables auto-resizing of the storage size. Defaults to true.
        :param builtins.int disk_autoresize_limit: The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param builtins.int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        :param builtins.str disk_type: The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        :param builtins.str edition: The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        :param builtins.bool enable_dataplex_integration: Enables Dataplex Integration.
        :param builtins.bool enable_google_ml_integration: Enables Vertex AI Integration.
        :param Sequence['GetDatabaseInstancesInstanceSettingInsightsConfigArgs'] insights_configs: Configuration of Query Insights.
        :param Sequence['GetDatabaseInstancesInstanceSettingMaintenanceWindowArgs'] maintenance_windows: Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        :param builtins.str pricing_plan: Pricing plan for this instance, can only be PER_USE.
        :param builtins.bool retain_backups_on_delete: When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        :param builtins.str tier: To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
        :param builtins.str time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param Mapping[str, builtins.str] user_labels: A set of key/value user label pairs to assign to the instance.
        :param builtins.int version: Used to make sure changes to the settings block are atomic.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "connection_pool_configs", connection_pool_configs)
        pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        pulumi.set(__self__, "data_cache_configs", data_cache_configs)
        pulumi.set(__self__, "data_disk_provisioned_iops", data_disk_provisioned_iops)
        pulumi.set(__self__, "data_disk_provisioned_throughput", data_disk_provisioned_throughput)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "enable_dataplex_integration", enable_dataplex_integration)
        pulumi.set(__self__, "enable_google_ml_integration", enable_google_ml_integration)
        pulumi.set(__self__, "insights_configs", insights_configs)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "password_validation_policies", password_validation_policies)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "retain_backups_on_delete", retain_backups_on_delete)
        pulumi.set(__self__, "sql_server_audit_configs", sql_server_audit_configs)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> builtins.str:
        """
        This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult']:
        return pulumi.get(self, "active_directory_configs")

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult']:
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> builtins.str:
        """
        The availability type of the Cloud SQL instance, high availability
        (REGIONAL) or single zone (ZONAL). For all instances, ensure that
        settings.backup_configuration.enabled is set to true.
        For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
        For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
        is set to true. Defaults to ZONAL.
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @property
    @pulumi.getter
    def collation(self) -> builtins.str:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="connectionPoolConfigs")
    def connection_pool_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult']:
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        return pulumi.get(self, "connection_pool_configs")

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> builtins.str:
        """
        Enables the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections. If enabled, all the direct connections are rejected.
        """
        return pulumi.get(self, "connector_enforcement")

    @property
    @pulumi.getter(name="dataCacheConfigs")
    def data_cache_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDataCacheConfigResult']:
        """
        Data cache configurations.
        """
        return pulumi.get(self, "data_cache_configs")

    @property
    @pulumi.getter(name="dataDiskProvisionedIops")
    def data_disk_provisioned_iops(self) -> builtins.int:
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_iops")

    @property
    @pulumi.getter(name="dataDiskProvisionedThroughput")
    def data_disk_provisioned_throughput(self) -> builtins.int:
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for HYPERDISK_BALANCED disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_throughput")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> builtins.bool:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult']:
        return pulumi.get(self, "deny_maintenance_periods")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> builtins.bool:
        """
        Enables auto-resizing of the storage size. Defaults to true.
        """
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> builtins.int:
        """
        The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> builtins.int:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for PD_SSD, PD_HDD and 20GB for HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> builtins.str:
        """
        The type of supported data disk is tier dependent and can be PD_SSD or PD_HDD or HYPERDISK_BALANCED.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def edition(self) -> builtins.str:
        """
        The edition of the instance, can be ENTERPRISE or ENTERPRISE_PLUS.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="enableDataplexIntegration")
    def enable_dataplex_integration(self) -> builtins.bool:
        """
        Enables Dataplex Integration.
        """
        return pulumi.get(self, "enable_dataplex_integration")

    @property
    @pulumi.getter(name="enableGoogleMlIntegration")
    def enable_google_ml_integration(self) -> builtins.bool:
        """
        Enables Vertex AI Integration.
        """
        return pulumi.get(self, "enable_google_ml_integration")

    @property
    @pulumi.getter(name="insightsConfigs")
    def insights_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingInsightsConfigResult']:
        """
        Configuration of Query Insights.
        """
        return pulumi.get(self, "insights_configs")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingMaintenanceWindowResult']:
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="passwordValidationPolicies")
    def password_validation_policies(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult']:
        return pulumi.get(self, "password_validation_policies")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> builtins.str:
        """
        Pricing plan for this instance, can only be PER_USE.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="retainBackupsOnDelete")
    def retain_backups_on_delete(self) -> builtins.bool:
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The ON_DEMAND backup will be retained until customer deletes the backup or the project. The AUTOMATED backup will be retained based on the backups retention setting.
        """
        return pulumi.get(self, "retain_backups_on_delete")

    @property
    @pulumi.getter(name="sqlServerAuditConfigs")
    def sql_server_audit_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult']:
        return pulumi.get(self, "sql_server_audit_configs")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        """
        To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, builtins.str]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        Used to make sure changes to the settings block are atomic.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain: builtins.str):
        """
        :param builtins.str domain: Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingAdvancedMachineFeatureResult(dict):
    def __init__(__self__, *,
                 threads_per_core: builtins.int):
        """
        :param builtins.int threads_per_core: The number of threads per physical core. Can be 1 or 2.
        """
        pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> builtins.int:
        """
        The number of threads per physical core. Can be 1 or 2.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 backup_retention_settings: Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult'],
                 binary_log_enabled: builtins.bool,
                 enabled: builtins.bool,
                 location: builtins.str,
                 point_in_time_recovery_enabled: builtins.bool,
                 start_time: builtins.str,
                 transaction_log_retention_days: builtins.int):
        """
        :param builtins.bool binary_log_enabled: True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        :param builtins.bool enabled: True if backup configuration is enabled.
        :param builtins.str location: Location of the backup configuration.
        :param builtins.bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled.
        :param builtins.str start_time: HH:MM format time indicating when backup configuration starts.
        :param builtins.int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult']:
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> builtins.bool:
        """
        True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Location of the backup configuration.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> builtins.bool:
        """
        True if Point-in-time recovery is enabled.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        HH:MM format time indicating when backup configuration starts.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> builtins.int:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. (For PostgreSQL Enterprise Plus instances, from 1 to 35.)
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult(dict):
    def __init__(__self__, *,
                 retained_backups: builtins.int,
                 retention_unit: builtins.str):
        """
        :param builtins.int retained_backups: Number of backups to retain.
        :param builtins.str retention_unit: The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> builtins.int:
        """
        Number of backups to retain.
        """
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> builtins.str:
        """
        The unit that 'retainedBackups' represents. Defaults to COUNT
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingConnectionPoolConfigResult(dict):
    def __init__(__self__, *,
                 connection_pooling_enabled: builtins.bool,
                 flags: Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult']):
        """
        :param builtins.bool connection_pooling_enabled: Whether Managed Connection Pool is enabled for this instance.
        :param Sequence['GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagArgs'] flags: List of connection pool configuration flags
        """
        pulumi.set(__self__, "connection_pooling_enabled", connection_pooling_enabled)
        pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="connectionPoolingEnabled")
    def connection_pooling_enabled(self) -> builtins.bool:
        """
        Whether Managed Connection Pool is enabled for this instance.
        """
        return pulumi.get(self, "connection_pooling_enabled")

    @property
    @pulumi.getter
    def flags(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult']:
        """
        List of connection pool configuration flags
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingConnectionPoolConfigFlagResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the flag.
        :param builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDataCacheConfigResult(dict):
    def __init__(__self__, *,
                 data_cache_enabled: builtins.bool):
        """
        :param builtins.bool data_cache_enabled: Whether data cache is enabled for the instance.
        """
        pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> builtins.bool:
        """
        Whether data cache is enabled for the instance.
        """
        return pulumi.get(self, "data_cache_enabled")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the flag.
        :param builtins.str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: builtins.str,
                 start_date: builtins.str,
                 time: builtins.str):
        """
        :param builtins.str end_date: End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param builtins.str start_date: Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param builtins.str time: Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> builtins.str:
        """
        End date before which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        """
        Start date after which maintenance will not take place. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> builtins.str:
        """
        Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_insights_enabled: builtins.bool,
                 query_plans_per_minute: builtins.int,
                 query_string_length: builtins.int,
                 record_application_tags: builtins.bool,
                 record_client_address: builtins.bool):
        """
        :param builtins.bool query_insights_enabled: True if Query Insights feature is enabled.
        :param builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        :param builtins.int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        :param builtins.bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param builtins.bool record_client_address: True if Query Insights will record client address when enabled.
        """
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> builtins.bool:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> builtins.int:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5. For Enterprise Plus instances, from 0 to 200.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> builtins.int:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. For Enterprise Plus instances, from 1 to 1048576.
        """
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> builtins.bool:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> builtins.bool:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: builtins.str,
                 authorized_networks: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 custom_subject_alternative_names: Sequence[builtins.str],
                 enable_private_path_for_google_cloud_services: builtins.bool,
                 ipv4_enabled: builtins.bool,
                 private_network: builtins.str,
                 psc_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult'],
                 server_ca_mode: builtins.str,
                 server_ca_pool: builtins.str,
                 ssl_mode: builtins.str):
        """
        :param builtins.str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence[builtins.str] custom_subject_alternative_names: The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param builtins.bool enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param builtins.bool ipv4_enabled: Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        :param builtins.str private_network: The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        :param Sequence['GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigArgs'] psc_configs: PSC settings for a Cloud SQL instance.
        :param builtins.str server_ca_mode: Specify how the server certificate's Certificate Authority is hosted.
        :param builtins.str server_ca_pool: The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        :param builtins.str ssl_mode: Specify how SSL connection should be enforced in DB connections.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "custom_subject_alternative_names", custom_subject_alternative_names)
        pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "psc_configs", psc_configs)
        pulumi.set(__self__, "server_ca_mode", server_ca_mode)
        pulumi.set(__self__, "server_ca_pool", server_ca_pool)
        pulumi.set(__self__, "ssl_mode", ssl_mode)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> builtins.str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="customSubjectAlternativeNames")
    def custom_subject_alternative_names(self) -> Sequence[builtins.str]:
        """
        The custom subject alternative names for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "custom_subject_alternative_names")

    @property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> builtins.bool:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> builtins.bool:
        """
        Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> builtins.str:
        """
        The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult']:
        """
        PSC settings for a Cloud SQL instance.
        """
        return pulumi.get(self, "psc_configs")

    @property
    @pulumi.getter(name="serverCaMode")
    def server_ca_mode(self) -> builtins.str:
        """
        Specify how the server certificate's Certificate Authority is hosted.
        """
        return pulumi.get(self, "server_ca_mode")

    @property
    @pulumi.getter(name="serverCaPool")
    def server_ca_pool(self) -> builtins.str:
        """
        The resource name of the server CA pool for an instance with "CUSTOMER_MANAGED_CAS_CA" as the "server_ca_mode".
        """
        return pulumi.get(self, "server_ca_pool")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> builtins.str:
        """
        Specify how SSL connection should be enforced in DB connections.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: builtins.str,
                 name: builtins.str,
                 value: builtins.str):
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigResult(dict):
    def __init__(__self__, *,
                 allowed_consumer_projects: Sequence[builtins.str],
                 psc_auto_connections: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult'],
                 psc_enabled: builtins.bool):
        """
        :param Sequence[builtins.str] allowed_consumer_projects: List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        :param Sequence['GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionArgs'] psc_auto_connections: A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        :param builtins.bool psc_enabled: Whether PSC connectivity is enabled for this instance.
        """
        pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        pulumi.set(__self__, "psc_enabled", psc_enabled)

    @property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Sequence[builtins.str]:
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult']:
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        return pulumi.get(self, "psc_auto_connections")

    @property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> builtins.bool:
        """
        Whether PSC connectivity is enabled for this instance.
        """
        return pulumi.get(self, "psc_enabled")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationPscConfigPscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 consumer_network: builtins.str,
                 consumer_service_project_id: builtins.str):
        """
        :param builtins.str consumer_network: The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        :param builtins.str consumer_service_project_id: The project ID of consumer service project of this consumer endpoint.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        pulumi.set(__self__, "consumer_service_project_id", consumer_service_project_id)

    @property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> builtins.str:
        """
        The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. The consumer host project of this network might be different from the consumer service project.
        """
        return pulumi.get(self, "consumer_network")

    @property
    @pulumi.getter(name="consumerServiceProjectId")
    def consumer_service_project_id(self) -> builtins.str:
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        return pulumi.get(self, "consumer_service_project_id")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: builtins.str,
                 secondary_zone: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str follow_gae_application: A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        :param builtins.str secondary_zone: The preferred Compute Engine zone for the secondary/failover
        :param builtins.str zone: To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
        """
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> builtins.str:
        """
        A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> builtins.str:
        """
        The preferred Compute Engine zone for the secondary/failover
        """
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: builtins.int,
                 hour: builtins.int,
                 update_track: builtins.str):
        """
        :param builtins.int day: Day of week (1-7), starting on Monday
        :param builtins.int hour: Hour of day (0-23), ignored if day not set
        :param builtins.str update_track: Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> builtins.int:
        """
        Day of week (1-7), starting on Monday
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of day (0-23), ignored if day not set
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> builtins.str:
        """
        Receive updates after one week (canary) or after two weeks (stable) or after five weeks (week5) of notification.
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult(dict):
    def __init__(__self__, *,
                 complexity: builtins.str,
                 disallow_username_substring: builtins.bool,
                 enable_password_policy: builtins.bool,
                 min_length: builtins.int,
                 password_change_interval: builtins.str,
                 reuse_interval: builtins.int):
        """
        :param builtins.str complexity: Password complexity.
        :param builtins.bool disallow_username_substring: Disallow username as a part of the password.
        :param builtins.bool enable_password_policy: Whether the password policy is enabled or not.
        :param builtins.int min_length: Minimum number of characters allowed.
        :param builtins.str password_change_interval: Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        :param builtins.int reuse_interval: Number of previous passwords that cannot be reused.
        """
        pulumi.set(__self__, "complexity", complexity)
        pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        pulumi.set(__self__, "min_length", min_length)
        pulumi.set(__self__, "password_change_interval", password_change_interval)
        pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter
    def complexity(self) -> builtins.str:
        """
        Password complexity.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> builtins.bool:
        """
        Disallow username as a part of the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> builtins.bool:
        """
        Whether the password policy is enabled or not.
        """
        return pulumi.get(self, "enable_password_policy")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> builtins.int:
        """
        Minimum number of characters allowed.
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> builtins.str:
        """
        Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        """
        return pulumi.get(self, "password_change_interval")

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> builtins.int:
        """
        Number of previous passwords that cannot be reused.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 retention_interval: builtins.str,
                 upload_interval: builtins.str):
        """
        :param builtins.str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param builtins.str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        :param builtins.str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> builtins.str:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
        """
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> builtins.str:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class GetDatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 charset: builtins.str,
                 collation: builtins.str,
                 deletion_policy: builtins.str,
                 instance: builtins.str,
                 name: builtins.str,
                 project: builtins.str,
                 self_link: builtins.str):
        """
        :param builtins.str charset: The charset value. See MySQL's
               [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
               and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
               for more details and supported values. Postgres databases only support
               a value of 'UTF8' at creation time.
        :param builtins.str collation: The collation value. See MySQL's
               [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
               and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
               for more details and supported values. Postgres databases only support
               a value of 'en_US.UTF8' at creation time.
        :param builtins.str deletion_policy: The deletion policy for the database. Setting ABANDON allows the resource
               to be abandoned rather than deleted. This is useful for Postgres, where databases cannot be
               deleted from the API if there are users other than cloudsqlsuperuser with access. Possible
               values are: "ABANDON", "DELETE". Defaults to "DELETE".
        :param builtins.str instance: The name of the Cloud SQL database instance in which the database belongs.
        :param builtins.str name: The name of the database in the Cloud SQL instance.
               This does not include the project ID or instance name.
        :param builtins.str project: The ID of the project in which the instance belongs.
               
               > **Note** This datasource performs client-side sorting to provide consistent ordering of the databases.
        """
        pulumi.set(__self__, "charset", charset)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "deletion_policy", deletion_policy)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def charset(self) -> builtins.str:
        """
        The charset value. See MySQL's
        [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
        and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
        for more details and supported values. Postgres databases only support
        a value of 'UTF8' at creation time.
        """
        return pulumi.get(self, "charset")

    @property
    @pulumi.getter
    def collation(self) -> builtins.str:
        """
        The collation value. See MySQL's
        [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
        and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
        for more details and supported values. Postgres databases only support
        a value of 'en_US.UTF8' at creation time.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> builtins.str:
        """
        The deletion policy for the database. Setting ABANDON allows the resource
        to be abandoned rather than deleted. This is useful for Postgres, where databases cannot be
        deleted from the API if there are users other than cloudsqlsuperuser with access. Possible
        values are: "ABANDON", "DELETE". Defaults to "DELETE".
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter
    def instance(self) -> builtins.str:
        """
        The name of the Cloud SQL database instance in which the database belongs.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the database in the Cloud SQL instance.
        This does not include the project ID or instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the instance belongs.

        > **Note** This datasource performs client-side sorting to provide consistent ordering of the databases.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")


@pulumi.output_type
class GetTiersTierResult(dict):
    def __init__(__self__, *,
                 disk_quota: builtins.int,
                 ram: builtins.int,
                 regions: Sequence[builtins.str],
                 tier: builtins.str):
        """
        :param builtins.int disk_quota: The maximum disk size of this tier in bytes.
        :param builtins.int ram: The maximum ram usage of this tier in bytes.
        :param Sequence[builtins.str] regions: The applicable regions for this tier.
        :param builtins.str tier: An identifier for the machine type, for example, db-custom-1-3840.
        """
        pulumi.set(__self__, "disk_quota", disk_quota)
        pulumi.set(__self__, "ram", ram)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="diskQuota")
    def disk_quota(self) -> builtins.int:
        """
        The maximum disk size of this tier in bytes.
        """
        return pulumi.get(self, "disk_quota")

    @property
    @pulumi.getter
    def ram(self) -> builtins.int:
        """
        The maximum ram usage of this tier in bytes.
        """
        return pulumi.get(self, "ram")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        The applicable regions for this tier.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        """
        An identifier for the machine type, for example, db-custom-1-3840.
        """
        return pulumi.get(self, "tier")


