# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedFolderArgs', 'ManagedFolder']

@pulumi.input_type
class ManagedFolderArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedFolder resource.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket that contains the managed folder.
        :param pulumi.Input[builtins.bool] force_destroy: Allows the deletion of a managed folder even if contains
               objects. If a non-empty managed folder is deleted, any objects
               within the folder will remain in a simulated folder with the
               same name.
        :param pulumi.Input[builtins.str] name: The name of the managed folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`.
               
               
               - - -
        """
        pulumi.set(__self__, "bucket", bucket)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the bucket that contains the managed folder.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows the deletion of a managed folder even if contains
        objects. If a non-empty managed folder is deleted, any objects
        within the folder will remain in a simulated folder with the
        same name.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the managed folder expressed as a path. Must include
        trailing '/'. For example, `example_dir/example_dir2/`.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ManagedFolderState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 metageneration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedFolder resources.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket that contains the managed folder.
        :param pulumi.Input[builtins.str] create_time: The timestamp at which this managed folder was created.
        :param pulumi.Input[builtins.bool] force_destroy: Allows the deletion of a managed folder even if contains
               objects. If a non-empty managed folder is deleted, any objects
               within the folder will remain in a simulated folder with the
               same name.
        :param pulumi.Input[builtins.str] metageneration: The metadata generation of the managed folder.
        :param pulumi.Input[builtins.str] name: The name of the managed folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`.
               
               
               - - -
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] update_time: The timestamp at which this managed folder was most recently updated.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if metageneration is not None:
            pulumi.set(__self__, "metageneration", metageneration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the bucket that contains the managed folder.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp at which this managed folder was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows the deletion of a managed folder even if contains
        objects. If a non-empty managed folder is deleted, any objects
        within the folder will remain in a simulated folder with the
        same name.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def metageneration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The metadata generation of the managed folder.
        """
        return pulumi.get(self, "metageneration")

    @metageneration.setter
    def metageneration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metageneration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the managed folder expressed as a path. Must include
        trailing '/'. For example, `example_dir/example_dir2/`.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp at which this managed folder was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:storage/managedFolder:ManagedFolder")
class ManagedFolder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Google Cloud Storage Managed Folder.

        You can apply Identity and Access Management (IAM) policies to
        managed folders to grant principals access only to the objects
        within the managed folder, which lets you more finely control access
        for specific data sets and tables within a bucket. You can nest
        managed folders up to 15 levels deep, including the parent managed
        folder.

        Managed folders can only be created in buckets that have uniform
        bucket-level access enabled.

        To get more information about ManagedFolder, see:

        * [API documentation](https://cloud.google.com/storage/docs/json_api/v1/managedFolder)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage/docs/managed-folders)

        ## Example Usage

        ### Storage Managed Folder Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="my-bucket",
            location="EU",
            uniform_bucket_level_access=True)
        folder = gcp.storage.ManagedFolder("folder",
            bucket=bucket.name,
            name="managed/folder/name/",
            force_destroy=True)
        ```

        ## Import

        ManagedFolder can be imported using any of these accepted formats:

        * `{{bucket}}/managedFolders/{{name}}`

        * `{{bucket}}/{{name}}`

        When using the `pulumi import` command, ManagedFolder can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/managedFolder:ManagedFolder default {{bucket}}/managedFolders/{{name}}
        ```

        ```sh
        $ pulumi import gcp:storage/managedFolder:ManagedFolder default {{bucket}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket that contains the managed folder.
        :param pulumi.Input[builtins.bool] force_destroy: Allows the deletion of a managed folder even if contains
               objects. If a non-empty managed folder is deleted, any objects
               within the folder will remain in a simulated folder with the
               same name.
        :param pulumi.Input[builtins.str] name: The name of the managed folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedFolderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Storage Managed Folder.

        You can apply Identity and Access Management (IAM) policies to
        managed folders to grant principals access only to the objects
        within the managed folder, which lets you more finely control access
        for specific data sets and tables within a bucket. You can nest
        managed folders up to 15 levels deep, including the parent managed
        folder.

        Managed folders can only be created in buckets that have uniform
        bucket-level access enabled.

        To get more information about ManagedFolder, see:

        * [API documentation](https://cloud.google.com/storage/docs/json_api/v1/managedFolder)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage/docs/managed-folders)

        ## Example Usage

        ### Storage Managed Folder Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="my-bucket",
            location="EU",
            uniform_bucket_level_access=True)
        folder = gcp.storage.ManagedFolder("folder",
            bucket=bucket.name,
            name="managed/folder/name/",
            force_destroy=True)
        ```

        ## Import

        ManagedFolder can be imported using any of these accepted formats:

        * `{{bucket}}/managedFolders/{{name}}`

        * `{{bucket}}/{{name}}`

        When using the `pulumi import` command, ManagedFolder can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/managedFolder:ManagedFolder default {{bucket}}/managedFolders/{{name}}
        ```

        ```sh
        $ pulumi import gcp:storage/managedFolder:ManagedFolder default {{bucket}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ManagedFolderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedFolderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedFolderArgs.__new__(ManagedFolderArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["name"] = name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["metageneration"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        super(ManagedFolder, __self__).__init__(
            'gcp:storage/managedFolder:ManagedFolder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            metageneration: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedFolder':
        """
        Get an existing ManagedFolder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket that contains the managed folder.
        :param pulumi.Input[builtins.str] create_time: The timestamp at which this managed folder was created.
        :param pulumi.Input[builtins.bool] force_destroy: Allows the deletion of a managed folder even if contains
               objects. If a non-empty managed folder is deleted, any objects
               within the folder will remain in a simulated folder with the
               same name.
        :param pulumi.Input[builtins.str] metageneration: The metadata generation of the managed folder.
        :param pulumi.Input[builtins.str] name: The name of the managed folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`.
               
               
               - - -
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] update_time: The timestamp at which this managed folder was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedFolderState.__new__(_ManagedFolderState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["metageneration"] = metageneration
        __props__.__dict__["name"] = name
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["update_time"] = update_time
        return ManagedFolder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[builtins.str]:
        """
        The name of the bucket that contains the managed folder.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which this managed folder was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allows the deletion of a managed folder even if contains
        objects. If a non-empty managed folder is deleted, any objects
        within the folder will remain in a simulated folder with the
        same name.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def metageneration(self) -> pulumi.Output[builtins.str]:
        """
        The metadata generation of the managed folder.
        """
        return pulumi.get(self, "metageneration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the managed folder expressed as a path. Must include
        trailing '/'. For example, `example_dir/example_dir2/`.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which this managed folder was most recently updated.
        """
        return pulumi.get(self, "update_time")

