# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LocationTagBindingArgs', 'LocationTagBinding']

@pulumi.input_type
class LocationTagBindingArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[builtins.str],
                 tag_value: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LocationTagBinding resource.
        :param pulumi.Input[builtins.str] parent: The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
        :param pulumi.Input[builtins.str] tag_value: The TagValue of the TagBinding. Must be of the form tagValues/456.
        :param pulumi.Input[builtins.str] location: Location of the target resource.
               
               - - -
        """
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "tag_value", tag_value)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> pulumi.Input[builtins.str]:
        """
        The TagValue of the TagBinding. Must be of the form tagValues/456.
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tag_value", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the target resource.

        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _LocationTagBindingState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LocationTagBinding resources.
        :param pulumi.Input[builtins.str] location: Location of the target resource.
               
               - - -
        :param pulumi.Input[builtins.str] name: The generated id for the TagBinding. This is a string of the form: `tagBindings/{parent}/{tag-value-name}`
        :param pulumi.Input[builtins.str] parent: The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
        :param pulumi.Input[builtins.str] tag_value: The TagValue of the TagBinding. Must be of the form tagValues/456.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the target resource.

        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The generated id for the TagBinding. This is a string of the form: `tagBindings/{parent}/{tag-value-name}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The TagValue of the TagBinding. Must be of the form tagValues/456.
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tag_value", value)


@pulumi.type_token("gcp:tags/locationTagBinding:LocationTagBinding")
class LocationTagBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A LocationTagBinding represents a connection between a TagValue and a non-global target such as a Cloud Run Service or Compute Instance. Once a LocationTagBinding is created, the TagValue is applied to all the descendants of the cloud resource.

        To get more information about LocationTagBinding, see:

        * [API documentation](https://cloud.google.com/resource-manager/reference/rest/v3/tagBindings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing)

        ## Example Usage

        ### Cloud Run Service

        To bind a tag to a Cloud Run service:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="project_id",
            name="project_id",
            org_id="123456789")
        key = gcp.tags.TagKey("key",
            parent="organizations/123456789",
            short_name="keyname",
            description="For keyname resources.")
        value = gcp.tags.TagValue("value",
            parent=key.id,
            short_name="valuename",
            description="For valuename resources.")
        binding = gcp.tags.LocationTagBinding("binding",
            parent=f"//run.googleapis.com/projects/{project_google_project['number']}/locations/{default['location']}/services/{default['name']}",
            tag_value=value.id,
            location="us-central1")
        ```

        ### Compute Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="project_id",
            name="project_id",
            org_id="123456789")
        key = gcp.tags.TagKey("key",
            parent="organizations/123456789",
            short_name="keyname",
            description="For keyname resources.")
        value = gcp.tags.TagValue("value",
            parent=key.id,
            short_name="valuename",
            description="For valuename resources.")
        binding = gcp.tags.LocationTagBinding("binding",
            parent=project.number.apply(lambda number: f"//compute.googleapis.com/projects/{number}/zones/us-central1-a/instances/{instance['instanceId']}"),
            tag_value=value.id,
            location="us-central1-a")
        ```

        ## Import

        LocationTagBinding can be imported using any of these accepted formats:

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, TagBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tags/locationTagBinding:LocationTagBinding default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Location of the target resource.
               
               - - -
        :param pulumi.Input[builtins.str] parent: The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
        :param pulumi.Input[builtins.str] tag_value: The TagValue of the TagBinding. Must be of the form tagValues/456.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocationTagBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A LocationTagBinding represents a connection between a TagValue and a non-global target such as a Cloud Run Service or Compute Instance. Once a LocationTagBinding is created, the TagValue is applied to all the descendants of the cloud resource.

        To get more information about LocationTagBinding, see:

        * [API documentation](https://cloud.google.com/resource-manager/reference/rest/v3/tagBindings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing)

        ## Example Usage

        ### Cloud Run Service

        To bind a tag to a Cloud Run service:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="project_id",
            name="project_id",
            org_id="123456789")
        key = gcp.tags.TagKey("key",
            parent="organizations/123456789",
            short_name="keyname",
            description="For keyname resources.")
        value = gcp.tags.TagValue("value",
            parent=key.id,
            short_name="valuename",
            description="For valuename resources.")
        binding = gcp.tags.LocationTagBinding("binding",
            parent=f"//run.googleapis.com/projects/{project_google_project['number']}/locations/{default['location']}/services/{default['name']}",
            tag_value=value.id,
            location="us-central1")
        ```

        ### Compute Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="project_id",
            name="project_id",
            org_id="123456789")
        key = gcp.tags.TagKey("key",
            parent="organizations/123456789",
            short_name="keyname",
            description="For keyname resources.")
        value = gcp.tags.TagValue("value",
            parent=key.id,
            short_name="valuename",
            description="For valuename resources.")
        binding = gcp.tags.LocationTagBinding("binding",
            parent=project.number.apply(lambda number: f"//compute.googleapis.com/projects/{number}/zones/us-central1-a/instances/{instance['instanceId']}"),
            tag_value=value.id,
            location="us-central1-a")
        ```

        ## Import

        LocationTagBinding can be imported using any of these accepted formats:

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, TagBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tags/locationTagBinding:LocationTagBinding default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param LocationTagBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationTagBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationTagBindingArgs.__new__(LocationTagBindingArgs)

            __props__.__dict__["location"] = location
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if tag_value is None and not opts.urn:
                raise TypeError("Missing required property 'tag_value'")
            __props__.__dict__["tag_value"] = tag_value
            __props__.__dict__["name"] = None
        super(LocationTagBinding, __self__).__init__(
            'gcp:tags/locationTagBinding:LocationTagBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            tag_value: Optional[pulumi.Input[builtins.str]] = None) -> 'LocationTagBinding':
        """
        Get an existing LocationTagBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Location of the target resource.
               
               - - -
        :param pulumi.Input[builtins.str] name: The generated id for the TagBinding. This is a string of the form: `tagBindings/{parent}/{tag-value-name}`
        :param pulumi.Input[builtins.str] parent: The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
        :param pulumi.Input[builtins.str] tag_value: The TagValue of the TagBinding. Must be of the form tagValues/456.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LocationTagBindingState.__new__(_LocationTagBindingState)

        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["tag_value"] = tag_value
        return LocationTagBinding(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Location of the target resource.

        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The generated id for the TagBinding. This is a string of the form: `tagBindings/{parent}/{tag-value-name}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> pulumi.Output[builtins.str]:
        """
        The TagValue of the TagBinding. Must be of the form tagValues/456.
        """
        return pulumi.get(self, "tag_value")

