# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'NodeNetworkEndpointArgs',
    'NodeNetworkEndpointArgsDict',
    'NodeSchedulingConfigArgs',
    'NodeSchedulingConfigArgsDict',
    'V2QueuedResourceTpuArgs',
    'V2QueuedResourceTpuArgsDict',
    'V2QueuedResourceTpuNodeSpecArgs',
    'V2QueuedResourceTpuNodeSpecArgsDict',
    'V2QueuedResourceTpuNodeSpecNodeArgs',
    'V2QueuedResourceTpuNodeSpecNodeArgsDict',
    'V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgs',
    'V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgsDict',
    'V2VmAcceleratorConfigArgs',
    'V2VmAcceleratorConfigArgsDict',
    'V2VmDataDiskArgs',
    'V2VmDataDiskArgsDict',
    'V2VmNetworkConfigArgs',
    'V2VmNetworkConfigArgsDict',
    'V2VmNetworkEndpointArgs',
    'V2VmNetworkEndpointArgsDict',
    'V2VmNetworkEndpointAccessConfigArgs',
    'V2VmNetworkEndpointAccessConfigArgsDict',
    'V2VmSchedulingConfigArgs',
    'V2VmSchedulingConfigArgsDict',
    'V2VmServiceAccountArgs',
    'V2VmServiceAccountArgsDict',
    'V2VmShieldedInstanceConfigArgs',
    'V2VmShieldedInstanceConfigArgsDict',
    'V2VmSymptomArgs',
    'V2VmSymptomArgsDict',
]

MYPY = False

if not MYPY:
    class NodeNetworkEndpointArgsDict(TypedDict):
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        The IP address of this network endpoint.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Output)
        The port of this network endpoint.
        """
elif False:
    NodeNetworkEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeNetworkEndpointArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] ip_address: (Output)
               The IP address of this network endpoint.
        :param pulumi.Input[builtins.int] port: (Output)
               The port of this network endpoint.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The IP address of this network endpoint.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Output)
        The port of this network endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class NodeSchedulingConfigArgsDict(TypedDict):
        preemptible: pulumi.Input[builtins.bool]
        """
        Defines whether the TPU instance is preemptible.
        """
elif False:
    NodeSchedulingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeSchedulingConfigArgs:
    def __init__(__self__, *,
                 preemptible: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] preemptible: Defines whether the TPU instance is preemptible.
        """
        pulumi.set(__self__, "preemptible", preemptible)

    @property
    @pulumi.getter
    def preemptible(self) -> pulumi.Input[builtins.bool]:
        """
        Defines whether the TPU instance is preemptible.
        """
        return pulumi.get(self, "preemptible")

    @preemptible.setter
    def preemptible(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "preemptible", value)


if not MYPY:
    class V2QueuedResourceTpuArgsDict(TypedDict):
        node_specs: NotRequired[pulumi.Input[Sequence[pulumi.Input['V2QueuedResourceTpuNodeSpecArgsDict']]]]
        """
        The TPU node(s) being requested.
        Structure is documented below.
        """
elif False:
    V2QueuedResourceTpuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2QueuedResourceTpuArgs:
    def __init__(__self__, *,
                 node_specs: Optional[pulumi.Input[Sequence[pulumi.Input['V2QueuedResourceTpuNodeSpecArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['V2QueuedResourceTpuNodeSpecArgs']]] node_specs: The TPU node(s) being requested.
               Structure is documented below.
        """
        if node_specs is not None:
            pulumi.set(__self__, "node_specs", node_specs)

    @property
    @pulumi.getter(name="nodeSpecs")
    def node_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2QueuedResourceTpuNodeSpecArgs']]]]:
        """
        The TPU node(s) being requested.
        Structure is documented below.
        """
        return pulumi.get(self, "node_specs")

    @node_specs.setter
    def node_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2QueuedResourceTpuNodeSpecArgs']]]]):
        pulumi.set(self, "node_specs", value)


if not MYPY:
    class V2QueuedResourceTpuNodeSpecArgsDict(TypedDict):
        node: pulumi.Input['V2QueuedResourceTpuNodeSpecNodeArgsDict']
        """
        The node.
        Structure is documented below.
        """
        parent: pulumi.Input[builtins.str]
        """
        The parent resource name.
        """
        node_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Unqualified node identifier used to identify the node in the project once provisioned.
        """
elif False:
    V2QueuedResourceTpuNodeSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2QueuedResourceTpuNodeSpecArgs:
    def __init__(__self__, *,
                 node: pulumi.Input['V2QueuedResourceTpuNodeSpecNodeArgs'],
                 parent: pulumi.Input[builtins.str],
                 node_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['V2QueuedResourceTpuNodeSpecNodeArgs'] node: The node.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The parent resource name.
        :param pulumi.Input[builtins.str] node_id: Unqualified node identifier used to identify the node in the project once provisioned.
        """
        pulumi.set(__self__, "node", node)
        pulumi.set(__self__, "parent", parent)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)

    @property
    @pulumi.getter
    def node(self) -> pulumi.Input['V2QueuedResourceTpuNodeSpecNodeArgs']:
        """
        The node.
        Structure is documented below.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: pulumi.Input['V2QueuedResourceTpuNodeSpecNodeArgs']):
        pulumi.set(self, "node", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The parent resource name.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unqualified node identifier used to identify the node in the project once provisioned.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_id", value)


if not MYPY:
    class V2QueuedResourceTpuNodeSpecNodeArgsDict(TypedDict):
        runtime_version: pulumi.Input[builtins.str]
        """
        Runtime version for the TPU.
        """
        accelerator_type: NotRequired[pulumi.Input[builtins.str]]
        """
        TPU accelerator type for the TPU. If not specified, this defaults to 'v2-8'.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        Text description of the TPU.
        """
        network_config: NotRequired[pulumi.Input['V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgsDict']]
        """
        Network configurations for the TPU node.
        Structure is documented below.
        """
elif False:
    V2QueuedResourceTpuNodeSpecNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2QueuedResourceTpuNodeSpecNodeArgs:
    def __init__(__self__, *,
                 runtime_version: pulumi.Input[builtins.str],
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgs']] = None):
        """
        :param pulumi.Input[builtins.str] runtime_version: Runtime version for the TPU.
        :param pulumi.Input[builtins.str] accelerator_type: TPU accelerator type for the TPU. If not specified, this defaults to 'v2-8'.
        :param pulumi.Input[builtins.str] description: Text description of the TPU.
        :param pulumi.Input['V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgs'] network_config: Network configurations for the TPU node.
               Structure is documented below.
        """
        pulumi.set(__self__, "runtime_version", runtime_version)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[builtins.str]:
        """
        Runtime version for the TPU.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TPU accelerator type for the TPU. If not specified, this defaults to 'v2-8'.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Text description of the TPU.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgs']]:
        """
        Network configurations for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)


if not MYPY:
    class V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgsDict(TypedDict):
        can_ip_forward: NotRequired[pulumi.Input[builtins.bool]]
        """
        Allows the TPU node to send and receive packets with non-matching destination or source
        IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        enable_external_ips: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to
        false, the specified subnetwork or network should have Private Google Access enabled.
        """
        network: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine
        network. If none is provided, "default" will be used.
        """
        queue_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies networking queue count for TPU VM instance's network interface.
        """
        subnetwork: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
        Engine subnetwork. If none is provided, "default" will be used.
        """
elif False:
    V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgs:
    def __init__(__self__, *,
                 can_ip_forward: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_external_ips: Optional[pulumi.Input[builtins.bool]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 queue_count: Optional[pulumi.Input[builtins.int]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] can_ip_forward: Allows the TPU node to send and receive packets with non-matching destination or source
               IPs. This is required if you plan to use the TPU workers to forward routes.
        :param pulumi.Input[builtins.bool] enable_external_ips: Indicates that external IP addresses would be associated with the TPU workers. If set to
               false, the specified subnetwork or network should have Private Google Access enabled.
        :param pulumi.Input[builtins.str] network: The name of the network for the TPU node. It must be a preexisting Google Compute Engine
               network. If none is provided, "default" will be used.
        :param pulumi.Input[builtins.int] queue_count: Specifies networking queue count for TPU VM instance's network interface.
        :param pulumi.Input[builtins.str] subnetwork: The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
               Engine subnetwork. If none is provided, "default" will be used.
        """
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if enable_external_ips is not None:
            pulumi.set(__self__, "enable_external_ips", enable_external_ips)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if queue_count is not None:
            pulumi.set(__self__, "queue_count", queue_count)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows the TPU node to send and receive packets with non-matching destination or source
        IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="enableExternalIps")
    def enable_external_ips(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to
        false, the specified subnetwork or network should have Private Google Access enabled.
        """
        return pulumi.get(self, "enable_external_ips")

    @enable_external_ips.setter
    def enable_external_ips(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_external_ips", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine
        network. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="queueCount")
    def queue_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies networking queue count for TPU VM instance's network interface.
        """
        return pulumi.get(self, "queue_count")

    @queue_count.setter
    def queue_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "queue_count", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
        Engine subnetwork. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)


if not MYPY:
    class V2VmAcceleratorConfigArgsDict(TypedDict):
        topology: pulumi.Input[builtins.str]
        """
        Topology of TPU in chips.
        """
        type: pulumi.Input[builtins.str]
        """
        Type of TPU. Please select one of the allowed types: https://cloud.google.com/tpu/docs/reference/rest/v2/AcceleratorConfig#Type
        """
elif False:
    V2VmAcceleratorConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmAcceleratorConfigArgs:
    def __init__(__self__, *,
                 topology: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] topology: Topology of TPU in chips.
        :param pulumi.Input[builtins.str] type: Type of TPU. Please select one of the allowed types: https://cloud.google.com/tpu/docs/reference/rest/v2/AcceleratorConfig#Type
        """
        pulumi.set(__self__, "topology", topology)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def topology(self) -> pulumi.Input[builtins.str]:
        """
        Topology of TPU in chips.
        """
        return pulumi.get(self, "topology")

    @topology.setter
    def topology(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "topology", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of TPU. Please select one of the allowed types: https://cloud.google.com/tpu/docs/reference/rest/v2/AcceleratorConfig#Type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class V2VmDataDiskArgsDict(TypedDict):
        source_disk: pulumi.Input[builtins.str]
        """
        Specifies the full path to an existing disk. For example:
        "projects/my-project/zones/us-central1-c/disks/my-disk".
        """
        mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The mode in which to attach this disk. If not specified, the default is READ_WRITE
        mode. Only applicable to dataDisks.
        Default value is `READ_WRITE`.
        Possible values are: `READ_WRITE`, `READ_ONLY`.
        """
elif False:
    V2VmDataDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmDataDiskArgs:
    def __init__(__self__, *,
                 source_disk: pulumi.Input[builtins.str],
                 mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] source_disk: Specifies the full path to an existing disk. For example:
               "projects/my-project/zones/us-central1-c/disks/my-disk".
        :param pulumi.Input[builtins.str] mode: The mode in which to attach this disk. If not specified, the default is READ_WRITE
               mode. Only applicable to dataDisks.
               Default value is `READ_WRITE`.
               Possible values are: `READ_WRITE`, `READ_ONLY`.
        """
        pulumi.set(__self__, "source_disk", source_disk)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the full path to an existing disk. For example:
        "projects/my-project/zones/us-central1-c/disks/my-disk".
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode in which to attach this disk. If not specified, the default is READ_WRITE
        mode. Only applicable to dataDisks.
        Default value is `READ_WRITE`.
        Possible values are: `READ_WRITE`, `READ_ONLY`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)


if not MYPY:
    class V2VmNetworkConfigArgsDict(TypedDict):
        can_ip_forward: NotRequired[pulumi.Input[builtins.bool]]
        """
        Allows the TPU node to send and receive packets with non-matching destination or source
        IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        enable_external_ips: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to
        false, the specified subnetwork or network should have Private Google Access enabled.
        """
        network: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine
        network. If none is provided, "default" will be used.
        """
        queue_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies networking queue count for TPU VM instance's network interface.
        """
        subnetwork: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
        Engine subnetwork. If none is provided, "default" will be used.
        """
elif False:
    V2VmNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmNetworkConfigArgs:
    def __init__(__self__, *,
                 can_ip_forward: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_external_ips: Optional[pulumi.Input[builtins.bool]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 queue_count: Optional[pulumi.Input[builtins.int]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] can_ip_forward: Allows the TPU node to send and receive packets with non-matching destination or source
               IPs. This is required if you plan to use the TPU workers to forward routes.
        :param pulumi.Input[builtins.bool] enable_external_ips: Indicates that external IP addresses would be associated with the TPU workers. If set to
               false, the specified subnetwork or network should have Private Google Access enabled.
        :param pulumi.Input[builtins.str] network: The name of the network for the TPU node. It must be a preexisting Google Compute Engine
               network. If none is provided, "default" will be used.
        :param pulumi.Input[builtins.int] queue_count: Specifies networking queue count for TPU VM instance's network interface.
        :param pulumi.Input[builtins.str] subnetwork: The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
               Engine subnetwork. If none is provided, "default" will be used.
        """
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if enable_external_ips is not None:
            pulumi.set(__self__, "enable_external_ips", enable_external_ips)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if queue_count is not None:
            pulumi.set(__self__, "queue_count", queue_count)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows the TPU node to send and receive packets with non-matching destination or source
        IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="enableExternalIps")
    def enable_external_ips(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to
        false, the specified subnetwork or network should have Private Google Access enabled.
        """
        return pulumi.get(self, "enable_external_ips")

    @enable_external_ips.setter
    def enable_external_ips(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_external_ips", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine
        network. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="queueCount")
    def queue_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies networking queue count for TPU VM instance's network interface.
        """
        return pulumi.get(self, "queue_count")

    @queue_count.setter
    def queue_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "queue_count", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
        Engine subnetwork. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)


if not MYPY:
    class V2VmNetworkEndpointArgsDict(TypedDict):
        access_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointAccessConfigArgsDict']]]]
        """
        (Output)
        The access config for the TPU worker.
        Structure is documented below.
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        The internal IP address of this network endpoint.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Output)
        The port of this network endpoint.
        """
elif False:
    V2VmNetworkEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmNetworkEndpointArgs:
    def __init__(__self__, *,
                 access_configs: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointAccessConfigArgs']]]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointAccessConfigArgs']]] access_configs: (Output)
               The access config for the TPU worker.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ip_address: (Output)
               The internal IP address of this network endpoint.
        :param pulumi.Input[builtins.int] port: (Output)
               The port of this network endpoint.
        """
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointAccessConfigArgs']]]]:
        """
        (Output)
        The access config for the TPU worker.
        Structure is documented below.
        """
        return pulumi.get(self, "access_configs")

    @access_configs.setter
    def access_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointAccessConfigArgs']]]]):
        pulumi.set(self, "access_configs", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The internal IP address of this network endpoint.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Output)
        The port of this network endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class V2VmNetworkEndpointAccessConfigArgsDict(TypedDict):
        external_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        An external IP address associated with the TPU worker.
        """
elif False:
    V2VmNetworkEndpointAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmNetworkEndpointAccessConfigArgs:
    def __init__(__self__, *,
                 external_ip: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] external_ip: (Output)
               An external IP address associated with the TPU worker.
        """
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        An external IP address associated with the TPU worker.
        """
        return pulumi.get(self, "external_ip")

    @external_ip.setter
    def external_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_ip", value)


if not MYPY:
    class V2VmSchedulingConfigArgsDict(TypedDict):
        preemptible: NotRequired[pulumi.Input[builtins.bool]]
        """
        Defines whether the node is preemptible.
        """
        reserved: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the node is created under a reservation.
        """
        spot: NotRequired[pulumi.Input[builtins.bool]]
        """
        Optional. Defines whether the node is Spot VM.
        """
elif False:
    V2VmSchedulingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmSchedulingConfigArgs:
    def __init__(__self__, *,
                 preemptible: Optional[pulumi.Input[builtins.bool]] = None,
                 reserved: Optional[pulumi.Input[builtins.bool]] = None,
                 spot: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] preemptible: Defines whether the node is preemptible.
        :param pulumi.Input[builtins.bool] reserved: Whether the node is created under a reservation.
        :param pulumi.Input[builtins.bool] spot: Optional. Defines whether the node is Spot VM.
        """
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)
        if spot is not None:
            pulumi.set(__self__, "spot", spot)

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether the node is preemptible.
        """
        return pulumi.get(self, "preemptible")

    @preemptible.setter
    def preemptible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preemptible", value)

    @property
    @pulumi.getter
    def reserved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the node is created under a reservation.
        """
        return pulumi.get(self, "reserved")

    @reserved.setter
    def reserved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reserved", value)

    @property
    @pulumi.getter
    def spot(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. Defines whether the node is Spot VM.
        """
        return pulumi.get(self, "spot")

    @spot.setter
    def spot(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "spot", value)


if not MYPY:
    class V2VmServiceAccountArgsDict(TypedDict):
        email: NotRequired[pulumi.Input[builtins.str]]
        """
        Email address of the service account. If empty, default Compute service account will be used.
        """
        scopes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of scopes to be made available for this service account. If empty, access to all
        Cloud APIs will be allowed.
        """
elif False:
    V2VmServiceAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmServiceAccountArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] email: Email address of the service account. If empty, default Compute service account will be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: The list of scopes to be made available for this service account. If empty, access to all
               Cloud APIs will be allowed.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the service account. If empty, default Compute service account will be used.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of scopes to be made available for this service account. If empty, access to all
        Cloud APIs will be allowed.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)


if not MYPY:
    class V2VmShieldedInstanceConfigArgsDict(TypedDict):
        enable_secure_boot: pulumi.Input[builtins.bool]
        """
        Defines whether the instance has Secure Boot enabled.
        """
elif False:
    V2VmShieldedInstanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_secure_boot: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enable_secure_boot: Defines whether the instance has Secure Boot enabled.
        """
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> pulumi.Input[builtins.bool]:
        """
        Defines whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_secure_boot", value)


if not MYPY:
    class V2VmSymptomArgsDict(TypedDict):
        create_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Timestamp when the Symptom is created.
        """
        details: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Detailed information of the current Symptom.
        """
        symptom_type: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Type of the Symptom.
        """
        worker_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        A string used to uniquely distinguish a worker within a TPU node.
        """
elif False:
    V2VmSymptomArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class V2VmSymptomArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 details: Optional[pulumi.Input[builtins.str]] = None,
                 symptom_type: Optional[pulumi.Input[builtins.str]] = None,
                 worker_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create_time: (Output)
               Timestamp when the Symptom is created.
        :param pulumi.Input[builtins.str] details: (Output)
               Detailed information of the current Symptom.
        :param pulumi.Input[builtins.str] symptom_type: (Output)
               Type of the Symptom.
        :param pulumi.Input[builtins.str] worker_id: (Output)
               A string used to uniquely distinguish a worker within a TPU node.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if symptom_type is not None:
            pulumi.set(__self__, "symptom_type", symptom_type)
        if worker_id is not None:
            pulumi.set(__self__, "worker_id", worker_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Timestamp when the Symptom is created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Detailed information of the current Symptom.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="symptomType")
    def symptom_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Type of the Symptom.
        """
        return pulumi.get(self, "symptom_type")

    @symptom_type.setter
    def symptom_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "symptom_type", value)

    @property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        A string used to uniquely distinguish a worker within a TPU node.
        """
        return pulumi.get(self, "worker_id")

    @worker_id.setter
    def worker_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_id", value)


