# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeArgs', 'Node']

@pulumi.input_type
class NodeArgs:
    def __init__(__self__, *,
                 accelerator_type: pulumi.Input[builtins.str],
                 tensorflow_version: pulumi.Input[builtins.str],
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_config: Optional[pulumi.Input['NodeSchedulingConfigArgs']] = None,
                 use_service_networking: Optional[pulumi.Input[builtins.bool]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Node resource.
        :param pulumi.Input[builtins.str] accelerator_type: The type of hardware accelerators associated with this node.
        :param pulumi.Input[builtins.str] tensorflow_version: The version of Tensorflow running in the Node.
               
               
               - - -
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP
               address. This CIDR block must be a /29 block; the Compute Engine
               networks API forbids a smaller block, and using a larger block would
               be wasteful (a node can only consume one IP address).
               Errors will occur if the CIDR block has already been used for a
               currently existing TPU node, the CIDR block conflicts with any
               subnetworks in the user's provided network, or the provided network
               is peered with another network that is using that CIDR block.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the TPU. Maximum of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input[builtins.str] network: The name of a network to peer the TPU node to. It must be a
               preexisting Compute Engine network inside of the project on which
               this API has been activated. If none is provided, "default" will be
               used.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['NodeSchedulingConfigArgs'] scheduling_config: Sets the scheduling options for this TPU instance.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] use_service_networking: Whether the VPC peering for the node is set up through Service Networking API.
               The VPC Peering should be set up before provisioning the node. If this field is set,
               cidr_block field should not be specified. If the network that you want to peer the
               TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        pulumi.set(__self__, "accelerator_type", accelerator_type)
        pulumi.set(__self__, "tensorflow_version", tensorflow_version)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if scheduling_config is not None:
            pulumi.set(__self__, "scheduling_config", scheduling_config)
        if use_service_networking is not None:
            pulumi.set(__self__, "use_service_networking", use_service_networking)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of hardware accelerators associated with this node.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="tensorflowVersion")
    def tensorflow_version(self) -> pulumi.Input[builtins.str]:
        """
        The version of Tensorflow running in the Node.


        - - -
        """
        return pulumi.get(self, "tensorflow_version")

    @tensorflow_version.setter
    def tensorflow_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tensorflow_version", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block that the TPU node will use when selecting an IP
        address. This CIDR block must be a /29 block; the Compute Engine
        networks API forbids a smaller block, and using a larger block would
        be wasteful (a node can only consume one IP address).
        Errors will occur if the CIDR block has already been used for a
        currently existing TPU node, the CIDR block conflicts with any
        subnetworks in the user's provided network, or the provided network
        is peered with another network that is using that CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-supplied description of the TPU. Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable name of the TPU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a network to peer the TPU node to. It must be a
        preexisting Compute Engine network inside of the project on which
        this API has been activated. If none is provided, "default" will be
        used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="schedulingConfig")
    def scheduling_config(self) -> Optional[pulumi.Input['NodeSchedulingConfigArgs']]:
        """
        Sets the scheduling options for this TPU instance.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduling_config")

    @scheduling_config.setter
    def scheduling_config(self, value: Optional[pulumi.Input['NodeSchedulingConfigArgs']]):
        pulumi.set(self, "scheduling_config", value)

    @property
    @pulumi.getter(name="useServiceNetworking")
    def use_service_networking(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the VPC peering for the node is set up through Service Networking API.
        The VPC Peering should be set up before provisioning the node. If this field is set,
        cidr_block field should not be specified. If the network that you want to peer the
        TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
        """
        return pulumi.get(self, "use_service_networking")

    @use_service_networking.setter
    def use_service_networking(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_service_networking", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _NodeState:
    def __init__(__self__, *,
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 network_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeNetworkEndpointArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 scheduling_config: Optional[pulumi.Input['NodeSchedulingConfigArgs']] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 tensorflow_version: Optional[pulumi.Input[builtins.str]] = None,
                 use_service_networking: Optional[pulumi.Input[builtins.bool]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Node resources.
        :param pulumi.Input[builtins.str] accelerator_type: The type of hardware accelerators associated with this node.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP
               address. This CIDR block must be a /29 block; the Compute Engine
               networks API forbids a smaller block, and using a larger block would
               be wasteful (a node can only consume one IP address).
               Errors will occur if the CIDR block has already been used for a
               currently existing TPU node, the CIDR block conflicts with any
               subnetworks in the user's provided network, or the provided network
               is peered with another network that is using that CIDR block.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the TPU. Maximum of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input[builtins.str] network: The name of a network to peer the TPU node to. It must be a
               preexisting Compute Engine network inside of the project on which
               this API has been activated. If none is provided, "default" will be
               used.
        :param pulumi.Input[Sequence[pulumi.Input['NodeNetworkEndpointArgs']]] network_endpoints: The network endpoints where TPU workers can be accessed and sent work.
               It is recommended that Tensorflow clients of the node first reach out
               to the first (index 0) entry.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['NodeSchedulingConfigArgs'] scheduling_config: Sets the scheduling options for this TPU instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_account: The service account used to run the tensor flow services within the
               node. To share resources, including Google Cloud Storage data, with
               the Tensorflow job running in the Node, this account must have
               permissions to that data.
        :param pulumi.Input[builtins.str] tensorflow_version: The version of Tensorflow running in the Node.
               
               
               - - -
        :param pulumi.Input[builtins.bool] use_service_networking: Whether the VPC peering for the node is set up through Service Networking API.
               The VPC Peering should be set up before provisioning the node. If this field is set,
               cidr_block field should not be specified. If the network that you want to peer the
               TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_endpoints is not None:
            pulumi.set(__self__, "network_endpoints", network_endpoints)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if scheduling_config is not None:
            pulumi.set(__self__, "scheduling_config", scheduling_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if tensorflow_version is not None:
            pulumi.set(__self__, "tensorflow_version", tensorflow_version)
        if use_service_networking is not None:
            pulumi.set(__self__, "use_service_networking", use_service_networking)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of hardware accelerators associated with this node.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block that the TPU node will use when selecting an IP
        address. This CIDR block must be a /29 block; the Compute Engine
        networks API forbids a smaller block, and using a larger block would
        be wasteful (a node can only consume one IP address).
        Errors will occur if the CIDR block has already been used for a
        currently existing TPU node, the CIDR block conflicts with any
        subnetworks in the user's provided network, or the provided network
        is peered with another network that is using that CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-supplied description of the TPU. Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable name of the TPU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a network to peer the TPU node to. It must be a
        preexisting Compute Engine network inside of the project on which
        this API has been activated. If none is provided, "default" will be
        used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkEndpoints")
    def network_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeNetworkEndpointArgs']]]]:
        """
        The network endpoints where TPU workers can be accessed and sent work.
        It is recommended that Tensorflow clients of the node first reach out
        to the first (index 0) entry.
        Structure is documented below.
        """
        return pulumi.get(self, "network_endpoints")

    @network_endpoints.setter
    def network_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeNetworkEndpointArgs']]]]):
        pulumi.set(self, "network_endpoints", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="schedulingConfig")
    def scheduling_config(self) -> Optional[pulumi.Input['NodeSchedulingConfigArgs']]:
        """
        Sets the scheduling options for this TPU instance.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduling_config")

    @scheduling_config.setter
    def scheduling_config(self, value: Optional[pulumi.Input['NodeSchedulingConfigArgs']]):
        pulumi.set(self, "scheduling_config", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service account used to run the tensor flow services within the
        node. To share resources, including Google Cloud Storage data, with
        the Tensorflow job running in the Node, this account must have
        permissions to that data.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="tensorflowVersion")
    def tensorflow_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of Tensorflow running in the Node.


        - - -
        """
        return pulumi.get(self, "tensorflow_version")

    @tensorflow_version.setter
    def tensorflow_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tensorflow_version", value)

    @property
    @pulumi.getter(name="useServiceNetworking")
    def use_service_networking(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the VPC peering for the node is set up through Service Networking API.
        The VPC Peering should be set up before provisioning the node. If this field is set,
        cidr_block field should not be specified. If the network that you want to peer the
        TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
        """
        return pulumi.get(self, "use_service_networking")

    @use_service_networking.setter
    def use_service_networking(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_service_networking", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:tpu/node:Node")
class Node(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_config: Optional[pulumi.Input[Union['NodeSchedulingConfigArgs', 'NodeSchedulingConfigArgsDict']]] = None,
                 tensorflow_version: Optional[pulumi.Input[builtins.str]] = None,
                 use_service_networking: Optional[pulumi.Input[builtins.bool]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > **Warning:** `tpu.Node` is deprecated and will be removed in a future major release. Use `tpu.V2Vm` instead. For moving from TPU Node to TPU VM architecture, see https://cloud.google.com/tpu/docs/system-architecture-tpu-vm#from-tpu-node-to-tpu-vm.

        A Cloud TPU instance.

        To get more information about Node, see:

        * [API documentation](https://cloud.google.com/tpu/docs/reference/rest/v1/projects.locations.nodes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/tpu/docs/)

        ## Example Usage

        ### Tpu Node Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        available = gcp.tpu.get_tensorflow_versions()
        tpu = gcp.tpu.Node("tpu",
            name="test-tpu",
            zone="us-central1-b",
            accelerator_type="v3-8",
            tensorflow_version=available.versions[0],
            cidr_block="10.2.0.0/29")
        ```
        ### Tpu Node Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        available = gcp.tpu.get_tensorflow_versions()
        network = gcp.compute.Network("network", name="tpu-node-network")
        service_range = gcp.compute.GlobalAddress("service_range",
            name="my-global-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=network.id)
        private_service_connection = gcp.servicenetworking.Connection("private_service_connection",
            network=network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        tpu = gcp.tpu.Node("tpu",
            name="test-tpu",
            zone="us-central1-b",
            accelerator_type="v3-8",
            tensorflow_version=available.versions[0],
            description="Google Provider test TPU",
            use_service_networking=True,
            network=private_service_connection.network,
            labels={
                "foo": "bar",
            },
            scheduling_config={
                "preemptible": True,
            })
        ```

        ## Import

        Node can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{zone}}/nodes/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Node can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tpu/node:Node default projects/{{project}}/locations/{{zone}}/nodes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/node:Node default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/node:Node default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/node:Node default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] accelerator_type: The type of hardware accelerators associated with this node.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP
               address. This CIDR block must be a /29 block; the Compute Engine
               networks API forbids a smaller block, and using a larger block would
               be wasteful (a node can only consume one IP address).
               Errors will occur if the CIDR block has already been used for a
               currently existing TPU node, the CIDR block conflicts with any
               subnetworks in the user's provided network, or the provided network
               is peered with another network that is using that CIDR block.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the TPU. Maximum of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input[builtins.str] network: The name of a network to peer the TPU node to. It must be a
               preexisting Compute Engine network inside of the project on which
               this API has been activated. If none is provided, "default" will be
               used.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['NodeSchedulingConfigArgs', 'NodeSchedulingConfigArgsDict']] scheduling_config: Sets the scheduling options for this TPU instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] tensorflow_version: The version of Tensorflow running in the Node.
               
               
               - - -
        :param pulumi.Input[builtins.bool] use_service_networking: Whether the VPC peering for the node is set up through Service Networking API.
               The VPC Peering should be set up before provisioning the node. If this field is set,
               cidr_block field should not be specified. If the network that you want to peer the
               TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Warning:** `tpu.Node` is deprecated and will be removed in a future major release. Use `tpu.V2Vm` instead. For moving from TPU Node to TPU VM architecture, see https://cloud.google.com/tpu/docs/system-architecture-tpu-vm#from-tpu-node-to-tpu-vm.

        A Cloud TPU instance.

        To get more information about Node, see:

        * [API documentation](https://cloud.google.com/tpu/docs/reference/rest/v1/projects.locations.nodes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/tpu/docs/)

        ## Example Usage

        ### Tpu Node Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        available = gcp.tpu.get_tensorflow_versions()
        tpu = gcp.tpu.Node("tpu",
            name="test-tpu",
            zone="us-central1-b",
            accelerator_type="v3-8",
            tensorflow_version=available.versions[0],
            cidr_block="10.2.0.0/29")
        ```
        ### Tpu Node Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        available = gcp.tpu.get_tensorflow_versions()
        network = gcp.compute.Network("network", name="tpu-node-network")
        service_range = gcp.compute.GlobalAddress("service_range",
            name="my-global-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=network.id)
        private_service_connection = gcp.servicenetworking.Connection("private_service_connection",
            network=network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        tpu = gcp.tpu.Node("tpu",
            name="test-tpu",
            zone="us-central1-b",
            accelerator_type="v3-8",
            tensorflow_version=available.versions[0],
            description="Google Provider test TPU",
            use_service_networking=True,
            network=private_service_connection.network,
            labels={
                "foo": "bar",
            },
            scheduling_config={
                "preemptible": True,
            })
        ```

        ## Import

        Node can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{zone}}/nodes/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Node can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tpu/node:Node default projects/{{project}}/locations/{{zone}}/nodes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/node:Node default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/node:Node default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/node:Node default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_config: Optional[pulumi.Input[Union['NodeSchedulingConfigArgs', 'NodeSchedulingConfigArgsDict']]] = None,
                 tensorflow_version: Optional[pulumi.Input[builtins.str]] = None,
                 use_service_networking: Optional[pulumi.Input[builtins.bool]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeArgs.__new__(NodeArgs)

            if accelerator_type is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_type'")
            __props__.__dict__["accelerator_type"] = accelerator_type
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["scheduling_config"] = scheduling_config
            if tensorflow_version is None and not opts.urn:
                raise TypeError("Missing required property 'tensorflow_version'")
            __props__.__dict__["tensorflow_version"] = tensorflow_version
            __props__.__dict__["use_service_networking"] = use_service_networking
            __props__.__dict__["zone"] = zone
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["network_endpoints"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["service_account"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Node, __self__).__init__(
            'gcp:tpu/node:Node',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
            cidr_block: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            network_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeNetworkEndpointArgs', 'NodeNetworkEndpointArgsDict']]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            scheduling_config: Optional[pulumi.Input[Union['NodeSchedulingConfigArgs', 'NodeSchedulingConfigArgsDict']]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None,
            tensorflow_version: Optional[pulumi.Input[builtins.str]] = None,
            use_service_networking: Optional[pulumi.Input[builtins.bool]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Node':
        """
        Get an existing Node resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] accelerator_type: The type of hardware accelerators associated with this node.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP
               address. This CIDR block must be a /29 block; the Compute Engine
               networks API forbids a smaller block, and using a larger block would
               be wasteful (a node can only consume one IP address).
               Errors will occur if the CIDR block has already been used for a
               currently existing TPU node, the CIDR block conflicts with any
               subnetworks in the user's provided network, or the provided network
               is peered with another network that is using that CIDR block.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the TPU. Maximum of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input[builtins.str] network: The name of a network to peer the TPU node to. It must be a
               preexisting Compute Engine network inside of the project on which
               this API has been activated. If none is provided, "default" will be
               used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeNetworkEndpointArgs', 'NodeNetworkEndpointArgsDict']]]] network_endpoints: The network endpoints where TPU workers can be accessed and sent work.
               It is recommended that Tensorflow clients of the node first reach out
               to the first (index 0) entry.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['NodeSchedulingConfigArgs', 'NodeSchedulingConfigArgsDict']] scheduling_config: Sets the scheduling options for this TPU instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_account: The service account used to run the tensor flow services within the
               node. To share resources, including Google Cloud Storage data, with
               the Tensorflow job running in the Node, this account must have
               permissions to that data.
        :param pulumi.Input[builtins.str] tensorflow_version: The version of Tensorflow running in the Node.
               
               
               - - -
        :param pulumi.Input[builtins.bool] use_service_networking: Whether the VPC peering for the node is set up through Service Networking API.
               The VPC Peering should be set up before provisioning the node. If this field is set,
               cidr_block field should not be specified. If the network that you want to peer the
               TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeState.__new__(_NodeState)

        __props__.__dict__["accelerator_type"] = accelerator_type
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_endpoints"] = network_endpoints
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["scheduling_config"] = scheduling_config
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["tensorflow_version"] = tensorflow_version
        __props__.__dict__["use_service_networking"] = use_service_networking
        __props__.__dict__["zone"] = zone
        return Node(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of hardware accelerators associated with this node.
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[builtins.str]:
        """
        The CIDR block that the TPU node will use when selecting an IP
        address. This CIDR block must be a /29 block; the Compute Engine
        networks API forbids a smaller block, and using a larger block would
        be wasteful (a node can only consume one IP address).
        Errors will occur if the CIDR block has already been used for a
        currently existing TPU node, the CIDR block conflicts with any
        subnetworks in the user's provided network, or the provided network
        is peered with another network that is using that CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user-supplied description of the TPU. Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The immutable name of the TPU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The name of a network to peer the TPU node to. It must be a
        preexisting Compute Engine network inside of the project on which
        this API has been activated. If none is provided, "default" will be
        used.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkEndpoints")
    def network_endpoints(self) -> pulumi.Output[Sequence['outputs.NodeNetworkEndpoint']]:
        """
        The network endpoints where TPU workers can be accessed and sent work.
        It is recommended that Tensorflow clients of the node first reach out
        to the first (index 0) entry.
        Structure is documented below.
        """
        return pulumi.get(self, "network_endpoints")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="schedulingConfig")
    def scheduling_config(self) -> pulumi.Output[Optional['outputs.NodeSchedulingConfig']]:
        """
        Sets the scheduling options for this TPU instance.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduling_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[builtins.str]:
        """
        The service account used to run the tensor flow services within the
        node. To share resources, including Google Cloud Storage data, with
        the Tensorflow job running in the Node, this account must have
        permissions to that data.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="tensorflowVersion")
    def tensorflow_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of Tensorflow running in the Node.


        - - -
        """
        return pulumi.get(self, "tensorflow_version")

    @property
    @pulumi.getter(name="useServiceNetworking")
    def use_service_networking(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the VPC peering for the node is set up through Service Networking API.
        The VPC Peering should be set up before provisioning the node. If this field is set,
        cidr_block field should not be specified. If the network that you want to peer the
        TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
        """
        return pulumi.get(self, "use_service_networking")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

