# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'NodeNetworkEndpoint',
    'NodeSchedulingConfig',
    'V2QueuedResourceTpu',
    'V2QueuedResourceTpuNodeSpec',
    'V2QueuedResourceTpuNodeSpecNode',
    'V2QueuedResourceTpuNodeSpecNodeNetworkConfig',
    'V2VmAcceleratorConfig',
    'V2VmDataDisk',
    'V2VmNetworkConfig',
    'V2VmNetworkEndpoint',
    'V2VmNetworkEndpointAccessConfig',
    'V2VmSchedulingConfig',
    'V2VmServiceAccount',
    'V2VmShieldedInstanceConfig',
    'V2VmSymptom',
]

@pulumi.output_type
class NodeNetworkEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeNetworkEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeNetworkEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeNetworkEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str ip_address: (Output)
               The IP address of this network endpoint.
        :param builtins.int port: (Output)
               The port of this network endpoint.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        """
        (Output)
        The IP address of this network endpoint.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        (Output)
        The port of this network endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class NodeSchedulingConfig(dict):
    def __init__(__self__, *,
                 preemptible: builtins.bool):
        """
        :param builtins.bool preemptible: Defines whether the TPU instance is preemptible.
        """
        pulumi.set(__self__, "preemptible", preemptible)

    @property
    @pulumi.getter
    def preemptible(self) -> builtins.bool:
        """
        Defines whether the TPU instance is preemptible.
        """
        return pulumi.get(self, "preemptible")


@pulumi.output_type
class V2QueuedResourceTpu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSpecs":
            suggest = "node_specs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2QueuedResourceTpu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2QueuedResourceTpu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2QueuedResourceTpu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_specs: Optional[Sequence['outputs.V2QueuedResourceTpuNodeSpec']] = None):
        """
        :param Sequence['V2QueuedResourceTpuNodeSpecArgs'] node_specs: The TPU node(s) being requested.
               Structure is documented below.
        """
        if node_specs is not None:
            pulumi.set(__self__, "node_specs", node_specs)

    @property
    @pulumi.getter(name="nodeSpecs")
    def node_specs(self) -> Optional[Sequence['outputs.V2QueuedResourceTpuNodeSpec']]:
        """
        The TPU node(s) being requested.
        Structure is documented below.
        """
        return pulumi.get(self, "node_specs")


@pulumi.output_type
class V2QueuedResourceTpuNodeSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2QueuedResourceTpuNodeSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2QueuedResourceTpuNodeSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2QueuedResourceTpuNodeSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node: 'outputs.V2QueuedResourceTpuNodeSpecNode',
                 parent: builtins.str,
                 node_id: Optional[builtins.str] = None):
        """
        :param 'V2QueuedResourceTpuNodeSpecNodeArgs' node: The node.
               Structure is documented below.
        :param builtins.str parent: The parent resource name.
        :param builtins.str node_id: Unqualified node identifier used to identify the node in the project once provisioned.
        """
        pulumi.set(__self__, "node", node)
        pulumi.set(__self__, "parent", parent)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)

    @property
    @pulumi.getter
    def node(self) -> 'outputs.V2QueuedResourceTpuNodeSpecNode':
        """
        The node.
        Structure is documented below.
        """
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def parent(self) -> builtins.str:
        """
        The parent resource name.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[builtins.str]:
        """
        Unqualified node identifier used to identify the node in the project once provisioned.
        """
        return pulumi.get(self, "node_id")


@pulumi.output_type
class V2QueuedResourceTpuNodeSpecNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "networkConfig":
            suggest = "network_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2QueuedResourceTpuNodeSpecNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2QueuedResourceTpuNodeSpecNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2QueuedResourceTpuNodeSpecNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 runtime_version: builtins.str,
                 accelerator_type: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 network_config: Optional['outputs.V2QueuedResourceTpuNodeSpecNodeNetworkConfig'] = None):
        """
        :param builtins.str runtime_version: Runtime version for the TPU.
        :param builtins.str accelerator_type: TPU accelerator type for the TPU. If not specified, this defaults to 'v2-8'.
        :param builtins.str description: Text description of the TPU.
        :param 'V2QueuedResourceTpuNodeSpecNodeNetworkConfigArgs' network_config: Network configurations for the TPU node.
               Structure is documented below.
        """
        pulumi.set(__self__, "runtime_version", runtime_version)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> builtins.str:
        """
        Runtime version for the TPU.
        """
        return pulumi.get(self, "runtime_version")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[builtins.str]:
        """
        TPU accelerator type for the TPU. If not specified, this defaults to 'v2-8'.
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Text description of the TPU.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional['outputs.V2QueuedResourceTpuNodeSpecNodeNetworkConfig']:
        """
        Network configurations for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")


@pulumi.output_type
class V2QueuedResourceTpuNodeSpecNodeNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canIpForward":
            suggest = "can_ip_forward"
        elif key == "enableExternalIps":
            suggest = "enable_external_ips"
        elif key == "queueCount":
            suggest = "queue_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2QueuedResourceTpuNodeSpecNodeNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2QueuedResourceTpuNodeSpecNodeNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2QueuedResourceTpuNodeSpecNodeNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_ip_forward: Optional[builtins.bool] = None,
                 enable_external_ips: Optional[builtins.bool] = None,
                 network: Optional[builtins.str] = None,
                 queue_count: Optional[builtins.int] = None,
                 subnetwork: Optional[builtins.str] = None):
        """
        :param builtins.bool can_ip_forward: Allows the TPU node to send and receive packets with non-matching destination or source
               IPs. This is required if you plan to use the TPU workers to forward routes.
        :param builtins.bool enable_external_ips: Indicates that external IP addresses would be associated with the TPU workers. If set to
               false, the specified subnetwork or network should have Private Google Access enabled.
        :param builtins.str network: The name of the network for the TPU node. It must be a preexisting Google Compute Engine
               network. If none is provided, "default" will be used.
        :param builtins.int queue_count: Specifies networking queue count for TPU VM instance's network interface.
        :param builtins.str subnetwork: The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
               Engine subnetwork. If none is provided, "default" will be used.
        """
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if enable_external_ips is not None:
            pulumi.set(__self__, "enable_external_ips", enable_external_ips)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if queue_count is not None:
            pulumi.set(__self__, "queue_count", queue_count)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[builtins.bool]:
        """
        Allows the TPU node to send and receive packets with non-matching destination or source
        IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="enableExternalIps")
    def enable_external_ips(self) -> Optional[builtins.bool]:
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to
        false, the specified subnetwork or network should have Private Google Access enabled.
        """
        return pulumi.get(self, "enable_external_ips")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine
        network. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="queueCount")
    def queue_count(self) -> Optional[builtins.int]:
        """
        Specifies networking queue count for TPU VM instance's network interface.
        """
        return pulumi.get(self, "queue_count")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[builtins.str]:
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
        Engine subnetwork. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class V2VmAcceleratorConfig(dict):
    def __init__(__self__, *,
                 topology: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str topology: Topology of TPU in chips.
        :param builtins.str type: Type of TPU. Please select one of the allowed types: https://cloud.google.com/tpu/docs/reference/rest/v2/AcceleratorConfig#Type
        """
        pulumi.set(__self__, "topology", topology)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def topology(self) -> builtins.str:
        """
        Topology of TPU in chips.
        """
        return pulumi.get(self, "topology")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of TPU. Please select one of the allowed types: https://cloud.google.com/tpu/docs/reference/rest/v2/AcceleratorConfig#Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class V2VmDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceDisk":
            suggest = "source_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_disk: builtins.str,
                 mode: Optional[builtins.str] = None):
        """
        :param builtins.str source_disk: Specifies the full path to an existing disk. For example:
               "projects/my-project/zones/us-central1-c/disks/my-disk".
        :param builtins.str mode: The mode in which to attach this disk. If not specified, the default is READ_WRITE
               mode. Only applicable to dataDisks.
               Default value is `READ_WRITE`.
               Possible values are: `READ_WRITE`, `READ_ONLY`.
        """
        pulumi.set(__self__, "source_disk", source_disk)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> builtins.str:
        """
        Specifies the full path to an existing disk. For example:
        "projects/my-project/zones/us-central1-c/disks/my-disk".
        """
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        The mode in which to attach this disk. If not specified, the default is READ_WRITE
        mode. Only applicable to dataDisks.
        Default value is `READ_WRITE`.
        Possible values are: `READ_WRITE`, `READ_ONLY`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class V2VmNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canIpForward":
            suggest = "can_ip_forward"
        elif key == "enableExternalIps":
            suggest = "enable_external_ips"
        elif key == "queueCount":
            suggest = "queue_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_ip_forward: Optional[builtins.bool] = None,
                 enable_external_ips: Optional[builtins.bool] = None,
                 network: Optional[builtins.str] = None,
                 queue_count: Optional[builtins.int] = None,
                 subnetwork: Optional[builtins.str] = None):
        """
        :param builtins.bool can_ip_forward: Allows the TPU node to send and receive packets with non-matching destination or source
               IPs. This is required if you plan to use the TPU workers to forward routes.
        :param builtins.bool enable_external_ips: Indicates that external IP addresses would be associated with the TPU workers. If set to
               false, the specified subnetwork or network should have Private Google Access enabled.
        :param builtins.str network: The name of the network for the TPU node. It must be a preexisting Google Compute Engine
               network. If none is provided, "default" will be used.
        :param builtins.int queue_count: Specifies networking queue count for TPU VM instance's network interface.
        :param builtins.str subnetwork: The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
               Engine subnetwork. If none is provided, "default" will be used.
        """
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if enable_external_ips is not None:
            pulumi.set(__self__, "enable_external_ips", enable_external_ips)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if queue_count is not None:
            pulumi.set(__self__, "queue_count", queue_count)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[builtins.bool]:
        """
        Allows the TPU node to send and receive packets with non-matching destination or source
        IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="enableExternalIps")
    def enable_external_ips(self) -> Optional[builtins.bool]:
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to
        false, the specified subnetwork or network should have Private Google Access enabled.
        """
        return pulumi.get(self, "enable_external_ips")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine
        network. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="queueCount")
    def queue_count(self) -> Optional[builtins.int]:
        """
        Specifies networking queue count for TPU VM instance's network interface.
        """
        return pulumi.get(self, "queue_count")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[builtins.str]:
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute
        Engine subnetwork. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class V2VmNetworkEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfigs":
            suggest = "access_configs"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmNetworkEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmNetworkEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmNetworkEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_configs: Optional[Sequence['outputs.V2VmNetworkEndpointAccessConfig']] = None,
                 ip_address: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param Sequence['V2VmNetworkEndpointAccessConfigArgs'] access_configs: (Output)
               The access config for the TPU worker.
               Structure is documented below.
        :param builtins.str ip_address: (Output)
               The internal IP address of this network endpoint.
        :param builtins.int port: (Output)
               The port of this network endpoint.
        """
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[Sequence['outputs.V2VmNetworkEndpointAccessConfig']]:
        """
        (Output)
        The access config for the TPU worker.
        Structure is documented below.
        """
        return pulumi.get(self, "access_configs")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        """
        (Output)
        The internal IP address of this network endpoint.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        (Output)
        The port of this network endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class V2VmNetworkEndpointAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalIp":
            suggest = "external_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmNetworkEndpointAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmNetworkEndpointAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmNetworkEndpointAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_ip: Optional[builtins.str] = None):
        """
        :param builtins.str external_ip: (Output)
               An external IP address associated with the TPU worker.
        """
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[builtins.str]:
        """
        (Output)
        An external IP address associated with the TPU worker.
        """
        return pulumi.get(self, "external_ip")


@pulumi.output_type
class V2VmSchedulingConfig(dict):
    def __init__(__self__, *,
                 preemptible: Optional[builtins.bool] = None,
                 reserved: Optional[builtins.bool] = None,
                 spot: Optional[builtins.bool] = None):
        """
        :param builtins.bool preemptible: Defines whether the node is preemptible.
        :param builtins.bool reserved: Whether the node is created under a reservation.
        :param builtins.bool spot: Optional. Defines whether the node is Spot VM.
        """
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)
        if spot is not None:
            pulumi.set(__self__, "spot", spot)

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[builtins.bool]:
        """
        Defines whether the node is preemptible.
        """
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter
    def reserved(self) -> Optional[builtins.bool]:
        """
        Whether the node is created under a reservation.
        """
        return pulumi.get(self, "reserved")

    @property
    @pulumi.getter
    def spot(self) -> Optional[builtins.bool]:
        """
        Optional. Defines whether the node is Spot VM.
        """
        return pulumi.get(self, "spot")


@pulumi.output_type
class V2VmServiceAccount(dict):
    def __init__(__self__, *,
                 email: Optional[builtins.str] = None,
                 scopes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str email: Email address of the service account. If empty, default Compute service account will be used.
        :param Sequence[builtins.str] scopes: The list of scopes to be made available for this service account. If empty, access to all
               Cloud APIs will be allowed.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the service account. If empty, default Compute service account will be used.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of scopes to be made available for this service account. If empty, access to all
        Cloud APIs will be allowed.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class V2VmShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableSecureBoot":
            suggest = "enable_secure_boot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_secure_boot: builtins.bool):
        """
        :param builtins.bool enable_secure_boot: Defines whether the instance has Secure Boot enabled.
        """
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> builtins.bool:
        """
        Defines whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")


@pulumi.output_type
class V2VmSymptom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "symptomType":
            suggest = "symptom_type"
        elif key == "workerId":
            suggest = "worker_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2VmSymptom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2VmSymptom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2VmSymptom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: Optional[builtins.str] = None,
                 details: Optional[builtins.str] = None,
                 symptom_type: Optional[builtins.str] = None,
                 worker_id: Optional[builtins.str] = None):
        """
        :param builtins.str create_time: (Output)
               Timestamp when the Symptom is created.
        :param builtins.str details: (Output)
               Detailed information of the current Symptom.
        :param builtins.str symptom_type: (Output)
               Type of the Symptom.
        :param builtins.str worker_id: (Output)
               A string used to uniquely distinguish a worker within a TPU node.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if symptom_type is not None:
            pulumi.set(__self__, "symptom_type", symptom_type)
        if worker_id is not None:
            pulumi.set(__self__, "worker_id", worker_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Timestamp when the Symptom is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def details(self) -> Optional[builtins.str]:
        """
        (Output)
        Detailed information of the current Symptom.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="symptomType")
    def symptom_type(self) -> Optional[builtins.str]:
        """
        (Output)
        Type of the Symptom.
        """
        return pulumi.get(self, "symptom_type")

    @property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> Optional[builtins.str]:
        """
        (Output)
        A string used to uniquely distinguish a worker within a TPU node.
        """
        return pulumi.get(self, "worker_id")


