# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2VmArgs', 'V2Vm']

@pulumi.input_type
class V2VmArgs:
    def __init__(__self__, *,
                 runtime_version: pulumi.Input[builtins.str],
                 accelerator_config: Optional[pulumi.Input['V2VmAcceleratorConfigArgs']] = None,
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['V2VmNetworkConfigArgs']] = None,
                 network_configs: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_config: Optional[pulumi.Input['V2VmSchedulingConfigArgs']] = None,
                 service_account: Optional[pulumi.Input['V2VmServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['V2VmShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a V2Vm resource.
        :param pulumi.Input[builtins.str] runtime_version: Runtime version for the TPU.
               
               
               - - -
        :param pulumi.Input['V2VmAcceleratorConfigArgs'] accelerator_config: The AccleratorConfig for the TPU Node. `accelerator_config` cannot be used at the same time
               as `accelerator_type`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
               Structure is documented below.
        :param pulumi.Input[builtins.str] accelerator_type: TPU accelerator type for the TPU. `accelerator_type` cannot be used at the same time as
               `accelerator_config`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
               be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
               block would be wasteful (a node can only consume one IP address). Errors will occur if the
               CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
               with any subnetworks in the user's provided network, or the provided network is peered with
               another network that is using that CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]] data_disks: The additional data disks for the Node.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Text description of the TPU.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input['V2VmNetworkConfigArgs'] network_config: Network configurations for the TPU node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]] network_configs: Repeated network configurations for the TPU node. This field is used to specify multiple
               network configs for the TPU node.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['V2VmSchedulingConfigArgs'] scheduling_config: The scheduling options for this node.
               Structure is documented below.
        :param pulumi.Input['V2VmServiceAccountArgs'] service_account: The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is
               specified, the default compute service account will be used.
               Structure is documented below.
        :param pulumi.Input['V2VmShieldedInstanceConfigArgs'] shielded_instance_config: Shielded Instance options.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        pulumi.set(__self__, "runtime_version", runtime_version)
        if accelerator_config is not None:
            pulumi.set(__self__, "accelerator_config", accelerator_config)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if network_configs is not None:
            pulumi.set(__self__, "network_configs", network_configs)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if scheduling_config is not None:
            pulumi.set(__self__, "scheduling_config", scheduling_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[builtins.str]:
        """
        Runtime version for the TPU.


        - - -
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> Optional[pulumi.Input['V2VmAcceleratorConfigArgs']]:
        """
        The AccleratorConfig for the TPU Node. `accelerator_config` cannot be used at the same time
        as `accelerator_type`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_config")

    @accelerator_config.setter
    def accelerator_config(self, value: Optional[pulumi.Input['V2VmAcceleratorConfigArgs']]):
        pulumi.set(self, "accelerator_config", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TPU accelerator type for the TPU. `accelerator_type` cannot be used at the same time as
        `accelerator_config`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
        be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
        block would be wasteful (a node can only consume one IP address). Errors will occur if the
        CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
        with any subnetworks in the user's provided network, or the provided network is peered with
        another network that is using that CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]]]:
        """
        The additional data disks for the Node.
        Structure is documented below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Text description of the TPU.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable name of the TPU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['V2VmNetworkConfigArgs']]:
        """
        Network configurations for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['V2VmNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]]]:
        """
        Repeated network configurations for the TPU node. This field is used to specify multiple
        network configs for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")

    @network_configs.setter
    def network_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]]]):
        pulumi.set(self, "network_configs", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="schedulingConfig")
    def scheduling_config(self) -> Optional[pulumi.Input['V2VmSchedulingConfigArgs']]:
        """
        The scheduling options for this node.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduling_config")

    @scheduling_config.setter
    def scheduling_config(self, value: Optional[pulumi.Input['V2VmSchedulingConfigArgs']]):
        pulumi.set(self, "scheduling_config", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['V2VmServiceAccountArgs']]:
        """
        The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is
        specified, the default compute service account will be used.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['V2VmServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['V2VmShieldedInstanceConfigArgs']]:
        """
        Shielded Instance options.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['V2VmShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _V2VmState:
    def __init__(__self__, *,
                 accelerator_config: Optional[pulumi.Input['V2VmAcceleratorConfigArgs']] = None,
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 health: Optional[pulumi.Input[builtins.str]] = None,
                 health_description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 multislice_node: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['V2VmNetworkConfigArgs']] = None,
                 network_configs: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]]] = None,
                 network_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 queued_resource: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_config: Optional[pulumi.Input['V2VmSchedulingConfigArgs']] = None,
                 service_account: Optional[pulumi.Input['V2VmServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['V2VmShieldedInstanceConfigArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 symptoms: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmSymptomArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering V2Vm resources.
        :param pulumi.Input['V2VmAcceleratorConfigArgs'] accelerator_config: The AccleratorConfig for the TPU Node. `accelerator_config` cannot be used at the same time
               as `accelerator_type`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
               Structure is documented below.
        :param pulumi.Input[builtins.str] accelerator_type: TPU accelerator type for the TPU. `accelerator_type` cannot be used at the same time as
               `accelerator_config`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        :param pulumi.Input[builtins.str] api_version: The API version that created this Node.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
               be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
               block would be wasteful (a node can only consume one IP address). Errors will occur if the
               CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
               with any subnetworks in the user's provided network, or the provided network is peered with
               another network that is using that CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]] data_disks: The additional data disks for the Node.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Text description of the TPU.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] health: The health status of the TPU node.
        :param pulumi.Input[builtins.str] health_description: If this field is populated, it contains a description of why the TPU Node is unhealthy.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
        :param pulumi.Input[builtins.bool] multislice_node: Whether the Node belongs to a Multislice group.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input['V2VmNetworkConfigArgs'] network_config: Network configurations for the TPU node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]] network_configs: Repeated network configurations for the TPU node. This field is used to specify multiple
               network configs for the TPU node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointArgs']]] network_endpoints: The network endpoints where TPU workers can be accessed and sent work. It is recommended that
               runtime clients of the node reach out to the 0th entry in this map first.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] queued_resource: The qualified name of the QueuedResource that requested this Node.
        :param pulumi.Input[builtins.str] runtime_version: Runtime version for the TPU.
               
               
               - - -
        :param pulumi.Input['V2VmSchedulingConfigArgs'] scheduling_config: The scheduling options for this node.
               Structure is documented below.
        :param pulumi.Input['V2VmServiceAccountArgs'] service_account: The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is
               specified, the default compute service account will be used.
               Structure is documented below.
        :param pulumi.Input['V2VmShieldedInstanceConfigArgs'] shielded_instance_config: Shielded Instance options.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The current state for the TPU Node.
        :param pulumi.Input[Sequence[pulumi.Input['V2VmSymptomArgs']]] symptoms: The Symptoms that have occurred to the TPU Node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        if accelerator_config is not None:
            pulumi.set(__self__, "accelerator_config", accelerator_config)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if health_description is not None:
            pulumi.set(__self__, "health_description", health_description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if multislice_node is not None:
            pulumi.set(__self__, "multislice_node", multislice_node)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if network_configs is not None:
            pulumi.set(__self__, "network_configs", network_configs)
        if network_endpoints is not None:
            pulumi.set(__self__, "network_endpoints", network_endpoints)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if queued_resource is not None:
            pulumi.set(__self__, "queued_resource", queued_resource)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if scheduling_config is not None:
            pulumi.set(__self__, "scheduling_config", scheduling_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if symptoms is not None:
            pulumi.set(__self__, "symptoms", symptoms)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> Optional[pulumi.Input['V2VmAcceleratorConfigArgs']]:
        """
        The AccleratorConfig for the TPU Node. `accelerator_config` cannot be used at the same time
        as `accelerator_type`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_config")

    @accelerator_config.setter
    def accelerator_config(self, value: Optional[pulumi.Input['V2VmAcceleratorConfigArgs']]):
        pulumi.set(self, "accelerator_config", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TPU accelerator type for the TPU. `accelerator_type` cannot be used at the same time as
        `accelerator_config`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The API version that created this Node.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
        be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
        block would be wasteful (a node can only consume one IP address). Errors will occur if the
        CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
        with any subnetworks in the user's provided network, or the provided network is peered with
        another network that is using that CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]]]:
        """
        The additional data disks for the Node.
        Structure is documented below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Text description of the TPU.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The health status of the TPU node.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter(name="healthDescription")
    def health_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If this field is populated, it contains a description of why the TPU Node is unhealthy.
        """
        return pulumi.get(self, "health_description")

    @health_description.setter
    def health_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="multisliceNode")
    def multislice_node(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Node belongs to a Multislice group.
        """
        return pulumi.get(self, "multislice_node")

    @multislice_node.setter
    def multislice_node(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multislice_node", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable name of the TPU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['V2VmNetworkConfigArgs']]:
        """
        Network configurations for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['V2VmNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]]]:
        """
        Repeated network configurations for the TPU node. This field is used to specify multiple
        network configs for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")

    @network_configs.setter
    def network_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkConfigArgs']]]]):
        pulumi.set(self, "network_configs", value)

    @property
    @pulumi.getter(name="networkEndpoints")
    def network_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointArgs']]]]:
        """
        The network endpoints where TPU workers can be accessed and sent work. It is recommended that
        runtime clients of the node reach out to the 0th entry in this map first.
        Structure is documented below.
        """
        return pulumi.get(self, "network_endpoints")

    @network_endpoints.setter
    def network_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmNetworkEndpointArgs']]]]):
        pulumi.set(self, "network_endpoints", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="queuedResource")
    def queued_resource(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The qualified name of the QueuedResource that requested this Node.
        """
        return pulumi.get(self, "queued_resource")

    @queued_resource.setter
    def queued_resource(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queued_resource", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Runtime version for the TPU.


        - - -
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="schedulingConfig")
    def scheduling_config(self) -> Optional[pulumi.Input['V2VmSchedulingConfigArgs']]:
        """
        The scheduling options for this node.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduling_config")

    @scheduling_config.setter
    def scheduling_config(self, value: Optional[pulumi.Input['V2VmSchedulingConfigArgs']]):
        pulumi.set(self, "scheduling_config", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['V2VmServiceAccountArgs']]:
        """
        The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is
        specified, the default compute service account will be used.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['V2VmServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['V2VmShieldedInstanceConfigArgs']]:
        """
        Shielded Instance options.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['V2VmShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state for the TPU Node.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def symptoms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2VmSymptomArgs']]]]:
        """
        The Symptoms that have occurred to the TPU Node.
        Structure is documented below.
        """
        return pulumi.get(self, "symptoms")

    @symptoms.setter
    def symptoms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2VmSymptomArgs']]]]):
        pulumi.set(self, "symptoms", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:tpu/v2Vm:V2Vm")
class V2Vm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_config: Optional[pulumi.Input[Union['V2VmAcceleratorConfigArgs', 'V2VmAcceleratorConfigArgsDict']]] = None,
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmDataDiskArgs', 'V2VmDataDiskArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]] = None,
                 network_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_config: Optional[pulumi.Input[Union['V2VmSchedulingConfigArgs', 'V2VmSchedulingConfigArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[Union['V2VmServiceAccountArgs', 'V2VmServiceAccountArgsDict']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['V2VmShieldedInstanceConfigArgs', 'V2VmShieldedInstanceConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Tpu V2 Vm Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        available = gcp.tpu.get_v2_runtime_versions()
        tpu = gcp.tpu.V2Vm("tpu",
            name="test-tpu",
            zone="us-central1-c",
            runtime_version="tpu-vm-tf-2.13.0")
        ```
        ### Tpu V2 Vm Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        available = gcp.tpu.get_v2_runtime_versions()
        available_get_v2_accelerator_types = gcp.tpu.get_v2_accelerator_types()
        network = gcp.compute.Network("network",
            name="tpu-net",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="tpu-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=network.id)
        sa = gcp.serviceaccount.Account("sa",
            account_id="tpu-sa",
            display_name="Test TPU VM")
        disk = gcp.compute.Disk("disk",
            name="tpu-disk",
            image="debian-cloud/debian-11",
            size=10,
            type="pd-ssd",
            zone="us-central1-c")
        # Wait after service account creation to limit eventual consistency errors.
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[sa]))
        tpu = gcp.tpu.V2Vm("tpu",
            name="test-tpu",
            zone="us-central1-c",
            description="Text description of the TPU.",
            runtime_version="tpu-vm-tf-2.13.0",
            accelerator_config={
                "type": "V2",
                "topology": "2x2",
            },
            cidr_block="10.0.0.0/29",
            network_config={
                "can_ip_forward": True,
                "enable_external_ips": True,
                "network": network.id,
                "subnetwork": subnet.id,
                "queue_count": 32,
            },
            scheduling_config={
                "preemptible": True,
                "spot": True,
            },
            shielded_instance_config={
                "enable_secure_boot": True,
            },
            service_account={
                "email": sa.email,
                "scopes": ["https://www.googleapis.com/auth/cloud-platform"],
            },
            data_disks=[{
                "source_disk": disk.id,
                "mode": "READ_ONLY",
            }],
            labels={
                "foo": "bar",
            },
            metadata={
                "foo": "bar",
            },
            tags=["foo"],
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        Vm can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{zone}}/nodes/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Vm can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default projects/{{project}}/locations/{{zone}}/nodes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['V2VmAcceleratorConfigArgs', 'V2VmAcceleratorConfigArgsDict']] accelerator_config: The AccleratorConfig for the TPU Node. `accelerator_config` cannot be used at the same time
               as `accelerator_type`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
               Structure is documented below.
        :param pulumi.Input[builtins.str] accelerator_type: TPU accelerator type for the TPU. `accelerator_type` cannot be used at the same time as
               `accelerator_config`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
               be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
               block would be wasteful (a node can only consume one IP address). Errors will occur if the
               CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
               with any subnetworks in the user's provided network, or the provided network is peered with
               another network that is using that CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2VmDataDiskArgs', 'V2VmDataDiskArgsDict']]]] data_disks: The additional data disks for the Node.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Text description of the TPU.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']] network_config: Network configurations for the TPU node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]]] network_configs: Repeated network configurations for the TPU node. This field is used to specify multiple
               network configs for the TPU node.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] runtime_version: Runtime version for the TPU.
               
               
               - - -
        :param pulumi.Input[Union['V2VmSchedulingConfigArgs', 'V2VmSchedulingConfigArgsDict']] scheduling_config: The scheduling options for this node.
               Structure is documented below.
        :param pulumi.Input[Union['V2VmServiceAccountArgs', 'V2VmServiceAccountArgsDict']] service_account: The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is
               specified, the default compute service account will be used.
               Structure is documented below.
        :param pulumi.Input[Union['V2VmShieldedInstanceConfigArgs', 'V2VmShieldedInstanceConfigArgsDict']] shielded_instance_config: Shielded Instance options.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2VmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Tpu V2 Vm Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        available = gcp.tpu.get_v2_runtime_versions()
        tpu = gcp.tpu.V2Vm("tpu",
            name="test-tpu",
            zone="us-central1-c",
            runtime_version="tpu-vm-tf-2.13.0")
        ```
        ### Tpu V2 Vm Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        available = gcp.tpu.get_v2_runtime_versions()
        available_get_v2_accelerator_types = gcp.tpu.get_v2_accelerator_types()
        network = gcp.compute.Network("network",
            name="tpu-net",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="tpu-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=network.id)
        sa = gcp.serviceaccount.Account("sa",
            account_id="tpu-sa",
            display_name="Test TPU VM")
        disk = gcp.compute.Disk("disk",
            name="tpu-disk",
            image="debian-cloud/debian-11",
            size=10,
            type="pd-ssd",
            zone="us-central1-c")
        # Wait after service account creation to limit eventual consistency errors.
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[sa]))
        tpu = gcp.tpu.V2Vm("tpu",
            name="test-tpu",
            zone="us-central1-c",
            description="Text description of the TPU.",
            runtime_version="tpu-vm-tf-2.13.0",
            accelerator_config={
                "type": "V2",
                "topology": "2x2",
            },
            cidr_block="10.0.0.0/29",
            network_config={
                "can_ip_forward": True,
                "enable_external_ips": True,
                "network": network.id,
                "subnetwork": subnet.id,
                "queue_count": 32,
            },
            scheduling_config={
                "preemptible": True,
                "spot": True,
            },
            shielded_instance_config={
                "enable_secure_boot": True,
            },
            service_account={
                "email": sa.email,
                "scopes": ["https://www.googleapis.com/auth/cloud-platform"],
            },
            data_disks=[{
                "source_disk": disk.id,
                "mode": "READ_ONLY",
            }],
            labels={
                "foo": "bar",
            },
            metadata={
                "foo": "bar",
            },
            tags=["foo"],
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        Vm can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{zone}}/nodes/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Vm can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default projects/{{project}}/locations/{{zone}}/nodes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:tpu/v2Vm:V2Vm default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param V2VmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2VmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_config: Optional[pulumi.Input[Union['V2VmAcceleratorConfigArgs', 'V2VmAcceleratorConfigArgsDict']]] = None,
                 accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmDataDiskArgs', 'V2VmDataDiskArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]] = None,
                 network_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_config: Optional[pulumi.Input[Union['V2VmSchedulingConfigArgs', 'V2VmSchedulingConfigArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[Union['V2VmServiceAccountArgs', 'V2VmServiceAccountArgsDict']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['V2VmShieldedInstanceConfigArgs', 'V2VmShieldedInstanceConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2VmArgs.__new__(V2VmArgs)

            __props__.__dict__["accelerator_config"] = accelerator_config
            __props__.__dict__["accelerator_type"] = accelerator_type
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["network_configs"] = network_configs
            __props__.__dict__["project"] = project
            if runtime_version is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_version'")
            __props__.__dict__["runtime_version"] = runtime_version
            __props__.__dict__["scheduling_config"] = scheduling_config
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["api_version"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["health_description"] = None
            __props__.__dict__["multislice_node"] = None
            __props__.__dict__["network_endpoints"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["queued_resource"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["symptoms"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(V2Vm, __self__).__init__(
            'gcp:tpu/v2Vm:V2Vm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_config: Optional[pulumi.Input[Union['V2VmAcceleratorConfigArgs', 'V2VmAcceleratorConfigArgsDict']]] = None,
            accelerator_type: Optional[pulumi.Input[builtins.str]] = None,
            api_version: Optional[pulumi.Input[builtins.str]] = None,
            cidr_block: Optional[pulumi.Input[builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmDataDiskArgs', 'V2VmDataDiskArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            health: Optional[pulumi.Input[builtins.str]] = None,
            health_description: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            multislice_node: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]] = None,
            network_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]]]] = None,
            network_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmNetworkEndpointArgs', 'V2VmNetworkEndpointArgsDict']]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            queued_resource: Optional[pulumi.Input[builtins.str]] = None,
            runtime_version: Optional[pulumi.Input[builtins.str]] = None,
            scheduling_config: Optional[pulumi.Input[Union['V2VmSchedulingConfigArgs', 'V2VmSchedulingConfigArgsDict']]] = None,
            service_account: Optional[pulumi.Input[Union['V2VmServiceAccountArgs', 'V2VmServiceAccountArgsDict']]] = None,
            shielded_instance_config: Optional[pulumi.Input[Union['V2VmShieldedInstanceConfigArgs', 'V2VmShieldedInstanceConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            symptoms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2VmSymptomArgs', 'V2VmSymptomArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'V2Vm':
        """
        Get an existing V2Vm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['V2VmAcceleratorConfigArgs', 'V2VmAcceleratorConfigArgsDict']] accelerator_config: The AccleratorConfig for the TPU Node. `accelerator_config` cannot be used at the same time
               as `accelerator_type`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
               Structure is documented below.
        :param pulumi.Input[builtins.str] accelerator_type: TPU accelerator type for the TPU. `accelerator_type` cannot be used at the same time as
               `accelerator_config`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        :param pulumi.Input[builtins.str] api_version: The API version that created this Node.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
               be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
               block would be wasteful (a node can only consume one IP address). Errors will occur if the
               CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
               with any subnetworks in the user's provided network, or the provided network is peered with
               another network that is using that CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2VmDataDiskArgs', 'V2VmDataDiskArgsDict']]]] data_disks: The additional data disks for the Node.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Text description of the TPU.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] health: The health status of the TPU node.
        :param pulumi.Input[builtins.str] health_description: If this field is populated, it contains a description of why the TPU Node is unhealthy.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
        :param pulumi.Input[builtins.bool] multislice_node: Whether the Node belongs to a Multislice group.
        :param pulumi.Input[builtins.str] name: The immutable name of the TPU.
        :param pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']] network_config: Network configurations for the TPU node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2VmNetworkConfigArgs', 'V2VmNetworkConfigArgsDict']]]] network_configs: Repeated network configurations for the TPU node. This field is used to specify multiple
               network configs for the TPU node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2VmNetworkEndpointArgs', 'V2VmNetworkEndpointArgsDict']]]] network_endpoints: The network endpoints where TPU workers can be accessed and sent work. It is recommended that
               runtime clients of the node reach out to the 0th entry in this map first.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] queued_resource: The qualified name of the QueuedResource that requested this Node.
        :param pulumi.Input[builtins.str] runtime_version: Runtime version for the TPU.
               
               
               - - -
        :param pulumi.Input[Union['V2VmSchedulingConfigArgs', 'V2VmSchedulingConfigArgsDict']] scheduling_config: The scheduling options for this node.
               Structure is documented below.
        :param pulumi.Input[Union['V2VmServiceAccountArgs', 'V2VmServiceAccountArgsDict']] service_account: The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is
               specified, the default compute service account will be used.
               Structure is documented below.
        :param pulumi.Input[Union['V2VmShieldedInstanceConfigArgs', 'V2VmShieldedInstanceConfigArgsDict']] shielded_instance_config: Shielded Instance options.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The current state for the TPU Node.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2VmSymptomArgs', 'V2VmSymptomArgsDict']]]] symptoms: The Symptoms that have occurred to the TPU Node.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        :param pulumi.Input[builtins.str] zone: The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2VmState.__new__(_V2VmState)

        __props__.__dict__["accelerator_config"] = accelerator_config
        __props__.__dict__["accelerator_type"] = accelerator_type
        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["health"] = health
        __props__.__dict__["health_description"] = health_description
        __props__.__dict__["labels"] = labels
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["multislice_node"] = multislice_node
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["network_configs"] = network_configs
        __props__.__dict__["network_endpoints"] = network_endpoints
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["queued_resource"] = queued_resource
        __props__.__dict__["runtime_version"] = runtime_version
        __props__.__dict__["scheduling_config"] = scheduling_config
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["state"] = state
        __props__.__dict__["symptoms"] = symptoms
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return V2Vm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> pulumi.Output['outputs.V2VmAcceleratorConfig']:
        """
        The AccleratorConfig for the TPU Node. `accelerator_config` cannot be used at the same time
        as `accelerator_type`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_config")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Output[builtins.str]:
        """
        TPU accelerator type for the TPU. `accelerator_type` cannot be used at the same time as
        `accelerator_config`. If neither is specified, `accelerator_type` defaults to 'v2-8'.
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[builtins.str]:
        """
        The API version that created this Node.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[builtins.str]:
        """
        The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must
        be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger
        block would be wasteful (a node can only consume one IP address). Errors will occur if the
        CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts
        with any subnetworks in the user's provided network, or the provided network is peered with
        another network that is using that CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.V2VmDataDisk']]]:
        """
        The additional data disks for the Node.
        Structure is documented below.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Text description of the TPU.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def health(self) -> pulumi.Output[builtins.str]:
        """
        The health status of the TPU node.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthDescription")
    def health_description(self) -> pulumi.Output[builtins.str]:
        """
        If this field is populated, it contains a description of why the TPU Node is unhealthy.
        """
        return pulumi.get(self, "health_description")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Resource labels to represent user-provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="multisliceNode")
    def multislice_node(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the Node belongs to a Multislice group.
        """
        return pulumi.get(self, "multislice_node")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The immutable name of the TPU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.V2VmNetworkConfig']:
        """
        Network configurations for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> pulumi.Output[Optional[Sequence['outputs.V2VmNetworkConfig']]]:
        """
        Repeated network configurations for the TPU node. This field is used to specify multiple
        network configs for the TPU node.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")

    @property
    @pulumi.getter(name="networkEndpoints")
    def network_endpoints(self) -> pulumi.Output[Sequence['outputs.V2VmNetworkEndpoint']]:
        """
        The network endpoints where TPU workers can be accessed and sent work. It is recommended that
        runtime clients of the node reach out to the 0th entry in this map first.
        Structure is documented below.
        """
        return pulumi.get(self, "network_endpoints")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="queuedResource")
    def queued_resource(self) -> pulumi.Output[builtins.str]:
        """
        The qualified name of the QueuedResource that requested this Node.
        """
        return pulumi.get(self, "queued_resource")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Output[builtins.str]:
        """
        Runtime version for the TPU.


        - - -
        """
        return pulumi.get(self, "runtime_version")

    @property
    @pulumi.getter(name="schedulingConfig")
    def scheduling_config(self) -> pulumi.Output[Optional['outputs.V2VmSchedulingConfig']]:
        """
        The scheduling options for this node.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduling_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output['outputs.V2VmServiceAccount']:
        """
        The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is
        specified, the default compute service account will be used.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output[Optional['outputs.V2VmShieldedInstanceConfig']]:
        """
        Shielded Instance options.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state for the TPU Node.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def symptoms(self) -> pulumi.Output[Sequence['outputs.V2VmSymptom']]:
        """
        The Symptoms that have occurred to the TPU Node.
        Structure is documented below.
        """
        return pulumi.get(self, "symptoms")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The GCP location for the TPU. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

