# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 config: Optional[pulumi.Input['JobConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[builtins.str] location: The location of the transcoding job resource.
               
               
               - - -
        :param pulumi.Input['JobConfigArgs'] config: The configuration for this template.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] template_id: Specify the templateId to use for populating Job.config.
               The default is preset/web-hd, which is the only supported preset.
        """
        pulumi.set(__self__, "location", location)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the transcoding job resource.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['JobConfigArgs']]:
        """
        The configuration for this template.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['JobConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels associated with this job. You can use these to organize and group your jobs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the templateId to use for populating Job.config.
        The default is preset/web-hd, which is the only supported preset.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['JobConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input['JobConfigArgs'] config: The configuration for this template.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time the job was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] end_time: The time the transcoding finished.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the transcoding job resource.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The resource name of the job.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] start_time: The time the transcoding started.
        :param pulumi.Input[builtins.str] state: The current state of the job.
        :param pulumi.Input[builtins.str] template_id: Specify the templateId to use for populating Job.config.
               The default is preset/web-hd, which is the only supported preset.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['JobConfigArgs']]:
        """
        The configuration for this template.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['JobConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the job was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the transcoding finished.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels associated with this job. You can use these to organize and group your jobs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the transcoding job resource.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the transcoding started.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the templateId to use for populating Job.config.
        The default is preset/web-hd, which is the only supported preset.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.type_token("gcp:transcoder/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['JobConfigArgs', 'JobConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Transcoding Job Resource

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/transcoder/docs/reference/rest/v1/projects.locations.jobs)
        * How-to Guides
            * [Transcoder](https://cloud.google.com/transcoder/docs/)

        ## Example Usage

        ### Transcoder Job Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        default_job_template = gcp.transcoder.JobTemplate("default",
            job_template_id="example-job-template",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
                "edit_lists": [{
                    "key": "atom0",
                    "inputs": ["input0"],
                    "start_time_offset": "0s",
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                ],
            },
            labels={
                "label": "key",
            })
        default_job = gcp.transcoder.Job("default",
            template_id=default_job_template.name,
            location="us-central1",
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Pubsub

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        transcoder_notifications = gcp.pubsub.Topic("transcoder_notifications", name="transcoder-notifications")
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "edit_lists": [{
                    "key": "atom0",
                    "inputs": ["input0"],
                    "start_time_offset": "0s",
                }],
                "ad_breaks": [{
                    "start_time_offset": "3.500s",
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                ],
                "pubsub_destination": {
                    "topic": transcoder_notifications.id,
                },
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Encryptions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        encryption_key = gcp.secretmanager.Secret("encryption_key",
            secret_id="transcoder-encryption-key",
            replication={
                "auto": {},
            })
        encryption_key_secret_version = gcp.secretmanager.SecretVersion("encryption_key",
            secret=encryption_key.name,
            secret_data="4A67F2C1B8E93A4F6D3E7890A1BC23DF")
        project = gcp.organizations.get_project()
        # this is required to allow the transcoder service identity to access the secret
        transcoder = gcp.projects.ServiceIdentity("transcoder",
            project=project.project_id,
            service="transcoder.googleapis.com")
        transcoder_encryption_key_accessor = gcp.secretmanager.SecretIamMember("transcoder_encryption_key_accessor",
            secret_id=encryption_key.secret_id,
            project=encryption_key.project,
            role="roles/secretmanager.secretAccessor",
            member=transcoder.email.apply(lambda email: f"serviceAccount:{email}"))
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "elementary_streams": [
                    {
                        "key": "es_video",
                        "video_stream": {
                            "h264": {
                                "profile": "main",
                                "height_pixels": 600,
                                "width_pixels": 800,
                                "bitrate_bps": 1000000,
                                "frame_rate": 60,
                            },
                        },
                    },
                    {
                        "key": "es_audio",
                        "audio_stream": {
                            "codec": "aac",
                            "channel_count": 2,
                            "bitrate_bps": 160000,
                        },
                    },
                ],
                "encryptions": [
                    {
                        "id": "aes-128",
                        "secret_manager_key_source": {
                            "secret_version": encryption_key_secret_version.name,
                        },
                        "drm_systems": {
                            "clearkey": {},
                        },
                        "aes128": {},
                    },
                    {
                        "id": "cenc",
                        "secret_manager_key_source": {
                            "secret_version": encryption_key_secret_version.name,
                        },
                        "drm_systems": {
                            "widevine": {},
                        },
                        "mpeg_cenc": {
                            "scheme": "cenc",
                        },
                    },
                    {
                        "id": "cbcs",
                        "secret_manager_key_source": {
                            "secret_version": encryption_key_secret_version.name,
                        },
                        "drm_systems": {
                            "widevine": {},
                        },
                        "mpeg_cenc": {
                            "scheme": "cbcs",
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "ts_aes128",
                        "container": "ts",
                        "elementary_streams": [
                            "es_video",
                            "es_audio",
                        ],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "aes-128",
                    },
                    {
                        "key": "fmp4_cenc_video",
                        "container": "fmp4",
                        "elementary_streams": ["es_video"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cenc",
                    },
                    {
                        "key": "fmp4_cenc_audio",
                        "container": "fmp4",
                        "elementary_streams": ["es_audio"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cenc",
                    },
                    {
                        "key": "fmp4_cbcs_video",
                        "container": "fmp4",
                        "elementary_streams": ["es_video"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cbcs",
                    },
                    {
                        "key": "fmp4_cbcs_audio",
                        "container": "fmp4",
                        "elementary_streams": ["es_audio"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cbcs",
                    },
                ],
                "manifests": [
                    {
                        "file_name": "manifest_aes128.m3u8",
                        "type": "HLS",
                        "mux_streams": ["ts_aes128"],
                    },
                    {
                        "file_name": "manifest_cenc.mpd",
                        "type": "DASH",
                        "mux_streams": [
                            "fmp4_cenc_video",
                            "fmp4_cenc_audio",
                        ],
                    },
                    {
                        "file_name": "manifest_cbcs.mpd",
                        "type": "DASH",
                        "mux_streams": [
                            "fmp4_cbcs_video",
                            "fmp4_cbcs_audio",
                        ],
                    },
                ],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Overlays

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        overlay_png = gcp.storage.BucketObject("overlay_png",
            name="overlay.png",
            source=pulumi.FileAsset("./test-fixtures/overlay.png"),
            bucket=default.name)
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "edit_lists": [{
                    "key": "atom0",
                    "inputs": ["input0"],
                    "start_time_offset": "0s",
                }],
                "ad_breaks": [{
                    "start_time_offset": "3.500s",
                }],
                "overlays": [{
                    "animations": [{
                        "animation_fade": {
                            "fade_type": "FADE_IN",
                            "start_time_offset": "1.500s",
                            "end_time_offset": "3.500s",
                            "xy": {
                                "x": 1,
                                "y": 0.5,
                            },
                        },
                    }],
                    "image": {
                        "uri": pulumi.Output.all(
                            defaultName=default.name,
                            overlayPngName=overlay_png.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['overlayPngName']}")
        ,
                    },
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                ],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Manifests

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "edit_lists": [{
                    "key": "atom0",
                    "start_time_offset": "0s",
                    "inputs": ["input0"],
                }],
                "ad_breaks": [{
                    "start_time_offset": "3.500s",
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "media-sd",
                        "file_name": "media-sd.ts",
                        "container": "ts",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "media-hd",
                        "file_name": "media-hd.ts",
                        "container": "ts",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "video-only-sd",
                        "file_name": "video-only-sd.m4s",
                        "container": "fmp4",
                        "elementary_streams": ["video-stream0"],
                    },
                    {
                        "key": "video-only-hd",
                        "file_name": "video-only-hd.m4s",
                        "container": "fmp4",
                        "elementary_streams": ["video-stream1"],
                    },
                    {
                        "key": "audio-only",
                        "file_name": "audio-only.m4s",
                        "container": "fmp4",
                        "elementary_streams": ["audio-stream0"],
                    },
                ],
                "manifests": [
                    {
                        "file_name": "manifest.m3u8",
                        "type": "HLS",
                        "mux_streams": [
                            "media-sd",
                            "media-hd",
                        ],
                    },
                    {
                        "file_name": "manifest.mpd",
                        "type": "DASH",
                        "mux_streams": [
                            "video-only-sd",
                            "video-only-hd",
                            "audio-only",
                        ],
                    },
                ],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:transcoder/job:Job default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:transcoder/job:Job default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:transcoder/job:Job default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['JobConfigArgs', 'JobConfigArgsDict']] config: The configuration for this template.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the transcoding job resource.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] template_id: Specify the templateId to use for populating Job.config.
               The default is preset/web-hd, which is the only supported preset.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Transcoding Job Resource

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/transcoder/docs/reference/rest/v1/projects.locations.jobs)
        * How-to Guides
            * [Transcoder](https://cloud.google.com/transcoder/docs/)

        ## Example Usage

        ### Transcoder Job Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        default_job_template = gcp.transcoder.JobTemplate("default",
            job_template_id="example-job-template",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
                "edit_lists": [{
                    "key": "atom0",
                    "inputs": ["input0"],
                    "start_time_offset": "0s",
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                ],
            },
            labels={
                "label": "key",
            })
        default_job = gcp.transcoder.Job("default",
            template_id=default_job_template.name,
            location="us-central1",
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Pubsub

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        transcoder_notifications = gcp.pubsub.Topic("transcoder_notifications", name="transcoder-notifications")
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "edit_lists": [{
                    "key": "atom0",
                    "inputs": ["input0"],
                    "start_time_offset": "0s",
                }],
                "ad_breaks": [{
                    "start_time_offset": "3.500s",
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                ],
                "pubsub_destination": {
                    "topic": transcoder_notifications.id,
                },
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Encryptions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        encryption_key = gcp.secretmanager.Secret("encryption_key",
            secret_id="transcoder-encryption-key",
            replication={
                "auto": {},
            })
        encryption_key_secret_version = gcp.secretmanager.SecretVersion("encryption_key",
            secret=encryption_key.name,
            secret_data="4A67F2C1B8E93A4F6D3E7890A1BC23DF")
        project = gcp.organizations.get_project()
        # this is required to allow the transcoder service identity to access the secret
        transcoder = gcp.projects.ServiceIdentity("transcoder",
            project=project.project_id,
            service="transcoder.googleapis.com")
        transcoder_encryption_key_accessor = gcp.secretmanager.SecretIamMember("transcoder_encryption_key_accessor",
            secret_id=encryption_key.secret_id,
            project=encryption_key.project,
            role="roles/secretmanager.secretAccessor",
            member=transcoder.email.apply(lambda email: f"serviceAccount:{email}"))
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "elementary_streams": [
                    {
                        "key": "es_video",
                        "video_stream": {
                            "h264": {
                                "profile": "main",
                                "height_pixels": 600,
                                "width_pixels": 800,
                                "bitrate_bps": 1000000,
                                "frame_rate": 60,
                            },
                        },
                    },
                    {
                        "key": "es_audio",
                        "audio_stream": {
                            "codec": "aac",
                            "channel_count": 2,
                            "bitrate_bps": 160000,
                        },
                    },
                ],
                "encryptions": [
                    {
                        "id": "aes-128",
                        "secret_manager_key_source": {
                            "secret_version": encryption_key_secret_version.name,
                        },
                        "drm_systems": {
                            "clearkey": {},
                        },
                        "aes128": {},
                    },
                    {
                        "id": "cenc",
                        "secret_manager_key_source": {
                            "secret_version": encryption_key_secret_version.name,
                        },
                        "drm_systems": {
                            "widevine": {},
                        },
                        "mpeg_cenc": {
                            "scheme": "cenc",
                        },
                    },
                    {
                        "id": "cbcs",
                        "secret_manager_key_source": {
                            "secret_version": encryption_key_secret_version.name,
                        },
                        "drm_systems": {
                            "widevine": {},
                        },
                        "mpeg_cenc": {
                            "scheme": "cbcs",
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "ts_aes128",
                        "container": "ts",
                        "elementary_streams": [
                            "es_video",
                            "es_audio",
                        ],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "aes-128",
                    },
                    {
                        "key": "fmp4_cenc_video",
                        "container": "fmp4",
                        "elementary_streams": ["es_video"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cenc",
                    },
                    {
                        "key": "fmp4_cenc_audio",
                        "container": "fmp4",
                        "elementary_streams": ["es_audio"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cenc",
                    },
                    {
                        "key": "fmp4_cbcs_video",
                        "container": "fmp4",
                        "elementary_streams": ["es_video"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cbcs",
                    },
                    {
                        "key": "fmp4_cbcs_audio",
                        "container": "fmp4",
                        "elementary_streams": ["es_audio"],
                        "segment_settings": {
                            "segment_duration": "6s",
                        },
                        "encryption_id": "cbcs",
                    },
                ],
                "manifests": [
                    {
                        "file_name": "manifest_aes128.m3u8",
                        "type": "HLS",
                        "mux_streams": ["ts_aes128"],
                    },
                    {
                        "file_name": "manifest_cenc.mpd",
                        "type": "DASH",
                        "mux_streams": [
                            "fmp4_cenc_video",
                            "fmp4_cenc_audio",
                        ],
                    },
                    {
                        "file_name": "manifest_cbcs.mpd",
                        "type": "DASH",
                        "mux_streams": [
                            "fmp4_cbcs_video",
                            "fmp4_cbcs_audio",
                        ],
                    },
                ],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Overlays

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        overlay_png = gcp.storage.BucketObject("overlay_png",
            name="overlay.png",
            source=pulumi.FileAsset("./test-fixtures/overlay.png"),
            bucket=default.name)
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "edit_lists": [{
                    "key": "atom0",
                    "inputs": ["input0"],
                    "start_time_offset": "0s",
                }],
                "ad_breaks": [{
                    "start_time_offset": "3.500s",
                }],
                "overlays": [{
                    "animations": [{
                        "animation_fade": {
                            "fade_type": "FADE_IN",
                            "start_time_offset": "1.500s",
                            "end_time_offset": "3.500s",
                            "xy": {
                                "x": 1,
                                "y": 0.5,
                            },
                        },
                    }],
                    "image": {
                        "uri": pulumi.Output.all(
                            defaultName=default.name,
                            overlayPngName=overlay_png.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['overlayPngName']}")
        ,
                    },
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                ],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```
        ### Transcoder Job Manifests

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.Bucket("default",
            name="transcoder-job",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True,
            public_access_prevention="enforced")
        example_mp4 = gcp.storage.BucketObject("example_mp4",
            name="example.mp4",
            source=pulumi.FileAsset("./test-fixtures/example.mp4"),
            bucket=default.name)
        default_job = gcp.transcoder.Job("default",
            location="us-central1",
            config={
                "inputs": [{
                    "key": "input0",
                    "uri": pulumi.Output.all(
                        defaultName=default.name,
                        exampleMp4Name=example_mp4.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['defaultName']}/{resolved_outputs['exampleMp4Name']}")
        ,
                }],
                "edit_lists": [{
                    "key": "atom0",
                    "start_time_offset": "0s",
                    "inputs": ["input0"],
                }],
                "ad_breaks": [{
                    "start_time_offset": "3.500s",
                }],
                "elementary_streams": [
                    {
                        "key": "video-stream0",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 640,
                                "height_pixels": 360,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 550000,
                                "vbv_fullness_bits": 495000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "video-stream1",
                        "video_stream": {
                            "h264": {
                                "width_pixels": 1280,
                                "height_pixels": 720,
                                "bitrate_bps": 550000,
                                "frame_rate": 60,
                                "pixel_format": "yuv420p",
                                "rate_control_mode": "vbr",
                                "crf_level": 21,
                                "gop_duration": "3s",
                                "vbv_size_bits": 2500000,
                                "vbv_fullness_bits": 2250000,
                                "entropy_coder": "cabac",
                                "profile": "high",
                                "preset": "veryfast",
                            },
                        },
                    },
                    {
                        "key": "audio-stream0",
                        "audio_stream": {
                            "codec": "aac",
                            "bitrate_bps": 64000,
                            "channel_count": 2,
                            "channel_layouts": [
                                "fl",
                                "fr",
                            ],
                            "sample_rate_hertz": 48000,
                        },
                    },
                ],
                "mux_streams": [
                    {
                        "key": "sd",
                        "file_name": "sd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "hd",
                        "file_name": "hd.mp4",
                        "container": "mp4",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "media-sd",
                        "file_name": "media-sd.ts",
                        "container": "ts",
                        "elementary_streams": [
                            "video-stream0",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "media-hd",
                        "file_name": "media-hd.ts",
                        "container": "ts",
                        "elementary_streams": [
                            "video-stream1",
                            "audio-stream0",
                        ],
                    },
                    {
                        "key": "video-only-sd",
                        "file_name": "video-only-sd.m4s",
                        "container": "fmp4",
                        "elementary_streams": ["video-stream0"],
                    },
                    {
                        "key": "video-only-hd",
                        "file_name": "video-only-hd.m4s",
                        "container": "fmp4",
                        "elementary_streams": ["video-stream1"],
                    },
                    {
                        "key": "audio-only",
                        "file_name": "audio-only.m4s",
                        "container": "fmp4",
                        "elementary_streams": ["audio-stream0"],
                    },
                ],
                "manifests": [
                    {
                        "file_name": "manifest.m3u8",
                        "type": "HLS",
                        "mux_streams": [
                            "media-sd",
                            "media-hd",
                        ],
                    },
                    {
                        "file_name": "manifest.mpd",
                        "type": "DASH",
                        "mux_streams": [
                            "video-only-sd",
                            "video-only-hd",
                            "audio-only",
                        ],
                    },
                ],
                "output": {
                    "uri": default.name.apply(lambda name: f"gs://{name}/outputs/"),
                },
            },
            labels={
                "label": "key",
            })
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:transcoder/job:Job default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:transcoder/job:Job default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:transcoder/job:Job default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['JobConfigArgs', 'JobConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Job, __self__).__init__(
            'gcp:transcoder/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['JobConfigArgs', 'JobConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            end_time: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            template_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['JobConfigArgs', 'JobConfigArgsDict']] config: The configuration for this template.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time the job was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] end_time: The time the transcoding finished.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels associated with this job. You can use these to organize and group your jobs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the transcoding job resource.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The resource name of the job.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] start_time: The time the transcoding started.
        :param pulumi.Input[builtins.str] state: The current state of the job.
        :param pulumi.Input[builtins.str] template_id: Specify the templateId to use for populating Job.config.
               The default is preset/web-hd, which is the only supported preset.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["state"] = state
        __props__.__dict__["template_id"] = template_id
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.JobConfig']:
        """
        The configuration for this template.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the job was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the transcoding finished.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels associated with this job. You can use these to organize and group your jobs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the transcoding job resource.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the transcoding started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[builtins.str]:
        """
        Specify the templateId to use for populating Job.config.
        The default is preset/web-hd, which is the only supported preset.
        """
        return pulumi.get(self, "template_id")

