# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'JobConfig',
    'JobConfigAdBreak',
    'JobConfigEditList',
    'JobConfigElementaryStream',
    'JobConfigElementaryStreamAudioStream',
    'JobConfigElementaryStreamVideoStream',
    'JobConfigElementaryStreamVideoStreamH264',
    'JobConfigElementaryStreamVideoStreamH264Hlg',
    'JobConfigElementaryStreamVideoStreamH264Sdr',
    'JobConfigEncryption',
    'JobConfigEncryptionAes128',
    'JobConfigEncryptionDrmSystems',
    'JobConfigEncryptionDrmSystemsClearkey',
    'JobConfigEncryptionDrmSystemsFairplay',
    'JobConfigEncryptionDrmSystemsPlayready',
    'JobConfigEncryptionDrmSystemsWidevine',
    'JobConfigEncryptionMpegCenc',
    'JobConfigEncryptionSampleAes',
    'JobConfigEncryptionSecretManagerKeySource',
    'JobConfigInput',
    'JobConfigManifest',
    'JobConfigMuxStream',
    'JobConfigMuxStreamSegmentSettings',
    'JobConfigOutput',
    'JobConfigOverlay',
    'JobConfigOverlayAnimation',
    'JobConfigOverlayAnimationAnimationFade',
    'JobConfigOverlayAnimationAnimationFadeXy',
    'JobConfigOverlayImage',
    'JobConfigPubsubDestination',
    'JobTemplateConfig',
    'JobTemplateConfigAdBreak',
    'JobTemplateConfigEditList',
    'JobTemplateConfigElementaryStream',
    'JobTemplateConfigElementaryStreamAudioStream',
    'JobTemplateConfigElementaryStreamVideoStream',
    'JobTemplateConfigElementaryStreamVideoStreamH264',
    'JobTemplateConfigElementaryStreamVideoStreamH264Hlg',
    'JobTemplateConfigElementaryStreamVideoStreamH264Sdr',
    'JobTemplateConfigEncryption',
    'JobTemplateConfigEncryptionAes128',
    'JobTemplateConfigEncryptionDrmSystems',
    'JobTemplateConfigEncryptionDrmSystemsClearkey',
    'JobTemplateConfigEncryptionDrmSystemsFairplay',
    'JobTemplateConfigEncryptionDrmSystemsPlayready',
    'JobTemplateConfigEncryptionDrmSystemsWidevine',
    'JobTemplateConfigEncryptionMpegCenc',
    'JobTemplateConfigEncryptionSampleAes',
    'JobTemplateConfigEncryptionSecretManagerKeySource',
    'JobTemplateConfigInput',
    'JobTemplateConfigManifest',
    'JobTemplateConfigMuxStream',
    'JobTemplateConfigMuxStreamSegmentSettings',
    'JobTemplateConfigOutput',
    'JobTemplateConfigOverlay',
    'JobTemplateConfigOverlayAnimation',
    'JobTemplateConfigOverlayAnimationAnimationFade',
    'JobTemplateConfigOverlayAnimationAnimationFadeXy',
    'JobTemplateConfigOverlayImage',
    'JobTemplateConfigPubsubDestination',
]

@pulumi.output_type
class JobConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adBreaks":
            suggest = "ad_breaks"
        elif key == "editLists":
            suggest = "edit_lists"
        elif key == "elementaryStreams":
            suggest = "elementary_streams"
        elif key == "muxStreams":
            suggest = "mux_streams"
        elif key == "pubsubDestination":
            suggest = "pubsub_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_breaks: Optional[Sequence['outputs.JobConfigAdBreak']] = None,
                 edit_lists: Optional[Sequence['outputs.JobConfigEditList']] = None,
                 elementary_streams: Optional[Sequence['outputs.JobConfigElementaryStream']] = None,
                 encryptions: Optional[Sequence['outputs.JobConfigEncryption']] = None,
                 inputs: Optional[Sequence['outputs.JobConfigInput']] = None,
                 manifests: Optional[Sequence['outputs.JobConfigManifest']] = None,
                 mux_streams: Optional[Sequence['outputs.JobConfigMuxStream']] = None,
                 output: Optional['outputs.JobConfigOutput'] = None,
                 overlays: Optional[Sequence['outputs.JobConfigOverlay']] = None,
                 pubsub_destination: Optional['outputs.JobConfigPubsubDestination'] = None):
        """
        :param Sequence['JobConfigAdBreakArgs'] ad_breaks: Ad break.
               Structure is documented below.
        :param Sequence['JobConfigEditListArgs'] edit_lists: List of input assets stored in Cloud Storage.
               Structure is documented below.
        :param Sequence['JobConfigElementaryStreamArgs'] elementary_streams: List of input assets stored in Cloud Storage.
               Structure is documented below.
        :param Sequence['JobConfigEncryptionArgs'] encryptions: List of encryption configurations for the content.
               Structure is documented below.
        :param Sequence['JobConfigInputArgs'] inputs: List of input assets stored in Cloud Storage.
               Structure is documented below.
        :param Sequence['JobConfigManifestArgs'] manifests: Manifest configuration.
               Structure is documented below.
        :param Sequence['JobConfigMuxStreamArgs'] mux_streams: Multiplexing settings for output stream.
               Structure is documented below.
        :param 'JobConfigOutputArgs' output: Location of output file(s) in a Cloud Storage bucket.
               Structure is documented below.
        :param Sequence['JobConfigOverlayArgs'] overlays: List of overlays on the output video, in descending Z-order.
               Structure is documented below.
        :param 'JobConfigPubsubDestinationArgs' pubsub_destination: Pub/Sub destination.
               Structure is documented below.
        """
        if ad_breaks is not None:
            pulumi.set(__self__, "ad_breaks", ad_breaks)
        if edit_lists is not None:
            pulumi.set(__self__, "edit_lists", edit_lists)
        if elementary_streams is not None:
            pulumi.set(__self__, "elementary_streams", elementary_streams)
        if encryptions is not None:
            pulumi.set(__self__, "encryptions", encryptions)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if manifests is not None:
            pulumi.set(__self__, "manifests", manifests)
        if mux_streams is not None:
            pulumi.set(__self__, "mux_streams", mux_streams)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if overlays is not None:
            pulumi.set(__self__, "overlays", overlays)
        if pubsub_destination is not None:
            pulumi.set(__self__, "pubsub_destination", pubsub_destination)

    @property
    @pulumi.getter(name="adBreaks")
    def ad_breaks(self) -> Optional[Sequence['outputs.JobConfigAdBreak']]:
        """
        Ad break.
        Structure is documented below.
        """
        return pulumi.get(self, "ad_breaks")

    @property
    @pulumi.getter(name="editLists")
    def edit_lists(self) -> Optional[Sequence['outputs.JobConfigEditList']]:
        """
        List of input assets stored in Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "edit_lists")

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Optional[Sequence['outputs.JobConfigElementaryStream']]:
        """
        List of input assets stored in Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "elementary_streams")

    @property
    @pulumi.getter
    def encryptions(self) -> Optional[Sequence['outputs.JobConfigEncryption']]:
        """
        List of encryption configurations for the content.
        Structure is documented below.
        """
        return pulumi.get(self, "encryptions")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.JobConfigInput']]:
        """
        List of input assets stored in Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def manifests(self) -> Optional[Sequence['outputs.JobConfigManifest']]:
        """
        Manifest configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "manifests")

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> Optional[Sequence['outputs.JobConfigMuxStream']]:
        """
        Multiplexing settings for output stream.
        Structure is documented below.
        """
        return pulumi.get(self, "mux_streams")

    @property
    @pulumi.getter
    def output(self) -> Optional['outputs.JobConfigOutput']:
        """
        Location of output file(s) in a Cloud Storage bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def overlays(self) -> Optional[Sequence['outputs.JobConfigOverlay']]:
        """
        List of overlays on the output video, in descending Z-order.
        Structure is documented below.
        """
        return pulumi.get(self, "overlays")

    @property
    @pulumi.getter(name="pubsubDestination")
    def pubsub_destination(self) -> Optional['outputs.JobConfigPubsubDestination']:
        """
        Pub/Sub destination.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_destination")


@pulumi.output_type
class JobConfigAdBreak(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigAdBreak. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigAdBreak.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigAdBreak.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time_offset: Optional[builtins.str] = None):
        """
        :param builtins.str start_time_offset: Start time in seconds for the ad break, relative to the output file timeline
        """
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[builtins.str]:
        """
        Start time in seconds for the ad break, relative to the output file timeline
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class JobConfigEditList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigEditList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigEditList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigEditList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inputs: Optional[Sequence[builtins.str]] = None,
                 key: Optional[builtins.str] = None,
                 start_time_offset: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] inputs: List of values identifying files that should be used in this atom.
        :param builtins.str key: A unique key for this atom.
        :param builtins.str start_time_offset: Start time in seconds for the atom, relative to the input file timeline. The default is `0s`.
        """
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence[builtins.str]]:
        """
        List of values identifying files that should be used in this atom.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this atom.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[builtins.str]:
        """
        Start time in seconds for the atom, relative to the input file timeline. The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class JobConfigElementaryStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioStream":
            suggest = "audio_stream"
        elif key == "videoStream":
            suggest = "video_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigElementaryStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigElementaryStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigElementaryStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_stream: Optional['outputs.JobConfigElementaryStreamAudioStream'] = None,
                 key: Optional[builtins.str] = None,
                 video_stream: Optional['outputs.JobConfigElementaryStreamVideoStream'] = None):
        """
        :param 'JobConfigElementaryStreamAudioStreamArgs' audio_stream: Encoding of an audio stream.
               Structure is documented below.
        :param builtins.str key: A unique key for this atom.
        :param 'JobConfigElementaryStreamVideoStreamArgs' video_stream: Encoding of a video stream.
               Structure is documented below.
        """
        if audio_stream is not None:
            pulumi.set(__self__, "audio_stream", audio_stream)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if video_stream is not None:
            pulumi.set(__self__, "video_stream", video_stream)

    @property
    @pulumi.getter(name="audioStream")
    def audio_stream(self) -> Optional['outputs.JobConfigElementaryStreamAudioStream']:
        """
        Encoding of an audio stream.
        Structure is documented below.
        """
        return pulumi.get(self, "audio_stream")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this atom.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="videoStream")
    def video_stream(self) -> Optional['outputs.JobConfigElementaryStreamVideoStream']:
        """
        Encoding of a video stream.
        Structure is documented below.
        """
        return pulumi.get(self, "video_stream")


@pulumi.output_type
class JobConfigElementaryStreamAudioStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitrateBps":
            suggest = "bitrate_bps"
        elif key == "channelCount":
            suggest = "channel_count"
        elif key == "channelLayouts":
            suggest = "channel_layouts"
        elif key == "sampleRateHertz":
            suggest = "sample_rate_hertz"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigElementaryStreamAudioStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigElementaryStreamAudioStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigElementaryStreamAudioStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitrate_bps: builtins.int,
                 channel_count: Optional[builtins.int] = None,
                 channel_layouts: Optional[Sequence[builtins.str]] = None,
                 codec: Optional[builtins.str] = None,
                 sample_rate_hertz: Optional[builtins.int] = None):
        """
        :param builtins.int bitrate_bps: Audio bitrate in bits per second.
        :param builtins.int channel_count: Number of audio channels. The default is `2`.
        :param Sequence[builtins.str] channel_layouts: A list of channel names specifying layout of the audio channels. The default is ["fl", "fr"].
        :param builtins.str codec: The codec for this audio stream. The default is `aac`.
        :param builtins.int sample_rate_hertz: The audio sample rate in Hertz. The default is `48000`.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        if channel_count is not None:
            pulumi.set(__self__, "channel_count", channel_count)
        if channel_layouts is not None:
            pulumi.set(__self__, "channel_layouts", channel_layouts)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if sample_rate_hertz is not None:
            pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> builtins.int:
        """
        Audio bitrate in bits per second.
        """
        return pulumi.get(self, "bitrate_bps")

    @property
    @pulumi.getter(name="channelCount")
    def channel_count(self) -> Optional[builtins.int]:
        """
        Number of audio channels. The default is `2`.
        """
        return pulumi.get(self, "channel_count")

    @property
    @pulumi.getter(name="channelLayouts")
    def channel_layouts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of channel names specifying layout of the audio channels. The default is ["fl", "fr"].
        """
        return pulumi.get(self, "channel_layouts")

    @property
    @pulumi.getter
    def codec(self) -> Optional[builtins.str]:
        """
        The codec for this audio stream. The default is `aac`.
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> Optional[builtins.int]:
        """
        The audio sample rate in Hertz. The default is `48000`.
        """
        return pulumi.get(self, "sample_rate_hertz")


@pulumi.output_type
class JobConfigElementaryStreamVideoStream(dict):
    def __init__(__self__, *,
                 h264: Optional['outputs.JobConfigElementaryStreamVideoStreamH264'] = None):
        """
        :param 'JobConfigElementaryStreamVideoStreamH264Args' h264: H264 codec settings
               Structure is documented below.
               
               
               <a name="nested_config_elementary_streams_elementary_streams_video_stream_h264"></a>The `h264` block supports:
        """
        if h264 is not None:
            pulumi.set(__self__, "h264", h264)

    @property
    @pulumi.getter
    def h264(self) -> Optional['outputs.JobConfigElementaryStreamVideoStreamH264']:
        """
        H264 codec settings
        Structure is documented below.


        <a name="nested_config_elementary_streams_elementary_streams_video_stream_h264"></a>The `h264` block supports:
        """
        return pulumi.get(self, "h264")


@pulumi.output_type
class JobConfigElementaryStreamVideoStreamH264(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitrateBps":
            suggest = "bitrate_bps"
        elif key == "frameRate":
            suggest = "frame_rate"
        elif key == "crfLevel":
            suggest = "crf_level"
        elif key == "entropyCoder":
            suggest = "entropy_coder"
        elif key == "gopDuration":
            suggest = "gop_duration"
        elif key == "heightPixels":
            suggest = "height_pixels"
        elif key == "pixelFormat":
            suggest = "pixel_format"
        elif key == "rateControlMode":
            suggest = "rate_control_mode"
        elif key == "vbvFullnessBits":
            suggest = "vbv_fullness_bits"
        elif key == "vbvSizeBits":
            suggest = "vbv_size_bits"
        elif key == "widthPixels":
            suggest = "width_pixels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigElementaryStreamVideoStreamH264. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigElementaryStreamVideoStreamH264.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigElementaryStreamVideoStreamH264.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitrate_bps: builtins.int,
                 frame_rate: builtins.int,
                 crf_level: Optional[builtins.int] = None,
                 entropy_coder: Optional[builtins.str] = None,
                 gop_duration: Optional[builtins.str] = None,
                 height_pixels: Optional[builtins.int] = None,
                 hlg: Optional['outputs.JobConfigElementaryStreamVideoStreamH264Hlg'] = None,
                 pixel_format: Optional[builtins.str] = None,
                 preset: Optional[builtins.str] = None,
                 profile: Optional[builtins.str] = None,
                 rate_control_mode: Optional[builtins.str] = None,
                 sdr: Optional['outputs.JobConfigElementaryStreamVideoStreamH264Sdr'] = None,
                 vbv_fullness_bits: Optional[builtins.int] = None,
                 vbv_size_bits: Optional[builtins.int] = None,
                 width_pixels: Optional[builtins.int] = None):
        """
        :param builtins.int bitrate_bps: The video bitrate in bits per second.
        :param builtins.int frame_rate: The target video frame rate in frames per second (FPS).
        :param builtins.int crf_level: Target CRF level. The default is '21'.
        :param builtins.str entropy_coder: The entropy coder to use. The default is 'cabac'.
        :param builtins.str gop_duration: Select the GOP size based on the specified duration. The default is '3s'.
        :param builtins.int height_pixels: The height of the video in pixels.
        :param 'JobConfigElementaryStreamVideoStreamH264HlgArgs' hlg: HLG color format setting for H264.
        :param builtins.str pixel_format: Pixel format to use. The default is 'yuv420p'.
        :param builtins.str preset: Enforces the specified codec preset. The default is 'veryfast'.
        :param builtins.str profile: Enforces the specified codec profile.
        :param builtins.str rate_control_mode: Specify the mode. The default is 'vbr'.
        :param 'JobConfigElementaryStreamVideoStreamH264SdrArgs' sdr: SDR color format setting for H264.
        :param builtins.int vbv_fullness_bits: Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
        :param builtins.int vbv_size_bits: Size of the Video Buffering Verifier (VBV) buffer in bits.
        :param builtins.int width_pixels: The width of the video in pixels.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        pulumi.set(__self__, "frame_rate", frame_rate)
        if crf_level is not None:
            pulumi.set(__self__, "crf_level", crf_level)
        if entropy_coder is not None:
            pulumi.set(__self__, "entropy_coder", entropy_coder)
        if gop_duration is not None:
            pulumi.set(__self__, "gop_duration", gop_duration)
        if height_pixels is not None:
            pulumi.set(__self__, "height_pixels", height_pixels)
        if hlg is not None:
            pulumi.set(__self__, "hlg", hlg)
        if pixel_format is not None:
            pulumi.set(__self__, "pixel_format", pixel_format)
        if preset is not None:
            pulumi.set(__self__, "preset", preset)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if sdr is not None:
            pulumi.set(__self__, "sdr", sdr)
        if vbv_fullness_bits is not None:
            pulumi.set(__self__, "vbv_fullness_bits", vbv_fullness_bits)
        if vbv_size_bits is not None:
            pulumi.set(__self__, "vbv_size_bits", vbv_size_bits)
        if width_pixels is not None:
            pulumi.set(__self__, "width_pixels", width_pixels)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> builtins.int:
        """
        The video bitrate in bits per second.
        """
        return pulumi.get(self, "bitrate_bps")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> builtins.int:
        """
        The target video frame rate in frames per second (FPS).
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter(name="crfLevel")
    def crf_level(self) -> Optional[builtins.int]:
        """
        Target CRF level. The default is '21'.
        """
        return pulumi.get(self, "crf_level")

    @property
    @pulumi.getter(name="entropyCoder")
    def entropy_coder(self) -> Optional[builtins.str]:
        """
        The entropy coder to use. The default is 'cabac'.
        """
        return pulumi.get(self, "entropy_coder")

    @property
    @pulumi.getter(name="gopDuration")
    def gop_duration(self) -> Optional[builtins.str]:
        """
        Select the GOP size based on the specified duration. The default is '3s'.
        """
        return pulumi.get(self, "gop_duration")

    @property
    @pulumi.getter(name="heightPixels")
    def height_pixels(self) -> Optional[builtins.int]:
        """
        The height of the video in pixels.
        """
        return pulumi.get(self, "height_pixels")

    @property
    @pulumi.getter
    def hlg(self) -> Optional['outputs.JobConfigElementaryStreamVideoStreamH264Hlg']:
        """
        HLG color format setting for H264.
        """
        return pulumi.get(self, "hlg")

    @property
    @pulumi.getter(name="pixelFormat")
    def pixel_format(self) -> Optional[builtins.str]:
        """
        Pixel format to use. The default is 'yuv420p'.
        """
        return pulumi.get(self, "pixel_format")

    @property
    @pulumi.getter
    def preset(self) -> Optional[builtins.str]:
        """
        Enforces the specified codec preset. The default is 'veryfast'.
        """
        return pulumi.get(self, "preset")

    @property
    @pulumi.getter
    def profile(self) -> Optional[builtins.str]:
        """
        Enforces the specified codec profile.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[builtins.str]:
        """
        Specify the mode. The default is 'vbr'.
        """
        return pulumi.get(self, "rate_control_mode")

    @property
    @pulumi.getter
    def sdr(self) -> Optional['outputs.JobConfigElementaryStreamVideoStreamH264Sdr']:
        """
        SDR color format setting for H264.
        """
        return pulumi.get(self, "sdr")

    @property
    @pulumi.getter(name="vbvFullnessBits")
    def vbv_fullness_bits(self) -> Optional[builtins.int]:
        """
        Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
        """
        return pulumi.get(self, "vbv_fullness_bits")

    @property
    @pulumi.getter(name="vbvSizeBits")
    def vbv_size_bits(self) -> Optional[builtins.int]:
        """
        Size of the Video Buffering Verifier (VBV) buffer in bits.
        """
        return pulumi.get(self, "vbv_size_bits")

    @property
    @pulumi.getter(name="widthPixels")
    def width_pixels(self) -> Optional[builtins.int]:
        """
        The width of the video in pixels.
        """
        return pulumi.get(self, "width_pixels")


@pulumi.output_type
class JobConfigElementaryStreamVideoStreamH264Hlg(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigElementaryStreamVideoStreamH264Sdr(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drmSystems":
            suggest = "drm_systems"
        elif key == "mpegCenc":
            suggest = "mpeg_cenc"
        elif key == "sampleAes":
            suggest = "sample_aes"
        elif key == "secretManagerKeySource":
            suggest = "secret_manager_key_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 aes128: Optional['outputs.JobConfigEncryptionAes128'] = None,
                 drm_systems: Optional['outputs.JobConfigEncryptionDrmSystems'] = None,
                 mpeg_cenc: Optional['outputs.JobConfigEncryptionMpegCenc'] = None,
                 sample_aes: Optional['outputs.JobConfigEncryptionSampleAes'] = None,
                 secret_manager_key_source: Optional['outputs.JobConfigEncryptionSecretManagerKeySource'] = None):
        """
        :param builtins.str id: Identifier for this set of encryption options.
        :param 'JobConfigEncryptionAes128Args' aes128: Configuration for AES-128 encryption.
        :param 'JobConfigEncryptionDrmSystemsArgs' drm_systems: DRM system(s) to use; at least one must be specified. If a DRM system is omitted, it is considered disabled.
               Structure is documented below.
        :param 'JobConfigEncryptionMpegCencArgs' mpeg_cenc: Configuration for MPEG Common Encryption (MPEG-CENC).
               Structure is documented below.
        :param 'JobConfigEncryptionSampleAesArgs' sample_aes: Configuration for SAMPLE-AES encryption.
        :param 'JobConfigEncryptionSecretManagerKeySourceArgs' secret_manager_key_source: Configuration for secrets stored in Google Secret Manager.
               Structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        if aes128 is not None:
            pulumi.set(__self__, "aes128", aes128)
        if drm_systems is not None:
            pulumi.set(__self__, "drm_systems", drm_systems)
        if mpeg_cenc is not None:
            pulumi.set(__self__, "mpeg_cenc", mpeg_cenc)
        if sample_aes is not None:
            pulumi.set(__self__, "sample_aes", sample_aes)
        if secret_manager_key_source is not None:
            pulumi.set(__self__, "secret_manager_key_source", secret_manager_key_source)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier for this set of encryption options.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def aes128(self) -> Optional['outputs.JobConfigEncryptionAes128']:
        """
        Configuration for AES-128 encryption.
        """
        return pulumi.get(self, "aes128")

    @property
    @pulumi.getter(name="drmSystems")
    def drm_systems(self) -> Optional['outputs.JobConfigEncryptionDrmSystems']:
        """
        DRM system(s) to use; at least one must be specified. If a DRM system is omitted, it is considered disabled.
        Structure is documented below.
        """
        return pulumi.get(self, "drm_systems")

    @property
    @pulumi.getter(name="mpegCenc")
    def mpeg_cenc(self) -> Optional['outputs.JobConfigEncryptionMpegCenc']:
        """
        Configuration for MPEG Common Encryption (MPEG-CENC).
        Structure is documented below.
        """
        return pulumi.get(self, "mpeg_cenc")

    @property
    @pulumi.getter(name="sampleAes")
    def sample_aes(self) -> Optional['outputs.JobConfigEncryptionSampleAes']:
        """
        Configuration for SAMPLE-AES encryption.
        """
        return pulumi.get(self, "sample_aes")

    @property
    @pulumi.getter(name="secretManagerKeySource")
    def secret_manager_key_source(self) -> Optional['outputs.JobConfigEncryptionSecretManagerKeySource']:
        """
        Configuration for secrets stored in Google Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_manager_key_source")


@pulumi.output_type
class JobConfigEncryptionAes128(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigEncryptionDrmSystems(dict):
    def __init__(__self__, *,
                 clearkey: Optional['outputs.JobConfigEncryptionDrmSystemsClearkey'] = None,
                 fairplay: Optional['outputs.JobConfigEncryptionDrmSystemsFairplay'] = None,
                 playready: Optional['outputs.JobConfigEncryptionDrmSystemsPlayready'] = None,
                 widevine: Optional['outputs.JobConfigEncryptionDrmSystemsWidevine'] = None):
        """
        :param 'JobConfigEncryptionDrmSystemsClearkeyArgs' clearkey: Clearkey configuration.
        :param 'JobConfigEncryptionDrmSystemsFairplayArgs' fairplay: Fairplay configuration.
        :param 'JobConfigEncryptionDrmSystemsPlayreadyArgs' playready: Playready configuration.
        :param 'JobConfigEncryptionDrmSystemsWidevineArgs' widevine: Widevine configuration.
        """
        if clearkey is not None:
            pulumi.set(__self__, "clearkey", clearkey)
        if fairplay is not None:
            pulumi.set(__self__, "fairplay", fairplay)
        if playready is not None:
            pulumi.set(__self__, "playready", playready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter
    def clearkey(self) -> Optional['outputs.JobConfigEncryptionDrmSystemsClearkey']:
        """
        Clearkey configuration.
        """
        return pulumi.get(self, "clearkey")

    @property
    @pulumi.getter
    def fairplay(self) -> Optional['outputs.JobConfigEncryptionDrmSystemsFairplay']:
        """
        Fairplay configuration.
        """
        return pulumi.get(self, "fairplay")

    @property
    @pulumi.getter
    def playready(self) -> Optional['outputs.JobConfigEncryptionDrmSystemsPlayready']:
        """
        Playready configuration.
        """
        return pulumi.get(self, "playready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.JobConfigEncryptionDrmSystemsWidevine']:
        """
        Widevine configuration.
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class JobConfigEncryptionDrmSystemsClearkey(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigEncryptionDrmSystemsFairplay(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigEncryptionDrmSystemsPlayready(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigEncryptionDrmSystemsWidevine(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigEncryptionMpegCenc(dict):
    def __init__(__self__, *,
                 scheme: builtins.str):
        """
        :param builtins.str scheme: Specify the encryption scheme.
        """
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def scheme(self) -> builtins.str:
        """
        Specify the encryption scheme.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class JobConfigEncryptionSampleAes(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobConfigEncryptionSecretManagerKeySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigEncryptionSecretManagerKeySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigEncryptionSecretManagerKeySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigEncryptionSecretManagerKeySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: builtins.str):
        """
        :param builtins.str secret_version: The name of the Secret Version containing the encryption key in the following format: projects/{project}/secrets/{secret_id}/versions/{version_number}.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> builtins.str:
        """
        The name of the Secret Version containing the encryption key in the following format: projects/{project}/secrets/{secret_id}/versions/{version_number}.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class JobConfigInput(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str key: A unique key for this input. Must be specified when using advanced mapping and edit lists.
        :param builtins.str uri: URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, gs://bucket/inputs/file.mp4).
               If empty, the value is populated from Job.input_uri.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this input. Must be specified when using advanced mapping and edit lists.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, gs://bucket/inputs/file.mp4).
        If empty, the value is populated from Job.input_uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class JobConfigManifest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"
        elif key == "muxStreams":
            suggest = "mux_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_name: Optional[builtins.str] = None,
                 mux_streams: Optional[Sequence[builtins.str]] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str file_name: The name of the generated file. The default is `manifest`.
        :param Sequence[builtins.str] mux_streams: List of user supplied MuxStream.key values that should appear in this manifest.
        :param builtins.str type: Type of the manifest.
               Possible values are: `MANIFEST_TYPE_UNSPECIFIED`, `HLS`, `DASH`.
        """
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if mux_streams is not None:
            pulumi.set(__self__, "mux_streams", mux_streams)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[builtins.str]:
        """
        The name of the generated file. The default is `manifest`.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> Optional[Sequence[builtins.str]]:
        """
        List of user supplied MuxStream.key values that should appear in this manifest.
        """
        return pulumi.get(self, "mux_streams")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Type of the manifest.
        Possible values are: `MANIFEST_TYPE_UNSPECIFIED`, `HLS`, `DASH`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobConfigMuxStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elementaryStreams":
            suggest = "elementary_streams"
        elif key == "encryptionId":
            suggest = "encryption_id"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "segmentSettings":
            suggest = "segment_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigMuxStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigMuxStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigMuxStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: Optional[builtins.str] = None,
                 elementary_streams: Optional[Sequence[builtins.str]] = None,
                 encryption_id: Optional[builtins.str] = None,
                 file_name: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 segment_settings: Optional['outputs.JobConfigMuxStreamSegmentSettings'] = None):
        """
        :param builtins.str container: The container format. The default is `mp4`.
        :param Sequence[builtins.str] elementary_streams: List of ElementaryStream.key values multiplexed in this stream.
        :param builtins.str encryption_id: Identifier of the encryption configuration to use.
        :param builtins.str file_name: The name of the generated file.
        :param builtins.str key: A unique key for this multiplexed stream.
        :param 'JobConfigMuxStreamSegmentSettingsArgs' segment_settings: Segment settings for ts, fmp4 and vtt.
               Structure is documented below.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if elementary_streams is not None:
            pulumi.set(__self__, "elementary_streams", elementary_streams)
        if encryption_id is not None:
            pulumi.set(__self__, "encryption_id", encryption_id)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if segment_settings is not None:
            pulumi.set(__self__, "segment_settings", segment_settings)

    @property
    @pulumi.getter
    def container(self) -> Optional[builtins.str]:
        """
        The container format. The default is `mp4`.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Optional[Sequence[builtins.str]]:
        """
        List of ElementaryStream.key values multiplexed in this stream.
        """
        return pulumi.get(self, "elementary_streams")

    @property
    @pulumi.getter(name="encryptionId")
    def encryption_id(self) -> Optional[builtins.str]:
        """
        Identifier of the encryption configuration to use.
        """
        return pulumi.get(self, "encryption_id")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[builtins.str]:
        """
        The name of the generated file.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this multiplexed stream.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="segmentSettings")
    def segment_settings(self) -> Optional['outputs.JobConfigMuxStreamSegmentSettings']:
        """
        Segment settings for ts, fmp4 and vtt.
        Structure is documented below.
        """
        return pulumi.get(self, "segment_settings")


@pulumi.output_type
class JobConfigMuxStreamSegmentSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentDuration":
            suggest = "segment_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigMuxStreamSegmentSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigMuxStreamSegmentSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigMuxStreamSegmentSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 segment_duration: Optional[builtins.str] = None):
        """
        :param builtins.str segment_duration: Duration of the segments in seconds. The default is `6.0s`.
        """
        if segment_duration is not None:
            pulumi.set(__self__, "segment_duration", segment_duration)

    @property
    @pulumi.getter(name="segmentDuration")
    def segment_duration(self) -> Optional[builtins.str]:
        """
        Duration of the segments in seconds. The default is `6.0s`.
        """
        return pulumi.get(self, "segment_duration")


@pulumi.output_type
class JobConfigOutput(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: URI for the output file(s). For example, gs://my-bucket/outputs/.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        URI for the output file(s). For example, gs://my-bucket/outputs/.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class JobConfigOverlay(dict):
    def __init__(__self__, *,
                 animations: Optional[Sequence['outputs.JobConfigOverlayAnimation']] = None,
                 image: Optional['outputs.JobConfigOverlayImage'] = None):
        """
        :param Sequence['JobConfigOverlayAnimationArgs'] animations: List of animations. The list should be chronological, without any time overlap.
               Structure is documented below.
        :param 'JobConfigOverlayImageArgs' image: Image overlay.
               Structure is documented below.
        """
        if animations is not None:
            pulumi.set(__self__, "animations", animations)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def animations(self) -> Optional[Sequence['outputs.JobConfigOverlayAnimation']]:
        """
        List of animations. The list should be chronological, without any time overlap.
        Structure is documented below.
        """
        return pulumi.get(self, "animations")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.JobConfigOverlayImage']:
        """
        Image overlay.
        Structure is documented below.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class JobConfigOverlayAnimation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "animationFade":
            suggest = "animation_fade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigOverlayAnimation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigOverlayAnimation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigOverlayAnimation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 animation_fade: Optional['outputs.JobConfigOverlayAnimationAnimationFade'] = None):
        """
        :param 'JobConfigOverlayAnimationAnimationFadeArgs' animation_fade: Display overlay object with fade animation.
               Structure is documented below.
        """
        if animation_fade is not None:
            pulumi.set(__self__, "animation_fade", animation_fade)

    @property
    @pulumi.getter(name="animationFade")
    def animation_fade(self) -> Optional['outputs.JobConfigOverlayAnimationAnimationFade']:
        """
        Display overlay object with fade animation.
        Structure is documented below.
        """
        return pulumi.get(self, "animation_fade")


@pulumi.output_type
class JobConfigOverlayAnimationAnimationFade(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fadeType":
            suggest = "fade_type"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigOverlayAnimationAnimationFade. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigOverlayAnimationAnimationFade.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigOverlayAnimationAnimationFade.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fade_type: builtins.str,
                 end_time_offset: Optional[builtins.str] = None,
                 start_time_offset: Optional[builtins.str] = None,
                 xy: Optional['outputs.JobConfigOverlayAnimationAnimationFadeXy'] = None):
        """
        :param builtins.str fade_type: Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
               The possible values are:
               * `FADE_TYPE_UNSPECIFIED`: The fade type is not specified.
               * `FADE_IN`: Fade the overlay object into view.
               * `FADE_OUT`: Fade the overlay object out of view.
               Possible values are: `FADE_TYPE_UNSPECIFIED`, `FADE_IN`, `FADE_OUT`.
        :param builtins.str end_time_offset: The time to end the fade animation, in seconds.
        :param builtins.str start_time_offset: The time to start the fade animation, in seconds.
        :param 'JobConfigOverlayAnimationAnimationFadeXyArgs' xy: Normalized coordinates based on output video resolution.
               Structure is documented below.
        """
        pulumi.set(__self__, "fade_type", fade_type)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)
        if xy is not None:
            pulumi.set(__self__, "xy", xy)

    @property
    @pulumi.getter(name="fadeType")
    def fade_type(self) -> builtins.str:
        """
        Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
        The possible values are:
        * `FADE_TYPE_UNSPECIFIED`: The fade type is not specified.
        * `FADE_IN`: Fade the overlay object into view.
        * `FADE_OUT`: Fade the overlay object out of view.
        Possible values are: `FADE_TYPE_UNSPECIFIED`, `FADE_IN`, `FADE_OUT`.
        """
        return pulumi.get(self, "fade_type")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[builtins.str]:
        """
        The time to end the fade animation, in seconds.
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[builtins.str]:
        """
        The time to start the fade animation, in seconds.
        """
        return pulumi.get(self, "start_time_offset")

    @property
    @pulumi.getter
    def xy(self) -> Optional['outputs.JobConfigOverlayAnimationAnimationFadeXy']:
        """
        Normalized coordinates based on output video resolution.
        Structure is documented below.
        """
        return pulumi.get(self, "xy")


@pulumi.output_type
class JobConfigOverlayAnimationAnimationFadeXy(dict):
    def __init__(__self__, *,
                 x: Optional[builtins.float] = None,
                 y: Optional[builtins.float] = None):
        """
        :param builtins.float x: Normalized x coordinate.
        :param builtins.float y: Normalized y coordinate.
        """
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> Optional[builtins.float]:
        """
        Normalized x coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> Optional[builtins.float]:
        """
        Normalized y coordinate.
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class JobConfigOverlayImage(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: URI of the image in Cloud Storage. For example, gs://bucket/inputs/image.png.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        URI of the image in Cloud Storage. For example, gs://bucket/inputs/image.png.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class JobConfigPubsubDestination(dict):
    def __init__(__self__, *,
                 topic: Optional[builtins.str] = None):
        """
        :param builtins.str topic: The name of the Pub/Sub topic to publish job completion notification to. For example: projects/{project}/topics/{topic}.
        """
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> Optional[builtins.str]:
        """
        The name of the Pub/Sub topic to publish job completion notification to. For example: projects/{project}/topics/{topic}.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class JobTemplateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adBreaks":
            suggest = "ad_breaks"
        elif key == "editLists":
            suggest = "edit_lists"
        elif key == "elementaryStreams":
            suggest = "elementary_streams"
        elif key == "muxStreams":
            suggest = "mux_streams"
        elif key == "pubsubDestination":
            suggest = "pubsub_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_breaks: Optional[Sequence['outputs.JobTemplateConfigAdBreak']] = None,
                 edit_lists: Optional[Sequence['outputs.JobTemplateConfigEditList']] = None,
                 elementary_streams: Optional[Sequence['outputs.JobTemplateConfigElementaryStream']] = None,
                 encryptions: Optional[Sequence['outputs.JobTemplateConfigEncryption']] = None,
                 inputs: Optional[Sequence['outputs.JobTemplateConfigInput']] = None,
                 manifests: Optional[Sequence['outputs.JobTemplateConfigManifest']] = None,
                 mux_streams: Optional[Sequence['outputs.JobTemplateConfigMuxStream']] = None,
                 output: Optional['outputs.JobTemplateConfigOutput'] = None,
                 overlays: Optional[Sequence['outputs.JobTemplateConfigOverlay']] = None,
                 pubsub_destination: Optional['outputs.JobTemplateConfigPubsubDestination'] = None):
        """
        :param Sequence['JobTemplateConfigAdBreakArgs'] ad_breaks: Ad break.
               Structure is documented below.
        :param Sequence['JobTemplateConfigEditListArgs'] edit_lists: List of input assets stored in Cloud Storage.
               Structure is documented below.
        :param Sequence['JobTemplateConfigElementaryStreamArgs'] elementary_streams: List of input assets stored in Cloud Storage.
               Structure is documented below.
        :param Sequence['JobTemplateConfigEncryptionArgs'] encryptions: List of encryption configurations for the content.
               Structure is documented below.
        :param Sequence['JobTemplateConfigInputArgs'] inputs: List of input assets stored in Cloud Storage.
               Structure is documented below.
        :param Sequence['JobTemplateConfigManifestArgs'] manifests: Manifest configuration.
               Structure is documented below.
        :param Sequence['JobTemplateConfigMuxStreamArgs'] mux_streams: Multiplexing settings for output stream.
               Structure is documented below.
        :param 'JobTemplateConfigOutputArgs' output: Location of output file(s) in a Cloud Storage bucket.
               Structure is documented below.
        :param Sequence['JobTemplateConfigOverlayArgs'] overlays: List of overlays on the output video, in descending Z-order.
               Structure is documented below.
        :param 'JobTemplateConfigPubsubDestinationArgs' pubsub_destination: Pub/Sub destination.
               Structure is documented below.
        """
        if ad_breaks is not None:
            pulumi.set(__self__, "ad_breaks", ad_breaks)
        if edit_lists is not None:
            pulumi.set(__self__, "edit_lists", edit_lists)
        if elementary_streams is not None:
            pulumi.set(__self__, "elementary_streams", elementary_streams)
        if encryptions is not None:
            pulumi.set(__self__, "encryptions", encryptions)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if manifests is not None:
            pulumi.set(__self__, "manifests", manifests)
        if mux_streams is not None:
            pulumi.set(__self__, "mux_streams", mux_streams)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if overlays is not None:
            pulumi.set(__self__, "overlays", overlays)
        if pubsub_destination is not None:
            pulumi.set(__self__, "pubsub_destination", pubsub_destination)

    @property
    @pulumi.getter(name="adBreaks")
    def ad_breaks(self) -> Optional[Sequence['outputs.JobTemplateConfigAdBreak']]:
        """
        Ad break.
        Structure is documented below.
        """
        return pulumi.get(self, "ad_breaks")

    @property
    @pulumi.getter(name="editLists")
    def edit_lists(self) -> Optional[Sequence['outputs.JobTemplateConfigEditList']]:
        """
        List of input assets stored in Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "edit_lists")

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Optional[Sequence['outputs.JobTemplateConfigElementaryStream']]:
        """
        List of input assets stored in Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "elementary_streams")

    @property
    @pulumi.getter
    def encryptions(self) -> Optional[Sequence['outputs.JobTemplateConfigEncryption']]:
        """
        List of encryption configurations for the content.
        Structure is documented below.
        """
        return pulumi.get(self, "encryptions")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.JobTemplateConfigInput']]:
        """
        List of input assets stored in Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def manifests(self) -> Optional[Sequence['outputs.JobTemplateConfigManifest']]:
        """
        Manifest configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "manifests")

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> Optional[Sequence['outputs.JobTemplateConfigMuxStream']]:
        """
        Multiplexing settings for output stream.
        Structure is documented below.
        """
        return pulumi.get(self, "mux_streams")

    @property
    @pulumi.getter
    def output(self) -> Optional['outputs.JobTemplateConfigOutput']:
        """
        Location of output file(s) in a Cloud Storage bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def overlays(self) -> Optional[Sequence['outputs.JobTemplateConfigOverlay']]:
        """
        List of overlays on the output video, in descending Z-order.
        Structure is documented below.
        """
        return pulumi.get(self, "overlays")

    @property
    @pulumi.getter(name="pubsubDestination")
    def pubsub_destination(self) -> Optional['outputs.JobTemplateConfigPubsubDestination']:
        """
        Pub/Sub destination.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_destination")


@pulumi.output_type
class JobTemplateConfigAdBreak(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigAdBreak. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigAdBreak.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigAdBreak.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time_offset: Optional[builtins.str] = None):
        """
        :param builtins.str start_time_offset: Start time in seconds for the ad break, relative to the output file timeline
        """
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[builtins.str]:
        """
        Start time in seconds for the ad break, relative to the output file timeline
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class JobTemplateConfigEditList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigEditList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigEditList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigEditList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inputs: Optional[Sequence[builtins.str]] = None,
                 key: Optional[builtins.str] = None,
                 start_time_offset: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] inputs: List of values identifying files that should be used in this atom.
        :param builtins.str key: A unique key for this atom.
        :param builtins.str start_time_offset: Start time in seconds for the atom, relative to the input file timeline.  The default is `0s`.
        """
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence[builtins.str]]:
        """
        List of values identifying files that should be used in this atom.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this atom.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[builtins.str]:
        """
        Start time in seconds for the atom, relative to the input file timeline.  The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class JobTemplateConfigElementaryStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioStream":
            suggest = "audio_stream"
        elif key == "videoStream":
            suggest = "video_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigElementaryStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigElementaryStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigElementaryStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_stream: Optional['outputs.JobTemplateConfigElementaryStreamAudioStream'] = None,
                 key: Optional[builtins.str] = None,
                 video_stream: Optional['outputs.JobTemplateConfigElementaryStreamVideoStream'] = None):
        """
        :param 'JobTemplateConfigElementaryStreamAudioStreamArgs' audio_stream: Encoding of an audio stream.
               Structure is documented below.
        :param builtins.str key: A unique key for this atom.
        :param 'JobTemplateConfigElementaryStreamVideoStreamArgs' video_stream: Encoding of a video stream.
               Structure is documented below.
        """
        if audio_stream is not None:
            pulumi.set(__self__, "audio_stream", audio_stream)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if video_stream is not None:
            pulumi.set(__self__, "video_stream", video_stream)

    @property
    @pulumi.getter(name="audioStream")
    def audio_stream(self) -> Optional['outputs.JobTemplateConfigElementaryStreamAudioStream']:
        """
        Encoding of an audio stream.
        Structure is documented below.
        """
        return pulumi.get(self, "audio_stream")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this atom.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="videoStream")
    def video_stream(self) -> Optional['outputs.JobTemplateConfigElementaryStreamVideoStream']:
        """
        Encoding of a video stream.
        Structure is documented below.
        """
        return pulumi.get(self, "video_stream")


@pulumi.output_type
class JobTemplateConfigElementaryStreamAudioStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitrateBps":
            suggest = "bitrate_bps"
        elif key == "channelCount":
            suggest = "channel_count"
        elif key == "channelLayouts":
            suggest = "channel_layouts"
        elif key == "sampleRateHertz":
            suggest = "sample_rate_hertz"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigElementaryStreamAudioStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigElementaryStreamAudioStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigElementaryStreamAudioStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitrate_bps: builtins.int,
                 channel_count: Optional[builtins.int] = None,
                 channel_layouts: Optional[Sequence[builtins.str]] = None,
                 codec: Optional[builtins.str] = None,
                 sample_rate_hertz: Optional[builtins.int] = None):
        """
        :param builtins.int bitrate_bps: Audio bitrate in bits per second.
        :param builtins.int channel_count: Number of audio channels. The default is `2`.
        :param Sequence[builtins.str] channel_layouts: A list of channel names specifying layout of the audio channels.  The default is ["fl", "fr"].
        :param builtins.str codec: The codec for this audio stream. The default is `aac`.
        :param builtins.int sample_rate_hertz: The audio sample rate in Hertz. The default is `48000`.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        if channel_count is not None:
            pulumi.set(__self__, "channel_count", channel_count)
        if channel_layouts is not None:
            pulumi.set(__self__, "channel_layouts", channel_layouts)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if sample_rate_hertz is not None:
            pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> builtins.int:
        """
        Audio bitrate in bits per second.
        """
        return pulumi.get(self, "bitrate_bps")

    @property
    @pulumi.getter(name="channelCount")
    def channel_count(self) -> Optional[builtins.int]:
        """
        Number of audio channels. The default is `2`.
        """
        return pulumi.get(self, "channel_count")

    @property
    @pulumi.getter(name="channelLayouts")
    def channel_layouts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of channel names specifying layout of the audio channels.  The default is ["fl", "fr"].
        """
        return pulumi.get(self, "channel_layouts")

    @property
    @pulumi.getter
    def codec(self) -> Optional[builtins.str]:
        """
        The codec for this audio stream. The default is `aac`.
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> Optional[builtins.int]:
        """
        The audio sample rate in Hertz. The default is `48000`.
        """
        return pulumi.get(self, "sample_rate_hertz")


@pulumi.output_type
class JobTemplateConfigElementaryStreamVideoStream(dict):
    def __init__(__self__, *,
                 h264: Optional['outputs.JobTemplateConfigElementaryStreamVideoStreamH264'] = None):
        """
        :param 'JobTemplateConfigElementaryStreamVideoStreamH264Args' h264: H264 codec settings
               Structure is documented below.
               
               
               <a name="nested_config_elementary_streams_elementary_streams_video_stream_h264"></a>The `h264` block supports:
        """
        if h264 is not None:
            pulumi.set(__self__, "h264", h264)

    @property
    @pulumi.getter
    def h264(self) -> Optional['outputs.JobTemplateConfigElementaryStreamVideoStreamH264']:
        """
        H264 codec settings
        Structure is documented below.


        <a name="nested_config_elementary_streams_elementary_streams_video_stream_h264"></a>The `h264` block supports:
        """
        return pulumi.get(self, "h264")


@pulumi.output_type
class JobTemplateConfigElementaryStreamVideoStreamH264(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitrateBps":
            suggest = "bitrate_bps"
        elif key == "frameRate":
            suggest = "frame_rate"
        elif key == "crfLevel":
            suggest = "crf_level"
        elif key == "entropyCoder":
            suggest = "entropy_coder"
        elif key == "gopDuration":
            suggest = "gop_duration"
        elif key == "heightPixels":
            suggest = "height_pixels"
        elif key == "pixelFormat":
            suggest = "pixel_format"
        elif key == "rateControlMode":
            suggest = "rate_control_mode"
        elif key == "vbvFullnessBits":
            suggest = "vbv_fullness_bits"
        elif key == "vbvSizeBits":
            suggest = "vbv_size_bits"
        elif key == "widthPixels":
            suggest = "width_pixels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigElementaryStreamVideoStreamH264. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigElementaryStreamVideoStreamH264.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigElementaryStreamVideoStreamH264.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitrate_bps: builtins.int,
                 frame_rate: builtins.int,
                 crf_level: Optional[builtins.int] = None,
                 entropy_coder: Optional[builtins.str] = None,
                 gop_duration: Optional[builtins.str] = None,
                 height_pixels: Optional[builtins.int] = None,
                 hlg: Optional['outputs.JobTemplateConfigElementaryStreamVideoStreamH264Hlg'] = None,
                 pixel_format: Optional[builtins.str] = None,
                 preset: Optional[builtins.str] = None,
                 profile: Optional[builtins.str] = None,
                 rate_control_mode: Optional[builtins.str] = None,
                 sdr: Optional['outputs.JobTemplateConfigElementaryStreamVideoStreamH264Sdr'] = None,
                 vbv_fullness_bits: Optional[builtins.int] = None,
                 vbv_size_bits: Optional[builtins.int] = None,
                 width_pixels: Optional[builtins.int] = None):
        """
        :param builtins.int bitrate_bps: The video bitrate in bits per second.
        :param builtins.int frame_rate: The target video frame rate in frames per second (FPS).
        :param builtins.int crf_level: Target CRF level. The default is '21'.
        :param builtins.str entropy_coder: The entropy coder to use. The default is 'cabac'.
        :param builtins.str gop_duration: Select the GOP size based on the specified duration. The default is '3s'.
        :param builtins.int height_pixels: The height of the video in pixels.
        :param 'JobTemplateConfigElementaryStreamVideoStreamH264HlgArgs' hlg: HLG color format setting for H264.
        :param builtins.str pixel_format: Pixel format to use. The default is 'yuv420p'.
        :param builtins.str preset: Enforces the specified codec preset. The default is 'veryfast'.
        :param builtins.str profile: Enforces the specified codec profile.
        :param builtins.str rate_control_mode: Specify the mode. The default is 'vbr'.
        :param 'JobTemplateConfigElementaryStreamVideoStreamH264SdrArgs' sdr: SDR color format setting for H264.
        :param builtins.int vbv_fullness_bits: Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
        :param builtins.int vbv_size_bits: Size of the Video Buffering Verifier (VBV) buffer in bits.
        :param builtins.int width_pixels: The width of the video in pixels.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        pulumi.set(__self__, "frame_rate", frame_rate)
        if crf_level is not None:
            pulumi.set(__self__, "crf_level", crf_level)
        if entropy_coder is not None:
            pulumi.set(__self__, "entropy_coder", entropy_coder)
        if gop_duration is not None:
            pulumi.set(__self__, "gop_duration", gop_duration)
        if height_pixels is not None:
            pulumi.set(__self__, "height_pixels", height_pixels)
        if hlg is not None:
            pulumi.set(__self__, "hlg", hlg)
        if pixel_format is not None:
            pulumi.set(__self__, "pixel_format", pixel_format)
        if preset is not None:
            pulumi.set(__self__, "preset", preset)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if sdr is not None:
            pulumi.set(__self__, "sdr", sdr)
        if vbv_fullness_bits is not None:
            pulumi.set(__self__, "vbv_fullness_bits", vbv_fullness_bits)
        if vbv_size_bits is not None:
            pulumi.set(__self__, "vbv_size_bits", vbv_size_bits)
        if width_pixels is not None:
            pulumi.set(__self__, "width_pixels", width_pixels)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> builtins.int:
        """
        The video bitrate in bits per second.
        """
        return pulumi.get(self, "bitrate_bps")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> builtins.int:
        """
        The target video frame rate in frames per second (FPS).
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter(name="crfLevel")
    def crf_level(self) -> Optional[builtins.int]:
        """
        Target CRF level. The default is '21'.
        """
        return pulumi.get(self, "crf_level")

    @property
    @pulumi.getter(name="entropyCoder")
    def entropy_coder(self) -> Optional[builtins.str]:
        """
        The entropy coder to use. The default is 'cabac'.
        """
        return pulumi.get(self, "entropy_coder")

    @property
    @pulumi.getter(name="gopDuration")
    def gop_duration(self) -> Optional[builtins.str]:
        """
        Select the GOP size based on the specified duration. The default is '3s'.
        """
        return pulumi.get(self, "gop_duration")

    @property
    @pulumi.getter(name="heightPixels")
    def height_pixels(self) -> Optional[builtins.int]:
        """
        The height of the video in pixels.
        """
        return pulumi.get(self, "height_pixels")

    @property
    @pulumi.getter
    def hlg(self) -> Optional['outputs.JobTemplateConfigElementaryStreamVideoStreamH264Hlg']:
        """
        HLG color format setting for H264.
        """
        return pulumi.get(self, "hlg")

    @property
    @pulumi.getter(name="pixelFormat")
    def pixel_format(self) -> Optional[builtins.str]:
        """
        Pixel format to use. The default is 'yuv420p'.
        """
        return pulumi.get(self, "pixel_format")

    @property
    @pulumi.getter
    def preset(self) -> Optional[builtins.str]:
        """
        Enforces the specified codec preset. The default is 'veryfast'.
        """
        return pulumi.get(self, "preset")

    @property
    @pulumi.getter
    def profile(self) -> Optional[builtins.str]:
        """
        Enforces the specified codec profile.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[builtins.str]:
        """
        Specify the mode. The default is 'vbr'.
        """
        return pulumi.get(self, "rate_control_mode")

    @property
    @pulumi.getter
    def sdr(self) -> Optional['outputs.JobTemplateConfigElementaryStreamVideoStreamH264Sdr']:
        """
        SDR color format setting for H264.
        """
        return pulumi.get(self, "sdr")

    @property
    @pulumi.getter(name="vbvFullnessBits")
    def vbv_fullness_bits(self) -> Optional[builtins.int]:
        """
        Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
        """
        return pulumi.get(self, "vbv_fullness_bits")

    @property
    @pulumi.getter(name="vbvSizeBits")
    def vbv_size_bits(self) -> Optional[builtins.int]:
        """
        Size of the Video Buffering Verifier (VBV) buffer in bits.
        """
        return pulumi.get(self, "vbv_size_bits")

    @property
    @pulumi.getter(name="widthPixels")
    def width_pixels(self) -> Optional[builtins.int]:
        """
        The width of the video in pixels.
        """
        return pulumi.get(self, "width_pixels")


@pulumi.output_type
class JobTemplateConfigElementaryStreamVideoStreamH264Hlg(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigElementaryStreamVideoStreamH264Sdr(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drmSystems":
            suggest = "drm_systems"
        elif key == "mpegCenc":
            suggest = "mpeg_cenc"
        elif key == "sampleAes":
            suggest = "sample_aes"
        elif key == "secretManagerKeySource":
            suggest = "secret_manager_key_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 aes128: Optional['outputs.JobTemplateConfigEncryptionAes128'] = None,
                 drm_systems: Optional['outputs.JobTemplateConfigEncryptionDrmSystems'] = None,
                 mpeg_cenc: Optional['outputs.JobTemplateConfigEncryptionMpegCenc'] = None,
                 sample_aes: Optional['outputs.JobTemplateConfigEncryptionSampleAes'] = None,
                 secret_manager_key_source: Optional['outputs.JobTemplateConfigEncryptionSecretManagerKeySource'] = None):
        """
        :param builtins.str id: Identifier for this set of encryption options.
        :param 'JobTemplateConfigEncryptionAes128Args' aes128: Configuration for AES-128 encryption.
        :param 'JobTemplateConfigEncryptionDrmSystemsArgs' drm_systems: DRM system(s) to use; at least one must be specified. If a DRM system is omitted, it is considered disabled.
               Structure is documented below.
        :param 'JobTemplateConfigEncryptionMpegCencArgs' mpeg_cenc: Configuration for MPEG Common Encryption (MPEG-CENC).
               Structure is documented below.
        :param 'JobTemplateConfigEncryptionSampleAesArgs' sample_aes: Configuration for SAMPLE-AES encryption.
        :param 'JobTemplateConfigEncryptionSecretManagerKeySourceArgs' secret_manager_key_source: Configuration for secrets stored in Google Secret Manager.
               Structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        if aes128 is not None:
            pulumi.set(__self__, "aes128", aes128)
        if drm_systems is not None:
            pulumi.set(__self__, "drm_systems", drm_systems)
        if mpeg_cenc is not None:
            pulumi.set(__self__, "mpeg_cenc", mpeg_cenc)
        if sample_aes is not None:
            pulumi.set(__self__, "sample_aes", sample_aes)
        if secret_manager_key_source is not None:
            pulumi.set(__self__, "secret_manager_key_source", secret_manager_key_source)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier for this set of encryption options.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def aes128(self) -> Optional['outputs.JobTemplateConfigEncryptionAes128']:
        """
        Configuration for AES-128 encryption.
        """
        return pulumi.get(self, "aes128")

    @property
    @pulumi.getter(name="drmSystems")
    def drm_systems(self) -> Optional['outputs.JobTemplateConfigEncryptionDrmSystems']:
        """
        DRM system(s) to use; at least one must be specified. If a DRM system is omitted, it is considered disabled.
        Structure is documented below.
        """
        return pulumi.get(self, "drm_systems")

    @property
    @pulumi.getter(name="mpegCenc")
    def mpeg_cenc(self) -> Optional['outputs.JobTemplateConfigEncryptionMpegCenc']:
        """
        Configuration for MPEG Common Encryption (MPEG-CENC).
        Structure is documented below.
        """
        return pulumi.get(self, "mpeg_cenc")

    @property
    @pulumi.getter(name="sampleAes")
    def sample_aes(self) -> Optional['outputs.JobTemplateConfigEncryptionSampleAes']:
        """
        Configuration for SAMPLE-AES encryption.
        """
        return pulumi.get(self, "sample_aes")

    @property
    @pulumi.getter(name="secretManagerKeySource")
    def secret_manager_key_source(self) -> Optional['outputs.JobTemplateConfigEncryptionSecretManagerKeySource']:
        """
        Configuration for secrets stored in Google Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_manager_key_source")


@pulumi.output_type
class JobTemplateConfigEncryptionAes128(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigEncryptionDrmSystems(dict):
    def __init__(__self__, *,
                 clearkey: Optional['outputs.JobTemplateConfigEncryptionDrmSystemsClearkey'] = None,
                 fairplay: Optional['outputs.JobTemplateConfigEncryptionDrmSystemsFairplay'] = None,
                 playready: Optional['outputs.JobTemplateConfigEncryptionDrmSystemsPlayready'] = None,
                 widevine: Optional['outputs.JobTemplateConfigEncryptionDrmSystemsWidevine'] = None):
        """
        :param 'JobTemplateConfigEncryptionDrmSystemsClearkeyArgs' clearkey: Clearkey configuration.
        :param 'JobTemplateConfigEncryptionDrmSystemsFairplayArgs' fairplay: Fairplay configuration.
        :param 'JobTemplateConfigEncryptionDrmSystemsPlayreadyArgs' playready: Playready configuration.
        :param 'JobTemplateConfigEncryptionDrmSystemsWidevineArgs' widevine: Widevine configuration.
        """
        if clearkey is not None:
            pulumi.set(__self__, "clearkey", clearkey)
        if fairplay is not None:
            pulumi.set(__self__, "fairplay", fairplay)
        if playready is not None:
            pulumi.set(__self__, "playready", playready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter
    def clearkey(self) -> Optional['outputs.JobTemplateConfigEncryptionDrmSystemsClearkey']:
        """
        Clearkey configuration.
        """
        return pulumi.get(self, "clearkey")

    @property
    @pulumi.getter
    def fairplay(self) -> Optional['outputs.JobTemplateConfigEncryptionDrmSystemsFairplay']:
        """
        Fairplay configuration.
        """
        return pulumi.get(self, "fairplay")

    @property
    @pulumi.getter
    def playready(self) -> Optional['outputs.JobTemplateConfigEncryptionDrmSystemsPlayready']:
        """
        Playready configuration.
        """
        return pulumi.get(self, "playready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.JobTemplateConfigEncryptionDrmSystemsWidevine']:
        """
        Widevine configuration.
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class JobTemplateConfigEncryptionDrmSystemsClearkey(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigEncryptionDrmSystemsFairplay(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigEncryptionDrmSystemsPlayready(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigEncryptionDrmSystemsWidevine(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigEncryptionMpegCenc(dict):
    def __init__(__self__, *,
                 scheme: builtins.str):
        """
        :param builtins.str scheme: Specify the encryption scheme.
        """
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def scheme(self) -> builtins.str:
        """
        Specify the encryption scheme.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class JobTemplateConfigEncryptionSampleAes(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class JobTemplateConfigEncryptionSecretManagerKeySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigEncryptionSecretManagerKeySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigEncryptionSecretManagerKeySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigEncryptionSecretManagerKeySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: builtins.str):
        """
        :param builtins.str secret_version: The name of the Secret Version containing the encryption key in the following format: projects/{project}/secrets/{secret_id}/versions/{version_number}.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> builtins.str:
        """
        The name of the Secret Version containing the encryption key in the following format: projects/{project}/secrets/{secret_id}/versions/{version_number}.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class JobTemplateConfigInput(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str key: A unique key for this input. Must be specified when using advanced mapping and edit lists.
        :param builtins.str uri: URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, gs://bucket/inputs/file.mp4).
               If empty, the value is populated from Job.input_uri.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this input. Must be specified when using advanced mapping and edit lists.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, gs://bucket/inputs/file.mp4).
        If empty, the value is populated from Job.input_uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class JobTemplateConfigManifest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"
        elif key == "muxStreams":
            suggest = "mux_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_name: Optional[builtins.str] = None,
                 mux_streams: Optional[Sequence[builtins.str]] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str file_name: The name of the generated file. The default is `manifest`.
        :param Sequence[builtins.str] mux_streams: List of user supplied MuxStream.key values that should appear in this manifest.
        :param builtins.str type: Type of the manifest.
               Possible values are: `MANIFEST_TYPE_UNSPECIFIED`, `HLS`, `DASH`.
        """
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if mux_streams is not None:
            pulumi.set(__self__, "mux_streams", mux_streams)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[builtins.str]:
        """
        The name of the generated file. The default is `manifest`.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> Optional[Sequence[builtins.str]]:
        """
        List of user supplied MuxStream.key values that should appear in this manifest.
        """
        return pulumi.get(self, "mux_streams")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Type of the manifest.
        Possible values are: `MANIFEST_TYPE_UNSPECIFIED`, `HLS`, `DASH`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobTemplateConfigMuxStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elementaryStreams":
            suggest = "elementary_streams"
        elif key == "encryptionId":
            suggest = "encryption_id"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "segmentSettings":
            suggest = "segment_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigMuxStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigMuxStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigMuxStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: Optional[builtins.str] = None,
                 elementary_streams: Optional[Sequence[builtins.str]] = None,
                 encryption_id: Optional[builtins.str] = None,
                 file_name: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 segment_settings: Optional['outputs.JobTemplateConfigMuxStreamSegmentSettings'] = None):
        """
        :param builtins.str container: The container format. The default is `mp4`.
        :param Sequence[builtins.str] elementary_streams: List of ElementaryStream.key values multiplexed in this stream.
        :param builtins.str encryption_id: Identifier of the encryption configuration to use.
        :param builtins.str file_name: The name of the generated file.
        :param builtins.str key: A unique key for this multiplexed stream.
        :param 'JobTemplateConfigMuxStreamSegmentSettingsArgs' segment_settings: Segment settings for ts, fmp4 and vtt.
               Structure is documented below.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if elementary_streams is not None:
            pulumi.set(__self__, "elementary_streams", elementary_streams)
        if encryption_id is not None:
            pulumi.set(__self__, "encryption_id", encryption_id)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if segment_settings is not None:
            pulumi.set(__self__, "segment_settings", segment_settings)

    @property
    @pulumi.getter
    def container(self) -> Optional[builtins.str]:
        """
        The container format. The default is `mp4`.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Optional[Sequence[builtins.str]]:
        """
        List of ElementaryStream.key values multiplexed in this stream.
        """
        return pulumi.get(self, "elementary_streams")

    @property
    @pulumi.getter(name="encryptionId")
    def encryption_id(self) -> Optional[builtins.str]:
        """
        Identifier of the encryption configuration to use.
        """
        return pulumi.get(self, "encryption_id")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[builtins.str]:
        """
        The name of the generated file.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A unique key for this multiplexed stream.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="segmentSettings")
    def segment_settings(self) -> Optional['outputs.JobTemplateConfigMuxStreamSegmentSettings']:
        """
        Segment settings for ts, fmp4 and vtt.
        Structure is documented below.
        """
        return pulumi.get(self, "segment_settings")


@pulumi.output_type
class JobTemplateConfigMuxStreamSegmentSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentDuration":
            suggest = "segment_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigMuxStreamSegmentSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigMuxStreamSegmentSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigMuxStreamSegmentSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 segment_duration: Optional[builtins.str] = None):
        """
        :param builtins.str segment_duration: Duration of the segments in seconds. The default is `6.0s`.
        """
        if segment_duration is not None:
            pulumi.set(__self__, "segment_duration", segment_duration)

    @property
    @pulumi.getter(name="segmentDuration")
    def segment_duration(self) -> Optional[builtins.str]:
        """
        Duration of the segments in seconds. The default is `6.0s`.
        """
        return pulumi.get(self, "segment_duration")


@pulumi.output_type
class JobTemplateConfigOutput(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: URI for the output file(s). For example, gs://my-bucket/outputs/.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        URI for the output file(s). For example, gs://my-bucket/outputs/.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class JobTemplateConfigOverlay(dict):
    def __init__(__self__, *,
                 animations: Optional[Sequence['outputs.JobTemplateConfigOverlayAnimation']] = None,
                 image: Optional['outputs.JobTemplateConfigOverlayImage'] = None):
        """
        :param Sequence['JobTemplateConfigOverlayAnimationArgs'] animations: List of animations. The list should be chronological, without any time overlap.
               Structure is documented below.
        :param 'JobTemplateConfigOverlayImageArgs' image: Image overlay.
               Structure is documented below.
        """
        if animations is not None:
            pulumi.set(__self__, "animations", animations)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def animations(self) -> Optional[Sequence['outputs.JobTemplateConfigOverlayAnimation']]:
        """
        List of animations. The list should be chronological, without any time overlap.
        Structure is documented below.
        """
        return pulumi.get(self, "animations")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.JobTemplateConfigOverlayImage']:
        """
        Image overlay.
        Structure is documented below.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class JobTemplateConfigOverlayAnimation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "animationFade":
            suggest = "animation_fade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigOverlayAnimation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigOverlayAnimation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigOverlayAnimation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 animation_fade: Optional['outputs.JobTemplateConfigOverlayAnimationAnimationFade'] = None):
        """
        :param 'JobTemplateConfigOverlayAnimationAnimationFadeArgs' animation_fade: Display overlay object with fade animation.
               Structure is documented below.
        """
        if animation_fade is not None:
            pulumi.set(__self__, "animation_fade", animation_fade)

    @property
    @pulumi.getter(name="animationFade")
    def animation_fade(self) -> Optional['outputs.JobTemplateConfigOverlayAnimationAnimationFade']:
        """
        Display overlay object with fade animation.
        Structure is documented below.
        """
        return pulumi.get(self, "animation_fade")


@pulumi.output_type
class JobTemplateConfigOverlayAnimationAnimationFade(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fadeType":
            suggest = "fade_type"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateConfigOverlayAnimationAnimationFade. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateConfigOverlayAnimationAnimationFade.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateConfigOverlayAnimationAnimationFade.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fade_type: builtins.str,
                 end_time_offset: Optional[builtins.str] = None,
                 start_time_offset: Optional[builtins.str] = None,
                 xy: Optional['outputs.JobTemplateConfigOverlayAnimationAnimationFadeXy'] = None):
        """
        :param builtins.str fade_type: Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
               The possible values are:
               * `FADE_TYPE_UNSPECIFIED`: The fade type is not specified.
               * `FADE_IN`: Fade the overlay object into view.
               * `FADE_OUT`: Fade the overlay object out of view.
               Possible values are: `FADE_TYPE_UNSPECIFIED`, `FADE_IN`, `FADE_OUT`.
        :param builtins.str end_time_offset: The time to end the fade animation, in seconds.
        :param builtins.str start_time_offset: The time to start the fade animation, in seconds.
        :param 'JobTemplateConfigOverlayAnimationAnimationFadeXyArgs' xy: Normalized coordinates based on output video resolution.
               Structure is documented below.
        """
        pulumi.set(__self__, "fade_type", fade_type)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)
        if xy is not None:
            pulumi.set(__self__, "xy", xy)

    @property
    @pulumi.getter(name="fadeType")
    def fade_type(self) -> builtins.str:
        """
        Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
        The possible values are:
        * `FADE_TYPE_UNSPECIFIED`: The fade type is not specified.
        * `FADE_IN`: Fade the overlay object into view.
        * `FADE_OUT`: Fade the overlay object out of view.
        Possible values are: `FADE_TYPE_UNSPECIFIED`, `FADE_IN`, `FADE_OUT`.
        """
        return pulumi.get(self, "fade_type")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[builtins.str]:
        """
        The time to end the fade animation, in seconds.
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[builtins.str]:
        """
        The time to start the fade animation, in seconds.
        """
        return pulumi.get(self, "start_time_offset")

    @property
    @pulumi.getter
    def xy(self) -> Optional['outputs.JobTemplateConfigOverlayAnimationAnimationFadeXy']:
        """
        Normalized coordinates based on output video resolution.
        Structure is documented below.
        """
        return pulumi.get(self, "xy")


@pulumi.output_type
class JobTemplateConfigOverlayAnimationAnimationFadeXy(dict):
    def __init__(__self__, *,
                 x: Optional[builtins.float] = None,
                 y: Optional[builtins.float] = None):
        """
        :param builtins.float x: Normalized x coordinate.
        :param builtins.float y: Normalized y coordinate.
        """
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> Optional[builtins.float]:
        """
        Normalized x coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> Optional[builtins.float]:
        """
        Normalized y coordinate.
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class JobTemplateConfigOverlayImage(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: URI of the image in Cloud Storage. For example, gs://bucket/inputs/image.png.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        URI of the image in Cloud Storage. For example, gs://bucket/inputs/image.png.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class JobTemplateConfigPubsubDestination(dict):
    def __init__(__self__, *,
                 topic: Optional[builtins.str] = None):
        """
        :param builtins.str topic: The name of the Pub/Sub topic to publish job completion notification to. For example: projects/{project}/topics/{topic}.
        """
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> Optional[builtins.str]:
        """
        The name of the Pub/Sub topic to publish job completion notification to. For example: projects/{project}/topics/{topic}.
        """
        return pulumi.get(self, "topic")


