# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiFeatureOnlineStoreArgs', 'AiFeatureOnlineStore']

@pulumi.input_type
class AiFeatureOnlineStoreArgs:
    def __init__(__self__, *,
                 bigtable: Optional[pulumi.Input['AiFeatureOnlineStoreBigtableArgs']] = None,
                 dedicated_serving_endpoint: Optional[pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs']] = None,
                 embedding_management: Optional[pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs']] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimized: Optional[pulumi.Input['AiFeatureOnlineStoreOptimizedArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AiFeatureOnlineStore resource.
        :param pulumi.Input['AiFeatureOnlineStoreBigtableArgs'] bigtable: Settings for Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs'] dedicated_serving_endpoint: The dedicated serving endpoint for this FeatureOnlineStore, which is different from common vertex service endpoint. Only need to be set when you choose Optimized storage type or enable EmbeddingManagement. Will use public endpoint by default.
               Structure is documented below.
        :param pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs'] embedding_management: The settings for embedding management in FeatureOnlineStore. Embedding management can only be set for BigTable. It is enabled by default for optimized storagetype.
               Structure is documented below.
               
               > **Warning:** `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type
        :param pulumi.Input[builtins.bool] force_destroy: If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels with user-defined metadata to organize your feature online stores.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
               
               
               - - -
        :param pulumi.Input['AiFeatureOnlineStoreOptimizedArgs'] optimized: Settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of feature online store. eg us-central1
        """
        if bigtable is not None:
            pulumi.set(__self__, "bigtable", bigtable)
        if dedicated_serving_endpoint is not None:
            pulumi.set(__self__, "dedicated_serving_endpoint", dedicated_serving_endpoint)
        if embedding_management is not None:
            warnings.warn("""`embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type""", DeprecationWarning)
            pulumi.log.warn("""embedding_management is deprecated: `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type""")
        if embedding_management is not None:
            pulumi.set(__self__, "embedding_management", embedding_management)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimized is not None:
            pulumi.set(__self__, "optimized", optimized)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def bigtable(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreBigtableArgs']]:
        """
        Settings for Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "bigtable")

    @bigtable.setter
    def bigtable(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreBigtableArgs']]):
        pulumi.set(self, "bigtable", value)

    @property
    @pulumi.getter(name="dedicatedServingEndpoint")
    def dedicated_serving_endpoint(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs']]:
        """
        The dedicated serving endpoint for this FeatureOnlineStore, which is different from common vertex service endpoint. Only need to be set when you choose Optimized storage type or enable EmbeddingManagement. Will use public endpoint by default.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_serving_endpoint")

    @dedicated_serving_endpoint.setter
    def dedicated_serving_endpoint(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs']]):
        pulumi.set(self, "dedicated_serving_endpoint", value)

    @property
    @pulumi.getter(name="embeddingManagement")
    @_utilities.deprecated("""`embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type""")
    def embedding_management(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs']]:
        """
        The settings for embedding management in FeatureOnlineStore. Embedding management can only be set for BigTable. It is enabled by default for optimized storagetype.
        Structure is documented below.

        > **Warning:** `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type
        """
        return pulumi.get(self, "embedding_management")

    @embedding_management.setter
    def embedding_management(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs']]):
        pulumi.set(self, "embedding_management", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels with user-defined metadata to organize your feature online stores.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optimized(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreOptimizedArgs']]:
        """
        Settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore
        """
        return pulumi.get(self, "optimized")

    @optimized.setter
    def optimized(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreOptimizedArgs']]):
        pulumi.set(self, "optimized", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of feature online store. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AiFeatureOnlineStoreState:
    def __init__(__self__, *,
                 bigtable: Optional[pulumi.Input['AiFeatureOnlineStoreBigtableArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 dedicated_serving_endpoint: Optional[pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 embedding_management: Optional[pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs']] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimized: Optional[pulumi.Input['AiFeatureOnlineStoreOptimizedArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiFeatureOnlineStore resources.
        :param pulumi.Input['AiFeatureOnlineStoreBigtableArgs'] bigtable: Settings for Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The timestamp of when the feature online store was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs'] dedicated_serving_endpoint: The dedicated serving endpoint for this FeatureOnlineStore, which is different from common vertex service endpoint. Only need to be set when you choose Optimized storage type or enable EmbeddingManagement. Will use public endpoint by default.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs'] embedding_management: The settings for embedding management in FeatureOnlineStore. Embedding management can only be set for BigTable. It is enabled by default for optimized storagetype.
               Structure is documented below.
               
               > **Warning:** `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type
        :param pulumi.Input[builtins.str] etag: Used to perform consistent read-modify-write updates.
        :param pulumi.Input[builtins.bool] force_destroy: If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels with user-defined metadata to organize your feature online stores.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
               
               
               - - -
        :param pulumi.Input['AiFeatureOnlineStoreOptimizedArgs'] optimized: Settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: The region of feature online store. eg us-central1
        :param pulumi.Input[builtins.str] state: The state of the Feature Online Store. See the possible states in [this link](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores#state).
        :param pulumi.Input[builtins.str] update_time: The timestamp of when the feature online store was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        if bigtable is not None:
            pulumi.set(__self__, "bigtable", bigtable)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dedicated_serving_endpoint is not None:
            pulumi.set(__self__, "dedicated_serving_endpoint", dedicated_serving_endpoint)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if embedding_management is not None:
            warnings.warn("""`embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type""", DeprecationWarning)
            pulumi.log.warn("""embedding_management is deprecated: `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type""")
        if embedding_management is not None:
            pulumi.set(__self__, "embedding_management", embedding_management)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimized is not None:
            pulumi.set(__self__, "optimized", optimized)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def bigtable(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreBigtableArgs']]:
        """
        Settings for Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "bigtable")

    @bigtable.setter
    def bigtable(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreBigtableArgs']]):
        pulumi.set(self, "bigtable", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of when the feature online store was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dedicatedServingEndpoint")
    def dedicated_serving_endpoint(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs']]:
        """
        The dedicated serving endpoint for this FeatureOnlineStore, which is different from common vertex service endpoint. Only need to be set when you choose Optimized storage type or enable EmbeddingManagement. Will use public endpoint by default.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_serving_endpoint")

    @dedicated_serving_endpoint.setter
    def dedicated_serving_endpoint(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreDedicatedServingEndpointArgs']]):
        pulumi.set(self, "dedicated_serving_endpoint", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="embeddingManagement")
    @_utilities.deprecated("""`embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type""")
    def embedding_management(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs']]:
        """
        The settings for embedding management in FeatureOnlineStore. Embedding management can only be set for BigTable. It is enabled by default for optimized storagetype.
        Structure is documented below.

        > **Warning:** `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type
        """
        return pulumi.get(self, "embedding_management")

    @embedding_management.setter
    def embedding_management(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreEmbeddingManagementArgs']]):
        pulumi.set(self, "embedding_management", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used to perform consistent read-modify-write updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels with user-defined metadata to organize your feature online stores.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optimized(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreOptimizedArgs']]:
        """
        Settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore
        """
        return pulumi.get(self, "optimized")

    @optimized.setter
    def optimized(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreOptimizedArgs']]):
        pulumi.set(self, "optimized", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of feature online store. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the Feature Online Store. See the possible states in [this link](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores#state).
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of when the feature online store was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore")
class AiFeatureOnlineStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigtable: Optional[pulumi.Input[Union['AiFeatureOnlineStoreBigtableArgs', 'AiFeatureOnlineStoreBigtableArgsDict']]] = None,
                 dedicated_serving_endpoint: Optional[pulumi.Input[Union['AiFeatureOnlineStoreDedicatedServingEndpointArgs', 'AiFeatureOnlineStoreDedicatedServingEndpointArgsDict']]] = None,
                 embedding_management: Optional[pulumi.Input[Union['AiFeatureOnlineStoreEmbeddingManagementArgs', 'AiFeatureOnlineStoreEmbeddingManagementArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimized: Optional[pulumi.Input[Union['AiFeatureOnlineStoreOptimizedArgs', 'AiFeatureOnlineStoreOptimizedArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Vertex AI Feature Online Store provides a centralized repository for serving ML features and embedding indexes at low latency. The Feature Online Store is a top-level container.

        To get more information about FeatureOnlineStore, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/docs)

        ## Example Usage

        ### Vertex Ai Feature Online Store

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature_online_store = gcp.vertex.AiFeatureOnlineStore("feature_online_store",
            name="example_feature_online_store",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 3,
                    "cpu_utilization_target": 50,
                },
            })
        ```
        ### Vertex Ai Featureonlinestore With Optimized

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_online_store_optimized",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            optimized={},
            dedicated_serving_endpoint={
                "private_service_connect_config": {
                    "enable_private_service_connect": True,
                    "project_allowlists": [project.number],
                },
            })
        ```
        ### Vertex Ai Featureonlinestore With Beta Fields Bigtable

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_online_store_beta_bigtable",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            },
            embedding_management={
                "enabled": True,
            },
            force_destroy=True)
        project = gcp.organizations.get_project()
        ```

        ## Import

        FeatureOnlineStore can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/featureOnlineStores/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, FeatureOnlineStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default projects/{{project}}/locations/{{region}}/featureOnlineStores/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiFeatureOnlineStoreBigtableArgs', 'AiFeatureOnlineStoreBigtableArgsDict']] bigtable: Settings for Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[Union['AiFeatureOnlineStoreDedicatedServingEndpointArgs', 'AiFeatureOnlineStoreDedicatedServingEndpointArgsDict']] dedicated_serving_endpoint: The dedicated serving endpoint for this FeatureOnlineStore, which is different from common vertex service endpoint. Only need to be set when you choose Optimized storage type or enable EmbeddingManagement. Will use public endpoint by default.
               Structure is documented below.
        :param pulumi.Input[Union['AiFeatureOnlineStoreEmbeddingManagementArgs', 'AiFeatureOnlineStoreEmbeddingManagementArgsDict']] embedding_management: The settings for embedding management in FeatureOnlineStore. Embedding management can only be set for BigTable. It is enabled by default for optimized storagetype.
               Structure is documented below.
               
               > **Warning:** `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type
        :param pulumi.Input[builtins.bool] force_destroy: If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels with user-defined metadata to organize your feature online stores.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
               
               
               - - -
        :param pulumi.Input[Union['AiFeatureOnlineStoreOptimizedArgs', 'AiFeatureOnlineStoreOptimizedArgsDict']] optimized: Settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of feature online store. eg us-central1
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AiFeatureOnlineStoreArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Vertex AI Feature Online Store provides a centralized repository for serving ML features and embedding indexes at low latency. The Feature Online Store is a top-level container.

        To get more information about FeatureOnlineStore, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/docs)

        ## Example Usage

        ### Vertex Ai Feature Online Store

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature_online_store = gcp.vertex.AiFeatureOnlineStore("feature_online_store",
            name="example_feature_online_store",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 3,
                    "cpu_utilization_target": 50,
                },
            })
        ```
        ### Vertex Ai Featureonlinestore With Optimized

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_online_store_optimized",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            optimized={},
            dedicated_serving_endpoint={
                "private_service_connect_config": {
                    "enable_private_service_connect": True,
                    "project_allowlists": [project.number],
                },
            })
        ```
        ### Vertex Ai Featureonlinestore With Beta Fields Bigtable

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_online_store_beta_bigtable",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            },
            embedding_management={
                "enabled": True,
            },
            force_destroy=True)
        project = gcp.organizations.get_project()
        ```

        ## Import

        FeatureOnlineStore can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/featureOnlineStores/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, FeatureOnlineStore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default projects/{{project}}/locations/{{region}}/featureOnlineStores/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AiFeatureOnlineStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiFeatureOnlineStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigtable: Optional[pulumi.Input[Union['AiFeatureOnlineStoreBigtableArgs', 'AiFeatureOnlineStoreBigtableArgsDict']]] = None,
                 dedicated_serving_endpoint: Optional[pulumi.Input[Union['AiFeatureOnlineStoreDedicatedServingEndpointArgs', 'AiFeatureOnlineStoreDedicatedServingEndpointArgsDict']]] = None,
                 embedding_management: Optional[pulumi.Input[Union['AiFeatureOnlineStoreEmbeddingManagementArgs', 'AiFeatureOnlineStoreEmbeddingManagementArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimized: Optional[pulumi.Input[Union['AiFeatureOnlineStoreOptimizedArgs', 'AiFeatureOnlineStoreOptimizedArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiFeatureOnlineStoreArgs.__new__(AiFeatureOnlineStoreArgs)

            __props__.__dict__["bigtable"] = bigtable
            __props__.__dict__["dedicated_serving_endpoint"] = dedicated_serving_endpoint
            __props__.__dict__["embedding_management"] = embedding_management
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["optimized"] = optimized
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AiFeatureOnlineStore, __self__).__init__(
            'gcp:vertex/aiFeatureOnlineStore:AiFeatureOnlineStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bigtable: Optional[pulumi.Input[Union['AiFeatureOnlineStoreBigtableArgs', 'AiFeatureOnlineStoreBigtableArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            dedicated_serving_endpoint: Optional[pulumi.Input[Union['AiFeatureOnlineStoreDedicatedServingEndpointArgs', 'AiFeatureOnlineStoreDedicatedServingEndpointArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            embedding_management: Optional[pulumi.Input[Union['AiFeatureOnlineStoreEmbeddingManagementArgs', 'AiFeatureOnlineStoreEmbeddingManagementArgsDict']]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            optimized: Optional[pulumi.Input[Union['AiFeatureOnlineStoreOptimizedArgs', 'AiFeatureOnlineStoreOptimizedArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AiFeatureOnlineStore':
        """
        Get an existing AiFeatureOnlineStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiFeatureOnlineStoreBigtableArgs', 'AiFeatureOnlineStoreBigtableArgsDict']] bigtable: Settings for Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The timestamp of when the feature online store was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Union['AiFeatureOnlineStoreDedicatedServingEndpointArgs', 'AiFeatureOnlineStoreDedicatedServingEndpointArgsDict']] dedicated_serving_endpoint: The dedicated serving endpoint for this FeatureOnlineStore, which is different from common vertex service endpoint. Only need to be set when you choose Optimized storage type or enable EmbeddingManagement. Will use public endpoint by default.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['AiFeatureOnlineStoreEmbeddingManagementArgs', 'AiFeatureOnlineStoreEmbeddingManagementArgsDict']] embedding_management: The settings for embedding management in FeatureOnlineStore. Embedding management can only be set for BigTable. It is enabled by default for optimized storagetype.
               Structure is documented below.
               
               > **Warning:** `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type
        :param pulumi.Input[builtins.str] etag: Used to perform consistent read-modify-write updates.
        :param pulumi.Input[builtins.bool] force_destroy: If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels with user-defined metadata to organize your feature online stores.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
               
               
               - - -
        :param pulumi.Input[Union['AiFeatureOnlineStoreOptimizedArgs', 'AiFeatureOnlineStoreOptimizedArgsDict']] optimized: Settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: The region of feature online store. eg us-central1
        :param pulumi.Input[builtins.str] state: The state of the Feature Online Store. See the possible states in [this link](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores#state).
        :param pulumi.Input[builtins.str] update_time: The timestamp of when the feature online store was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiFeatureOnlineStoreState.__new__(_AiFeatureOnlineStoreState)

        __props__.__dict__["bigtable"] = bigtable
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dedicated_serving_endpoint"] = dedicated_serving_endpoint
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["embedding_management"] = embedding_management
        __props__.__dict__["etag"] = etag
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["optimized"] = optimized
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return AiFeatureOnlineStore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bigtable(self) -> pulumi.Output[Optional['outputs.AiFeatureOnlineStoreBigtable']]:
        """
        Settings for Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "bigtable")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the feature online store was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dedicatedServingEndpoint")
    def dedicated_serving_endpoint(self) -> pulumi.Output['outputs.AiFeatureOnlineStoreDedicatedServingEndpoint']:
        """
        The dedicated serving endpoint for this FeatureOnlineStore, which is different from common vertex service endpoint. Only need to be set when you choose Optimized storage type or enable EmbeddingManagement. Will use public endpoint by default.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_serving_endpoint")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="embeddingManagement")
    @_utilities.deprecated("""`embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type""")
    def embedding_management(self) -> pulumi.Output['outputs.AiFeatureOnlineStoreEmbeddingManagement']:
        """
        The settings for embedding management in FeatureOnlineStore. Embedding management can only be set for BigTable. It is enabled by default for optimized storagetype.
        Structure is documented below.

        > **Warning:** `embedding_management` is deprecated. This field is no longer needed anymore and embedding management is automatically enabled when specifying Optimized storage type
        """
        return pulumi.get(self, "embedding_management")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Used to perform consistent read-modify-write updates.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to true, any FeatureViews and Features for this FeatureOnlineStore will also be deleted.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels with user-defined metadata to organize your feature online stores.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the Feature Online Store. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optimized(self) -> pulumi.Output[Optional['outputs.AiFeatureOnlineStoreOptimized']]:
        """
        Settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore
        """
        return pulumi.get(self, "optimized")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region of feature online store. eg us-central1
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the Feature Online Store. See the possible states in [this link](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores#state).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the feature online store was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

