# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalAccessRuleResult',
    'AwaitableGetExternalAccessRuleResult',
    'get_external_access_rule',
    'get_external_access_rule_output',
]

@pulumi.output_type
class GetExternalAccessRuleResult:
    """
    A collection of values returned by getExternalAccessRule.
    """
    def __init__(__self__, action=None, create_time=None, description=None, destination_ip_ranges=None, destination_ports=None, id=None, ip_protocol=None, name=None, parent=None, priority=None, source_ip_ranges=None, source_ports=None, state=None, uid=None, update_time=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_ip_ranges and not isinstance(destination_ip_ranges, list):
            raise TypeError("Expected argument 'destination_ip_ranges' to be a list")
        pulumi.set(__self__, "destination_ip_ranges", destination_ip_ranges)
        if destination_ports and not isinstance(destination_ports, list):
            raise TypeError("Expected argument 'destination_ports' to be a list")
        pulumi.set(__self__, "destination_ports", destination_ports)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_protocol and not isinstance(ip_protocol, str):
            raise TypeError("Expected argument 'ip_protocol' to be a str")
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if source_ip_ranges and not isinstance(source_ip_ranges, list):
            raise TypeError("Expected argument 'source_ip_ranges' to be a list")
        pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        if source_ports and not isinstance(source_ports, list):
            raise TypeError("Expected argument 'source_ports' to be a list")
        pulumi.set(__self__, "source_ports", source_ports)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIpRanges")
    def destination_ip_ranges(self) -> Sequence['outputs.GetExternalAccessRuleDestinationIpRangeResult']:
        return pulumi.get(self, "destination_ip_ranges")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> builtins.str:
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Sequence['outputs.GetExternalAccessRuleSourceIpRangeResult']:
        return pulumi.get(self, "source_ip_ranges")

    @property
    @pulumi.getter(name="sourcePorts")
    def source_ports(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "source_ports")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> builtins.str:
        return pulumi.get(self, "update_time")


class AwaitableGetExternalAccessRuleResult(GetExternalAccessRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalAccessRuleResult(
            action=self.action,
            create_time=self.create_time,
            description=self.description,
            destination_ip_ranges=self.destination_ip_ranges,
            destination_ports=self.destination_ports,
            id=self.id,
            ip_protocol=self.ip_protocol,
            name=self.name,
            parent=self.parent,
            priority=self.priority,
            source_ip_ranges=self.source_ip_ranges,
            source_ports=self.source_ports,
            state=self.state,
            uid=self.uid,
            update_time=self.update_time)


def get_external_access_rule(name: Optional[builtins.str] = None,
                             parent: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalAccessRuleResult:
    """
    Use this data source to get details about a external access rule resource.

    To get more information about external address, see:
    * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.networkPolicies.externalAccessRules)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_external_access_rule = gcp.vmwareengine.get_external_access_rule(name="my-external-access-rule",
        parent="project/my-project/locations/us-west1-a/networkPolicies/my-network-policy")
    ```


    :param builtins.str name: Name of the resource.
    :param builtins.str parent: The resource name of the network policy that this cluster belongs.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['parent'] = parent
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:vmwareengine/getExternalAccessRule:getExternalAccessRule', __args__, opts=opts, typ=GetExternalAccessRuleResult).value

    return AwaitableGetExternalAccessRuleResult(
        action=pulumi.get(__ret__, 'action'),
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        destination_ip_ranges=pulumi.get(__ret__, 'destination_ip_ranges'),
        destination_ports=pulumi.get(__ret__, 'destination_ports'),
        id=pulumi.get(__ret__, 'id'),
        ip_protocol=pulumi.get(__ret__, 'ip_protocol'),
        name=pulumi.get(__ret__, 'name'),
        parent=pulumi.get(__ret__, 'parent'),
        priority=pulumi.get(__ret__, 'priority'),
        source_ip_ranges=pulumi.get(__ret__, 'source_ip_ranges'),
        source_ports=pulumi.get(__ret__, 'source_ports'),
        state=pulumi.get(__ret__, 'state'),
        uid=pulumi.get(__ret__, 'uid'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_external_access_rule_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                    parent: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalAccessRuleResult]:
    """
    Use this data source to get details about a external access rule resource.

    To get more information about external address, see:
    * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.networkPolicies.externalAccessRules)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_external_access_rule = gcp.vmwareengine.get_external_access_rule(name="my-external-access-rule",
        parent="project/my-project/locations/us-west1-a/networkPolicies/my-network-policy")
    ```


    :param builtins.str name: Name of the resource.
    :param builtins.str parent: The resource name of the network policy that this cluster belongs.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['parent'] = parent
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:vmwareengine/getExternalAccessRule:getExternalAccessRule', __args__, opts=opts, typ=GetExternalAccessRuleResult)
    return __ret__.apply(lambda __response__: GetExternalAccessRuleResult(
        action=pulumi.get(__response__, 'action'),
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        destination_ip_ranges=pulumi.get(__response__, 'destination_ip_ranges'),
        destination_ports=pulumi.get(__response__, 'destination_ports'),
        id=pulumi.get(__response__, 'id'),
        ip_protocol=pulumi.get(__response__, 'ip_protocol'),
        name=pulumi.get(__response__, 'name'),
        parent=pulumi.get(__response__, 'parent'),
        priority=pulumi.get(__response__, 'priority'),
        source_ip_ranges=pulumi.get(__response__, 'source_ip_ranges'),
        source_ports=pulumi.get(__response__, 'source_ports'),
        state=pulumi.get(__response__, 'state'),
        uid=pulumi.get(__response__, 'uid'),
        update_time=pulumi.get(__response__, 'update_time')))
