# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[builtins.str] location: The location where the VMwareEngineNetwork should reside.
        :param pulumi.Input[builtins.str] type: VMware Engine network type.
               Possible values are: `LEGACY`, `STANDARD`.
        :param pulumi.Input[builtins.str] description: User-provided description for this VMware Engine network.
        :param pulumi.Input[builtins.str] name: The ID of the VMwareEngineNetwork.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location where the VMwareEngineNetwork should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        VMware Engine network type.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description for this VMware Engine network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VMwareEngineNetwork.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_networks: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkVpcNetworkArgs']]]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[builtins.str] description: User-provided description for this VMware Engine network.
        :param pulumi.Input[builtins.str] location: The location where the VMwareEngineNetwork should reside.
        :param pulumi.Input[builtins.str] name: The ID of the VMwareEngineNetwork.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: State of the VMware Engine network.
        :param pulumi.Input[builtins.str] type: VMware Engine network type.
               Possible values are: `LEGACY`, `STANDARD`.
        :param pulumi.Input[builtins.str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkVpcNetworkArgs']]] vpc_networks: VMware Engine service VPC networks that provide connectivity from a private cloud to customer projects,
               the internet, and other Google Cloud services.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if vpc_networks is not None:
            pulumi.set(__self__, "vpc_networks", vpc_networks)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description for this VMware Engine network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the VMwareEngineNetwork should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VMwareEngineNetwork.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the VMware Engine network.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        VMware Engine network type.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="vpcNetworks")
    def vpc_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkVpcNetworkArgs']]]]:
        """
        VMware Engine service VPC networks that provide connectivity from a private cloud to customer projects,
        the internet, and other Google Cloud services.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_networks")

    @vpc_networks.setter
    def vpc_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkVpcNetworkArgs']]]]):
        pulumi.set(self, "vpc_networks", value)


@pulumi.type_token("gcp:vmwareengine/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides connectivity for VMware Engine private clouds.

        To get more information about Network, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.vmwareEngineNetworks)

        ## Example Usage

        ### Vmware Engine Network Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vmw_engine_network = gcp.vmwareengine.Network("vmw-engine-network",
            name="standard-nw",
            location="global",
            type="STANDARD",
            description="VMwareEngine standard network sample")
        ```
        ### Vmware Engine Network Legacy

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # there can be only 1 Legacy network per region for a given project,
        # so creating new project for isolation in CI.
        acceptance_project = gcp.organizations.Project("acceptance",
            name="vmw-proj",
            project_id="vmw-proj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[acceptance_project]))
        acceptance = gcp.projects.Service("acceptance",
            project=acceptance_project.project_id,
            service="vmwareengine.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        vmw_engine_network = gcp.vmwareengine.Network("vmw-engine-network",
            project=acceptance.project,
            name="us-west1-default",
            location="us-west1",
            type="LEGACY",
            description="VMwareEngine legacy network sample")
        ```

        ## Import

        Network can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vmwareEngineNetworks/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Network can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/network:Network default projects/{{project}}/locations/{{location}}/vmwareEngineNetworks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/network:Network default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/network:Network default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: User-provided description for this VMware Engine network.
        :param pulumi.Input[builtins.str] location: The location where the VMwareEngineNetwork should reside.
        :param pulumi.Input[builtins.str] name: The ID of the VMwareEngineNetwork.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] type: VMware Engine network type.
               Possible values are: `LEGACY`, `STANDARD`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides connectivity for VMware Engine private clouds.

        To get more information about Network, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.vmwareEngineNetworks)

        ## Example Usage

        ### Vmware Engine Network Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vmw_engine_network = gcp.vmwareengine.Network("vmw-engine-network",
            name="standard-nw",
            location="global",
            type="STANDARD",
            description="VMwareEngine standard network sample")
        ```
        ### Vmware Engine Network Legacy

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # there can be only 1 Legacy network per region for a given project,
        # so creating new project for isolation in CI.
        acceptance_project = gcp.organizations.Project("acceptance",
            name="vmw-proj",
            project_id="vmw-proj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[acceptance_project]))
        acceptance = gcp.projects.Service("acceptance",
            project=acceptance_project.project_id,
            service="vmwareengine.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        vmw_engine_network = gcp.vmwareengine.Network("vmw-engine-network",
            project=acceptance.project,
            name="us-west1-default",
            location="us-west1",
            type="LEGACY",
            description="VMwareEngine legacy network sample")
        ```

        ## Import

        Network can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vmwareEngineNetworks/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Network can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/network:Network default projects/{{project}}/locations/{{location}}/vmwareEngineNetworks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/network:Network default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/network:Network default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["description"] = description
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["vpc_networks"] = None
        super(Network, __self__).__init__(
            'gcp:vmwareengine/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            vpc_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkVpcNetworkArgs', 'NetworkVpcNetworkArgsDict']]]]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: User-provided description for this VMware Engine network.
        :param pulumi.Input[builtins.str] location: The location where the VMwareEngineNetwork should reside.
        :param pulumi.Input[builtins.str] name: The ID of the VMwareEngineNetwork.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: State of the VMware Engine network.
        :param pulumi.Input[builtins.str] type: VMware Engine network type.
               Possible values are: `LEGACY`, `STANDARD`.
        :param pulumi.Input[builtins.str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkVpcNetworkArgs', 'NetworkVpcNetworkArgsDict']]]] vpc_networks: VMware Engine service VPC networks that provide connectivity from a private cloud to customer projects,
               the internet, and other Google Cloud services.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["description"] = description
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["vpc_networks"] = vpc_networks
        return Network(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-provided description for this VMware Engine network.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the VMwareEngineNetwork should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VMwareEngineNetwork.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the VMware Engine network.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        VMware Engine network type.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="vpcNetworks")
    def vpc_networks(self) -> pulumi.Output[Sequence['outputs.NetworkVpcNetwork']]:
        """
        VMware Engine service VPC networks that provide connectivity from a private cloud to customer projects,
        the internet, and other Google Cloud services.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_networks")

