# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkPolicyArgs', 'NetworkPolicy']

@pulumi.input_type
class NetworkPolicyArgs:
    def __init__(__self__, *,
                 edge_services_cidr: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 vmware_engine_network: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_ip: Optional[pulumi.Input['NetworkPolicyExternalIpArgs']] = None,
                 internet_access: Optional[pulumi.Input['NetworkPolicyInternetAccessArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkPolicy resource.
        :param pulumi.Input[builtins.str] edge_services_cidr: IP address range in CIDR notation used to create internet access and external IP access.
               An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
               prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
        :param pulumi.Input[builtins.str] location: The resource name of the location (region) to create the new network policy in.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-central1
        :param pulumi.Input[builtins.str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        :param pulumi.Input[builtins.str] description: User-provided description for this network policy.
        :param pulumi.Input['NetworkPolicyExternalIpArgs'] external_ip: Network service that allows External IP addresses to be assigned to VMware workloads.
               This service can only be enabled when internetAccess is also enabled.
               Structure is documented below.
        :param pulumi.Input['NetworkPolicyInternetAccessArgs'] internet_access: Network service that allows VMware workloads to access the internet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The ID of the Network Policy.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "edge_services_cidr", edge_services_cidr)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)
        if internet_access is not None:
            pulumi.set(__self__, "internet_access", internet_access)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="edgeServicesCidr")
    def edge_services_cidr(self) -> pulumi.Input[builtins.str]:
        """
        IP address range in CIDR notation used to create internet access and external IP access.
        An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
        prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
        """
        return pulumi.get(self, "edge_services_cidr")

    @edge_services_cidr.setter
    def edge_services_cidr(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "edge_services_cidr", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The resource name of the location (region) to create the new network policy in.
        Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
        For example: projects/my-project/locations/us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> pulumi.Input[builtins.str]:
        """
        The relative resource name of the VMware Engine network. Specify the name in the following form:
        projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
        can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @vmware_engine_network.setter
    def vmware_engine_network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vmware_engine_network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description for this network policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[pulumi.Input['NetworkPolicyExternalIpArgs']]:
        """
        Network service that allows External IP addresses to be assigned to VMware workloads.
        This service can only be enabled when internetAccess is also enabled.
        Structure is documented below.
        """
        return pulumi.get(self, "external_ip")

    @external_ip.setter
    def external_ip(self, value: Optional[pulumi.Input['NetworkPolicyExternalIpArgs']]):
        pulumi.set(self, "external_ip", value)

    @property
    @pulumi.getter(name="internetAccess")
    def internet_access(self) -> Optional[pulumi.Input['NetworkPolicyInternetAccessArgs']]:
        """
        Network service that allows VMware workloads to access the internet.
        Structure is documented below.
        """
        return pulumi.get(self, "internet_access")

    @internet_access.setter
    def internet_access(self, value: Optional[pulumi.Input['NetworkPolicyInternetAccessArgs']]):
        pulumi.set(self, "internet_access", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Network Policy.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _NetworkPolicyState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edge_services_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 external_ip: Optional[pulumi.Input['NetworkPolicyExternalIpArgs']] = None,
                 internet_access: Optional[pulumi.Input['NetworkPolicyInternetAccessArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 vmware_engine_network: Optional[pulumi.Input[builtins.str]] = None,
                 vmware_engine_network_canonical: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkPolicy resources.
        :param pulumi.Input[builtins.str] create_time: Creation time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: User-provided description for this network policy.
        :param pulumi.Input[builtins.str] edge_services_cidr: IP address range in CIDR notation used to create internet access and external IP access.
               An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
               prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
        :param pulumi.Input['NetworkPolicyExternalIpArgs'] external_ip: Network service that allows External IP addresses to be assigned to VMware workloads.
               This service can only be enabled when internetAccess is also enabled.
               Structure is documented below.
        :param pulumi.Input['NetworkPolicyInternetAccessArgs'] internet_access: Network service that allows VMware workloads to access the internet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The resource name of the location (region) to create the new network policy in.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-central1
        :param pulumi.Input[builtins.str] name: The ID of the Network Policy.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[builtins.str] update_time: Last updated time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        :param pulumi.Input[builtins.str] vmware_engine_network_canonical: The canonical name of the VMware Engine network in the form:
               projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_services_cidr is not None:
            pulumi.set(__self__, "edge_services_cidr", edge_services_cidr)
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)
        if internet_access is not None:
            pulumi.set(__self__, "internet_access", internet_access)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vmware_engine_network is not None:
            pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        if vmware_engine_network_canonical is not None:
            pulumi.set(__self__, "vmware_engine_network_canonical", vmware_engine_network_canonical)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description for this network policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="edgeServicesCidr")
    def edge_services_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address range in CIDR notation used to create internet access and external IP access.
        An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
        prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
        """
        return pulumi.get(self, "edge_services_cidr")

    @edge_services_cidr.setter
    def edge_services_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_services_cidr", value)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[pulumi.Input['NetworkPolicyExternalIpArgs']]:
        """
        Network service that allows External IP addresses to be assigned to VMware workloads.
        This service can only be enabled when internetAccess is also enabled.
        Structure is documented below.
        """
        return pulumi.get(self, "external_ip")

    @external_ip.setter
    def external_ip(self, value: Optional[pulumi.Input['NetworkPolicyExternalIpArgs']]):
        pulumi.set(self, "external_ip", value)

    @property
    @pulumi.getter(name="internetAccess")
    def internet_access(self) -> Optional[pulumi.Input['NetworkPolicyInternetAccessArgs']]:
        """
        Network service that allows VMware workloads to access the internet.
        Structure is documented below.
        """
        return pulumi.get(self, "internet_access")

    @internet_access.setter
    def internet_access(self, value: Optional[pulumi.Input['NetworkPolicyInternetAccessArgs']]):
        pulumi.set(self, "internet_access", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the location (region) to create the new network policy in.
        Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
        For example: projects/my-project/locations/us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Network Policy.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last updated time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name of the VMware Engine network. Specify the name in the following form:
        projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
        can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @vmware_engine_network.setter
    def vmware_engine_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vmware_engine_network", value)

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canonical name of the VMware Engine network in the form:
        projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")

    @vmware_engine_network_canonical.setter
    def vmware_engine_network_canonical(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vmware_engine_network_canonical", value)


@pulumi.type_token("gcp:vmwareengine/networkPolicy:NetworkPolicy")
class NetworkPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edge_services_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 external_ip: Optional[pulumi.Input[Union['NetworkPolicyExternalIpArgs', 'NetworkPolicyExternalIpArgsDict']]] = None,
                 internet_access: Optional[pulumi.Input[Union['NetworkPolicyInternetAccessArgs', 'NetworkPolicyInternetAccessArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 vmware_engine_network: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents a network policy resource. Network policies are regional resources.

        To get more information about NetworkPolicy, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.networkPolicies)

        ## Example Usage

        ### Vmware Engine Network Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_policy_nw = gcp.vmwareengine.Network("network-policy-nw",
            name="sample-network",
            location="global",
            type="STANDARD",
            description="VMwareEngine standard network sample")
        vmw_engine_network_policy = gcp.vmwareengine.NetworkPolicy("vmw-engine-network-policy",
            location="us-west1",
            name="sample-network-policy",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=network_policy_nw.id)
        ```
        ### Vmware Engine Network Policy Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_policy_nw = gcp.vmwareengine.Network("network-policy-nw",
            name="sample-network",
            location="global",
            type="STANDARD",
            description="VMwareEngine standard network sample")
        vmw_engine_network_policy = gcp.vmwareengine.NetworkPolicy("vmw-engine-network-policy",
            location="us-west1",
            name="sample-network-policy",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=network_policy_nw.id,
            description="Sample Network Policy",
            internet_access={
                "enabled": True,
            },
            external_ip={
                "enabled": True,
            })
        ```

        ## Import

        NetworkPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/networkPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, NetworkPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/networkPolicy:NetworkPolicy default projects/{{project}}/locations/{{location}}/networkPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPolicy:NetworkPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPolicy:NetworkPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: User-provided description for this network policy.
        :param pulumi.Input[builtins.str] edge_services_cidr: IP address range in CIDR notation used to create internet access and external IP access.
               An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
               prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
        :param pulumi.Input[Union['NetworkPolicyExternalIpArgs', 'NetworkPolicyExternalIpArgsDict']] external_ip: Network service that allows External IP addresses to be assigned to VMware workloads.
               This service can only be enabled when internetAccess is also enabled.
               Structure is documented below.
        :param pulumi.Input[Union['NetworkPolicyInternetAccessArgs', 'NetworkPolicyInternetAccessArgsDict']] internet_access: Network service that allows VMware workloads to access the internet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The resource name of the location (region) to create the new network policy in.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-central1
        :param pulumi.Input[builtins.str] name: The ID of the Network Policy.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a network policy resource. Network policies are regional resources.

        To get more information about NetworkPolicy, see:

        * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.networkPolicies)

        ## Example Usage

        ### Vmware Engine Network Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_policy_nw = gcp.vmwareengine.Network("network-policy-nw",
            name="sample-network",
            location="global",
            type="STANDARD",
            description="VMwareEngine standard network sample")
        vmw_engine_network_policy = gcp.vmwareengine.NetworkPolicy("vmw-engine-network-policy",
            location="us-west1",
            name="sample-network-policy",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=network_policy_nw.id)
        ```
        ### Vmware Engine Network Policy Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_policy_nw = gcp.vmwareengine.Network("network-policy-nw",
            name="sample-network",
            location="global",
            type="STANDARD",
            description="VMwareEngine standard network sample")
        vmw_engine_network_policy = gcp.vmwareengine.NetworkPolicy("vmw-engine-network-policy",
            location="us-west1",
            name="sample-network-policy",
            edge_services_cidr="192.168.30.0/26",
            vmware_engine_network=network_policy_nw.id,
            description="Sample Network Policy",
            internet_access={
                "enabled": True,
            },
            external_ip={
                "enabled": True,
            })
        ```

        ## Import

        NetworkPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/networkPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, NetworkPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/networkPolicy:NetworkPolicy default projects/{{project}}/locations/{{location}}/networkPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPolicy:NetworkPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPolicy:NetworkPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edge_services_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 external_ip: Optional[pulumi.Input[Union['NetworkPolicyExternalIpArgs', 'NetworkPolicyExternalIpArgsDict']]] = None,
                 internet_access: Optional[pulumi.Input[Union['NetworkPolicyInternetAccessArgs', 'NetworkPolicyInternetAccessArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 vmware_engine_network: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPolicyArgs.__new__(NetworkPolicyArgs)

            __props__.__dict__["description"] = description
            if edge_services_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'edge_services_cidr'")
            __props__.__dict__["edge_services_cidr"] = edge_services_cidr
            __props__.__dict__["external_ip"] = external_ip
            __props__.__dict__["internet_access"] = internet_access
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if vmware_engine_network is None and not opts.urn:
                raise TypeError("Missing required property 'vmware_engine_network'")
            __props__.__dict__["vmware_engine_network"] = vmware_engine_network
            __props__.__dict__["create_time"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["vmware_engine_network_canonical"] = None
        super(NetworkPolicy, __self__).__init__(
            'gcp:vmwareengine/networkPolicy:NetworkPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            edge_services_cidr: Optional[pulumi.Input[builtins.str]] = None,
            external_ip: Optional[pulumi.Input[Union['NetworkPolicyExternalIpArgs', 'NetworkPolicyExternalIpArgsDict']]] = None,
            internet_access: Optional[pulumi.Input[Union['NetworkPolicyInternetAccessArgs', 'NetworkPolicyInternetAccessArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            vmware_engine_network: Optional[pulumi.Input[builtins.str]] = None,
            vmware_engine_network_canonical: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkPolicy':
        """
        Get an existing NetworkPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Creation time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: User-provided description for this network policy.
        :param pulumi.Input[builtins.str] edge_services_cidr: IP address range in CIDR notation used to create internet access and external IP access.
               An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
               prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
        :param pulumi.Input[Union['NetworkPolicyExternalIpArgs', 'NetworkPolicyExternalIpArgsDict']] external_ip: Network service that allows External IP addresses to be assigned to VMware workloads.
               This service can only be enabled when internetAccess is also enabled.
               Structure is documented below.
        :param pulumi.Input[Union['NetworkPolicyInternetAccessArgs', 'NetworkPolicyInternetAccessArgsDict']] internet_access: Network service that allows VMware workloads to access the internet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The resource name of the location (region) to create the new network policy in.
               Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
               For example: projects/my-project/locations/us-central1
        :param pulumi.Input[builtins.str] name: The ID of the Network Policy.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[builtins.str] update_time: Last updated time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        :param pulumi.Input[builtins.str] vmware_engine_network_canonical: The canonical name of the VMware Engine network in the form:
               projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkPolicyState.__new__(_NetworkPolicyState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["edge_services_cidr"] = edge_services_cidr
        __props__.__dict__["external_ip"] = external_ip
        __props__.__dict__["internet_access"] = internet_access
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vmware_engine_network"] = vmware_engine_network
        __props__.__dict__["vmware_engine_network_canonical"] = vmware_engine_network_canonical
        return NetworkPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Creation time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-provided description for this network policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="edgeServicesCidr")
    def edge_services_cidr(self) -> pulumi.Output[builtins.str]:
        """
        IP address range in CIDR notation used to create internet access and external IP access.
        An RFC 1918 CIDR block, with a "/26" prefix, is required. The range cannot overlap with any
        prefixes either in the consumer VPC network or in use by the private clouds attached to that VPC network.
        """
        return pulumi.get(self, "edge_services_cidr")

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> pulumi.Output['outputs.NetworkPolicyExternalIp']:
        """
        Network service that allows External IP addresses to be assigned to VMware workloads.
        This service can only be enabled when internetAccess is also enabled.
        Structure is documented below.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter(name="internetAccess")
    def internet_access(self) -> pulumi.Output['outputs.NetworkPolicyInternetAccess']:
        """
        Network service that allows VMware workloads to access the internet.
        Structure is documented below.
        """
        return pulumi.get(self, "internet_access")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the location (region) to create the new network policy in.
        Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names.
        For example: projects/my-project/locations/us-central1
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Network Policy.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Last updated time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> pulumi.Output[builtins.str]:
        """
        The relative resource name of the VMware Engine network. Specify the name in the following form:
        projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
        can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> pulumi.Output[builtins.str]:
        """
        The canonical name of the VMware Engine network in the form:
        projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")

