# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterAutoscalingSettings',
    'ClusterAutoscalingSettingsAutoscalingPolicy',
    'ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds',
    'ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds',
    'ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds',
    'ClusterNodeTypeConfig',
    'ExternalAccessRuleDestinationIpRange',
    'ExternalAccessRuleSourceIpRange',
    'NetworkPolicyExternalIp',
    'NetworkPolicyInternetAccess',
    'NetworkVpcNetwork',
    'PrivateCloudHcx',
    'PrivateCloudManagementCluster',
    'PrivateCloudManagementClusterAutoscalingSettings',
    'PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicy',
    'PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds',
    'PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds',
    'PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds',
    'PrivateCloudManagementClusterNodeTypeConfig',
    'PrivateCloudManagementClusterStretchedClusterConfig',
    'PrivateCloudNetworkConfig',
    'PrivateCloudNsx',
    'PrivateCloudVcenter',
    'SubnetDhcpAddressRange',
    'GetClusterAutoscalingSettingResult',
    'GetClusterAutoscalingSettingAutoscalingPolicyResult',
    'GetClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult',
    'GetClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult',
    'GetClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult',
    'GetClusterNodeTypeConfigResult',
    'GetExternalAccessRuleDestinationIpRangeResult',
    'GetExternalAccessRuleSourceIpRangeResult',
    'GetNetworkPolicyExternalIpResult',
    'GetNetworkPolicyInternetAccessResult',
    'GetNetworkVpcNetworkResult',
    'GetPrivateCloudHcxResult',
    'GetPrivateCloudManagementClusterResult',
    'GetPrivateCloudManagementClusterAutoscalingSettingResult',
    'GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyResult',
    'GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult',
    'GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult',
    'GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult',
    'GetPrivateCloudManagementClusterNodeTypeConfigResult',
    'GetPrivateCloudManagementClusterStretchedClusterConfigResult',
    'GetPrivateCloudNetworkConfigResult',
    'GetPrivateCloudNsxResult',
    'GetPrivateCloudVcenterResult',
    'GetSubnetDhcpAddressRangeResult',
]

@pulumi.output_type
class ClusterAutoscalingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingPolicies":
            suggest = "autoscaling_policies"
        elif key == "coolDownPeriod":
            suggest = "cool_down_period"
        elif key == "maxClusterNodeCount":
            suggest = "max_cluster_node_count"
        elif key == "minClusterNodeCount":
            suggest = "min_cluster_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_policies: Sequence['outputs.ClusterAutoscalingSettingsAutoscalingPolicy'],
                 cool_down_period: Optional[builtins.str] = None,
                 max_cluster_node_count: Optional[builtins.int] = None,
                 min_cluster_node_count: Optional[builtins.int] = None):
        """
        :param Sequence['ClusterAutoscalingSettingsAutoscalingPolicyArgs'] autoscaling_policies: The map with autoscaling policies applied to the cluster.
               The key is the identifier of the policy.
               It must meet the following requirements:
               * Only contains 1-63 alphanumeric characters and hyphens
               * Begins with an alphabetical character
               * Ends with a non-hyphen character
               * Not formatted as a UUID
               * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
               Currently the map must contain only one element
               that describes the autoscaling policy for compute nodes.
               Structure is documented below.
        :param builtins.str cool_down_period: The minimum duration between consecutive autoscale operations.
               It starts once addition or removal of nodes is fully completed.
               Minimum cool down period is 30m.
               Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int max_cluster_node_count: Maximum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int min_cluster_node_count: Minimum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        """
        pulumi.set(__self__, "autoscaling_policies", autoscaling_policies)
        if cool_down_period is not None:
            pulumi.set(__self__, "cool_down_period", cool_down_period)
        if max_cluster_node_count is not None:
            pulumi.set(__self__, "max_cluster_node_count", max_cluster_node_count)
        if min_cluster_node_count is not None:
            pulumi.set(__self__, "min_cluster_node_count", min_cluster_node_count)

    @property
    @pulumi.getter(name="autoscalingPolicies")
    def autoscaling_policies(self) -> Sequence['outputs.ClusterAutoscalingSettingsAutoscalingPolicy']:
        """
        The map with autoscaling policies applied to the cluster.
        The key is the identifier of the policy.
        It must meet the following requirements:
        * Only contains 1-63 alphanumeric characters and hyphens
        * Begins with an alphabetical character
        * Ends with a non-hyphen character
        * Not formatted as a UUID
        * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        Currently the map must contain only one element
        that describes the autoscaling policy for compute nodes.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_policies")

    @property
    @pulumi.getter(name="coolDownPeriod")
    def cool_down_period(self) -> Optional[builtins.str]:
        """
        The minimum duration between consecutive autoscale operations.
        It starts once addition or removal of nodes is fully completed.
        Minimum cool down period is 30m.
        Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "cool_down_period")

    @property
    @pulumi.getter(name="maxClusterNodeCount")
    def max_cluster_node_count(self) -> Optional[builtins.int]:
        """
        Maximum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "max_cluster_node_count")

    @property
    @pulumi.getter(name="minClusterNodeCount")
    def min_cluster_node_count(self) -> Optional[builtins.int]:
        """
        Minimum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "min_cluster_node_count")


@pulumi.output_type
class ClusterAutoscalingSettingsAutoscalingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalePolicyId":
            suggest = "autoscale_policy_id"
        elif key == "nodeTypeId":
            suggest = "node_type_id"
        elif key == "scaleOutSize":
            suggest = "scale_out_size"
        elif key == "consumedMemoryThresholds":
            suggest = "consumed_memory_thresholds"
        elif key == "cpuThresholds":
            suggest = "cpu_thresholds"
        elif key == "storageThresholds":
            suggest = "storage_thresholds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalingSettingsAutoscalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_policy_id: builtins.str,
                 node_type_id: builtins.str,
                 scale_out_size: builtins.int,
                 consumed_memory_thresholds: Optional['outputs.ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds'] = None,
                 cpu_thresholds: Optional['outputs.ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds'] = None,
                 storage_thresholds: Optional['outputs.ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds'] = None):
        """
        :param builtins.str autoscale_policy_id: The identifier for this object. Format specified above.
        :param builtins.str node_type_id: The canonical identifier of the node type to add or remove.
        :param builtins.int scale_out_size: Number of nodes to add to a cluster during a scale-out operation.
               Must be divisible by 2 for stretched clusters.
        :param 'ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholdsArgs' consumed_memory_thresholds: Utilization thresholds pertaining to amount of consumed memory.
               Structure is documented below.
        :param 'ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholdsArgs' cpu_thresholds: Utilization thresholds pertaining to CPU utilization.
               Structure is documented below.
        :param 'ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholdsArgs' storage_thresholds: Utilization thresholds pertaining to amount of consumed storage.
               Structure is documented below.
        """
        pulumi.set(__self__, "autoscale_policy_id", autoscale_policy_id)
        pulumi.set(__self__, "node_type_id", node_type_id)
        pulumi.set(__self__, "scale_out_size", scale_out_size)
        if consumed_memory_thresholds is not None:
            pulumi.set(__self__, "consumed_memory_thresholds", consumed_memory_thresholds)
        if cpu_thresholds is not None:
            pulumi.set(__self__, "cpu_thresholds", cpu_thresholds)
        if storage_thresholds is not None:
            pulumi.set(__self__, "storage_thresholds", storage_thresholds)

    @property
    @pulumi.getter(name="autoscalePolicyId")
    def autoscale_policy_id(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "autoscale_policy_id")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        """
        The canonical identifier of the node type to add or remove.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="scaleOutSize")
    def scale_out_size(self) -> builtins.int:
        """
        Number of nodes to add to a cluster during a scale-out operation.
        Must be divisible by 2 for stretched clusters.
        """
        return pulumi.get(self, "scale_out_size")

    @property
    @pulumi.getter(name="consumedMemoryThresholds")
    def consumed_memory_thresholds(self) -> Optional['outputs.ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds']:
        """
        Utilization thresholds pertaining to amount of consumed memory.
        Structure is documented below.
        """
        return pulumi.get(self, "consumed_memory_thresholds")

    @property
    @pulumi.getter(name="cpuThresholds")
    def cpu_thresholds(self) -> Optional['outputs.ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds']:
        """
        Utilization thresholds pertaining to CPU utilization.
        Structure is documented below.
        """
        return pulumi.get(self, "cpu_thresholds")

    @property
    @pulumi.getter(name="storageThresholds")
    def storage_thresholds(self) -> Optional['outputs.ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds']:
        """
        Utilization thresholds pertaining to amount of consumed storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_thresholds")


@pulumi.output_type
class ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleIn":
            suggest = "scale_in"
        elif key == "scaleOut":
            suggest = "scale_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleIn":
            suggest = "scale_in"
        elif key == "scaleOut":
            suggest = "scale_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleIn":
            suggest = "scale_in"
        elif key == "scaleOut":
            suggest = "scale_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class ClusterNodeTypeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeTypeId":
            suggest = "node_type_id"
        elif key == "customCoreCount":
            suggest = "custom_core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: builtins.int,
                 node_type_id: builtins.str,
                 custom_core_count: Optional[builtins.int] = None):
        """
        :param builtins.int node_count: The number of nodes of this type in the cluster.
        :param builtins.str node_type_id: The identifier for this object. Format specified above.
        :param builtins.int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of `nodeType.availableCustomCoreCounts`.
               If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
               Once the customer is created then corecount cannot be changed.
        """
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)
        if custom_core_count is not None:
            pulumi.set(__self__, "custom_core_count", custom_core_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> Optional[builtins.int]:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of `nodeType.availableCustomCoreCounts`.
        If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
        Once the customer is created then corecount cannot be changed.
        """
        return pulumi.get(self, "custom_core_count")


@pulumi.output_type
class ExternalAccessRuleDestinationIpRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalAddress":
            suggest = "external_address"
        elif key == "ipAddressRange":
            suggest = "ip_address_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalAccessRuleDestinationIpRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalAccessRuleDestinationIpRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalAccessRuleDestinationIpRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_address: Optional[builtins.str] = None,
                 ip_address_range: Optional[builtins.str] = None):
        """
        :param builtins.str external_address: The name of an `ExternalAddress` resource.
               
               - - -
        :param builtins.str ip_address_range: An IP address range in the CIDR format.
        """
        if external_address is not None:
            pulumi.set(__self__, "external_address", external_address)
        if ip_address_range is not None:
            pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> Optional[builtins.str]:
        """
        The name of an `ExternalAddress` resource.

        - - -
        """
        return pulumi.get(self, "external_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> Optional[builtins.str]:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class ExternalAccessRuleSourceIpRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipAddressRange":
            suggest = "ip_address_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalAccessRuleSourceIpRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalAccessRuleSourceIpRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalAccessRuleSourceIpRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[builtins.str] = None,
                 ip_address_range: Optional[builtins.str] = None):
        """
        :param builtins.str ip_address: A single IP address.
        :param builtins.str ip_address_range: An IP address range in the CIDR format.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_range is not None:
            pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        """
        A single IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> Optional[builtins.str]:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class NetworkPolicyExternalIp(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: True if the service is enabled; false otherwise.
        :param builtins.str state: (Output)
               State of the service. New values may be added to this enum when appropriate.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class NetworkPolicyInternetAccess(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: True if the service is enabled; false otherwise.
        :param builtins.str state: (Output)
               State of the service. New values may be added to this enum when appropriate.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class NetworkVpcNetwork(dict):
    def __init__(__self__, *,
                 network: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str network: (Output)
               The relative resource name of the service VPC network this VMware Engine network is attached to.
               For example: projects/123123/global/networks/my-network
        :param builtins.str type: VMware Engine network type.
               Possible values are: `LEGACY`, `STANDARD`.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        (Output)
        The relative resource name of the service VPC network this VMware Engine network is attached to.
        For example: projects/123123/global/networks/my-network
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        VMware Engine network type.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateCloudHcx(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudHcx. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudHcx.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudHcx.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[builtins.str] = None,
                 internal_ip: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str fqdn: Fully qualified domain name of the appliance.
        :param builtins.str internal_ip: Internal IP address of the appliance.
        :param builtins.str state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param builtins.str version: Version of the appliance.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[builtins.str]:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[builtins.str]:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PrivateCloudManagementCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "autoscalingSettings":
            suggest = "autoscaling_settings"
        elif key == "nodeTypeConfigs":
            suggest = "node_type_configs"
        elif key == "stretchedClusterConfig":
            suggest = "stretched_cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: builtins.str,
                 autoscaling_settings: Optional['outputs.PrivateCloudManagementClusterAutoscalingSettings'] = None,
                 node_type_configs: Optional[Sequence['outputs.PrivateCloudManagementClusterNodeTypeConfig']] = None,
                 stretched_cluster_config: Optional['outputs.PrivateCloudManagementClusterStretchedClusterConfig'] = None):
        """
        :param builtins.str cluster_id: The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
               * Only contains 1-63 alphanumeric characters and hyphens
               * Begins with an alphabetical character
               * Ends with a non-hyphen character
               * Not formatted as a UUID
               * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        :param 'PrivateCloudManagementClusterAutoscalingSettingsArgs' autoscaling_settings: Configuration of the autoscaling applied to this cluster
               Private cloud must have a minimum of 3 nodes to add autoscale settings
               Structure is documented below.
        :param Sequence['PrivateCloudManagementClusterNodeTypeConfigArgs'] node_type_configs: The map of cluster node types in this cluster,
               where the key is canonical identifier of the node type (corresponds to the NodeType).
               Structure is documented below.
        :param 'PrivateCloudManagementClusterStretchedClusterConfigArgs' stretched_cluster_config: The stretched cluster configuration for the private cloud.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if autoscaling_settings is not None:
            pulumi.set(__self__, "autoscaling_settings", autoscaling_settings)
        if node_type_configs is not None:
            pulumi.set(__self__, "node_type_configs", node_type_configs)
        if stretched_cluster_config is not None:
            pulumi.set(__self__, "stretched_cluster_config", stretched_cluster_config)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
        * Only contains 1-63 alphanumeric characters and hyphens
        * Begins with an alphabetical character
        * Ends with a non-hyphen character
        * Not formatted as a UUID
        * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="autoscalingSettings")
    def autoscaling_settings(self) -> Optional['outputs.PrivateCloudManagementClusterAutoscalingSettings']:
        """
        Configuration of the autoscaling applied to this cluster
        Private cloud must have a minimum of 3 nodes to add autoscale settings
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_settings")

    @property
    @pulumi.getter(name="nodeTypeConfigs")
    def node_type_configs(self) -> Optional[Sequence['outputs.PrivateCloudManagementClusterNodeTypeConfig']]:
        """
        The map of cluster node types in this cluster,
        where the key is canonical identifier of the node type (corresponds to the NodeType).
        Structure is documented below.
        """
        return pulumi.get(self, "node_type_configs")

    @property
    @pulumi.getter(name="stretchedClusterConfig")
    def stretched_cluster_config(self) -> Optional['outputs.PrivateCloudManagementClusterStretchedClusterConfig']:
        """
        The stretched cluster configuration for the private cloud.
        Structure is documented below.
        """
        return pulumi.get(self, "stretched_cluster_config")


@pulumi.output_type
class PrivateCloudManagementClusterAutoscalingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingPolicies":
            suggest = "autoscaling_policies"
        elif key == "coolDownPeriod":
            suggest = "cool_down_period"
        elif key == "maxClusterNodeCount":
            suggest = "max_cluster_node_count"
        elif key == "minClusterNodeCount":
            suggest = "min_cluster_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterAutoscalingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterAutoscalingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterAutoscalingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_policies: Sequence['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicy'],
                 cool_down_period: Optional[builtins.str] = None,
                 max_cluster_node_count: Optional[builtins.int] = None,
                 min_cluster_node_count: Optional[builtins.int] = None):
        """
        :param Sequence['PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyArgs'] autoscaling_policies: The map with autoscaling policies applied to the cluster.
               The key is the identifier of the policy.
               It must meet the following requirements:
               * Only contains 1-63 alphanumeric characters and hyphens
               * Begins with an alphabetical character
               * Ends with a non-hyphen character
               * Not formatted as a UUID
               * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
               Currently the map must contain only one element
               that describes the autoscaling policy for compute nodes.
               Structure is documented below.
        :param builtins.str cool_down_period: The minimum duration between consecutive autoscale operations.
               It starts once addition or removal of nodes is fully completed.
               Minimum cool down period is 30m.
               Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int max_cluster_node_count: Maximum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int min_cluster_node_count: Minimum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        """
        pulumi.set(__self__, "autoscaling_policies", autoscaling_policies)
        if cool_down_period is not None:
            pulumi.set(__self__, "cool_down_period", cool_down_period)
        if max_cluster_node_count is not None:
            pulumi.set(__self__, "max_cluster_node_count", max_cluster_node_count)
        if min_cluster_node_count is not None:
            pulumi.set(__self__, "min_cluster_node_count", min_cluster_node_count)

    @property
    @pulumi.getter(name="autoscalingPolicies")
    def autoscaling_policies(self) -> Sequence['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicy']:
        """
        The map with autoscaling policies applied to the cluster.
        The key is the identifier of the policy.
        It must meet the following requirements:
        * Only contains 1-63 alphanumeric characters and hyphens
        * Begins with an alphabetical character
        * Ends with a non-hyphen character
        * Not formatted as a UUID
        * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        Currently the map must contain only one element
        that describes the autoscaling policy for compute nodes.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_policies")

    @property
    @pulumi.getter(name="coolDownPeriod")
    def cool_down_period(self) -> Optional[builtins.str]:
        """
        The minimum duration between consecutive autoscale operations.
        It starts once addition or removal of nodes is fully completed.
        Minimum cool down period is 30m.
        Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "cool_down_period")

    @property
    @pulumi.getter(name="maxClusterNodeCount")
    def max_cluster_node_count(self) -> Optional[builtins.int]:
        """
        Maximum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "max_cluster_node_count")

    @property
    @pulumi.getter(name="minClusterNodeCount")
    def min_cluster_node_count(self) -> Optional[builtins.int]:
        """
        Minimum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "min_cluster_node_count")


@pulumi.output_type
class PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalePolicyId":
            suggest = "autoscale_policy_id"
        elif key == "nodeTypeId":
            suggest = "node_type_id"
        elif key == "scaleOutSize":
            suggest = "scale_out_size"
        elif key == "consumedMemoryThresholds":
            suggest = "consumed_memory_thresholds"
        elif key == "cpuThresholds":
            suggest = "cpu_thresholds"
        elif key == "storageThresholds":
            suggest = "storage_thresholds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_policy_id: builtins.str,
                 node_type_id: builtins.str,
                 scale_out_size: builtins.int,
                 consumed_memory_thresholds: Optional['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds'] = None,
                 cpu_thresholds: Optional['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds'] = None,
                 storage_thresholds: Optional['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds'] = None):
        """
        :param builtins.str autoscale_policy_id: The identifier for this object. Format specified above.
        :param builtins.str node_type_id: The canonical identifier of the node type to add or remove.
        :param builtins.int scale_out_size: Number of nodes to add to a cluster during a scale-out operation.
               Must be divisible by 2 for stretched clusters.
        :param 'PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholdsArgs' consumed_memory_thresholds: Utilization thresholds pertaining to amount of consumed memory.
               Structure is documented below.
        :param 'PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholdsArgs' cpu_thresholds: Utilization thresholds pertaining to CPU utilization.
               Structure is documented below.
        :param 'PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholdsArgs' storage_thresholds: Utilization thresholds pertaining to amount of consumed storage.
               Structure is documented below.
        """
        pulumi.set(__self__, "autoscale_policy_id", autoscale_policy_id)
        pulumi.set(__self__, "node_type_id", node_type_id)
        pulumi.set(__self__, "scale_out_size", scale_out_size)
        if consumed_memory_thresholds is not None:
            pulumi.set(__self__, "consumed_memory_thresholds", consumed_memory_thresholds)
        if cpu_thresholds is not None:
            pulumi.set(__self__, "cpu_thresholds", cpu_thresholds)
        if storage_thresholds is not None:
            pulumi.set(__self__, "storage_thresholds", storage_thresholds)

    @property
    @pulumi.getter(name="autoscalePolicyId")
    def autoscale_policy_id(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "autoscale_policy_id")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        """
        The canonical identifier of the node type to add or remove.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="scaleOutSize")
    def scale_out_size(self) -> builtins.int:
        """
        Number of nodes to add to a cluster during a scale-out operation.
        Must be divisible by 2 for stretched clusters.
        """
        return pulumi.get(self, "scale_out_size")

    @property
    @pulumi.getter(name="consumedMemoryThresholds")
    def consumed_memory_thresholds(self) -> Optional['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds']:
        """
        Utilization thresholds pertaining to amount of consumed memory.
        Structure is documented below.
        """
        return pulumi.get(self, "consumed_memory_thresholds")

    @property
    @pulumi.getter(name="cpuThresholds")
    def cpu_thresholds(self) -> Optional['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds']:
        """
        Utilization thresholds pertaining to CPU utilization.
        Structure is documented below.
        """
        return pulumi.get(self, "cpu_thresholds")

    @property
    @pulumi.getter(name="storageThresholds")
    def storage_thresholds(self) -> Optional['outputs.PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds']:
        """
        Utilization thresholds pertaining to amount of consumed storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_thresholds")


@pulumi.output_type
class PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleIn":
            suggest = "scale_in"
        elif key == "scaleOut":
            suggest = "scale_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyConsumedMemoryThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleIn":
            suggest = "scale_in"
        elif key == "scaleOut":
            suggest = "scale_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyCpuThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleIn":
            suggest = "scale_in"
        elif key == "scaleOut":
            suggest = "scale_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterAutoscalingSettingsAutoscalingPolicyStorageThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
               
               - - -
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.

        - - -
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class PrivateCloudManagementClusterNodeTypeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeTypeId":
            suggest = "node_type_id"
        elif key == "customCoreCount":
            suggest = "custom_core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterNodeTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterNodeTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterNodeTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: builtins.int,
                 node_type_id: builtins.str,
                 custom_core_count: Optional[builtins.int] = None):
        """
        :param builtins.int node_count: The number of nodes of this type in the cluster.
        :param builtins.str node_type_id: The identifier for this object. Format specified above.
        :param builtins.int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of `nodeType.availableCustomCoreCounts`.
               If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
               This cannot be changed once the PrivateCloud is created.
        """
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)
        if custom_core_count is not None:
            pulumi.set(__self__, "custom_core_count", custom_core_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> Optional[builtins.int]:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of `nodeType.availableCustomCoreCounts`.
        If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
        This cannot be changed once the PrivateCloud is created.
        """
        return pulumi.get(self, "custom_core_count")


@pulumi.output_type
class PrivateCloudManagementClusterStretchedClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredLocation":
            suggest = "preferred_location"
        elif key == "secondaryLocation":
            suggest = "secondary_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterStretchedClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterStretchedClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterStretchedClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_location: Optional[builtins.str] = None,
                 secondary_location: Optional[builtins.str] = None):
        """
        :param builtins.str preferred_location: Zone that will remain operational when connection between the two zones is lost.
               Specify the zone in the following format: projects/{project}/locations/{location}.
        :param builtins.str secondary_location: Additional zone for a higher level of availability and load balancing.
               Specify the zone in the following format: projects/{project}/locations/{location}.
        """
        if preferred_location is not None:
            pulumi.set(__self__, "preferred_location", preferred_location)
        if secondary_location is not None:
            pulumi.set(__self__, "secondary_location", secondary_location)

    @property
    @pulumi.getter(name="preferredLocation")
    def preferred_location(self) -> Optional[builtins.str]:
        """
        Zone that will remain operational when connection between the two zones is lost.
        Specify the zone in the following format: projects/{project}/locations/{location}.
        """
        return pulumi.get(self, "preferred_location")

    @property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> Optional[builtins.str]:
        """
        Additional zone for a higher level of availability and load balancing.
        Specify the zone in the following format: projects/{project}/locations/{location}.
        """
        return pulumi.get(self, "secondary_location")


@pulumi.output_type
class PrivateCloudNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managementCidr":
            suggest = "management_cidr"
        elif key == "dnsServerIp":
            suggest = "dns_server_ip"
        elif key == "managementIpAddressLayoutVersion":
            suggest = "management_ip_address_layout_version"
        elif key == "vmwareEngineNetwork":
            suggest = "vmware_engine_network"
        elif key == "vmwareEngineNetworkCanonical":
            suggest = "vmware_engine_network_canonical"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 management_cidr: builtins.str,
                 dns_server_ip: Optional[builtins.str] = None,
                 management_ip_address_layout_version: Optional[builtins.int] = None,
                 vmware_engine_network: Optional[builtins.str] = None,
                 vmware_engine_network_canonical: Optional[builtins.str] = None):
        """
        :param builtins.str management_cidr: Management CIDR used by VMware management appliances.
        :param builtins.str dns_server_ip: (Output)
               DNS Server IP of the Private Cloud.
        :param builtins.int management_ip_address_layout_version: (Output)
               The IP address layout version of the management IP address range.
               Possible versions include:
               * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
               as it does not support all features.
               * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
               used by all newly created private clouds. This version supports all current features.
        :param builtins.str vmware_engine_network: The relative resource name of the VMware Engine network attached to the private cloud.
               Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
               where {project} can either be a project number or a project ID.
        :param builtins.str vmware_engine_network_canonical: (Output)
               The canonical name of the VMware Engine network in
               the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        pulumi.set(__self__, "management_cidr", management_cidr)
        if dns_server_ip is not None:
            pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if management_ip_address_layout_version is not None:
            pulumi.set(__self__, "management_ip_address_layout_version", management_ip_address_layout_version)
        if vmware_engine_network is not None:
            pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        if vmware_engine_network_canonical is not None:
            pulumi.set(__self__, "vmware_engine_network_canonical", vmware_engine_network_canonical)

    @property
    @pulumi.getter(name="managementCidr")
    def management_cidr(self) -> builtins.str:
        """
        Management CIDR used by VMware management appliances.
        """
        return pulumi.get(self, "management_cidr")

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> Optional[builtins.str]:
        """
        (Output)
        DNS Server IP of the Private Cloud.
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="managementIpAddressLayoutVersion")
    def management_ip_address_layout_version(self) -> Optional[builtins.int]:
        """
        (Output)
        The IP address layout version of the management IP address range.
        Possible versions include:
        * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
        as it does not support all features.
        * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
        used by all newly created private clouds. This version supports all current features.
        """
        return pulumi.get(self, "management_ip_address_layout_version")

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> Optional[builtins.str]:
        """
        The relative resource name of the VMware Engine network attached to the private cloud.
        Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        where {project} can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> Optional[builtins.str]:
        """
        (Output)
        The canonical name of the VMware Engine network in
        the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")


@pulumi.output_type
class PrivateCloudNsx(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudNsx. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudNsx.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudNsx.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[builtins.str] = None,
                 internal_ip: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str fqdn: Fully qualified domain name of the appliance.
        :param builtins.str internal_ip: Internal IP address of the appliance.
        :param builtins.str state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param builtins.str version: Version of the appliance.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[builtins.str]:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[builtins.str]:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PrivateCloudVcenter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudVcenter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudVcenter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudVcenter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[builtins.str] = None,
                 internal_ip: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str fqdn: Fully qualified domain name of the appliance.
        :param builtins.str internal_ip: Internal IP address of the appliance.
        :param builtins.str state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param builtins.str version: Version of the appliance.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[builtins.str]:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[builtins.str]:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SubnetDhcpAddressRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firstAddress":
            suggest = "first_address"
        elif key == "lastAddress":
            suggest = "last_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetDhcpAddressRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetDhcpAddressRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetDhcpAddressRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 first_address: Optional[builtins.str] = None,
                 last_address: Optional[builtins.str] = None):
        """
        :param builtins.str first_address: (Output)
               The first IP address of the range.
        :param builtins.str last_address: (Output)
               The last IP address of the range.
        """
        if first_address is not None:
            pulumi.set(__self__, "first_address", first_address)
        if last_address is not None:
            pulumi.set(__self__, "last_address", last_address)

    @property
    @pulumi.getter(name="firstAddress")
    def first_address(self) -> Optional[builtins.str]:
        """
        (Output)
        The first IP address of the range.
        """
        return pulumi.get(self, "first_address")

    @property
    @pulumi.getter(name="lastAddress")
    def last_address(self) -> Optional[builtins.str]:
        """
        (Output)
        The last IP address of the range.
        """
        return pulumi.get(self, "last_address")


@pulumi.output_type
class GetClusterAutoscalingSettingResult(dict):
    def __init__(__self__, *,
                 autoscaling_policies: Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyResult'],
                 cool_down_period: builtins.str,
                 max_cluster_node_count: builtins.int,
                 min_cluster_node_count: builtins.int):
        """
        :param Sequence['GetClusterAutoscalingSettingAutoscalingPolicyArgs'] autoscaling_policies: The map with autoscaling policies applied to the cluster.
               The key is the identifier of the policy.
               It must meet the following requirements:
                 * Only contains 1-63 alphanumeric characters and hyphens
                 * Begins with an alphabetical character
                 * Ends with a non-hyphen character
                 * Not formatted as a UUID
                 * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
               
               Currently the map must contain only one element
               that describes the autoscaling policy for compute nodes.
        :param builtins.str cool_down_period: The minimum duration between consecutive autoscale operations.
               It starts once addition or removal of nodes is fully completed.
               Minimum cool down period is 30m.
               Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int max_cluster_node_count: Maximum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int min_cluster_node_count: Minimum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        """
        pulumi.set(__self__, "autoscaling_policies", autoscaling_policies)
        pulumi.set(__self__, "cool_down_period", cool_down_period)
        pulumi.set(__self__, "max_cluster_node_count", max_cluster_node_count)
        pulumi.set(__self__, "min_cluster_node_count", min_cluster_node_count)

    @property
    @pulumi.getter(name="autoscalingPolicies")
    def autoscaling_policies(self) -> Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyResult']:
        """
        The map with autoscaling policies applied to the cluster.
        The key is the identifier of the policy.
        It must meet the following requirements:
          * Only contains 1-63 alphanumeric characters and hyphens
          * Begins with an alphabetical character
          * Ends with a non-hyphen character
          * Not formatted as a UUID
          * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)

        Currently the map must contain only one element
        that describes the autoscaling policy for compute nodes.
        """
        return pulumi.get(self, "autoscaling_policies")

    @property
    @pulumi.getter(name="coolDownPeriod")
    def cool_down_period(self) -> builtins.str:
        """
        The minimum duration between consecutive autoscale operations.
        It starts once addition or removal of nodes is fully completed.
        Minimum cool down period is 30m.
        Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "cool_down_period")

    @property
    @pulumi.getter(name="maxClusterNodeCount")
    def max_cluster_node_count(self) -> builtins.int:
        """
        Maximum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "max_cluster_node_count")

    @property
    @pulumi.getter(name="minClusterNodeCount")
    def min_cluster_node_count(self) -> builtins.int:
        """
        Minimum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "min_cluster_node_count")


@pulumi.output_type
class GetClusterAutoscalingSettingAutoscalingPolicyResult(dict):
    def __init__(__self__, *,
                 autoscale_policy_id: builtins.str,
                 consumed_memory_thresholds: Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult'],
                 cpu_thresholds: Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult'],
                 node_type_id: builtins.str,
                 scale_out_size: builtins.int,
                 storage_thresholds: Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult']):
        """
        :param Sequence['GetClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdArgs'] consumed_memory_thresholds: Utilization thresholds pertaining to amount of consumed memory.
        :param Sequence['GetClusterAutoscalingSettingAutoscalingPolicyCpuThresholdArgs'] cpu_thresholds: Utilization thresholds pertaining to CPU utilization.
        :param builtins.str node_type_id: The canonical identifier of the node type to add or remove.
        :param builtins.int scale_out_size: Number of nodes to add to a cluster during a scale-out operation.
               Must be divisible by 2 for stretched clusters.
        :param Sequence['GetClusterAutoscalingSettingAutoscalingPolicyStorageThresholdArgs'] storage_thresholds: Utilization thresholds pertaining to amount of consumed storage.
        """
        pulumi.set(__self__, "autoscale_policy_id", autoscale_policy_id)
        pulumi.set(__self__, "consumed_memory_thresholds", consumed_memory_thresholds)
        pulumi.set(__self__, "cpu_thresholds", cpu_thresholds)
        pulumi.set(__self__, "node_type_id", node_type_id)
        pulumi.set(__self__, "scale_out_size", scale_out_size)
        pulumi.set(__self__, "storage_thresholds", storage_thresholds)

    @property
    @pulumi.getter(name="autoscalePolicyId")
    def autoscale_policy_id(self) -> builtins.str:
        return pulumi.get(self, "autoscale_policy_id")

    @property
    @pulumi.getter(name="consumedMemoryThresholds")
    def consumed_memory_thresholds(self) -> Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult']:
        """
        Utilization thresholds pertaining to amount of consumed memory.
        """
        return pulumi.get(self, "consumed_memory_thresholds")

    @property
    @pulumi.getter(name="cpuThresholds")
    def cpu_thresholds(self) -> Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult']:
        """
        Utilization thresholds pertaining to CPU utilization.
        """
        return pulumi.get(self, "cpu_thresholds")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        """
        The canonical identifier of the node type to add or remove.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="scaleOutSize")
    def scale_out_size(self) -> builtins.int:
        """
        Number of nodes to add to a cluster during a scale-out operation.
        Must be divisible by 2 for stretched clusters.
        """
        return pulumi.get(self, "scale_out_size")

    @property
    @pulumi.getter(name="storageThresholds")
    def storage_thresholds(self) -> Sequence['outputs.GetClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult']:
        """
        Utilization thresholds pertaining to amount of consumed storage.
        """
        return pulumi.get(self, "storage_thresholds")


@pulumi.output_type
class GetClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult(dict):
    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class GetClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult(dict):
    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class GetClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult(dict):
    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class GetClusterNodeTypeConfigResult(dict):
    def __init__(__self__, *,
                 custom_core_count: builtins.int,
                 node_count: builtins.int,
                 node_type_id: builtins.str):
        """
        :param builtins.int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of 'nodeType.availableCustomCoreCounts'.
               If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
               Once the customer is created then corecount cannot be changed.
        :param builtins.int node_count: The number of nodes of this type in the cluster.
        """
        pulumi.set(__self__, "custom_core_count", custom_core_count)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> builtins.int:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of 'nodeType.availableCustomCoreCounts'.
        If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
        Once the customer is created then corecount cannot be changed.
        """
        return pulumi.get(self, "custom_core_count")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        return pulumi.get(self, "node_type_id")


@pulumi.output_type
class GetExternalAccessRuleDestinationIpRangeResult(dict):
    def __init__(__self__, *,
                 external_address: builtins.str,
                 ip_address_range: builtins.str):
        """
        :param builtins.str external_address: The name of an 'ExternalAddress' resource.
        :param builtins.str ip_address_range: An IP address range in the CIDR format.
        """
        pulumi.set(__self__, "external_address", external_address)
        pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> builtins.str:
        """
        The name of an 'ExternalAddress' resource.
        """
        return pulumi.get(self, "external_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> builtins.str:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class GetExternalAccessRuleSourceIpRangeResult(dict):
    def __init__(__self__, *,
                 ip_address: builtins.str,
                 ip_address_range: builtins.str):
        """
        :param builtins.str ip_address: A single IP address.
        :param builtins.str ip_address_range: An IP address range in the CIDR format.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        A single IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> builtins.str:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class GetNetworkPolicyExternalIpResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 state: builtins.str):
        """
        :param builtins.bool enabled: True if the service is enabled; false otherwise.
        :param builtins.str state: State of the service. New values may be added to this enum when appropriate.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetNetworkPolicyInternetAccessResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 state: builtins.str):
        """
        :param builtins.bool enabled: True if the service is enabled; false otherwise.
        :param builtins.str state: State of the service. New values may be added to this enum when appropriate.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetNetworkVpcNetworkResult(dict):
    def __init__(__self__, *,
                 network: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str network: The relative resource name of the service VPC network this VMware Engine network is attached to.
               For example: projects/123123/global/networks/my-network
        :param builtins.str type: Type of VPC network (INTRANET, INTERNET, or GOOGLE_CLOUD)
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        The relative resource name of the service VPC network this VMware Engine network is attached to.
        For example: projects/123123/global/networks/my-network
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of VPC network (INTRANET, INTERNET, or GOOGLE_CLOUD)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPrivateCloudHcxResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 internal_ip: builtins.str,
                 state: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str fqdn: Fully qualified domain name of the appliance.
        :param builtins.str internal_ip: Internal IP address of the appliance.
        :param builtins.str state: State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        :param builtins.str version: Version of the appliance.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> builtins.str:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPrivateCloudManagementClusterResult(dict):
    def __init__(__self__, *,
                 autoscaling_settings: Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingResult'],
                 cluster_id: builtins.str,
                 node_type_configs: Sequence['outputs.GetPrivateCloudManagementClusterNodeTypeConfigResult'],
                 stretched_cluster_configs: Sequence['outputs.GetPrivateCloudManagementClusterStretchedClusterConfigResult']):
        """
        :param Sequence['GetPrivateCloudManagementClusterAutoscalingSettingArgs'] autoscaling_settings: Configuration of the autoscaling applied to this cluster
               Private cloud must have a minimum of 3 nodes to add autoscale settings
        :param builtins.str cluster_id: The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
                 * Only contains 1-63 alphanumeric characters and hyphens
                 * Begins with an alphabetical character
                 * Ends with a non-hyphen character
                 * Not formatted as a UUID
                 * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        :param Sequence['GetPrivateCloudManagementClusterNodeTypeConfigArgs'] node_type_configs: The map of cluster node types in this cluster,
               where the key is canonical identifier of the node type (corresponds to the NodeType).
        :param Sequence['GetPrivateCloudManagementClusterStretchedClusterConfigArgs'] stretched_cluster_configs: The stretched cluster configuration for the private cloud.
        """
        pulumi.set(__self__, "autoscaling_settings", autoscaling_settings)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "node_type_configs", node_type_configs)
        pulumi.set(__self__, "stretched_cluster_configs", stretched_cluster_configs)

    @property
    @pulumi.getter(name="autoscalingSettings")
    def autoscaling_settings(self) -> Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingResult']:
        """
        Configuration of the autoscaling applied to this cluster
        Private cloud must have a minimum of 3 nodes to add autoscale settings
        """
        return pulumi.get(self, "autoscaling_settings")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
          * Only contains 1-63 alphanumeric characters and hyphens
          * Begins with an alphabetical character
          * Ends with a non-hyphen character
          * Not formatted as a UUID
          * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="nodeTypeConfigs")
    def node_type_configs(self) -> Sequence['outputs.GetPrivateCloudManagementClusterNodeTypeConfigResult']:
        """
        The map of cluster node types in this cluster,
        where the key is canonical identifier of the node type (corresponds to the NodeType).
        """
        return pulumi.get(self, "node_type_configs")

    @property
    @pulumi.getter(name="stretchedClusterConfigs")
    def stretched_cluster_configs(self) -> Sequence['outputs.GetPrivateCloudManagementClusterStretchedClusterConfigResult']:
        """
        The stretched cluster configuration for the private cloud.
        """
        return pulumi.get(self, "stretched_cluster_configs")


@pulumi.output_type
class GetPrivateCloudManagementClusterAutoscalingSettingResult(dict):
    def __init__(__self__, *,
                 autoscaling_policies: Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyResult'],
                 cool_down_period: builtins.str,
                 max_cluster_node_count: builtins.int,
                 min_cluster_node_count: builtins.int):
        """
        :param Sequence['GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyArgs'] autoscaling_policies: The map with autoscaling policies applied to the cluster.
               The key is the identifier of the policy.
               It must meet the following requirements:
                * Only contains 1-63 alphanumeric characters and hyphens
                * Begins with an alphabetical character
                * Ends with a non-hyphen character
                * Not formatted as a UUID
                * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
               
               Currently the map must contain only one element
               that describes the autoscaling policy for compute nodes.
        :param builtins.str cool_down_period: The minimum duration between consecutive autoscale operations.
               It starts once addition or removal of nodes is fully completed.
               Minimum cool down period is 30m.
               Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int max_cluster_node_count: Maximum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        :param builtins.int min_cluster_node_count: Minimum number of nodes of any type in a cluster.
               Mandatory for successful addition of autoscaling settings in cluster.
        """
        pulumi.set(__self__, "autoscaling_policies", autoscaling_policies)
        pulumi.set(__self__, "cool_down_period", cool_down_period)
        pulumi.set(__self__, "max_cluster_node_count", max_cluster_node_count)
        pulumi.set(__self__, "min_cluster_node_count", min_cluster_node_count)

    @property
    @pulumi.getter(name="autoscalingPolicies")
    def autoscaling_policies(self) -> Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyResult']:
        """
        The map with autoscaling policies applied to the cluster.
        The key is the identifier of the policy.
        It must meet the following requirements:
         * Only contains 1-63 alphanumeric characters and hyphens
         * Begins with an alphabetical character
         * Ends with a non-hyphen character
         * Not formatted as a UUID
         * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)

        Currently the map must contain only one element
        that describes the autoscaling policy for compute nodes.
        """
        return pulumi.get(self, "autoscaling_policies")

    @property
    @pulumi.getter(name="coolDownPeriod")
    def cool_down_period(self) -> builtins.str:
        """
        The minimum duration between consecutive autoscale operations.
        It starts once addition or removal of nodes is fully completed.
        Minimum cool down period is 30m.
        Cool down period must be in whole minutes (for example, 30m, 31m, 50m).
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "cool_down_period")

    @property
    @pulumi.getter(name="maxClusterNodeCount")
    def max_cluster_node_count(self) -> builtins.int:
        """
        Maximum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "max_cluster_node_count")

    @property
    @pulumi.getter(name="minClusterNodeCount")
    def min_cluster_node_count(self) -> builtins.int:
        """
        Minimum number of nodes of any type in a cluster.
        Mandatory for successful addition of autoscaling settings in cluster.
        """
        return pulumi.get(self, "min_cluster_node_count")


@pulumi.output_type
class GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyResult(dict):
    def __init__(__self__, *,
                 autoscale_policy_id: builtins.str,
                 consumed_memory_thresholds: Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult'],
                 cpu_thresholds: Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult'],
                 node_type_id: builtins.str,
                 scale_out_size: builtins.int,
                 storage_thresholds: Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult']):
        """
        :param Sequence['GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdArgs'] consumed_memory_thresholds: Utilization thresholds pertaining to amount of consumed memory.
        :param Sequence['GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyCpuThresholdArgs'] cpu_thresholds: Utilization thresholds pertaining to CPU utilization.
        :param builtins.str node_type_id: The canonical identifier of the node type to add or remove.
        :param builtins.int scale_out_size: Number of nodes to add to a cluster during a scale-out operation.
               Must be divisible by 2 for stretched clusters.
        :param Sequence['GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyStorageThresholdArgs'] storage_thresholds: Utilization thresholds pertaining to amount of consumed storage.
        """
        pulumi.set(__self__, "autoscale_policy_id", autoscale_policy_id)
        pulumi.set(__self__, "consumed_memory_thresholds", consumed_memory_thresholds)
        pulumi.set(__self__, "cpu_thresholds", cpu_thresholds)
        pulumi.set(__self__, "node_type_id", node_type_id)
        pulumi.set(__self__, "scale_out_size", scale_out_size)
        pulumi.set(__self__, "storage_thresholds", storage_thresholds)

    @property
    @pulumi.getter(name="autoscalePolicyId")
    def autoscale_policy_id(self) -> builtins.str:
        return pulumi.get(self, "autoscale_policy_id")

    @property
    @pulumi.getter(name="consumedMemoryThresholds")
    def consumed_memory_thresholds(self) -> Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult']:
        """
        Utilization thresholds pertaining to amount of consumed memory.
        """
        return pulumi.get(self, "consumed_memory_thresholds")

    @property
    @pulumi.getter(name="cpuThresholds")
    def cpu_thresholds(self) -> Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult']:
        """
        Utilization thresholds pertaining to CPU utilization.
        """
        return pulumi.get(self, "cpu_thresholds")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        """
        The canonical identifier of the node type to add or remove.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="scaleOutSize")
    def scale_out_size(self) -> builtins.int:
        """
        Number of nodes to add to a cluster during a scale-out operation.
        Must be divisible by 2 for stretched clusters.
        """
        return pulumi.get(self, "scale_out_size")

    @property
    @pulumi.getter(name="storageThresholds")
    def storage_thresholds(self) -> Sequence['outputs.GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult']:
        """
        Utilization thresholds pertaining to amount of consumed storage.
        """
        return pulumi.get(self, "storage_thresholds")


@pulumi.output_type
class GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyConsumedMemoryThresholdResult(dict):
    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyCpuThresholdResult(dict):
    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class GetPrivateCloudManagementClusterAutoscalingSettingAutoscalingPolicyStorageThresholdResult(dict):
    def __init__(__self__, *,
                 scale_in: builtins.int,
                 scale_out: builtins.int):
        """
        :param builtins.int scale_in: The utilization triggering the scale-in operation in percent.
        :param builtins.int scale_out: The utilization triggering the scale-out operation in percent.
        """
        pulumi.set(__self__, "scale_in", scale_in)
        pulumi.set(__self__, "scale_out", scale_out)

    @property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> builtins.int:
        """
        The utilization triggering the scale-in operation in percent.
        """
        return pulumi.get(self, "scale_in")

    @property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> builtins.int:
        """
        The utilization triggering the scale-out operation in percent.
        """
        return pulumi.get(self, "scale_out")


@pulumi.output_type
class GetPrivateCloudManagementClusterNodeTypeConfigResult(dict):
    def __init__(__self__, *,
                 custom_core_count: builtins.int,
                 node_count: builtins.int,
                 node_type_id: builtins.str):
        """
        :param builtins.int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of 'nodeType.availableCustomCoreCounts'.
               If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
               This cannot be changed once the PrivateCloud is created.
        :param builtins.int node_count: The number of nodes of this type in the cluster.
        """
        pulumi.set(__self__, "custom_core_count", custom_core_count)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> builtins.int:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of 'nodeType.availableCustomCoreCounts'.
        If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
        This cannot be changed once the PrivateCloud is created.
        """
        return pulumi.get(self, "custom_core_count")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> builtins.str:
        return pulumi.get(self, "node_type_id")


@pulumi.output_type
class GetPrivateCloudManagementClusterStretchedClusterConfigResult(dict):
    def __init__(__self__, *,
                 preferred_location: builtins.str,
                 secondary_location: builtins.str):
        """
        :param builtins.str preferred_location: Zone that will remain operational when connection between the two zones is lost.
               Specify the zone in the following format: projects/{project}/locations/{location}.
        :param builtins.str secondary_location: Additional zone for a higher level of availability and load balancing.
               Specify the zone in the following format: projects/{project}/locations/{location}.
        """
        pulumi.set(__self__, "preferred_location", preferred_location)
        pulumi.set(__self__, "secondary_location", secondary_location)

    @property
    @pulumi.getter(name="preferredLocation")
    def preferred_location(self) -> builtins.str:
        """
        Zone that will remain operational when connection between the two zones is lost.
        Specify the zone in the following format: projects/{project}/locations/{location}.
        """
        return pulumi.get(self, "preferred_location")

    @property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> builtins.str:
        """
        Additional zone for a higher level of availability and load balancing.
        Specify the zone in the following format: projects/{project}/locations/{location}.
        """
        return pulumi.get(self, "secondary_location")


@pulumi.output_type
class GetPrivateCloudNetworkConfigResult(dict):
    def __init__(__self__, *,
                 dns_server_ip: builtins.str,
                 management_cidr: builtins.str,
                 management_ip_address_layout_version: builtins.int,
                 vmware_engine_network: builtins.str,
                 vmware_engine_network_canonical: builtins.str):
        """
        :param builtins.str dns_server_ip: DNS Server IP of the Private Cloud.
        :param builtins.str management_cidr: Management CIDR used by VMware management appliances.
        :param builtins.int management_ip_address_layout_version: The IP address layout version of the management IP address range.
               Possible versions include:
               * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
               as it does not support all features.
               * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
               used by all newly created private clouds. This version supports all current features.
        :param builtins.str vmware_engine_network: The relative resource name of the VMware Engine network attached to the private cloud.
               Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
               where {project} can either be a project number or a project ID.
        :param builtins.str vmware_engine_network_canonical: The canonical name of the VMware Engine network in
               the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        pulumi.set(__self__, "management_cidr", management_cidr)
        pulumi.set(__self__, "management_ip_address_layout_version", management_ip_address_layout_version)
        pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        pulumi.set(__self__, "vmware_engine_network_canonical", vmware_engine_network_canonical)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> builtins.str:
        """
        DNS Server IP of the Private Cloud.
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="managementCidr")
    def management_cidr(self) -> builtins.str:
        """
        Management CIDR used by VMware management appliances.
        """
        return pulumi.get(self, "management_cidr")

    @property
    @pulumi.getter(name="managementIpAddressLayoutVersion")
    def management_ip_address_layout_version(self) -> builtins.int:
        """
        The IP address layout version of the management IP address range.
        Possible versions include:
        * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
        as it does not support all features.
        * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
        used by all newly created private clouds. This version supports all current features.
        """
        return pulumi.get(self, "management_ip_address_layout_version")

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> builtins.str:
        """
        The relative resource name of the VMware Engine network attached to the private cloud.
        Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        where {project} can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> builtins.str:
        """
        The canonical name of the VMware Engine network in
        the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")


@pulumi.output_type
class GetPrivateCloudNsxResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 internal_ip: builtins.str,
                 state: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str fqdn: Fully qualified domain name of the appliance.
        :param builtins.str internal_ip: Internal IP address of the appliance.
        :param builtins.str state: State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        :param builtins.str version: Version of the appliance.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> builtins.str:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPrivateCloudVcenterResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 internal_ip: builtins.str,
                 state: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str fqdn: Fully qualified domain name of the appliance.
        :param builtins.str internal_ip: Internal IP address of the appliance.
        :param builtins.str state: State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        :param builtins.str version: Version of the appliance.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> builtins.str:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetSubnetDhcpAddressRangeResult(dict):
    def __init__(__self__, *,
                 first_address: builtins.str,
                 last_address: builtins.str):
        """
        :param builtins.str first_address: The first IP address of the range.
        :param builtins.str last_address: The last IP address of the range.
        """
        pulumi.set(__self__, "first_address", first_address)
        pulumi.set(__self__, "last_address", last_address)

    @property
    @pulumi.getter(name="firstAddress")
    def first_address(self) -> builtins.str:
        """
        The first IP address of the range.
        """
        return pulumi.get(self, "first_address")

    @property
    @pulumi.getter(name="lastAddress")
    def last_address(self) -> builtins.str:
        """
        The last IP address of the range.
        """
        return pulumi.get(self, "last_address")


