# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWorkstationIamPolicyResult',
    'AwaitableGetWorkstationIamPolicyResult',
    'get_workstation_iam_policy',
    'get_workstation_iam_policy_output',
]

@pulumi.output_type
class GetWorkstationIamPolicyResult:
    """
    A collection of values returned by getWorkstationIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, location=None, policy_data=None, project=None, workstation_cluster_id=None, workstation_config_id=None, workstation_id=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if workstation_cluster_id and not isinstance(workstation_cluster_id, str):
            raise TypeError("Expected argument 'workstation_cluster_id' to be a str")
        pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        if workstation_config_id and not isinstance(workstation_config_id, str):
            raise TypeError("Expected argument 'workstation_config_id' to be a str")
        pulumi.set(__self__, "workstation_config_id", workstation_config_id)
        if workstation_id and not isinstance(workstation_id, str):
            raise TypeError("Expected argument 'workstation_id' to be a str")
        pulumi.set(__self__, "workstation_id", workstation_id)

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Required only by `workstations.WorkstationIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> builtins.str:
        return pulumi.get(self, "workstation_cluster_id")

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> builtins.str:
        return pulumi.get(self, "workstation_config_id")

    @property
    @pulumi.getter(name="workstationId")
    def workstation_id(self) -> builtins.str:
        return pulumi.get(self, "workstation_id")


class AwaitableGetWorkstationIamPolicyResult(GetWorkstationIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkstationIamPolicyResult(
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project,
            workstation_cluster_id=self.workstation_cluster_id,
            workstation_config_id=self.workstation_config_id,
            workstation_id=self.workstation_id)


def get_workstation_iam_policy(location: Optional[builtins.str] = None,
                               project: Optional[builtins.str] = None,
                               workstation_cluster_id: Optional[builtins.str] = None,
                               workstation_config_id: Optional[builtins.str] = None,
                               workstation_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkstationIamPolicyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.workstations.get_workstation_iam_policy(project=default["project"],
        location=default["location"],
        workstation_cluster_id=default["workstationClusterId"],
        workstation_config_id=default["workstationConfigId"],
        workstation_id=default["workstationId"])
    ```


    :param builtins.str location: The location where the workstation parent resources reside.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param builtins.str workstation_cluster_id: The ID of the parent workstation cluster.
           Used to find the parent resource to bind the IAM policy to
    :param builtins.str workstation_config_id: The ID of the parent workstation cluster config.
           Used to find the parent resource to bind the IAM policy to
    :param builtins.str workstation_id: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['workstationClusterId'] = workstation_cluster_id
    __args__['workstationConfigId'] = workstation_config_id
    __args__['workstationId'] = workstation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:workstations/getWorkstationIamPolicy:getWorkstationIamPolicy', __args__, opts=opts, typ=GetWorkstationIamPolicyResult).value

    return AwaitableGetWorkstationIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        workstation_cluster_id=pulumi.get(__ret__, 'workstation_cluster_id'),
        workstation_config_id=pulumi.get(__ret__, 'workstation_config_id'),
        workstation_id=pulumi.get(__ret__, 'workstation_id'))
def get_workstation_iam_policy_output(location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                      workstation_config_id: Optional[pulumi.Input[builtins.str]] = None,
                                      workstation_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkstationIamPolicyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.workstations.get_workstation_iam_policy(project=default["project"],
        location=default["location"],
        workstation_cluster_id=default["workstationClusterId"],
        workstation_config_id=default["workstationConfigId"],
        workstation_id=default["workstationId"])
    ```


    :param builtins.str location: The location where the workstation parent resources reside.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param builtins.str workstation_cluster_id: The ID of the parent workstation cluster.
           Used to find the parent resource to bind the IAM policy to
    :param builtins.str workstation_config_id: The ID of the parent workstation cluster config.
           Used to find the parent resource to bind the IAM policy to
    :param builtins.str workstation_id: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['workstationClusterId'] = workstation_cluster_id
    __args__['workstationConfigId'] = workstation_config_id
    __args__['workstationId'] = workstation_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:workstations/getWorkstationIamPolicy:getWorkstationIamPolicy', __args__, opts=opts, typ=GetWorkstationIamPolicyResult)
    return __ret__.apply(lambda __response__: GetWorkstationIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        workstation_cluster_id=pulumi.get(__response__, 'workstation_cluster_id'),
        workstation_config_id=pulumi.get(__response__, 'workstation_config_id'),
        workstation_id=pulumi.get(__response__, 'workstation_id')))
