# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkstationArgs', 'Workstation']

@pulumi.input_type
class WorkstationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 workstation_cluster_id: pulumi.Input[builtins.str],
                 workstation_config_id: pulumi.Input[builtins.str],
                 workstation_id: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_workstation: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Workstation resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation parent resources reside.
               
               
               - - -
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID of the parent workstation cluster config.
        :param pulumi.Input[builtins.str] workstation_id: ID to use for the workstation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: 'Client-specified environment variables passed to the workstation container's entrypoint.'
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] source_workstation: Full resource name of the source workstation from which the workstation's persistent
               directories will be cloned from during creation.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        pulumi.set(__self__, "workstation_config_id", workstation_config_id)
        pulumi.set(__self__, "workstation_id", workstation_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_workstation is not None:
            pulumi.set(__self__, "source_workstation", source_workstation)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location where the workstation parent resources reside.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the parent workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

    @workstation_config_id.setter
    def workstation_config_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workstation_config_id", value)

    @property
    @pulumi.getter(name="workstationId")
    def workstation_id(self) -> pulumi.Input[builtins.str]:
        """
        ID to use for the workstation.
        """
        return pulumi.get(self, "workstation_id")

    @workstation_id.setter
    def workstation_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workstation_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        'Client-specified environment variables passed to the workstation container's entrypoint.'
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sourceWorkstation")
    def source_workstation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full resource name of the source workstation from which the workstation's persistent
        directories will be cloned from during creation.
        """
        return pulumi.get(self, "source_workstation")

    @source_workstation.setter
    def source_workstation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_workstation", value)


@pulumi.input_type
class _WorkstationState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 source_workstation: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workstation resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Time when this resource was created.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: 'Client-specified environment variables passed to the workstation container's entrypoint.'
        :param pulumi.Input[builtins.str] host: Host to which clients can send HTTPS traffic that will be received by the workstation.
               Authorized traffic will be received to the workstation as HTTP on port 80.
               To send traffic to a different port, clients may prefix the host with the destination port in the format "{port}-{host}".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation parent resources reside.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: Full name of this resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] source_workstation: Full resource name of the source workstation from which the workstation's persistent
               directories will be cloned from during creation.
        :param pulumi.Input[builtins.str] state: Current state of the workstation.
        :param pulumi.Input[builtins.str] uid: A system-assigned unique identified for this resource.
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID of the parent workstation cluster config.
        :param pulumi.Input[builtins.str] workstation_id: ID to use for the workstation.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if source_workstation is not None:
            pulumi.set(__self__, "source_workstation", source_workstation)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if workstation_cluster_id is not None:
            pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        if workstation_config_id is not None:
            pulumi.set(__self__, "workstation_config_id", workstation_config_id)
        if workstation_id is not None:
            pulumi.set(__self__, "workstation_id", workstation_id)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        'Client-specified environment variables passed to the workstation container's entrypoint.'
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Host to which clients can send HTTPS traffic that will be received by the workstation.
        Authorized traffic will be received to the workstation as HTTP on port 80.
        To send traffic to a different port, clients may prefix the host with the destination port in the format "{port}-{host}".
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the workstation parent resources reside.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="sourceWorkstation")
    def source_workstation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full resource name of the source workstation from which the workstation's persistent
        directories will be cloned from during creation.
        """
        return pulumi.get(self, "source_workstation")

    @source_workstation.setter
    def source_workstation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_workstation", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current state of the workstation.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A system-assigned unique identified for this resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the parent workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

    @workstation_config_id.setter
    def workstation_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workstation_config_id", value)

    @property
    @pulumi.getter(name="workstationId")
    def workstation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID to use for the workstation.
        """
        return pulumi.get(self, "workstation_id")

    @workstation_id.setter
    def workstation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workstation_id", value)


@pulumi.type_token("gcp:workstations/workstation:Workstation")
class Workstation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_workstation: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Workstation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                },
            })
        default_workstation = gcp.workstations.Workstation("default",
            workstation_id="work-station",
            workstation_config_id=default_workstation_config.workstation_config_id,
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            labels={
                "label": "key",
            },
            env={
                "name": "foo",
            },
            annotations={
                "label-one": "value-one",
            })
        ```

        ## Import

        Workstation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}/workstations/{{workstation_id}}`

        * `{{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}`

        * `{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}`

        When using the `pulumi import` command, Workstation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workstations/workstation:Workstation default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}/workstations/{{workstation_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstation:Workstation default {{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstation:Workstation default {{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: 'Client-specified environment variables passed to the workstation container's entrypoint.'
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation parent resources reside.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] source_workstation: Full resource name of the source workstation from which the workstation's persistent
               directories will be cloned from during creation.
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID of the parent workstation cluster config.
        :param pulumi.Input[builtins.str] workstation_id: ID to use for the workstation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkstationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Workstation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default.name)
        default_workstation_cluster = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        default_workstation_config = gcp.workstations.WorkstationConfig("default",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host={
                "gce_instance": {
                    "machine_type": "e2-standard-4",
                    "boot_disk_size_gb": 35,
                    "disable_public_ip_addresses": True,
                },
            })
        default_workstation = gcp.workstations.Workstation("default",
            workstation_id="work-station",
            workstation_config_id=default_workstation_config.workstation_config_id,
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            labels={
                "label": "key",
            },
            env={
                "name": "foo",
            },
            annotations={
                "label-one": "value-one",
            })
        ```

        ## Import

        Workstation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}/workstations/{{workstation_id}}`

        * `{{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}`

        * `{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}`

        When using the `pulumi import` command, Workstation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workstations/workstation:Workstation default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}/workstations/{{workstation_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstation:Workstation default {{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstation:Workstation default {{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}/{{workstation_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkstationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkstationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_workstation: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkstationArgs.__new__(WorkstationArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["env"] = env
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["source_workstation"] = source_workstation
            if workstation_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_cluster_id'")
            __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
            if workstation_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_config_id'")
            __props__.__dict__["workstation_config_id"] = workstation_config_id
            if workstation_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_id'")
            __props__.__dict__["workstation_id"] = workstation_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Workstation, __self__).__init__(
            'gcp:workstations/workstation:Workstation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            host: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            source_workstation: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            workstation_config_id: Optional[pulumi.Input[builtins.str]] = None,
            workstation_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Workstation':
        """
        Get an existing Workstation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Time when this resource was created.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: 'Client-specified environment variables passed to the workstation container's entrypoint.'
        :param pulumi.Input[builtins.str] host: Host to which clients can send HTTPS traffic that will be received by the workstation.
               Authorized traffic will be received to the workstation as HTTP on port 80.
               To send traffic to a different port, clients may prefix the host with the destination port in the format "{port}-{host}".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation parent resources reside.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: Full name of this resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] source_workstation: Full resource name of the source workstation from which the workstation's persistent
               directories will be cloned from during creation.
        :param pulumi.Input[builtins.str] state: Current state of the workstation.
        :param pulumi.Input[builtins.str] uid: A system-assigned unique identified for this resource.
        :param pulumi.Input[builtins.str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[builtins.str] workstation_config_id: The ID of the parent workstation cluster config.
        :param pulumi.Input[builtins.str] workstation_id: ID to use for the workstation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkstationState.__new__(_WorkstationState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["env"] = env
        __props__.__dict__["host"] = host
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["source_workstation"] = source_workstation
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
        __props__.__dict__["workstation_config_id"] = workstation_config_id
        __props__.__dict__["workstation_id"] = workstation_id
        return Workstation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def env(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        'Client-specified environment variables passed to the workstation container's entrypoint.'
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[builtins.str]:
        """
        Host to which clients can send HTTPS traffic that will be received by the workstation.
        Authorized traffic will be received to the workstation as HTTP on port 80.
        To send traffic to a different port, clients may prefix the host with the destination port in the format "{port}-{host}".
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the workstation parent resources reside.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="sourceWorkstation")
    def source_workstation(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Full resource name of the source workstation from which the workstation's persistent
        directories will be cloned from during creation.
        """
        return pulumi.get(self, "source_workstation")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Current state of the workstation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        A system-assigned unique identified for this resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the parent workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

    @property
    @pulumi.getter(name="workstationId")
    def workstation_id(self) -> pulumi.Output[builtins.str]:
        """
        ID to use for the workstation.
        """
        return pulumi.get(self, "workstation_id")

