# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkstationClusterArgs', 'WorkstationCluster']

@pulumi.input_type
class WorkstationClusterArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[builtins.str],
                 subnetwork: pulumi.Input[builtins.str],
                 workstation_cluster_id: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_config: Optional[pulumi.Input['WorkstationClusterDomainConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 private_cluster_config: Optional[pulumi.Input['WorkstationClusterPrivateClusterConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a WorkstationCluster resource.
        :param pulumi.Input[builtins.str] network: The relative resource name of the VPC network on which the instance can be accessed.
               It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[builtins.str] subnetwork: Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
               Must be part of the subnetwork specified for this cluster.
        :param pulumi.Input[builtins.str] workstation_cluster_id: ID to use for the workstation cluster.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input['WorkstationClusterDomainConfigArgs'] domain_config: Configuration options for a custom domain.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster should reside.
        :param pulumi.Input['WorkstationClusterPrivateClusterConfigArgs'] private_cluster_config: Configuration for private cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Resource manager tags bound to this resource.
               For example:
               "123/environment": "production",
               "123/costCenter": "marketing"
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_config is not None:
            pulumi.set(__self__, "domain_config", domain_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if private_cluster_config is not None:
            pulumi.set(__self__, "private_cluster_config", private_cluster_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The relative resource name of the VPC network on which the instance can be accessed.
        It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
        Must be part of the subnetwork specified for this cluster.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        ID to use for the workstation cluster.


        - - -
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainConfig")
    def domain_config(self) -> Optional[pulumi.Input['WorkstationClusterDomainConfigArgs']]:
        """
        Configuration options for a custom domain.
        Structure is documented below.
        """
        return pulumi.get(self, "domain_config")

    @domain_config.setter
    def domain_config(self, value: Optional[pulumi.Input['WorkstationClusterDomainConfigArgs']]):
        pulumi.set(self, "domain_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the workstation cluster should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> Optional[pulumi.Input['WorkstationClusterPrivateClusterConfigArgs']]:
        """
        Configuration for private cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "private_cluster_config")

    @private_cluster_config.setter
    def private_cluster_config(self, value: Optional[pulumi.Input['WorkstationClusterPrivateClusterConfigArgs']]):
        pulumi.set(self, "private_cluster_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource manager tags bound to this resource.
        For example:
        "123/environment": "production",
        "123/costCenter": "marketing"
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkstationClusterState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationClusterConditionArgs']]]] = None,
                 control_plane_ip: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 degraded: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_config: Optional[pulumi.Input['WorkstationClusterDomainConfigArgs']] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 private_cluster_config: Optional[pulumi.Input['WorkstationClusterPrivateClusterConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkstationCluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationClusterConditionArgs']]] conditions: Status conditions describing the current resource state.
               Structure is documented below.
        :param pulumi.Input[builtins.str] control_plane_ip: The private IP address of the control plane for this workstation cluster.
               Workstation VMs need access to this IP address to work with the service, so make sure that your firewall rules allow egress from the workstation VMs to this address.
        :param pulumi.Input[builtins.str] create_time: Time when this resource was created.
        :param pulumi.Input[builtins.bool] degraded: Whether this resource is in degraded mode, in which case it may require user action to restore full functionality.
               Details can be found in the conditions field.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input['WorkstationClusterDomainConfigArgs'] domain_config: Configuration options for a custom domain.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: Checksum computed by the server.
               May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster should reside.
        :param pulumi.Input[builtins.str] name: The name of the cluster resource.
        :param pulumi.Input[builtins.str] network: The relative resource name of the VPC network on which the instance can be accessed.
               It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input['WorkstationClusterPrivateClusterConfigArgs'] private_cluster_config: Configuration for private cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] subnetwork: Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
               Must be part of the subnetwork specified for this cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Resource manager tags bound to this resource.
               For example:
               "123/environment": "production",
               "123/costCenter": "marketing"
        :param pulumi.Input[builtins.str] uid: The system-generated UID of the resource.
        :param pulumi.Input[builtins.str] workstation_cluster_id: ID to use for the workstation cluster.
               
               
               - - -
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if control_plane_ip is not None:
            pulumi.set(__self__, "control_plane_ip", control_plane_ip)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if degraded is not None:
            pulumi.set(__self__, "degraded", degraded)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_config is not None:
            pulumi.set(__self__, "domain_config", domain_config)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_cluster_config is not None:
            pulumi.set(__self__, "private_cluster_config", private_cluster_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if workstation_cluster_id is not None:
            pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationClusterConditionArgs']]]]:
        """
        Status conditions describing the current resource state.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationClusterConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="controlPlaneIp")
    def control_plane_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address of the control plane for this workstation cluster.
        Workstation VMs need access to this IP address to work with the service, so make sure that your firewall rules allow egress from the workstation VMs to this address.
        """
        return pulumi.get(self, "control_plane_ip")

    @control_plane_ip.setter
    def control_plane_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "control_plane_ip", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def degraded(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality.
        Details can be found in the conditions field.
        """
        return pulumi.get(self, "degraded")

    @degraded.setter
    def degraded(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "degraded", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainConfig")
    def domain_config(self) -> Optional[pulumi.Input['WorkstationClusterDomainConfigArgs']]:
        """
        Configuration options for a custom domain.
        Structure is documented below.
        """
        return pulumi.get(self, "domain_config")

    @domain_config.setter
    def domain_config(self, value: Optional[pulumi.Input['WorkstationClusterDomainConfigArgs']]):
        pulumi.set(self, "domain_config", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Checksum computed by the server.
        May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the workstation cluster should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name of the VPC network on which the instance can be accessed.
        It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> Optional[pulumi.Input['WorkstationClusterPrivateClusterConfigArgs']]:
        """
        Configuration for private cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "private_cluster_config")

    @private_cluster_config.setter
    def private_cluster_config(self, value: Optional[pulumi.Input['WorkstationClusterPrivateClusterConfigArgs']]):
        pulumi.set(self, "private_cluster_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
        Must be part of the subnetwork specified for this cluster.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource manager tags bound to this resource.
        For example:
        "123/environment": "production",
        "123/costCenter": "marketing"
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID to use for the workstation cluster.


        - - -
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workstation_cluster_id", value)


@pulumi.type_token("gcp:workstations/workstationCluster:WorkstationCluster")
class WorkstationCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_config: Optional[pulumi.Input[Union['WorkstationClusterDomainConfigArgs', 'WorkstationClusterDomainConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 private_cluster_config: Optional[pulumi.Input[Union['WorkstationClusterPrivateClusterConfigArgs', 'WorkstationClusterPrivateClusterConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Workstation Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        project = gcp.organizations.get_project()
        ```
        ### Workstation Cluster Private

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="workstation-cluster-private",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster-private",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster-private",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            private_cluster_config={
                "enable_private_endpoint": True,
            },
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        project = gcp.organizations.get_project()
        ```
        ### Workstation Cluster Custom Domain

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="workstation-cluster-custom-domain",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster-custom-domain",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster-custom-domain",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            private_cluster_config={
                "enable_private_endpoint": True,
            },
            domain_config={
                "domain": "workstations.example.com",
            },
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        project = gcp.organizations.get_project()
        ```
        ### Workstation Cluster Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        tag_key = gcp.tags.TagKey("tag_key",
            parent=f"projects/{project.number}",
            short_name="keyname")
        tag_value = gcp.tags.TagValue("tag_value",
            parent=tag_key.name.apply(lambda name: f"tagKeys/{name}"),
            short_name="valuename")
        default_network = gcp.compute.Network("default",
            name="workstation-cluster-tags",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster-tags",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster-tags",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            tags=pulumi.Output.all(
                tagKeyShort_name=tag_key.short_name,
                tagValueShort_name=tag_value.short_name
        ).apply(lambda resolved_outputs: {
                f"{project.project_id}/{resolved_outputs['tagKeyShort_name']}": resolved_outputs['tagValueShort_name'],
            })
        )
        ```

        ## Import

        WorkstationCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}`

        * `{{project}}/{{location}}/{{workstation_cluster_id}}`

        * `{{location}}/{{workstation_cluster_id}}`

        When using the `pulumi import` command, WorkstationCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workstations/workstationCluster:WorkstationCluster default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationCluster:WorkstationCluster default {{project}}/{{location}}/{{workstation_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationCluster:WorkstationCluster default {{location}}/{{workstation_cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Union['WorkstationClusterDomainConfigArgs', 'WorkstationClusterDomainConfigArgsDict']] domain_config: Configuration options for a custom domain.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster should reside.
        :param pulumi.Input[builtins.str] network: The relative resource name of the VPC network on which the instance can be accessed.
               It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[Union['WorkstationClusterPrivateClusterConfigArgs', 'WorkstationClusterPrivateClusterConfigArgsDict']] private_cluster_config: Configuration for private cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] subnetwork: Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
               Must be part of the subnetwork specified for this cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Resource manager tags bound to this resource.
               For example:
               "123/environment": "production",
               "123/costCenter": "marketing"
        :param pulumi.Input[builtins.str] workstation_cluster_id: ID to use for the workstation cluster.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkstationClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Workstation Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="workstation-cluster",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        project = gcp.organizations.get_project()
        ```
        ### Workstation Cluster Private

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="workstation-cluster-private",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster-private",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster-private",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            private_cluster_config={
                "enable_private_endpoint": True,
            },
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        project = gcp.organizations.get_project()
        ```
        ### Workstation Cluster Custom Domain

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="workstation-cluster-custom-domain",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster-custom-domain",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster-custom-domain",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            private_cluster_config={
                "enable_private_endpoint": True,
            },
            domain_config={
                "domain": "workstations.example.com",
            },
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            })
        project = gcp.organizations.get_project()
        ```
        ### Workstation Cluster Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        tag_key = gcp.tags.TagKey("tag_key",
            parent=f"projects/{project.number}",
            short_name="keyname")
        tag_value = gcp.tags.TagValue("tag_value",
            parent=tag_key.name.apply(lambda name: f"tagKeys/{name}"),
            short_name="valuename")
        default_network = gcp.compute.Network("default",
            name="workstation-cluster-tags",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="workstation-cluster-tags",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name)
        default = gcp.workstations.WorkstationCluster("default",
            workstation_cluster_id="workstation-cluster-tags",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            tags=pulumi.Output.all(
                tagKeyShort_name=tag_key.short_name,
                tagValueShort_name=tag_value.short_name
        ).apply(lambda resolved_outputs: {
                f"{project.project_id}/{resolved_outputs['tagKeyShort_name']}": resolved_outputs['tagValueShort_name'],
            })
        )
        ```

        ## Import

        WorkstationCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}`

        * `{{project}}/{{location}}/{{workstation_cluster_id}}`

        * `{{location}}/{{workstation_cluster_id}}`

        When using the `pulumi import` command, WorkstationCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workstations/workstationCluster:WorkstationCluster default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationCluster:WorkstationCluster default {{project}}/{{location}}/{{workstation_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:workstations/workstationCluster:WorkstationCluster default {{location}}/{{workstation_cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkstationClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkstationClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_config: Optional[pulumi.Input[Union['WorkstationClusterDomainConfigArgs', 'WorkstationClusterDomainConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 private_cluster_config: Optional[pulumi.Input[Union['WorkstationClusterPrivateClusterConfigArgs', 'WorkstationClusterPrivateClusterConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkstationClusterArgs.__new__(WorkstationClusterArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain_config"] = domain_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["private_cluster_config"] = private_cluster_config
            __props__.__dict__["project"] = project
            if subnetwork is None and not opts.urn:
                raise TypeError("Missing required property 'subnetwork'")
            __props__.__dict__["subnetwork"] = subnetwork
            __props__.__dict__["tags"] = tags
            if workstation_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_cluster_id'")
            __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
            __props__.__dict__["conditions"] = None
            __props__.__dict__["control_plane_ip"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["degraded"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkstationCluster, __self__).__init__(
            'gcp:workstations/workstationCluster:WorkstationCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkstationClusterConditionArgs', 'WorkstationClusterConditionArgsDict']]]]] = None,
            control_plane_ip: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            degraded: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            domain_config: Optional[pulumi.Input[Union['WorkstationClusterDomainConfigArgs', 'WorkstationClusterDomainConfigArgsDict']]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            private_cluster_config: Optional[pulumi.Input[Union['WorkstationClusterPrivateClusterConfigArgs', 'WorkstationClusterPrivateClusterConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            subnetwork: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            workstation_cluster_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkstationCluster':
        """
        Get an existing WorkstationCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Client-specified annotations. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkstationClusterConditionArgs', 'WorkstationClusterConditionArgsDict']]]] conditions: Status conditions describing the current resource state.
               Structure is documented below.
        :param pulumi.Input[builtins.str] control_plane_ip: The private IP address of the control plane for this workstation cluster.
               Workstation VMs need access to this IP address to work with the service, so make sure that your firewall rules allow egress from the workstation VMs to this address.
        :param pulumi.Input[builtins.str] create_time: Time when this resource was created.
        :param pulumi.Input[builtins.bool] degraded: Whether this resource is in degraded mode, in which case it may require user action to restore full functionality.
               Details can be found in the conditions field.
        :param pulumi.Input[builtins.str] display_name: Human-readable name for this resource.
        :param pulumi.Input[Union['WorkstationClusterDomainConfigArgs', 'WorkstationClusterDomainConfigArgsDict']] domain_config: Configuration options for a custom domain.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: Checksum computed by the server.
               May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the workstation cluster should reside.
        :param pulumi.Input[builtins.str] name: The name of the cluster resource.
        :param pulumi.Input[builtins.str] network: The relative resource name of the VPC network on which the instance can be accessed.
               It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[Union['WorkstationClusterPrivateClusterConfigArgs', 'WorkstationClusterPrivateClusterConfigArgsDict']] private_cluster_config: Configuration for private cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] subnetwork: Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
               Must be part of the subnetwork specified for this cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Resource manager tags bound to this resource.
               For example:
               "123/environment": "production",
               "123/costCenter": "marketing"
        :param pulumi.Input[builtins.str] uid: The system-generated UID of the resource.
        :param pulumi.Input[builtins.str] workstation_cluster_id: ID to use for the workstation cluster.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkstationClusterState.__new__(_WorkstationClusterState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["control_plane_ip"] = control_plane_ip
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["degraded"] = degraded
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_config"] = domain_config
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["private_cluster_config"] = private_cluster_config
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["tags"] = tags
        __props__.__dict__["uid"] = uid
        __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
        return WorkstationCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Client-specified annotations. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.WorkstationClusterCondition']]:
        """
        Status conditions describing the current resource state.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="controlPlaneIp")
    def control_plane_ip(self) -> pulumi.Output[builtins.str]:
        """
        The private IP address of the control plane for this workstation cluster.
        Workstation VMs need access to this IP address to work with the service, so make sure that your firewall rules allow egress from the workstation VMs to this address.
        """
        return pulumi.get(self, "control_plane_ip")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def degraded(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality.
        Details can be found in the conditions field.
        """
        return pulumi.get(self, "degraded")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainConfig")
    def domain_config(self) -> pulumi.Output[Optional['outputs.WorkstationClusterDomainConfig']]:
        """
        Configuration options for a custom domain.
        Structure is documented below.
        """
        return pulumi.get(self, "domain_config")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Checksum computed by the server.
        May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location where the workstation cluster should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the cluster resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The relative resource name of the VPC network on which the instance can be accessed.
        It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> pulumi.Output[Optional['outputs.WorkstationClusterPrivateClusterConfig']]:
        """
        Configuration for private cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "private_cluster_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
        Must be part of the subnetwork specified for this cluster.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Resource manager tags bound to this resource.
        For example:
        "123/environment": "production",
        "123/costCenter": "marketing"
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        ID to use for the workstation cluster.


        - - -
        """
        return pulumi.get(self, "workstation_cluster_id")

