"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from typing_extensions import TypedDict


class AvailableTargetTypedDict(TypedDict):
    r"""An available organization-level channel target (i.e., one for which a channel target has not
    been created in the current suborg).
    """

    organization_id: int
    r"""Internal ID of the org with which the target is associated."""
    channel_id: int
    r"""Internal ID of the channel with which the target is associated."""
    channel_name: Nullable[str]
    r"""Name of the channel with which the target is associated."""
    target: str
    r"""Org-level target."""


class AvailableTarget(BaseModel):
    r"""An available organization-level channel target (i.e., one for which a channel target has not
    been created in the current suborg).
    """

    organization_id: int
    r"""Internal ID of the org with which the target is associated."""

    channel_id: int
    r"""Internal ID of the channel with which the target is associated."""

    channel_name: Nullable[str]
    r"""Name of the channel with which the target is associated."""

    target: str
    r"""Org-level target."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["channel_name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
