"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import io
import pydantic
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from syllable_sdk.utils import FieldMetadata, MultipartFormMetadata
from typing import IO, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class BodyOrganizationsUpdateLogoTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class BodyOrganizationsUpdateLogo(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]

    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


class BodyOrganizationsUpdateTypedDict(TypedDict):
    display_name: str
    r"""The human-readable display name of the organization"""
    logo: NotRequired[BodyOrganizationsUpdateLogoTypedDict]
    r"""The organization logo image file to upload. Must be a PNG file and 120x120 pixels. If not provided, the logo will not be updated."""
    description: NotRequired[Nullable[str]]
    r"""Description of the organization"""
    domains: NotRequired[Nullable[str]]
    r"""Comma-delimited list of domains that users at the organization may have in their email addresses"""
    saml_provider_id: NotRequired[Nullable[str]]
    r"""SAML provider ID for user authentication"""
    update_comments: NotRequired[Nullable[str]]
    r"""Comments about the update"""


class BodyOrganizationsUpdate(BaseModel):
    display_name: Annotated[str, FieldMetadata(multipart=True)]
    r"""The human-readable display name of the organization"""

    logo: Annotated[
        Optional[BodyOrganizationsUpdateLogo],
        FieldMetadata(multipart=MultipartFormMetadata(file=True)),
    ] = None
    r"""The organization logo image file to upload. Must be a PNG file and 120x120 pixels. If not provided, the logo will not be updated."""

    description: Annotated[OptionalNullable[str], FieldMetadata(multipart=True)] = UNSET
    r"""Description of the organization"""

    domains: Annotated[OptionalNullable[str], FieldMetadata(multipart=True)] = UNSET
    r"""Comma-delimited list of domains that users at the organization may have in their email addresses"""

    saml_provider_id: Annotated[
        OptionalNullable[str], FieldMetadata(multipart=True)
    ] = UNSET
    r"""SAML provider ID for user authentication"""

    update_comments: Annotated[OptionalNullable[str], FieldMetadata(multipart=True)] = (
        UNSET
    )
    r"""Comments about the update"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "logo",
            "description",
            "domains",
            "saml_provider_id",
            "update_comments",
        ]
        nullable_fields = [
            "description",
            "domains",
            "saml_provider_id",
            "update_comments",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
