"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .channelconfigview import ChannelConfigView, ChannelConfigViewTypedDict
from .channelservices import ChannelServices
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class ChannelTypedDict(TypedDict):
    name: str
    r"""The channel name"""
    channel_service: ChannelServices
    r"""The communication service for a channel."""
    id: int
    r"""The channel ID"""
    supported_modes: NotRequired[Nullable[str]]
    r"""The comma-delimited list of supported modes for the channel, which defines the       possible communication methods for channel targets linked to it."""
    is_system_channel: NotRequired[bool]
    r"""Whether the channel is a built-in system channel (i.e., is not customizable)"""
    config: NotRequired[Nullable[ChannelConfigViewTypedDict]]
    r"""Configuration for the channel"""


class Channel(BaseModel):
    name: str
    r"""The channel name"""

    channel_service: ChannelServices
    r"""The communication service for a channel."""

    id: int
    r"""The channel ID"""

    supported_modes: OptionalNullable[str] = UNSET
    r"""The comma-delimited list of supported modes for the channel, which defines the       possible communication methods for channel targets linked to it."""

    is_system_channel: Optional[bool] = True
    r"""Whether the channel is a built-in system channel (i.e., is not customizable)"""

    config: OptionalNullable[ChannelConfigView] = UNSET
    r"""Configuration for the channel"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["supported_modes", "is_system_channel", "config"]
        nullable_fields = ["supported_modes", "config"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
