"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .targetmodes import TargetModes
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Optional, TYPE_CHECKING
from typing_extensions import NotRequired, TypedDict

if TYPE_CHECKING:
    from .agentresponse import AgentResponse, AgentResponseTypedDict


class ChannelTargetResponseTypedDict(TypedDict):
    r"""Response model for channel target operations.
    A channel target links a channel to an agent, allowing users to communicate with the agent
    through that channel. For more information, see
    [Console docs](https://docs.syllable.ai/Resources/Channels).
    """

    agent_id: int
    r"""The internal ID of the agent associated with the channel target"""
    channel_id: int
    r"""The internal ID of the channel associated with the channel target"""
    target: str
    r"""The name of the channel target. Must correspond to an organization-level target (available targets can be fetched from `/channels/available-targets`)."""
    target_mode: TargetModes
    r"""Available modes (communication methods) for channel targets."""
    id: int
    r"""The internal ID of the channel target"""
    channel_name: str
    r"""The name of the channel associated with the channel target"""
    updated_at: datetime
    r"""Timestamp of the most recent update to the channel target"""
    last_updated_by: str
    r"""Email of the user who last updated the channel target"""
    fallback_target: NotRequired[Nullable[str]]
    r"""The fallback for the channel target (currently only supported for \"voice\" mode)"""
    is_test: NotRequired[bool]
    r"""Whether the channel target is intended for testing. If true, any sessions created through this target will be labeled as a test session (i.e., will not be included in dashboard data and can easily be filtered out in the Sessions screen in the SyllableConsole)."""
    agent: NotRequired[Nullable["AgentResponseTypedDict"]]
    r"""Definition of the agent with which the channel target is associated."""


class ChannelTargetResponse(BaseModel):
    r"""Response model for channel target operations.
    A channel target links a channel to an agent, allowing users to communicate with the agent
    through that channel. For more information, see
    [Console docs](https://docs.syllable.ai/Resources/Channels).
    """

    agent_id: int
    r"""The internal ID of the agent associated with the channel target"""

    channel_id: int
    r"""The internal ID of the channel associated with the channel target"""

    target: str
    r"""The name of the channel target. Must correspond to an organization-level target (available targets can be fetched from `/channels/available-targets`)."""

    target_mode: TargetModes
    r"""Available modes (communication methods) for channel targets."""

    id: int
    r"""The internal ID of the channel target"""

    channel_name: str
    r"""The name of the channel associated with the channel target"""

    updated_at: datetime
    r"""Timestamp of the most recent update to the channel target"""

    last_updated_by: str
    r"""Email of the user who last updated the channel target"""

    fallback_target: OptionalNullable[str] = UNSET
    r"""The fallback for the channel target (currently only supported for \"voice\" mode)"""

    is_test: Optional[bool] = False
    r"""Whether the channel target is intended for testing. If true, any sessions created through this target will be labeled as a test session (i.e., will not be included in dashboard data and can easily be filtered out in the Sessions screen in the SyllableConsole)."""

    agent: OptionalNullable["AgentResponse"] = UNSET
    r"""Definition of the agent with which the channel target is associated."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["fallback_target", "is_test", "agent"]
        nullable_fields = ["fallback_target", "agent"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
