"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class CommunicationBatchInputTypedDict(TypedDict):
    batch_id: str
    r"""Unique ID for conversation batch"""
    campaign_id: int
    r"""Unique ID for campaign"""
    expires_on: NotRequired[Nullable[datetime]]
    r"""Timestamp of batch expiration"""
    paused: NotRequired[Nullable[bool]]
    r"""Whether the batch is on HOLD. When on HOLD, no outreach will be made."""


class CommunicationBatchInput(BaseModel):
    batch_id: str
    r"""Unique ID for conversation batch"""

    campaign_id: int
    r"""Unique ID for campaign"""

    expires_on: OptionalNullable[datetime] = UNSET
    r"""Timestamp of batch expiration"""

    paused: OptionalNullable[bool] = UNSET
    r"""Whether the batch is on HOLD. When on HOLD, no outreach will be made."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["expires_on", "paused"]
        nullable_fields = ["expires_on", "paused"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
