"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class AttributesTypedDict(TypedDict):
    pass


class Attributes(BaseModel):
    pass


class EventTypedDict(TypedDict):
    r"""An event represents a specific occurrence during a session."""

    timestamp: datetime
    r"""Timestamp at which the event occurred"""
    session_id: NotRequired[Nullable[str]]
    r"""ID of the session in which the event occurred"""
    conversation_id: NotRequired[Nullable[str]]
    r"""ID of the conversation associated with the session in which the event occurred"""
    source: NotRequired[Nullable[str]]
    r"""Source of the event (either a tool call or an LLM prompt)"""
    source_id: NotRequired[Nullable[str]]
    r"""ID of the source of the event (either a tool ID or a prompt ID)"""
    category: NotRequired[Nullable[str]]
    r"""Broad categorization of the event"""
    type: NotRequired[Nullable[str]]
    r"""More specific class of the event"""
    user_id: NotRequired[Nullable[str]]
    r"""ID of the user interacting with the system when the event occurred (e.g., their       phone number)"""
    description: NotRequired[Nullable[str]]
    r"""Human-readable description of the event"""
    attributes: NotRequired[Nullable[AttributesTypedDict]]
    r"""Arbitrary additional metadata for the event"""


class Event(BaseModel):
    r"""An event represents a specific occurrence during a session."""

    timestamp: datetime
    r"""Timestamp at which the event occurred"""

    session_id: OptionalNullable[str] = UNSET
    r"""ID of the session in which the event occurred"""

    conversation_id: OptionalNullable[str] = UNSET
    r"""ID of the conversation associated with the session in which the event occurred"""

    source: OptionalNullable[str] = UNSET
    r"""Source of the event (either a tool call or an LLM prompt)"""

    source_id: OptionalNullable[str] = UNSET
    r"""ID of the source of the event (either a tool ID or a prompt ID)"""

    category: OptionalNullable[str] = UNSET
    r"""Broad categorization of the event"""

    type: OptionalNullable[str] = UNSET
    r"""More specific class of the event"""

    user_id: OptionalNullable[str] = UNSET
    r"""ID of the user interacting with the system when the event occurred (e.g., their       phone number)"""

    description: OptionalNullable[str] = UNSET
    r"""Human-readable description of the event"""

    attributes: OptionalNullable[Attributes] = UNSET
    r"""Arbitrary additional metadata for the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "session_id",
            "conversation_id",
            "source",
            "source_id",
            "category",
            "type",
            "user_id",
            "description",
            "attributes",
        ]
        nullable_fields = [
            "session_id",
            "conversation_id",
            "source",
            "source_id",
            "category",
            "type",
            "user_id",
            "description",
            "attributes",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
