"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Dict, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


FolderStatsTypedDict = TypeAliasType("FolderStatsTypedDict", Union[str, int, float])


FolderStats = TypeAliasType("FolderStats", Union[str, int, float])


class FolderDetailsTypedDict(TypedDict):
    r"""Response model for an insight upload folder details."""

    name: str
    r"""Human-readable name of insight folder"""
    id: int
    r"""System-assign folder ID"""
    last_updated_by: str
    r"""Email of user who last updated upload folder"""
    folder_stats: Dict[str, FolderStatsTypedDict]
    r"""Meta-data of insight upload files associated with the folder"""
    label: NotRequired[Nullable[str]]
    r"""optional label assigned to insight folder"""
    description: NotRequired[Nullable[str]]
    r"""Text description of insight upload folder"""
    created_at: NotRequired[datetime]
    r"""Timestamp at which insight upload folder was created"""
    updated_at: NotRequired[datetime]
    r"""Timestamp at which insight upload folder was last updated"""


class FolderDetails(BaseModel):
    r"""Response model for an insight upload folder details."""

    name: str
    r"""Human-readable name of insight folder"""

    id: int
    r"""System-assign folder ID"""

    last_updated_by: str
    r"""Email of user who last updated upload folder"""

    folder_stats: Dict[str, FolderStats]
    r"""Meta-data of insight upload files associated with the folder"""

    label: OptionalNullable[str] = UNSET
    r"""optional label assigned to insight folder"""

    description: OptionalNullable[str] = UNSET
    r"""Text description of insight upload folder"""

    created_at: Optional[datetime] = None
    r"""Timestamp at which insight upload folder was created"""

    updated_at: Optional[datetime] = None
    r"""Timestamp at which insight upload folder was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["label", "description", "created_at", "updated_at"]
        nullable_fields = ["label", "description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
