"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import pydantic
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import Annotated, NotRequired, TypedDict


class IncidentResponseTypedDict(TypedDict):
    r"""Response model for service incident operations."""

    description: str
    r"""Description of the service incident"""
    start_datetime: datetime
    r"""Start time of the incident"""
    resolution_datetime: datetime
    r"""Resolution time of the incident"""
    impact_category: str
    r"""Category of the impact"""
    sessions_impacted: int
    r"""Number of sessions impacted"""
    markdown: str
    r"""Detailed markdown description of the incident"""
    id: int
    r"""The ID of the incident to update"""
    last_updated_by: Nullable[str]
    r"""The email of the user who last updated the incident"""
    organization_id: NotRequired[Nullable[int]]
    r"""The ID of the organization"""
    sub_organization_id: NotRequired[Nullable[int]]
    r"""The ID of the sub-organization"""
    sub_organization: NotRequired[Nullable[str]]
    r"""The name of the sub-organization (DEPRECATED)"""
    created_at: NotRequired[Nullable[datetime]]
    r"""Creation time of the incident"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Last update time of the incident"""


class IncidentResponse(BaseModel):
    r"""Response model for service incident operations."""

    description: str
    r"""Description of the service incident"""

    start_datetime: datetime
    r"""Start time of the incident"""

    resolution_datetime: datetime
    r"""Resolution time of the incident"""

    impact_category: str
    r"""Category of the impact"""

    sessions_impacted: int
    r"""Number of sessions impacted"""

    markdown: str
    r"""Detailed markdown description of the incident"""

    id: int
    r"""The ID of the incident to update"""

    last_updated_by: Nullable[str]
    r"""The email of the user who last updated the incident"""

    organization_id: OptionalNullable[int] = UNSET
    r"""The ID of the organization"""

    sub_organization_id: OptionalNullable[int] = UNSET
    r"""The ID of the sub-organization"""

    sub_organization: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET
    r"""The name of the sub-organization (DEPRECATED)"""

    created_at: OptionalNullable[datetime] = UNSET
    r"""Creation time of the incident"""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""Last update time of the incident"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "organization_id",
            "sub_organization_id",
            "sub_organization",
            "created_at",
            "updated_at",
        ]
        nullable_fields = [
            "organization_id",
            "sub_organization_id",
            "sub_organization",
            "created_at",
            "updated_at",
            "last_updated_by",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
