"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .body_insights_folder_upload_file import (
    BodyInsightsFolderUploadFile,
    BodyInsightsFolderUploadFileTypedDict,
)
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from syllable_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class InsightsFolderUploadFileRequestTypedDict(TypedDict):
    folder_id: int
    call_id: str
    r"""A unique identifier for the call"""
    agent_number: NotRequired[Nullable[str]]
    r"""The phone number or ID of the agent involved."""
    customer_number: NotRequired[Nullable[str]]
    r"""The phone number or ID of the customer."""
    start_time: NotRequired[Nullable[datetime]]
    r"""The timestamp of the call's beginning"""
    end_time: NotRequired[Nullable[datetime]]
    r"""The timestamp of the call's end."""
    duration: NotRequired[Nullable[float]]
    r"""The call duration in seconds."""
    metadata: NotRequired[Nullable[str]]
    body_insights_folder_upload_file: NotRequired[BodyInsightsFolderUploadFileTypedDict]


class InsightsFolderUploadFileRequest(BaseModel):
    folder_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    call_id: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""A unique identifier for the call"""

    agent_number: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The phone number or ID of the agent involved."""

    customer_number: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The phone number or ID of the customer."""

    start_time: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The timestamp of the call's beginning"""

    end_time: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The timestamp of the call's end."""

    duration: Annotated[
        OptionalNullable[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The call duration in seconds."""

    metadata: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    body_insights_folder_upload_file: Annotated[
        Optional[BodyInsightsFolderUploadFile],
        FieldMetadata(request=RequestMetadata(media_type="multipart/form-data")),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "agent_number",
            "customer_number",
            "start_time",
            "end_time",
            "duration",
            "metadata",
            "Body_insights_folder_upload_file",
        ]
        nullable_fields = [
            "agent_number",
            "customer_number",
            "start_time",
            "end_time",
            "duration",
            "metadata",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
