"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class InsightsFolderInputTypedDict(TypedDict):
    r"""Request model to create/update an insight upload folder."""

    name: str
    r"""Human-readable name of insight folder"""
    label: NotRequired[Nullable[str]]
    r"""optional label assigned to insight folder"""
    description: NotRequired[Nullable[str]]
    r"""Text description of insight upload folder"""


class InsightsFolderInput(BaseModel):
    r"""Request model to create/update an insight upload folder."""

    name: str
    r"""Human-readable name of insight folder"""

    label: OptionalNullable[str] = UNSET
    r"""optional label assigned to insight folder"""

    description: OptionalNullable[str] = UNSET
    r"""Text description of insight upload folder"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["label", "description"]
        nullable_fields = ["label", "description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
