"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Dict, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


MetadataTypedDict = TypeAliasType("MetadataTypedDict", Union[str, int, float])


Metadata = TypeAliasType("Metadata", Union[str, int, float])


class InsightsUploadFileTypedDict(TypedDict):
    r"""Response model for an insight upload file."""

    id: int
    r"""System-assigned ID for the upload file"""
    folder_id: int
    r"""System-assigned ID for the folder to which the file belongs"""
    filename: str
    r"""Name of the uploaded file"""
    object_key: str
    r"""Object-store key of the uploaded file"""
    call_id: NotRequired[Nullable[str]]
    r"""Unique identifier for the call associated with the uploaded file"""
    agent_number: NotRequired[Nullable[str]]
    r"""Agent number associated with the uploaded file"""
    customer_number: NotRequired[Nullable[str]]
    r"""Customer number associated with the uploaded file"""
    duration: NotRequired[Nullable[float]]
    r"""Length in seconds of the uploaded recording"""
    start_time: NotRequired[Nullable[datetime]]
    r"""Start time of the uploaded file"""
    end_time: NotRequired[Nullable[datetime]]
    r"""End time of the uploaded file"""
    error_message: NotRequired[Nullable[str]]
    r"""Error message associated with the uploaded file"""
    metadata: NotRequired[Nullable[Dict[str, MetadataTypedDict]]]
    r"""Meta-data associated with the uploaded file"""
    created_at: NotRequired[datetime]
    r"""Timestamp at which insight upload file was created"""


class InsightsUploadFile(BaseModel):
    r"""Response model for an insight upload file."""

    id: int
    r"""System-assigned ID for the upload file"""

    folder_id: int
    r"""System-assigned ID for the folder to which the file belongs"""

    filename: str
    r"""Name of the uploaded file"""

    object_key: str
    r"""Object-store key of the uploaded file"""

    call_id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the call associated with the uploaded file"""

    agent_number: OptionalNullable[str] = UNSET
    r"""Agent number associated with the uploaded file"""

    customer_number: OptionalNullable[str] = UNSET
    r"""Customer number associated with the uploaded file"""

    duration: OptionalNullable[float] = UNSET
    r"""Length in seconds of the uploaded recording"""

    start_time: OptionalNullable[datetime] = UNSET
    r"""Start time of the uploaded file"""

    end_time: OptionalNullable[datetime] = UNSET
    r"""End time of the uploaded file"""

    error_message: OptionalNullable[str] = UNSET
    r"""Error message associated with the uploaded file"""

    metadata: OptionalNullable[Dict[str, Metadata]] = UNSET
    r"""Meta-data associated with the uploaded file"""

    created_at: Optional[datetime] = None
    r"""Timestamp at which insight upload file was created"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "call_id",
            "agent_number",
            "customer_number",
            "duration",
            "start_time",
            "end_time",
            "error_message",
            "metadata",
            "created_at",
        ]
        nullable_fields = [
            "call_id",
            "agent_number",
            "customer_number",
            "duration",
            "start_time",
            "end_time",
            "error_message",
            "metadata",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
