"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import NotRequired, TypedDict


class InsightsWorkflowQueueSessionTypedDict(TypedDict):
    r"""Session identifier for workflow queue."""

    workflow_name: str
    r"""Unique name for workflow"""
    session_id_list: NotRequired[Nullable[List[int]]]
    r"""List of session identifiers"""
    file_id_list: NotRequired[Nullable[List[int]]]
    r"""List of file IDs to be processed. This is only applicable for upload folders"""


class InsightsWorkflowQueueSession(BaseModel):
    r"""Session identifier for workflow queue."""

    workflow_name: str
    r"""Unique name for workflow"""

    session_id_list: OptionalNullable[List[int]] = UNSET
    r"""List of session identifiers"""

    file_id_list: OptionalNullable[List[int]] = UNSET
    r"""List of file IDs to be processed. This is only applicable for upload folders"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["session_id_list", "file_id_list"]
        nullable_fields = ["session_id_list", "file_id_list"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
