"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .insighttooldefinition import InsightToolDefinition, InsightToolDefinitionTypedDict
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Any, Optional
from typing_extensions import NotRequired, TypedDict


class InsightToolOutputTypedDict(TypedDict):
    r"""Response model for an insight tool configuration."""

    name: str
    r"""Human readable name of insight tool"""
    description: str
    r"""Text description of insight tool configuration"""
    version: int
    r"""Version of insight tool"""
    tool_arguments: Any
    r"""Arguments for calling the insight tool"""
    insight_tool_definition_id: int
    r"""Unique ID for insight tool definition used by this tool configuration"""
    id: int
    r"""Unique ID for insight tool"""
    last_updated_by: str
    r"""Email of user who last updated insight tool configuration"""
    insight_tool_definition: NotRequired[Nullable[InsightToolDefinitionTypedDict]]
    r"""Insight Tool Definition"""
    created_at: NotRequired[datetime]
    r"""Timestamp of at which insight tool configuration was created"""
    updated_at: NotRequired[datetime]
    r"""Timestamp at which insight tool configuration was last updated"""


class InsightToolOutput(BaseModel):
    r"""Response model for an insight tool configuration."""

    name: str
    r"""Human readable name of insight tool"""

    description: str
    r"""Text description of insight tool configuration"""

    version: int
    r"""Version of insight tool"""

    tool_arguments: Any
    r"""Arguments for calling the insight tool"""

    insight_tool_definition_id: int
    r"""Unique ID for insight tool definition used by this tool configuration"""

    id: int
    r"""Unique ID for insight tool"""

    last_updated_by: str
    r"""Email of user who last updated insight tool configuration"""

    insight_tool_definition: OptionalNullable[InsightToolDefinition] = UNSET
    r"""Insight Tool Definition"""

    created_at: Optional[datetime] = None
    r"""Timestamp of at which insight tool configuration was created"""

    updated_at: Optional[datetime] = None
    r"""Timestamp at which insight tool configuration was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["insight_tool_definition", "created_at", "updated_at"]
        nullable_fields = ["insight_tool_definition"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
