"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class InsightToolTestInputTypedDict(TypedDict):
    r"""Request model to test an insight tool."""

    tool_name: str
    r"""Human readable name of insight tool configuration"""
    session_id: NotRequired[Nullable[int]]
    r"""The session ID of the session against which to run the tool"""
    upload_file_id: NotRequired[Nullable[int]]
    r"""The file ID of the uploaded file against which to run the tool"""


class InsightToolTestInput(BaseModel):
    r"""Request model to test an insight tool."""

    tool_name: str
    r"""Human readable name of insight tool configuration"""

    session_id: OptionalNullable[int] = UNSET
    r"""The session ID of the session against which to run the tool"""

    upload_file_id: OptionalNullable[int] = UNSET
    r"""The file ID of the uploaded file against which to run the tool"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["session_id", "upload_file_id"]
        nullable_fields = ["session_id", "upload_file_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
