"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Dict, List, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


SampleRateTypedDict = TypeAliasType("SampleRateTypedDict", Union[int, float])
r"""Sample rate as a percentage of calls"""


SampleRate = TypeAliasType("SampleRate", Union[int, float])
r"""Sample rate as a percentage of calls"""


AgentListTypedDict = TypeAliasType("AgentListTypedDict", Union[List[int], List[str]])
r"""List of agents"""


AgentList = TypeAliasType("AgentList", Union[List[int], List[str]])
r"""List of agents"""


class InsightWorkflowConditionTypedDict(TypedDict):
    r"""Model for the conditions that trigger an insight workflow."""

    min_duration: NotRequired[Nullable[int]]
    r"""Minimum duration of the calls in seconds"""
    max_duration: NotRequired[Nullable[int]]
    r"""Maximum duration of the calls in seconds"""
    sample_rate: NotRequired[Nullable[SampleRateTypedDict]]
    r"""Sample rate as a percentage of calls"""
    agent_list: NotRequired[Nullable[AgentListTypedDict]]
    r"""List of agents"""
    prompt_list: NotRequired[Nullable[List[str]]]
    r"""List of prompts"""
    folder_list: NotRequired[Nullable[List[int]]]
    r"""List of folder IDs"""
    sheet_info: NotRequired[Nullable[Dict[str, str]]]
    r"""Information about the sheet to be used for the workflow"""


class InsightWorkflowCondition(BaseModel):
    r"""Model for the conditions that trigger an insight workflow."""

    min_duration: OptionalNullable[int] = UNSET
    r"""Minimum duration of the calls in seconds"""

    max_duration: OptionalNullable[int] = UNSET
    r"""Maximum duration of the calls in seconds"""

    sample_rate: OptionalNullable[SampleRate] = UNSET
    r"""Sample rate as a percentage of calls"""

    agent_list: OptionalNullable[AgentList] = UNSET
    r"""List of agents"""

    prompt_list: OptionalNullable[List[str]] = UNSET
    r"""List of prompts"""

    folder_list: OptionalNullable[List[int]] = UNSET
    r"""List of folder IDs"""

    sheet_info: OptionalNullable[Dict[str, str]] = UNSET
    r"""Information about the sheet to be used for the workflow"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "min_duration",
            "max_duration",
            "sample_rate",
            "agent_list",
            "prompt_list",
            "folder_list",
            "sheet_info",
        ]
        nullable_fields = [
            "min_duration",
            "max_duration",
            "sample_rate",
            "agent_list",
            "prompt_list",
            "folder_list",
            "sheet_info",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
