"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .insightworkflowcondition import (
    InsightWorkflowCondition,
    InsightWorkflowConditionTypedDict,
)
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import NotRequired, TypedDict


class InsightWorkflowInputTypedDict(TypedDict):
    r"""Request model to create/update an insight workflow."""

    name: str
    r"""Human-readable name of insight workflow"""
    source: str
    r"""Source of the workflow"""
    description: str
    r"""Text description of workflow"""
    insight_tool_ids: List[int]
    r"""Ordered list of IDs of tool configurations to be executed in the workflow"""
    conditions: InsightWorkflowConditionTypedDict
    r"""Model for the conditions that trigger an insight workflow."""
    start_datetime: NotRequired[Nullable[datetime]]
    r"""Target session timestamp the workflow (backfill) should start. An empty value indicates start on activation - live sessions only"""
    end_datetime: NotRequired[Nullable[datetime]]
    r"""Target session timestamp the workflow (backfill) should end. An empty value indicates no end, i.e., include live sessions until deactivation"""


class InsightWorkflowInput(BaseModel):
    r"""Request model to create/update an insight workflow."""

    name: str
    r"""Human-readable name of insight workflow"""

    source: str
    r"""Source of the workflow"""

    description: str
    r"""Text description of workflow"""

    insight_tool_ids: List[int]
    r"""Ordered list of IDs of tool configurations to be executed in the workflow"""

    conditions: InsightWorkflowCondition
    r"""Model for the conditions that trigger an insight workflow."""

    start_datetime: OptionalNullable[datetime] = UNSET
    r"""Target session timestamp the workflow (backfill) should start. An empty value indicates start on activation - live sessions only"""

    end_datetime: OptionalNullable[datetime] = UNSET
    r"""Target session timestamp the workflow (backfill) should end. An empty value indicates no end, i.e., include live sessions until deactivation"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["start_datetime", "end_datetime"]
        nullable_fields = ["start_datetime", "end_datetime"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
