"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .agentvoicedisplayname import AgentVoiceDisplayName
from .languagecode import LanguageCode
from .ttsprovider import TtsProvider
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class LanguageConfigTypedDict(TypedDict):
    r"""Voice and DTMF configurations for a language in a language group. List of available voices
    and their supported languages can be fetched from `GET /agents/voices/available/`.
    """

    language_code: LanguageCode
    r"""BCP 47 codes of languages that Syllable supports."""
    voice_provider: TtsProvider
    r"""TTS provider for an agent voice."""
    voice_display_name: AgentVoiceDisplayName
    r"""Display names of voices that Syllable supports."""
    dtmf_code: int
    r"""DTMF code that should be used for the language in the menu generated from the language group."""
    voice_speed: NotRequired[Nullable[float]]
    r"""Speed of the voice in the range of 0.25 to 4.0 (OpenAI and Google) or 0.7 to 1.2 (ElevenLabs). Standard speed is 1.0."""
    voice_pitch: NotRequired[Nullable[float]]
    r"""Pitch of the voice in the range of -20.0 to 20.0. 20 means increase 20 semitones from the original pitch. -20 means decrease 20 semitones from the original pitch. 0 means use the original pitch. Only supported for Google configs."""


class LanguageConfig(BaseModel):
    r"""Voice and DTMF configurations for a language in a language group. List of available voices
    and their supported languages can be fetched from `GET /agents/voices/available/`.
    """

    language_code: LanguageCode
    r"""BCP 47 codes of languages that Syllable supports."""

    voice_provider: TtsProvider
    r"""TTS provider for an agent voice."""

    voice_display_name: AgentVoiceDisplayName
    r"""Display names of voices that Syllable supports."""

    dtmf_code: int
    r"""DTMF code that should be used for the language in the menu generated from the language group."""

    voice_speed: OptionalNullable[float] = UNSET
    r"""Speed of the voice in the range of 0.25 to 4.0 (OpenAI and Google) or 0.7 to 1.2 (ElevenLabs). Standard speed is 1.0."""

    voice_pitch: OptionalNullable[float] = UNSET
    r"""Pitch of the voice in the range of -20.0 to 20.0. 20 means increase 20 semitones from the original pitch. -20 means decrease 20 semitones from the original pitch. 0 means use the original pitch. Only supported for Google configs."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["voice_speed", "voice_pitch"]
        nullable_fields = ["voice_speed", "voice_pitch"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
