"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .latencycategory import LatencyCategory
from .latencyunittype import LatencyUnitType
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import NotRequired, TypedDict


class LatencyEntryTypedDict(TypedDict):
    r"""Data model for latency entries."""

    timestamp: datetime
    measurement_start: datetime
    category: LatencyCategory
    label: str
    unit_type: LatencyUnitType
    value: float
    value_str: str
    time_delta: str
    metadata: NotRequired[Nullable[List[str]]]


class LatencyEntry(BaseModel):
    r"""Data model for latency entries."""

    timestamp: datetime

    measurement_start: datetime

    category: LatencyCategory

    label: str

    unit_type: LatencyUnitType

    value: float

    value_str: str

    time_delta: str

    metadata: OptionalNullable[List[str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["metadata"]
        nullable_fields = ["metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
